/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.seeds.ui.hub.item;

import com.paterva.maltego.seeds.api.HubSeedBadge;
import com.paterva.maltego.seeds.api.HubSeedDescriptor;
import com.paterva.maltego.seeds.ui.HubSeedUtils;
import com.paterva.maltego.seeds.ui.hub.item.HubSeedListenerHoverAwarePanel;
import com.paterva.maltego.util.HtmlUtils;
import com.paterva.maltego.util.StringUtilities;
import com.paterva.maltego.util.ui.components.MultiLineLabel;
import com.paterva.maltego.util.ui.laf.MaltegoLAF;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIDefaults;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class HubSeedMainPanel
extends HubSeedListenerHoverAwarePanel {
    private static final UIDefaults LAF = MaltegoLAF.getLookAndFeelDefaults();
    private final HubSeedDescriptor _seed;
    private JPanel _bottomPanel;
    private JLabel _descriptionLabel;
    private JPanel _innerPanel;
    private JLabel _leftBadgeLabel;
    private JLabel _modifiedLabel;
    private JLabel _rightBadgeLabel;
    private JLabel _txEntityCountLabel;
    private JPanel jPanel1;

    public HubSeedMainPanel(HubSeedDescriptor seed) {
        this._seed = seed;
        this.initComponents();
        if (this._seed != null) {
            this.update();
        }
    }

    @Override
    public HubSeedDescriptor getSeed() {
        return this._seed;
    }

    private void update() {
        this.updateShortDescription();
        this.updateTxEntityCounts();
        this.updateDateModified();
        this.updateLeftBadge();
        this.updateRightBadge();
        this.updateBadgePanel();
    }

    private void updateShortDescription() {
        String description = this._seed.getDescription();
        if (description == null) {
            description = "";
        } else if (HtmlUtils.containsHtmlLink((String)description)) {
            description = HtmlUtils.getPlainText((String)description);
        }
        this._descriptionLabel.setText(description);
        this._descriptionLabel.setForeground(LAF.getColor("hub-item-description-fg"));
        this._descriptionLabel.setFont(HubSeedUtils.getFontScaled("hub-item-description-font"));
    }

    private void updateTxEntityCounts() {
        String text = HubSeedUtils.getTxEntityCounts(this._seed);
        if (!StringUtilities.isNullOrEmpty((String)text)) {
            this._txEntityCountLabel.setVisible(true);
            this._txEntityCountLabel.setText(text);
            this._txEntityCountLabel.setForeground(LAF.getColor("hub-item-tx-entity-counts-fg"));
            this._txEntityCountLabel.setFont(HubSeedUtils.getFontScaled("hub-item-tx-entity-counts-font"));
        } else {
            this._txEntityCountLabel.setVisible(false);
        }
    }

    private void updateDateModified() {
        String text = "";
        if (!StringUtilities.isNullOrEmpty((String)text)) {
            this._modifiedLabel.setVisible(true);
            this._modifiedLabel.setText(text);
            this._modifiedLabel.setForeground(LAF.getColor("hub-item-date-modified-fg"));
            this._modifiedLabel.setFont(HubSeedUtils.getFontScaled("hub-item-date-modified-font"));
        } else {
            this._modifiedLabel.setVisible(false);
        }
    }

    private void updateLeftBadge() {
        this._leftBadgeLabel.setVisible(false);
        String location = "SouthWest";
        HubSeedBadge locationBadge = HubSeedUtils.getLocationBadge(this._seed, location);
        if (locationBadge != null) {
            this._leftBadgeLabel.setVisible(true);
            this._leftBadgeLabel.setOpaque(true);
            this._leftBadgeLabel.setFont(HubSeedUtils.getFontScaled("hub-item-installed-font"));
            this._leftBadgeLabel.setForeground(HubSeedUtils.getBadgeFgColor((JComponent)((Object)this), locationBadge));
            this._leftBadgeLabel.setBackground(HubSeedUtils.getBadgeBgColor((JComponent)((Object)this), locationBadge));
            this._leftBadgeLabel.setText(locationBadge.getValue());
        }
    }

    private void updateRightBadge() {
        this._rightBadgeLabel.setVisible(false);
        String location = "SouthEast";
        HubSeedBadge locationBadge = HubSeedUtils.getLocationBadge(this._seed, location);
        if (locationBadge != null) {
            this._rightBadgeLabel.setVisible(true);
            this._rightBadgeLabel.setOpaque(true);
            this._rightBadgeLabel.setFont(HubSeedUtils.getFontScaled("hub-item-installed-font"));
            this._rightBadgeLabel.setForeground(HubSeedUtils.getBadgeFgColor((JComponent)((Object)this), locationBadge));
            this._rightBadgeLabel.setBackground(HubSeedUtils.getBadgeBgColor((JComponent)((Object)this), locationBadge));
            this._rightBadgeLabel.setText(locationBadge.getValue());
        }
    }

    private void updateBadgePanel() {
        if (!this._leftBadgeLabel.isVisible() && !this._rightBadgeLabel.isVisible()) {
            this._bottomPanel.setVisible(false);
        } else {
            this._bottomPanel.setVisible(true);
        }
    }

    @Override
    public void onSeedChanged() {
        this.update();
    }

    protected void onHoveredChanged() {
    }

    protected void onPanelClicked() {
    }

    private void initComponents() {
        this._innerPanel = new JPanel();
        this._descriptionLabel = new MultiLineLabel(2);
        this._txEntityCountLabel = new JLabel();
        this._modifiedLabel = new JLabel();
        this._bottomPanel = new JPanel();
        this._leftBadgeLabel = new JLabel();
        this._rightBadgeLabel = new JLabel();
        this.jPanel1 = new JPanel();
        this.setOpaque(false);
        this.setLayout(new GridBagLayout());
        this._innerPanel.setOpaque(false);
        this._innerPanel.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this._descriptionLabel, (String)NbBundle.getMessage(HubSeedMainPanel.class, (String)"HubSeedMainPanel._descriptionLabel.text"));
        this._descriptionLabel.setVerticalAlignment(1);
        this._descriptionLabel.setMaximumSize(new Dimension(2000, 2000));
        this._descriptionLabel.setVerticalTextPosition(1);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(1, 6, 5, 6);
        this._innerPanel.add((Component)this._descriptionLabel, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this._txEntityCountLabel, (String)NbBundle.getMessage(HubSeedMainPanel.class, (String)"HubSeedMainPanel._txEntityCountLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(1, 6, 1, 6);
        this._innerPanel.add((Component)this._txEntityCountLabel, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this._modifiedLabel, (String)NbBundle.getMessage(HubSeedMainPanel.class, (String)"HubSeedMainPanel._modifiedLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(1, 6, 1, 6);
        this._innerPanel.add((Component)this._modifiedLabel, gridBagConstraints);
        this._bottomPanel.setOpaque(false);
        this._bottomPanel.setLayout(new GridBagLayout());
        this._leftBadgeLabel.setHorizontalAlignment(0);
        Mnemonics.setLocalizedText((JLabel)this._leftBadgeLabel, (String)NbBundle.getMessage(HubSeedMainPanel.class, (String)"HubSeedMainPanel._leftBadgeLabel.text"));
        this._leftBadgeLabel.setHorizontalTextPosition(2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.ipadx = 12;
        gridBagConstraints.ipady = 2;
        gridBagConstraints.anchor = 16;
        this._bottomPanel.add((Component)this._leftBadgeLabel, gridBagConstraints);
        this._rightBadgeLabel.setHorizontalAlignment(0);
        Mnemonics.setLocalizedText((JLabel)this._rightBadgeLabel, (String)NbBundle.getMessage(HubSeedMainPanel.class, (String)"HubSeedMainPanel._rightBadgeLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.ipadx = 13;
        gridBagConstraints.ipady = 2;
        gridBagConstraints.anchor = 14;
        this._bottomPanel.add((Component)this._rightBadgeLabel, gridBagConstraints);
        this.jPanel1.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.weightx = 1.0;
        this._bottomPanel.add((Component)this.jPanel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this._innerPanel.add((Component)this._bottomPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add(this._innerPanel, gridBagConstraints);
    }
}

