/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.extexecution.base.input;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.extexecution.base.input.LineProcessor;

public final class LineProcessors {
    private static final Logger LOGGER = Logger.getLogger(LineProcessors.class.getName());

    private LineProcessors() {
    }

    @NonNull
    public static LineProcessor proxy(LineProcessor ... processors) {
        return new ProxyLineProcessor(processors);
    }

    @NonNull
    public static LineProcessor printing(@NonNull PrintWriter out) {
        return new PrintingLineProcessor(out);
    }

    @NonNull
    public static LineProcessor patternWaiting(@NonNull Pattern pattern, @NonNull CountDownLatch latch) {
        return new WaitingLineProcessor(pattern, latch);
    }

    private static class WaitingLineProcessor
    implements LineProcessor {
        private final Pattern pattern;
        private final CountDownLatch latch;
        private boolean processed;
        private boolean closed;

        public WaitingLineProcessor(Pattern pattern, CountDownLatch latch) {
            assert (pattern != null);
            assert (latch != null);
            this.pattern = pattern;
            this.latch = latch;
        }

        @Override
        public synchronized void processLine(String line) {
            assert (line != null);
            if (this.closed) {
                throw new IllegalStateException("Already closed processor");
            }
            if (!this.processed && this.pattern.matcher(line).matches()) {
                this.latch.countDown();
                this.processed = true;
            }
        }

        @Override
        public synchronized void reset() {
            if (this.closed) {
                throw new IllegalStateException("Already closed processor");
            }
        }

        @Override
        public synchronized void close() {
            this.closed = true;
        }
    }

    private static class PrintingLineProcessor
    implements LineProcessor {
        private final PrintWriter out;
        private boolean closed;

        public PrintingLineProcessor(PrintWriter out) {
            assert (out != null);
            this.out = out;
        }

        @Override
        public void processLine(String line) {
            assert (line != null);
            if (this.closed) {
                throw new IllegalStateException("Already closed processor");
            }
            LOGGER.log(Level.FINEST, line);
            this.out.println(line);
            this.out.flush();
        }

        @Override
        public void reset() {
            if (this.closed) {
                throw new IllegalStateException("Already closed processor");
            }
        }

        @Override
        public void close() {
            this.closed = true;
            this.out.flush();
            this.out.close();
        }
    }

    private static class ProxyLineProcessor
    implements LineProcessor {
        private final List<LineProcessor> processors = new ArrayList<LineProcessor>();
        private boolean closed;

        public ProxyLineProcessor(LineProcessor ... processors) {
            for (LineProcessor processor : processors) {
                if (processor == null) continue;
                this.processors.add(processor);
            }
        }

        @Override
        public void processLine(String line) {
            if (this.closed) {
                throw new IllegalStateException("Already closed processor");
            }
            for (LineProcessor processor : this.processors) {
                processor.processLine(line);
            }
        }

        @Override
        public void reset() {
            if (this.closed) {
                throw new IllegalStateException("Already closed processor");
            }
            for (LineProcessor processor : this.processors) {
                processor.reset();
            }
        }

        @Override
        public void close() {
            this.closed = true;
            for (LineProcessor processor : this.processors) {
                processor.close();
            }
        }
    }
}

