/*
 * Decompiled with CFR 0.152.
 */
package com.pinkmatter.modules.flamingo;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.LayoutManager2;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JMenuBar;
import javax.swing.JRootPane;

class RibbonRootPaneLayout
implements LayoutManager2 {
    private JComponent _toolbar;
    private LayoutManager _delegate;

    public RibbonRootPaneLayout(LayoutManager delegate, JComponent toolbar) {
        this._toolbar = toolbar;
        this._delegate = delegate;
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        return this._delegate.preferredLayoutSize(parent);
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        return this._delegate.minimumLayoutSize(parent);
    }

    @Override
    public Dimension maximumLayoutSize(Container target) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    @Override
    public void layoutContainer(Container parent) {
        JRootPane rootPane = (JRootPane)parent;
        RibbonRootPaneLayout.hideMenu(rootPane);
        this._delegate.layoutContainer(parent);
        Rectangle bounds = rootPane.getBounds();
        Insets insets = rootPane.getInsets();
        int y = 0;
        int h = bounds.height - insets.top - insets.bottom;
        if (rootPane.getContentPane() != null) {
            Rectangle contentBounds = rootPane.getContentPane().getBounds();
            if (this._toolbar != null) {
                Dimension size = this._toolbar.getPreferredSize();
                this._toolbar.setBounds(contentBounds.x, y, contentBounds.width, size.height);
                y += size.height;
                h -= size.height;
            }
            rootPane.getContentPane().setBounds(contentBounds.x, y, contentBounds.width, h);
        }
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
    }

    @Override
    public void removeLayoutComponent(Component comp) {
    }

    @Override
    public void addLayoutComponent(Component comp, Object constraints) {
    }

    @Override
    public float getLayoutAlignmentX(Container target) {
        return 0.0f;
    }

    @Override
    public float getLayoutAlignmentY(Container target) {
        return 0.0f;
    }

    @Override
    public void invalidateLayout(Container target) {
    }

    private static void hideMenu(JRootPane rootPane) {
        JMenuBar menu = rootPane.getJMenuBar();
        if (menu != null) {
            menu.setVisible(false);
        }
    }
}

