/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.array;

import com.oracle.truffle.js.runtime.array.ByteArrayAccess;
import com.oracle.truffle.js.runtime.array.TruffleByteArrayAccess;
import java.nio.ByteOrder;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
final class ByteArraySupport {
    static final ByteArrayAccess LITTLE_ENDIAN = new TruffleByteArrayAccess(com.oracle.truffle.api.memory.ByteArraySupport.littleEndian());
    static final ByteArrayAccess BIG_ENDIAN = new TruffleByteArrayAccess(com.oracle.truffle.api.memory.ByteArraySupport.bigEndian());
    static final ByteArrayAccess NATIVE_ORDER = ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN ? LITTLE_ENDIAN : BIG_ENDIAN;

    private ByteArraySupport() {
    }

    static ByteArrayAccess littleEndian() {
        return LITTLE_ENDIAN;
    }

    static ByteArrayAccess bigEndian() {
        return BIG_ENDIAN;
    }

    static ByteArrayAccess nativeOrder() {
        return NATIVE_ORDER;
    }
}

