/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.licensing.ui.wizard.licensed;

import com.paterva.maltego.licensing.E;
import com.paterva.maltego.licensing.EulaAcceptHandler;
import com.paterva.maltego.licensing.LicenseManager;
import com.paterva.maltego.licensing.LicensingException;
import com.paterva.maltego.licensing.mode.A;
import com.paterva.maltego.licensing.serialize.C;
import com.paterva.maltego.licensing.serialize.F;
import com.paterva.maltego.licensing.serialize.I;
import com.paterva.maltego.licensing.ui.wizard.LicenseWizard;
import com.paterva.maltego.licensing.ui.wizard.licensed.FailurePanel;
import com.paterva.maltego.licensing.ui.wizard.licensed.SuccessPanel;
import com.paterva.maltego.util.ui.dialog.PassFailProgressController;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.progress.ProgressHandle;
import org.openide.WizardDescriptor;
import org.openide.util.Exceptions;

public class LicenseActivationController
extends PassFailProgressController<F, SuccessPanel, FailurePanel> {
    private static final Logger LOG = Logger.getLogger(LicenseActivationController.class.getName());

    public LicenseActivationController() {
        this.setName("Activation");
        this.setDescription("A summary of the activation process is shown below.");
        this.setImage(LicenseWizard.getDescriptionImage());
    }

    protected F doProcessing(WizardDescriptor descriptor, ProgressHandle handle) throws LicensingException {
        F licenseBlob;
        block5: {
            LOG.log(Level.WARNING, "License wizard: License Key activation - applying activation");
            licenseBlob = (F)descriptor.getProperty("licensing.blob");
            I eula = (I)descriptor.getProperty("licensing.eula");
            try {
                LicenseManager licMan = LicenseManager.A();
                A oldLicenseMode = licMan.A(false);
                if (licenseBlob == null) break block5;
                try {
                    handle.progress("Applying new license...");
                    C.A((F)licenseBlob);
                    licMan.C(false);
                    licMan.H(false);
                    licMan.G(false);
                    licMan.I(true);
                    licMan.A(oldLicenseMode);
                    A newLicenseMode = licMan.A(false);
                    if (newLicenseMode == null || newLicenseMode.D()) {
                        throw new LicensingException("License file invalid.");
                    }
                    EulaAcceptHandler.eulaAccepted((I)eula);
                }
                catch (Exception ex) {
                    throw new IOException("Failed to save license file: " + ex.getMessage(), ex);
                }
            }
            catch (Exception ex) {
                throw new LicensingException("Click back to try again", ex, false);
            }
        }
        return licenseBlob;
    }

    protected void storeSettings(WizardDescriptor settings) {
    }

    protected SuccessPanel createPassComponent() {
        return new SuccessPanel();
    }

    protected FailurePanel createFailComponent() {
        return new FailurePanel();
    }

    protected void pass(WizardDescriptor descriptor, SuccessPanel component, F license) {
        if (license != null) {
            try {
                E capability = license.A(true).E(System.currentTimeMillis()).J();
                component.setProduct(capability.F());
                LOG.log(Level.INFO, "License wizard: License Key activation - success");
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    protected void fail(FailurePanel component, Exception e) {
        Throwable t;
        LOG.log(Level.WARNING, "License wizard: License Key activation - failure");
        Throwable throwable = t = e != null ? e.getCause() : null;
        if (t == null) {
            component.setError(null);
        } else if (t.getMessage() == null) {
            component.setError(t.toString());
        } else {
            component.setError(t.getMessage());
        }
        if (t instanceof LicensingException && ((LicensingException)t).isCommunicationError()) {
            component.setOptionsVisible(true);
            component.setTitle("Could not retrieve license from server!");
            component.setDescription("This usually means that you have no internet connection or that your proxy settings are incorrect.\n\nTo change your proxy settings click on the options button below. Use the \"Back\" button to retry the activation process");
        } else {
            component.setOptionsVisible(false);
            component.setTitle("Activation failed!");
            component.setDescription("This usually means that your license key is invalid or you have exceeded the maximum number of activations.\n\nPlease contact the Maltego help desk at support@maltego.com.");
        }
    }
}

