/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.automation.actions;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.LinkID;
import com.paterva.maltego.graph.store.GraphStore;
import com.paterva.maltego.graph.store.GraphStoreRegistry;
import com.paterva.maltego.graph.store.data.GraphStoreException;
import com.paterva.maltego.graph.store.structure.GraphStructureReader;
import java.util.HashSet;
import java.util.Set;

class GraphHelper {
    private GraphHelper() {
    }

    public static Set<EntityID> getRootParents(EntityID entityID, GraphID graphID) throws GraphStoreException {
        HashSet<EntityID> roots = new HashSet<EntityID>();
        GraphHelper.getRootParents(entityID, graphID, roots);
        return roots;
    }

    public static void getRootParents(EntityID entityID, GraphID graphID, Set<EntityID> roots) throws GraphStoreException {
        HashSet<EntityID> touched = new HashSet<EntityID>();
        GraphStore graphStore = GraphStoreRegistry.getDefault().forGraphID(graphID);
        GraphStructureReader structureReader = graphStore.getGraphStructureStore().getStructureReader();
        GraphHelper.addRootParentRecurse(entityID, structureReader, roots, touched);
    }

    private static void addRootParentRecurse(EntityID start, GraphStructureReader structureReader, Set<EntityID> roots, Set<EntityID> touched) throws GraphStoreException {
        if (!touched.contains(start)) {
            Set inLinks = structureReader.getIncoming(start);
            if (inLinks.size() > 0) {
                touched.add(start);
                for (LinkID linkID : inLinks) {
                    EntityID parentID = structureReader.getSource(linkID);
                    GraphHelper.addRootParentRecurse(parentID, structureReader, roots, touched);
                }
            } else {
                roots.add(start);
            }
        }
    }
}

