/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.util.ui.slide;

import com.paterva.maltego.util.ui.Direction;
import com.paterva.maltego.util.ui.slide.SlideCallback;
import com.paterva.maltego.util.ui.slide.SlideWindow;
import com.paterva.maltego.util.ui.slide.SlideWindowManager;
import com.paterva.maltego.util.ui.slide.SlideWindowSizer;
import com.paterva.maltego.util.ui.slide.SlideWindowTab;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Path2D;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.Border;

public class SlideWindowContainer
extends JPanel {
    private static final double SLIDE_SPEED = 0.4;
    private static final int POS_IN = 1;
    private static final int POS_OUT = 0;
    private JPanel _sliderPanel;
    private SlideWindowTab _tab;
    private SlideWindowSizer _sizer;
    private double _slidePosition;
    private double _slideIncrement;
    private Timer _slideTimer;
    private Direction _direction = Direction.EAST;
    private AWTEventListener _enterExitListener;
    private long _startSlideTime = 0L;
    private double _startSlidePosition;
    private int _enterExitSlidePosition = 1;
    private int _childSlidePosition = 1;
    private int _desiredSlidePosition = 1;
    private SlideWindow _slideWindow;
    private SlideCallback _slideCallback = new SlideCallbackImpl();
    private Dimension _parentSize;
    private JPanel _tabLeftFiller;
    private JPanel _tabTopFiller;
    private boolean _doingLayout = false;

    public SlideWindowContainer(SlideWindow slideWindow) {
        this.updateDesiredSlidePosition();
        this._slidePosition = this._desiredSlidePosition;
        this._slideWindow = slideWindow;
        this.setLayout(new BorderLayout());
        this.setOpaque(false);
        this._sliderPanel = new SlideTabPanel(new GridBagLayout());
        this._sliderPanel.setOpaque(false);
        this._tab = new SlideWindowTab(this, this._slideWindow.getSlideWindowName());
        this.addTabPanels();
        this._slideTimer = new Timer(0, new SlideTimerListener());
        this._slideTimer.setRepeats(true);
        this._slideTimer.setDelay(20);
        JPanel borderPanel = new JPanel(new BorderLayout());
        borderPanel.setOpaque(false);
        borderPanel.setBorder(new SlideBorder());
        borderPanel.add(this._slideWindow.getComponent());
        this.add(borderPanel);
        this._sizer = new SlideWindowSizer();
        this._sizer.setDestination(this);
        this._sizer.setSource(borderPanel);
    }

    private void addTabPanels() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        this._sliderPanel.add((Component)this._tab, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        this._tabLeftFiller = new JPanel();
        this._tabLeftFiller.setOpaque(false);
        this._sliderPanel.add((Component)this._tabLeftFiller, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        this._tabTopFiller = new JPanel();
        this._tabTopFiller.setOpaque(false);
        this._sliderPanel.add((Component)this._tabTopFiller, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        JPanel panel = new JPanel();
        panel.setPreferredSize(new Dimension(0, 0));
        panel.setOpaque(false);
        this._sliderPanel.add((Component)panel, gridBagConstraints);
    }

    public SlideWindow getSlideWindow() {
        return this._slideWindow;
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        width = Math.max(width, 150);
        height = Math.max(height, 150);
        Dimension parentSize = this.getParentSize();
        if (parentSize != null) {
            width = Math.min(width, (int)((double)parentSize.width * 0.8));
            height = Math.min(height, (int)((double)parentSize.height * 0.8));
            int right = parentSize.width - (x + width);
            int bottom = parentSize.height - (y + height);
            if (x <= y && x <= right && x <= bottom) {
                this._direction = Direction.WEST;
                x = this.getSlideLeftBorder();
                y = this.limit(y, 0, parentSize.height - height);
            } else if (y <= x && y <= right && y <= bottom) {
                this._direction = Direction.NORTH;
                y = this.getSlideTopBorder();
                x = this.limit(x, 0, parentSize.width - width);
            } else if (right <= x && right <= y && right <= bottom) {
                this._direction = Direction.EAST;
                x = this.getSlideRightBorder(width);
                y = this.limit(y, 0, parentSize.height - height);
            } else {
                this._direction = Direction.SOUTH;
                y = this.getSlideBottomBorder(height);
                x = this.limit(x, 0, parentSize.width - width);
            }
        }
        if (x != this.getX() || y != this.getY() || width != this.getWidth() || height != this.getHeight()) {
            super.setBounds(x, y, width, height);
            this.updateSliderControlPosition();
        }
    }

    private Dimension getParentSize() {
        Container parent;
        if (this._parentSize == null && (parent = this.getParent()) != null) {
            this._parentSize = parent.getSize();
        }
        return this._parentSize;
    }

    private int limit(int current, int min, int max) {
        return Math.min(Math.max(current, min), max);
    }

    @Override
    public void doLayout() {
        if (!this._doingLayout) {
            this._doingLayout = true;
            this.setBounds(this.getBounds());
            this._doingLayout = false;
        }
        super.doLayout();
    }

    private void updateSliderControlPosition() {
        Direction tabDirection;
        Container parent = this.getParent();
        if (parent != null && !(tabDirection = this.getTabDirection()).equals((Object)this._tab.getDirection())) {
            this.remove(this._sliderPanel);
            if (Direction.NORTH == tabDirection || Direction.SOUTH == tabDirection) {
                this._tabLeftFiller.setPreferredSize(new Dimension(11, 11));
                this._tabTopFiller.setPreferredSize(new Dimension(0, 0));
            } else {
                this._tabLeftFiller.setPreferredSize(new Dimension(0, 0));
                this._tabTopFiller.setPreferredSize(new Dimension(11, 11));
            }
            this._tab.setDirection(tabDirection);
            this.add((Component)this._sliderPanel, this.getBorderLayoutDirection(tabDirection));
            this.validate();
        }
    }

    public Direction getDirection() {
        return this._direction;
    }

    private Direction getTabDirection() {
        switch (this._direction) {
            case NORTH: {
                return Direction.SOUTH;
            }
            case SOUTH: {
                return Direction.NORTH;
            }
            case EAST: {
                return Direction.WEST;
            }
            case WEST: {
                return Direction.EAST;
            }
        }
        return null;
    }

    private String getBorderLayoutDirection(Direction direction) {
        switch (direction) {
            case NORTH: {
                return "North";
            }
            case SOUTH: {
                return "South";
            }
            case EAST: {
                return "East";
            }
            case WEST: {
                return "West";
            }
        }
        return null;
    }

    private void updateDesiredSlidePosition() {
        int desired = this._enterExitSlidePosition;
        if (this._childSlidePosition == 0) {
            desired = 0;
        }
        if (desired != this._desiredSlidePosition) {
            this._desiredSlidePosition = desired;
            this.startSliding();
        }
    }

    private void startSliding() {
        if (this._desiredSlidePosition == 0) {
            this.startSlideOut();
        } else {
            this.startSlideIn();
        }
    }

    private void startSlideOut() {
        this._slideIncrement = -2.5;
        this.startSlideTimer();
    }

    private void startSlideIn() {
        this._slideIncrement = 2.5;
        this.startSlideTimer();
    }

    private void startSlideTimer() {
        this._startSlidePosition = this._slidePosition;
        this._startSlideTime = System.currentTimeMillis();
        if (!this._slideTimer.isRunning()) {
            this._slideTimer.start();
        }
    }

    private int getSlideTopBorder() {
        int top = 0;
        if (Direction.NORTH.equals((Object)this._direction)) {
            top -= (int)((double)this.getContentHeight() * this.getExponential(this._slidePosition));
        }
        return top;
    }

    private int getSlideLeftBorder() {
        int left = 0;
        if (Direction.WEST.equals((Object)this._direction)) {
            left -= (int)((double)this.getContentWidth() * this.getExponential(this._slidePosition));
        }
        return left;
    }

    private int getSlideRightBorder(int newWidth) {
        int right = this.getParent().getWidth() - newWidth;
        if (Direction.EAST.equals((Object)this._direction)) {
            right += (int)((double)this.getContentWidth() * this.getExponential(this._slidePosition));
        }
        return right;
    }

    private int getSlideBottomBorder(int newHeight) {
        int bottom = this.getParent().getHeight() - newHeight;
        if (Direction.SOUTH.equals((Object)this._direction)) {
            bottom += (int)((double)this.getContentHeight() * this.getExponential(this._slidePosition));
        }
        return bottom;
    }

    private int getContentWidth() {
        return this.getWidth() - this._tab.getPreferredSize().width;
    }

    private int getContentHeight() {
        return this.getHeight() - this._tab.getPreferredSize().height;
    }

    public boolean isPinned() {
        return this._tab.isPinned();
    }

    public void setPinned(boolean pinned) {
        this._tab.setPinned(pinned);
        this._slidePosition = pinned ? 0.0 : 1.0;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this._enterExitListener = new EnterExitMouseHandler();
        Toolkit.getDefaultToolkit().addAWTEventListener(this._enterExitListener, 16L);
        this._slideWindow.addSlideCallback(this._slideCallback);
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        Toolkit.getDefaultToolkit().removeAWTEventListener(this._enterExitListener);
        this._enterExitListener = null;
        this._slideWindow.removeSlideCallback(this._slideCallback);
    }

    private double getExponential(double position) {
        return Math.pow(position, 3.0);
    }

    private class SlideCallbackImpl
    implements SlideCallback {
        private SlideCallbackImpl() {
        }

        @Override
        public void slideOut() {
            SlideWindowContainer.this._childSlidePosition = 0;
            SlideWindowContainer.this.updateDesiredSlidePosition();
        }

        @Override
        public void slideIn() {
            SlideWindowContainer.this._childSlidePosition = 1;
            SlideWindowContainer.this.updateDesiredSlidePosition();
        }
    }

    private class SlideBorder
    implements Border {
        private Insets _insets;

        private SlideBorder() {
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            Graphics2D g2D = (Graphics2D)g;
            g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            AffineTransform backupTransform = g2D.getTransform();
            int fillTopOffset = 1;
            int fillLeftOffset = 1;
            int fillRightOffset = 0;
            int fillBottomOffset = 0;
            switch (SlideWindowContainer.this._direction) {
                case EAST: {
                    g2D.transform(AffineTransform.getQuadrantRotateInstance(1));
                    g2D.translate(0, -(width - 1));
                    int temp = width;
                    width = height;
                    height = temp;
                    fillTopOffset = 0;
                    fillBottomOffset = -1;
                    break;
                }
                case WEST: {
                    g2D.translate(0, height - 1);
                    g2D.transform(AffineTransform.getQuadrantRotateInstance(-1));
                    int temp = width;
                    width = height;
                    height = temp;
                    fillLeftOffset = 0;
                    fillRightOffset = -1;
                    break;
                }
                case SOUTH: {
                    g2D.scale(1.0, -1.0);
                    g2D.translate(0, -(height - 1));
                    fillTopOffset = 0;
                    fillBottomOffset = -1;
                }
            }
            UIDefaults laf = UIManager.getLookAndFeelDefaults();
            SlideWindow active = SlideWindowManager.getDefault().getActive();
            boolean isActive = SlideWindowContainer.this._slideWindow.equals(active);
            g.setColor(laf.getColor(isActive ? "fullscreen-border-color" : "fullscreen-border-transparent"));
            int top = y;
            int left = x;
            int right = width - 1;
            int bottom = height - 1;
            int border = 5;
            Path2D linePath = null;
            Path2D fillPath = null;
            linePath = this.createNorthBorderPath(top, border, left, right, bottom, true);
            fillPath = this.createNorthBorderPath(top + fillTopOffset, border - 1, left + fillLeftOffset, right + fillRightOffset, bottom + fillBottomOffset, true);
            g2D.draw(linePath);
            g.setColor(laf.getColor(isActive ? "fullscreen-window-color" : "fullscreen-window-transparent"));
            g2D.fill(fillPath);
            g2D.setTransform(backupTransform);
        }

        @Override
        public Insets getBorderInsets(Component c) {
            if (this._insets == null) {
                this._insets = new Insets(6, 6, 6, 6);
            }
            return this._insets;
        }

        @Override
        public boolean isBorderOpaque() {
            return true;
        }

        private Path2D createNorthBorderPath(int top, int border, int left, int right, int bottom, boolean fill) {
            Path2D.Float linePath = new Path2D.Float(0);
            int innerTop = top + border;
            int innerLeft = left + border;
            int innerRight = right - border;
            int innerBottom = bottom - border;
            this.append3SidesNorth(linePath, left, bottom + (fill ? 1 : 0), top, right, fill, true);
            this.append3SidesNorth(linePath, innerLeft, innerBottom, innerTop, innerRight, fill, false);
            ((Path2D)linePath).lineTo(innerLeft + 1, innerBottom);
            return linePath;
        }

        private void append3SidesNorth(Path2D linePath, int left, int bottom, int top, int right, boolean fill, boolean round) {
            if (round) {
                linePath.moveTo(left + 11, bottom);
                linePath.quadTo(left, bottom, left, bottom - 11);
                if (!fill) {
                    linePath.moveTo(left, bottom - 11 - 1);
                }
            } else {
                linePath.moveTo(left, bottom);
            }
            linePath.lineTo(left, top);
            if (!fill) {
                linePath.moveTo(left + 1, top);
            }
            linePath.lineTo(right, top);
            if (!fill) {
                linePath.moveTo(right, top + 1);
            }
            if (round) {
                linePath.lineTo(right, bottom - 11);
                if (!fill) {
                    linePath.moveTo(left, bottom - 11 + 1);
                }
                linePath.quadTo(right, bottom, right - 11, bottom);
            } else {
                linePath.lineTo(right, bottom);
                if (!fill) {
                    linePath.moveTo(right - 1, bottom);
                }
            }
        }
    }

    private class SlideTabPanel
    extends JPanel {
        public SlideTabPanel(LayoutManager layout) {
            super(layout);
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent e) {
                    if (SlideTabPanel.this.getParent() != null) {
                        MouseListener[] ml;
                        for (MouseListener l : ml = SlideTabPanel.this.getParent().getMouseListeners()) {
                            l.mouseEntered(e);
                        }
                    }
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    if (SlideTabPanel.this.getParent() != null) {
                        MouseListener[] ml;
                        for (MouseListener l : ml = SlideTabPanel.this.getParent().getMouseListeners()) {
                            l.mouseExited(e);
                        }
                    }
                }
            });
        }

        @Override
        public void paint(Graphics g) {
            SlideWindow active = SlideWindowManager.getDefault().getActive();
            boolean isActive = SlideWindowContainer.this._slideWindow.equals(active);
            UIDefaults laf = UIManager.getLookAndFeelDefaults();
            g.setColor(laf.getColor(isActive ? "fullscreen-border-color" : "fullscreen-border-transparent"));
            int cornerBorder = 7;
            if (Direction.SOUTH.equals((Object)SlideWindowContainer.this._direction)) {
                g.drawLine(cornerBorder, this.getHeight() - 1, SlideWindowContainer.this._tab.getX(), this.getHeight() - 1);
                g.drawLine(SlideWindowContainer.this._tab.getX() + SlideWindowContainer.this._tab.getWidth(), this.getHeight() - 1, this.getWidth() - 1 - cornerBorder, this.getHeight() - 1);
            } else if (Direction.NORTH.equals((Object)SlideWindowContainer.this._direction)) {
                g.drawLine(cornerBorder, 0, SlideWindowContainer.this._tab.getX(), 0);
                g.drawLine(SlideWindowContainer.this._tab.getX() + SlideWindowContainer.this._tab.getWidth(), 0, this.getWidth() - 1 - cornerBorder, 0);
            } else if (Direction.WEST.equals((Object)SlideWindowContainer.this._direction)) {
                g.drawLine(0, cornerBorder, 0, SlideWindowContainer.this._tab.getY());
                g.drawLine(0, SlideWindowContainer.this._tab.getY() + SlideWindowContainer.this._tab.getHeight(), 0, this.getHeight() - 1 - cornerBorder);
            } else {
                g.drawLine(this.getWidth() - 1, cornerBorder, this.getWidth() - 1, SlideWindowContainer.this._tab.getY());
                g.drawLine(this.getWidth() - 1, SlideWindowContainer.this._tab.getY() + SlideWindowContainer.this._tab.getHeight(), this.getWidth() - 1, this.getHeight() - 1 - cornerBorder);
            }
            super.paint(g);
        }
    }

    private class SlideTimerListener
    implements ActionListener {
        private SlideTimerListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (SlideWindowContainer.this._tab.canSlide() && !SlideWindowContainer.this._sizer.isResizing()) {
                long elapsed = System.currentTimeMillis() - SlideWindowContainer.this._startSlideTime;
                SlideWindowContainer.this._slidePosition = SlideWindowContainer.this._startSlidePosition + SlideWindowContainer.this._slideIncrement * (double)elapsed / 1000.0;
            } else {
                SlideWindowContainer.this._slidePosition = -1.0;
            }
            if (SlideWindowContainer.this._slidePosition > 1.0) {
                SlideWindowContainer.this._slidePosition = 1.0;
                SlideWindowContainer.this._slideTimer.stop();
            } else if (SlideWindowContainer.this._slidePosition < 0.0) {
                SlideWindowContainer.this._slidePosition = 0.0;
                SlideWindowContainer.this._slideTimer.stop();
            }
            SlideWindowContainer.this.setBounds(SlideWindowContainer.this.getBounds());
        }
    }

    private class EnterExitMouseHandler
    implements AWTEventListener {
        private boolean _hasExited = true;

        private EnterExitMouseHandler() {
        }

        @Override
        public void eventDispatched(AWTEvent e) {
            MouseEvent m;
            if (e instanceof MouseEvent && ((m = (MouseEvent)e).getID() == 504 || m.getID() == 505 || m.getID() == 500)) {
                Point p = m.getLocationOnScreen();
                Rectangle bounds = SlideWindowContainer.this.getBounds();
                Point location = new Point(0, 0);
                SwingUtilities.convertPointToScreen(location, SlideWindowContainer.this);
                bounds.setLocation(location);
                if (!bounds.contains(p)) {
                    if (!this._hasExited) {
                        SlideWindow active = SlideWindowManager.getDefault().getActive();
                        if (!SlideWindowContainer.this._slideWindow.equals(active)) {
                            this._hasExited = true;
                            SlideWindowContainer.this._enterExitSlidePosition = 1;
                            SlideWindowContainer.this.updateDesiredSlidePosition();
                        }
                    }
                } else if (this._hasExited) {
                    this._hasExited = false;
                    SlideWindowContainer.this._enterExitSlidePosition = 0;
                    SlideWindowContainer.this.updateDesiredSlidePosition();
                }
            }
        }
    }
}

