/*
 * Decompiled with CFR 0.152.
 */
package org.xlightweb;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xlightweb.BodyDataSink;
import org.xlightweb.HttpResponse;
import org.xlightweb.HttpResponseHeader;
import org.xlightweb.HttpUtils;
import org.xlightweb.IHttpExchange;
import org.xlightweb.IHttpRequest;
import org.xlightweb.IHttpResponse;
import org.xlightweb.IHttpResponseHandler;
import org.xlightweb.IHttpResponseHeader;
import org.xlightweb.InvokeOn;
import org.xlightweb.RequestHandlerBase;
import org.xsocket.DataConverter;
import org.xsocket.Execution;
import org.xsocket.connection.IConnection;
import org.xsocket.connection.IWriteCompletionHandler;

public class FileServiceRequestHandler
extends RequestHandlerBase {
    private static final Logger LOG = Logger.getLogger(FileServiceRequestHandler.class.getName());
    public static final boolean SHOW_DIRECTORY_TREE_DEFAULT = false;
    private static final Map<String, String> MIME_TYPE_MAPPING = HttpUtils.getMimeTypeMapping();
    private static final int TRANSFER_BYTE_BUFFER_MAX_MAP_SIZE = Integer.parseInt(System.getProperty("org.xsocket.connection.transfer.mappedbytebuffer.maxsize", "65536"));
    private final File fileBase;
    private final boolean isShowDirectoryTree;
    private AtomicInteger pendingSendtransactions = new AtomicInteger(0);
    private int countFound = 0;
    private int countNotFound = 0;

    public FileServiceRequestHandler(String fileBasepath) throws FileNotFoundException {
        this(fileBasepath, false);
    }

    public FileServiceRequestHandler(String fileBasepath, boolean isShowDirectoryTree) throws FileNotFoundException {
        this.fileBase = new File(fileBasepath);
        this.isShowDirectoryTree = isShowDirectoryTree;
        if (!new File(fileBasepath).exists()) {
            throw new FileNotFoundException("base path " + fileBasepath + "does not exits");
        }
    }

    boolean isShowDirectoryTree() {
        return this.isShowDirectoryTree;
    }

    String getBasepath() {
        return this.fileBase.getAbsolutePath();
    }

    int getPendingSendTransactions() {
        return this.pendingSendtransactions.get();
    }

    int getCountFound() {
        return this.countFound;
    }

    int getCountNotFound() {
        return this.countNotFound;
    }

    @Execution(value=1)
    @InvokeOn(value=1)
    public void onRequest(IHttpExchange exchange) throws IOException {
        IHttpRequest request = exchange.getRequest();
        if (request.getMethod().equalsIgnoreCase("GET") || request.getMethod().equalsIgnoreCase("POST")) {
            String requestURI = URLDecoder.decode(request.getRequestURI(), "UTF-8");
            int ctxLength = request.getContextPath().length() + request.getRequestHandlerPath().length();
            if (requestURI.length() > ctxLength) {
                String filepath = requestURI.substring(ctxLength, requestURI.length());
                if (filepath.length() > 0) {
                    File file;
                    filepath = filepath.replaceAll("[/\\\\]+", "\\" + File.separator);
                    String path = this.fileBase.getAbsolutePath() + filepath;
                    if (path.endsWith(File.separator)) {
                        path = path.substring(0, path.length() - 1);
                    }
                    if ((file = new File(path)).exists()) {
                        if (file.isFile()) {
                            long ifModifedSince;
                            long lastModified = file.lastModified() / 1000L * 1000L;
                            String ifModifiedSinceRequestHeader = request.getHeader("If-Modified-Since");
                            if (ifModifiedSinceRequestHeader != null && lastModified <= (ifModifedSince = DataConverter.toDate((String)ifModifiedSinceRequestHeader).getTime())) {
                                HttpResponse response = new HttpResponse(304);
                                this.enhanceFoundResponseHeader(response.getResponseHeader(), lastModified, filepath);
                                if (LOG.isLoggable(Level.FINE)) {
                                    LOG.fine(filepath + " requested. returning not modified");
                                }
                                exchange.send(response);
                                return;
                            }
                            HttpResponseHeader responseHeader = new HttpResponseHeader(200);
                            this.enhanceFoundResponseHeader(responseHeader, lastModified, filepath);
                            if (LOG.isLoggable(Level.FINE)) {
                                LOG.fine(filepath + " requested. returning data");
                            }
                            BodyDataSink outChannel = exchange.send(responseHeader, (int)file.length());
                            SendFileProcess sendFile = new SendFileProcess(exchange.getConnection().getId(), outChannel, file);
                            sendFile.start();
                            ++this.countFound;
                            return;
                        }
                        this.handleNotFound(exchange, request, file);
                        return;
                    }
                    this.handleNotFound(exchange, request, file);
                    return;
                }
            } else {
                exchange.sendError(404, request.getRequestURI() + " not found");
                return;
            }
        }
        this.handleNotFound(exchange, request, this.fileBase);
    }

    private void enhanceFoundResponseHeader(IHttpResponseHeader responseHeader, long lastModified, String filepath) {
        responseHeader.setDate(DataConverter.toFormatedRFC822Date((long)System.currentTimeMillis()));
        responseHeader.setHeader("Last-Modified", DataConverter.toFormatedRFC822Date((long)lastModified));
        int pos = filepath.lastIndexOf(".");
        if (pos != -1) {
            String extension = filepath.substring(pos + 1, filepath.length());
            String mimeType = MIME_TYPE_MAPPING.get(extension);
            if (mimeType == null) {
                responseHeader.setContentType("application/octet-stream");
            } else {
                responseHeader.setContentType(mimeType);
            }
        }
    }

    private void handleNotFound(IHttpExchange exchange, IHttpRequest request, File file) throws IOException {
        ++this.countNotFound;
        if (this.isShowDirectoryTree && file.isDirectory() && this.fileBase.getAbsolutePath().length() <= file.getAbsolutePath().length()) {
            String body = this.printDirectoryTree(request, file);
            exchange.send(new HttpResponse(200, "text/html", body));
            return;
        }
        exchange.forward(request, (IHttpResponseHandler)new HttpResponseHandler(exchange));
    }

    private String printDirectoryTree(IHttpRequest request, File directory) throws IOException {
        StringBuilder sb = new StringBuilder();
        String requestResource = directory.getAbsolutePath();
        requestResource = requestResource.substring(this.fileBase.getAbsolutePath().length(), requestResource.length());
        if (request.getRequestHandlerPath().length() > 0) {
            requestResource = request.getRequestHandlerPath() + "/" + requestResource;
        }
        if (request.getContextPath().length() > 0) {
            requestResource = request.getContextPath() + "/" + requestResource;
        }
        requestResource = requestResource.replace("\\", "/");
        sb.append("<html>\r\n");
        sb.append("  <!-- This page is auto-generated by xSocket-http (http://xsocket.org) -->\r\n");
        sb.append("  <head>\r\n");
        sb.append("    <title>Index of " + requestResource + "</title>\r\n");
        sb.append("  </head>\r\n");
        sb.append("  <body>\r\n");
        sb.append("    <H1 style=\"color:#0a328c;font-size:1.5em;\">Index of " + requestResource + "</H1>\r\n");
        sb.append("    <p style=\"font-size:0.8em;\">\r\n");
        sb.append("    <table border=\"0\" style=\"color:#0a328c;font-size:1.0em;\">\r\n");
        for (File file : directory.listFiles()) {
            sb.append("      <tr>");
            sb.append("        <td align=\"right\">");
            if (file.isDirectory()) {
                sb.append("[DIR]");
            } else {
                sb.append("[TXT]");
            }
            sb.append("        </td>\r\n");
            sb.append("        <td>");
            sb.append("<a href=");
            String[] parts = requestResource.split("/");
            if (parts.length > 0) {
                sb.append(URLEncoder.encode(parts[parts.length - 1], "UTF-8") + "/");
            }
            sb.append(URLEncoder.encode(file.getName(), "UTF-8") + "> " + file.getName() + "</a>");
            sb.append("        </td>\r\n");
            sb.append("        <td>");
            sb.append(DataConverter.toFormatedDate((long)file.lastModified()));
            sb.append("        </td>\r\n");
            sb.append("        <td align=\"right\">");
            if (!file.isDirectory()) {
                sb.append(DataConverter.toFormatedBytesSize((long)file.length()));
            } else {
                sb.append("-");
            }
            sb.append("        </td>\r\n");
            sb.append("      </tr>");
        }
        sb.append("    </table>\r\n");
        sb.append("    </p>\r\n");
        sb.append("    <p style=\"font-size:0.8em;\">" + new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss Z").format(new Date()) + "    xLightweb (" + HttpUtils.getImplementationVersion() + ") at " + request.getServerName() + " Port " + request.getServerPort() + "</p>\r\n");
        sb.append("  </body>\r\n");
        sb.append("</html>\r\n");
        return sb.toString();
    }

    private static final class HttpResponseHandler
    implements IHttpResponseHandler {
        private IHttpExchange exchange = null;

        public HttpResponseHandler(IHttpExchange exchange) {
            this.exchange = exchange;
        }

        public void onResponse(IHttpResponse response) throws IOException {
            this.exchange.send(response);
        }

        public void onException(IOException ioe) {
            this.exchange.sendError(500);
        }
    }

    @Execution(value=1)
    private final class SendFileProcess
    implements IWriteCompletionHandler {
        private final String id;
        private final File file;
        private final RandomAccessFile raf;
        private final FileChannel fc;
        private final BodyDataSink outChannel;
        private long remaining = 0L;
        private long offset = 0L;
        private long length = 0L;
        private int bufferHashcode = 0;

        public SendFileProcess(String id, BodyDataSink outChannel, File file) throws IOException {
            this.id = id;
            this.file = file;
            this.raf = new RandomAccessFile(file, "r");
            this.fc = this.raf.getChannel();
            this.outChannel = outChannel;
            outChannel.setFlushmode(IConnection.FlushMode.ASYNC);
            this.remaining = file.length();
        }

        public void start() throws IOException {
            FileServiceRequestHandler.this.pendingSendtransactions.incrementAndGet();
            this.write();
        }

        public void onWritten(int written) throws IOException {
            if (LOG.isLoggable(Level.FINE)) {
                if (this.remaining > 0L) {
                    LOG.fine("[" + this.id + "] {" + this.bufferHashcode + "} data (size=" + written + " bytes) has been written. Writing next chunk");
                } else {
                    LOG.fine("[" + this.id + "] {" + this.bufferHashcode + "} data (size=" + written + " bytes) has been written.");
                }
            }
            this.write();
        }

        private void write() throws IOException {
            if (this.remaining > 0L) {
                this.length = this.remaining > (long)TRANSFER_BYTE_BUFFER_MAX_MAP_SIZE ? (long)TRANSFER_BYTE_BUFFER_MAX_MAP_SIZE : this.remaining;
                MappedByteBuffer buffer = this.fc.map(FileChannel.MapMode.READ_ONLY, this.offset, this.length);
                ByteBuffer[] bufs = new ByteBuffer[]{buffer};
                this.bufferHashcode = bufs.hashCode();
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("[" + this.id + "] {" + this.bufferHashcode + "} writing data (size=" + this.length + " bytes)");
                }
                this.outChannel.write(bufs, this);
                this.offset += this.length;
                this.remaining -= this.length;
            } else {
                this.closeFile();
                this.outChannel.close();
            }
        }

        public void onException(IOException ioe) {
            this.closeFile();
            this.outChannel.destroy();
        }

        private void closeFile() {
            block2: {
                try {
                    FileServiceRequestHandler.this.pendingSendtransactions.decrementAndGet();
                    this.fc.close();
                    this.raf.close();
                }
                catch (IOException ioe) {
                    if (!LOG.isLoggable(Level.FINE)) break block2;
                    LOG.fine("error occured by clsoing file channel " + this.file.getAbsolutePath());
                }
            }
        }
    }
}

