/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.collab.session.xmpp.bosh;

import com.paterva.maltego.collab.session.xmpp.bosh.BoshClientSocket;
import com.paterva.maltego.collab.session.xmpp.bosh.BoshConfiguration;
import com.paterva.maltego.collab.session.xmpp.bosh.BoshDebugSocket;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import javax.net.SocketFactory;

class BoshSocketFactory
extends SocketFactory {
    private boolean debug = false;
    private BoshConfiguration _config;

    public BoshSocketFactory(BoshConfiguration config) {
        this._config = config;
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        Socket newSocket = this.createSocketImpl();
        newSocket.connect(new InetSocketAddress(host, port));
        return newSocket;
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException, UnknownHostException {
        Socket newSocket = this.createSocketImpl();
        newSocket.bind(new InetSocketAddress(localHost, localPort));
        newSocket.connect(new InetSocketAddress(host, port));
        return newSocket;
    }

    @Override
    public Socket createSocket(InetAddress host, int port) throws IOException {
        Socket newSocket = this.createSocketImpl();
        newSocket.connect(new InetSocketAddress(host, port));
        return newSocket;
    }

    @Override
    public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
        Socket newSocket = this.createSocketImpl();
        newSocket.bind(new InetSocketAddress(localAddress, localPort));
        newSocket.connect(new InetSocketAddress(address, port));
        return newSocket;
    }

    private Socket createSocketImpl() throws SocketException {
        if (this.debug) {
            return new BoshDebugSocket();
        }
        return new BoshClientSocket(this._config.getURI(), this._config.getServiceName(), this._config.getProxy(), this._config.isHttps());
    }
}

