/*
 * Decompiled with CFR 0.152.
 */
package org.openid4java.association;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openid4java.association.AssociationException;

public class AssociationSessionType
implements Comparable {
    private static Log _log = LogFactory.getLog(AssociationSessionType.class);
    private static final boolean DEBUG = _log.isDebugEnabled();
    public static final AssociationSessionType NO_ENCRYPTION_SHA1MAC = new AssociationSessionType("no-encryption", null, "HMAC-SHA1", false, 0);
    public static final AssociationSessionType NO_ENCRYPTION_COMPAT_SHA1MAC = new AssociationSessionType("", null, "HMAC-SHA1", true, 1);
    public static final AssociationSessionType NO_ENCRYPTION_SHA256MAC = new AssociationSessionType("no-encryption", null, "HMAC-SHA256", false, 2);
    public static final AssociationSessionType DH_SHA1 = new AssociationSessionType("DH-SHA1", "SHA-1", "HMAC-SHA1", false, 3);
    public static final AssociationSessionType DH_COMPAT_SHA1 = new AssociationSessionType("DH-SHA1", "SHA-1", "HMAC-SHA1", true, 4);
    public static final AssociationSessionType DH_SHA256 = new AssociationSessionType("DH-SHA256", "SHA-256", "HMAC-SHA256", false, 5);
    private String _sessType;
    private String _hAlgorithm;
    private String _assocType;
    private boolean _compat;
    private int _order;

    private AssociationSessionType(String sessType, String hAlgorithm, String assocType, boolean compat, int order) {
        this._sessType = sessType;
        this._hAlgorithm = hAlgorithm;
        this._assocType = assocType;
        this._compat = compat;
        this._order = order;
    }

    public static AssociationSessionType create(String sessType) throws AssociationException {
        return AssociationSessionType.create(sessType, "HMAC-SHA1");
    }

    public static AssociationSessionType create(String sessType, String assocType) throws AssociationException {
        return AssociationSessionType.create(sessType, assocType, false);
    }

    public static AssociationSessionType create(String sessType, String assocType, boolean compatibility) throws AssociationException {
        AssociationSessionType result;
        if (!compatibility && "no-encryption".equals(sessType) && "HMAC-SHA1".equals(assocType)) {
            result = NO_ENCRYPTION_SHA1MAC;
        } else if (!compatibility && "no-encryption".equals(sessType) && "HMAC-SHA256".equals(assocType)) {
            result = NO_ENCRYPTION_SHA256MAC;
        } else if (compatibility && ("".equals(sessType) || sessType == null) && ("HMAC-SHA1".equals(assocType) || assocType == null)) {
            result = NO_ENCRYPTION_COMPAT_SHA1MAC;
        } else if (!compatibility && "DH-SHA1".equals(sessType) && "HMAC-SHA1".equals(assocType)) {
            result = DH_SHA1;
        } else if (compatibility && ("DH-SHA1".equals(sessType) || sessType == null)) {
            result = DH_COMPAT_SHA1;
        } else if (!compatibility && "DH-SHA256".equals(sessType) && "HMAC-SHA256".equals(assocType)) {
            result = DH_SHA256;
        } else {
            throw new AssociationException("Unsupported session / association type: " + sessType + " : " + assocType + ", compatibility: " + compatibility);
        }
        if (DEBUG) {
            _log.debug((Object)("Session:Association Type: " + result));
        }
        return result;
    }

    public String getSessionType() {
        return this._sessType;
    }

    public String getHAlgorithm() {
        return this._hAlgorithm;
    }

    public String getAssociationType() {
        return this._assocType;
    }

    public int getKeySize() {
        if ("HMAC-SHA1".equals(this._assocType)) {
            return 160;
        }
        if ("HMAC-SHA256".equals(this._assocType)) {
            return 256;
        }
        return 0;
    }

    public int compareTo(Object object) {
        AssociationSessionType that = (AssociationSessionType)object;
        if (this._order == that._order) {
            return 0;
        }
        return this._order > that._order ? 1 : -1;
    }

    public boolean isBetter(AssociationSessionType other) {
        return this.compareTo(other) > 0;
    }

    public boolean isVersion2() {
        return !this._compat;
    }

    public String toString() {
        return this._sessType + ":" + this._assocType + ":" + (this._compat ? "OpenID1" : "OpenID2");
    }
}

