/**
* @license Apache-2.0
*
* Copyright (c) 2019 The Stdlib Authors.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*    http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

'use strict';

// MAIN //

/**
* Returns a callback to be invoked upon calling the `prevSlide` command.
*
* @private
* @param {Presentation} pres - presentation instance
* @returns {Function} callback
*/
function command( pres ) {
	return onCommand;

	/**
	* Moves to the previous presentation slide.
	*
	* @private
	*/
	function onCommand() {
		pres._repl.once( 'drain', onDrain ); // eslint-disable-line no-underscore-dangle

		/**
		* Callback invoked upon a `drain` event.
		*
		* @private
		*/
		function onDrain() {
			pres.prevSlide().show();
		}
	}
}


// EXPORTS //

module.exports = command;
