/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.hfsexplorer.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.DecimalFormat;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.catacombae.hfsexplorer.ObjectContainer;
import org.catacombae.hfsexplorer.SpeedUnitUtils;
import org.catacombae.hfsexplorer.Util;
import org.catacombae.hfsexplorer.gui.ChainedPanel;
import org.catacombae.hfsexplorer.gui.DateSummaryPanel;
import org.catacombae.hfsexplorer.gui.LinkTargetPanel;
import org.catacombae.hfsexplorer.gui.POSIXAttributesPanel;
import org.catacombae.jparted.lib.fs.FSAttributes;
import org.catacombae.jparted.lib.fs.FSEntry;
import org.catacombae.jparted.lib.fs.FSFile;
import org.catacombae.jparted.lib.fs.FSFolder;
import org.catacombae.jparted.lib.fs.FSLink;
import org.jdesktop.layout.GroupLayout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FSEntrySummaryPanel
extends JPanel
implements ChainedPanel {
    private volatile boolean cancelSignaled = false;
    private DecimalFormat sizeFormatter = new DecimalFormat("0.00");
    private JPanel extendedInfoStackPanel;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JSeparator jSeparator1;
    private JTextField nameField;
    private JTextField sizeField;
    private JTextField typeField;

    FSEntrySummaryPanel() {
        this.initComponents();
    }

    public FSEntrySummaryPanel(Window window, FSEntry entry, String[] parentPath) {
        this();
        String sizeString;
        String typeString;
        window.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                FSEntrySummaryPanel.this.cancelSignaled = true;
            }
        });
        this.nameField.setText(entry.getName());
        if (entry instanceof FSFile) {
            FSFile file = (FSFile)entry;
            typeString = "File";
            sizeString = this.getSizeString(file.getMainFork().getLength());
        } else if (entry instanceof FSFolder) {
            FSFolder folder = (FSFolder)entry;
            typeString = "Folder";
            sizeString = "Calculating...";
            this.startFolderSizeCalculation(folder);
        } else if (entry instanceof FSLink) {
            FSLink link = (FSLink)entry;
            FSEntry linkTarget = link.getLinkTarget(parentPath);
            if (linkTarget == null) {
                typeString = "Symbolic link (broken)";
                sizeString = "- (broken link)";
            } else if (linkTarget instanceof FSFile) {
                FSFile file = (FSFile)linkTarget;
                typeString = "Symbolic link (file)";
                sizeString = this.getSizeString(file.getMainFork().getLength());
            } else if (linkTarget instanceof FSFolder) {
                FSFolder folder = (FSFolder)linkTarget;
                typeString = "Symbolic link (folder)";
                sizeString = "Calculating...";
                this.startFolderSizeCalculation(folder);
            } else {
                typeString = "Symbolic link (unknown [" + linkTarget.getClass() + "])";
                sizeString = "- (unknown type)";
            }
        } else {
            typeString = "Unknown [" + entry.getClass() + "]";
            sizeString = "- (unknown type)";
        }
        this.typeField.setText(typeString);
        this.sizeField.setText(sizeString);
        FSAttributes attrs = entry.getAttributes();
        JPanel currentChain = this;
        if (entry instanceof FSLink) {
            LinkTargetPanel ltp = new LinkTargetPanel((FSLink)entry);
            currentChain.setChainedContents(ltp);
            currentChain = ltp;
        }
        DateSummaryPanel dsp = new DateSummaryPanel(attrs);
        currentChain.setChainedContents(dsp);
        currentChain = dsp;
        if (attrs.hasPOSIXFileAttributes()) {
            POSIXAttributesPanel attributesPanel = new POSIXAttributesPanel(attrs.getPOSIXFileAttributes());
            currentChain.setChainedContents(attributesPanel);
            currentChain = attributesPanel;
        }
    }

    @Override
    public void setChainedContents(Component c) {
        this.extendedInfoStackPanel.removeAll();
        this.extendedInfoStackPanel.add(c);
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.nameField = new JTextField();
        this.jLabel2 = new JLabel();
        this.typeField = new JTextField();
        this.jLabel3 = new JLabel();
        this.sizeField = new JTextField();
        this.jSeparator1 = new JSeparator();
        this.extendedInfoStackPanel = new JPanel();
        this.jLabel1.setText("Name:");
        this.nameField.setEditable(false);
        this.nameField.setText("jTextField1");
        this.nameField.setOpaque(false);
        this.jLabel2.setText("Type:");
        this.typeField.setEditable(false);
        this.typeField.setText("jTextField2");
        this.typeField.setBorder(null);
        this.typeField.setOpaque(false);
        this.jLabel3.setText("Size:");
        this.sizeField.setEditable(false);
        this.sizeField.setText("jTextField3");
        this.sizeField.setBorder(null);
        this.sizeField.setOpaque(false);
        this.extendedInfoStackPanel.setLayout(new BoxLayout(this.extendedInfoStackPanel, 3));
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(2).add(1, (Component)this.extendedInfoStackPanel, -1, 340, Short.MAX_VALUE).add(1, (Component)this.jSeparator1, -1, 340, Short.MAX_VALUE).add(1, (GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jLabel1).add((Component)this.jLabel2).add((Component)this.jLabel3)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.sizeField, -1, 305, Short.MAX_VALUE).add((Component)this.typeField, -1, 305, Short.MAX_VALUE).add((Component)this.nameField, -1, 305, Short.MAX_VALUE)))).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.nameField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel2).add((Component)this.typeField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel3).add((Component)this.sizeField, -2, -1, -2)).addPreferredGap(0).add((Component)this.jSeparator1, -2, -1, -2).addPreferredGap(0).add((Component)this.extendedInfoStackPanel, -1, 119, Short.MAX_VALUE).addContainerGap()));
    }

    private String getSizeString(long result) {
        String baseString = Long.toString(result);
        if (result >= 1000L) {
            String spacedString = Util.addUnitSpaces(baseString, 3);
            if (result >= 1024L) {
                return SpeedUnitUtils.bytesToBinaryUnit(result, this.sizeFormatter) + " (" + spacedString + " bytes" + ")";
            }
            return spacedString + " bytes";
        }
        return baseString + " bytes";
    }

    private void startFolderSizeCalculation(final FSFolder folder) {
        Runnable r = new Runnable(){

            public void run() {
                String resultString;
                try {
                    ObjectContainer<Long> result = new ObjectContainer<Long>(0L);
                    FSEntrySummaryPanel.this.calculateFolderSize(folder, result);
                    resultString = FSEntrySummaryPanel.this.getSizeString((Long)result.o);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    resultString = "Exception while calculating! See debug console for info...";
                }
                final String finalResultString = !FSEntrySummaryPanel.this.cancelSignaled ? resultString : "Canceled";
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        FSEntrySummaryPanel.this.sizeField.setText(finalResultString);
                    }
                });
            }
        };
        new Thread(r).start();
    }

    private void calculateFolderSize(FSFolder folder, ObjectContainer<Long> result) {
        if (this.cancelSignaled) {
            System.err.println("Calculate process stopping for folder \"" + folder.getName() + "\"");
            return;
        }
        for (FSEntry entry : folder.listEntries()) {
            if (this.cancelSignaled) {
                System.err.println("Calculate process stopping for folder \"" + folder.getName() + "\", entry \"" + entry.getName() + "\"");
                return;
            }
            if (entry instanceof FSFile) {
                ObjectContainer<Long> objectContainer = result;
                Long.valueOf((Long)objectContainer.o + ((FSFile)entry).getMainFork().getLength());
                objectContainer.o = objectContainer.o;
                continue;
            }
            if (entry instanceof FSFolder) {
                this.calculateFolderSize((FSFolder)entry, result);
                continue;
            }
            if (entry instanceof FSLink) continue;
            System.err.println("FSEntrySummaryPanel.calculateFolderSize(): unexpected type " + entry.getClass());
        }
    }
}

