/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.core.matcher;

import java.util.regex.Pattern;
import javax.swing.text.JTextComponent;
import org.fest.swing.annotation.RunsInCurrentThread;
import org.fest.swing.core.matcher.NamedComponentMatcherTemplate;
import org.fest.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JTextComponentMatcher
extends NamedComponentMatcherTemplate<JTextComponent> {
    private Object text;

    public static JTextComponentMatcher withName(String name) {
        return new JTextComponentMatcher(name, ANY);
    }

    public static JTextComponentMatcher withText(String text) {
        return new JTextComponentMatcher(ANY, (Object)text);
    }

    public static JTextComponentMatcher withText(Pattern textPattern) {
        return new JTextComponentMatcher(ANY, (Object)textPattern);
    }

    public static JTextComponentMatcher any() {
        return new JTextComponentMatcher(ANY, ANY);
    }

    private JTextComponentMatcher(Object name, Object text) {
        super(JTextComponent.class, name);
        this.text = text;
    }

    public JTextComponentMatcher andText(String newText) {
        this.text = newText;
        return this;
    }

    public JTextComponentMatcher andText(Pattern textPattern) {
        this.text = textPattern;
        return this;
    }

    public JTextComponentMatcher andShowing() {
        this.requireShowing(true);
        return this;
    }

    @Override
    @RunsInCurrentThread
    protected boolean isMatching(JTextComponent button) {
        if (!this.isNameMatching(button.getName())) {
            return false;
        }
        return this.arePropertyValuesMatching(this.text, button.getText());
    }

    public String toString() {
        return Strings.concat((Object[])new Object[]{this.getClass().getName(), "[", "name=", this.quotedName(), ", ", "text=", this.quoted(this.text), ", ", "requireShowing=", String.valueOf(this.requireShowing()), "]"});
    }
}

