// SPDX-FileCopyrightText: Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
// SPDX-License-Identifier: BSD-3-Clause

#include "vtkAppendPolyData.h"
#include "vtkClipPolyData.h"
#include "vtkConeSource.h"
#include "vtkCoordinateFrameRepresentation.h"
#include "vtkCoordinateFrameWidget.h"
#include "vtkGlyph3D.h"
#include "vtkLODActor.h"
#include "vtkNew.h"
#include "vtkPlane.h"
#include "vtkPolyDataMapper.h"
#include "vtkProperty.h"
#include "vtkRenderWindow.h"
#include "vtkRenderWindowInteractor.h"
#include "vtkRenderer.h"
#include "vtkSphereSource.h"
#include "vtkTesting.h"

const char TestCoordinateFrameWidgetLog[] = "# StreamVersion 1.1\n"
                                            "ExposeEvent 0 299 0 0 0 0\n"
                                            "RenderEvent 0 299 0 0 0 0\n"
                                            "EnterEvent 299 8 0 0 0 0\n"
                                            "MouseMoveEvent 299 8 0 0 0 0\n"
                                            "MouseMoveEvent 261 54 0 0 0 0\n"
                                            "LeftButtonPressEvent 261 54 0 0 0 0\n"
                                            "StartInteractionEvent 261 54 0 0 0 0\n"
                                            "TimerEvent 261 54 0 0 0 0\n"
                                            "RenderEvent 261 54 0 0 0 0\n"
                                            "TimerEvent 261 54 0 0 0 0\n"
                                            "RenderEvent 261 54 0 0 0 0\n"
                                            "TimerEvent 261 54 0 0 0 0\n"
                                            "RenderEvent 261 54 0 0 0 0\n"
                                            "TimerEvent 261 54 0 0 0 0\n"
                                            "RenderEvent 261 54 0 0 0 0\n"
                                            "TimerEvent 261 54 0 0 0 0\n"
                                            "RenderEvent 261 54 0 0 0 0\n"
                                            "TimerEvent 261 54 0 0 0 0\n"
                                            "RenderEvent 261 54 0 0 0 0\n"
                                            "TimerEvent 261 54 0 0 0 0\n"
                                            "RenderEvent 261 54 0 0 0 0\n"
                                            "LeftButtonReleaseEvent 261 54 0 0 0 0\n"
                                            "EndInteractionEvent 261 54 0 0 0 0\n"
                                            "RenderEvent 261 54 0 0 0 0\n"
                                            "MouseMoveEvent 261 54 0 0 0 0\n"
                                            "MouseMoveEvent 149 140 0 0 0 0\n"
                                            "RenderEvent 149 140 0 0 0 0\n"
                                            "MouseMoveEvent 148 141 0 0 0 0\n"
                                            "MouseMoveEvent 142 143 0 0 0 0\n"
                                            "RenderEvent 142 143 0 0 0 0\n"
                                            "MouseMoveEvent 142 142 0 0 0 0\n"
                                            "MouseMoveEvent 144 114 0 0 0 0\n"
                                            "KeyPressEvent 144 114 0 112 1 p\n"
                                            "RenderEvent 144 114 0 112 1 p\n"
                                            "CharEvent 144 114 0 112 1 p\n"
                                            "StartPickEvent 144 114 0 112 1 p\n"
                                            "RenderEvent 144 114 0 112 1 p\n"
                                            "EndPickEvent 144 114 0 112 1 p\n"
                                            "KeyReleaseEvent 144 114 0 112 1 p\n"
                                            "MouseMoveEvent 144 114 0 0 0 p\n"
                                            "RenderEvent 144 114 0 0 0 p\n"
                                            "MouseMoveEvent 144 114 0 0 0 p\n"
                                            "MouseMoveEvent 153 119 0 0 0 p\n"
                                            "RenderEvent 153 119 0 0 0 p\n"
                                            "MouseMoveEvent 153 119 0 0 0 p\n"
                                            "MouseMoveEvent 172 163 0 0 0 p\n"
                                            "RenderEvent 172 163 0 0 0 p\n"
                                            "MouseMoveEvent 171 163 0 0 0 p\n"
                                            "MouseMoveEvent 171 164 0 0 0 p\n"
                                            "MouseMoveEvent 171 165 0 0 0 p\n"
                                            "MouseMoveEvent 170 165 0 0 0 p\n"
                                            "MouseMoveEvent 169 165 0 0 0 p\n"
                                            "LeftButtonPressEvent 169 165 0 0 0 p\n"
                                            "RenderEvent 169 165 0 0 0 p\n"
                                            "MouseMoveEvent 169 165 0 0 0 p\n"
                                            "RenderEvent 169 165 0 0 0 p\n"
                                            "MouseMoveEvent 169 165 0 0 0 p\n"
                                            "RenderEvent 169 165 0 0 0 p\n"
                                            "MouseMoveEvent 169 165 0 0 0 p\n"
                                            "RenderEvent 169 165 0 0 0 p\n"
                                            "MouseMoveEvent 165 165 0 0 0 p\n"
                                            "RenderEvent 165 165 0 0 0 p\n"
                                            "MouseMoveEvent 159 163 0 0 0 p\n"
                                            "RenderEvent 159 163 0 0 0 p\n"
                                            "MouseMoveEvent 154 162 0 0 0 p\n"
                                            "RenderEvent 154 162 0 0 0 p\n"
                                            "MouseMoveEvent 151 162 0 0 0 p\n"
                                            "RenderEvent 151 162 0 0 0 p\n"
                                            "MouseMoveEvent 149 162 0 0 0 p\n"
                                            "RenderEvent 149 162 0 0 0 p\n"
                                            "MouseMoveEvent 148 161 0 0 0 p\n"
                                            "RenderEvent 148 161 0 0 0 p\n"
                                            "MouseMoveEvent 146 161 0 0 0 p\n"
                                            "RenderEvent 146 161 0 0 0 p\n"
                                            "MouseMoveEvent 145 160 0 0 0 p\n"
                                            "RenderEvent 145 160 0 0 0 p\n"
                                            "MouseMoveEvent 142 160 0 0 0 p\n"
                                            "RenderEvent 142 160 0 0 0 p\n"
                                            "MouseMoveEvent 140 160 0 0 0 p\n"
                                            "RenderEvent 140 160 0 0 0 p\n"
                                            "MouseMoveEvent 138 159 0 0 0 p\n"
                                            "RenderEvent 138 159 0 0 0 p\n"
                                            "MouseMoveEvent 137 159 0 0 0 p\n"
                                            "RenderEvent 137 159 0 0 0 p\n"
                                            "MouseMoveEvent 135 158 0 0 0 p\n"
                                            "RenderEvent 135 158 0 0 0 p\n"
                                            "MouseMoveEvent 134 158 0 0 0 p\n"
                                            "RenderEvent 134 158 0 0 0 p\n"
                                            "MouseMoveEvent 133 157 0 0 0 p\n"
                                            "RenderEvent 133 157 0 0 0 p\n"
                                            "MouseMoveEvent 131 157 0 0 0 p\n"
                                            "RenderEvent 131 157 0 0 0 p\n"
                                            "MouseMoveEvent 129 156 0 0 0 p\n"
                                            "RenderEvent 129 156 0 0 0 p\n"
                                            "MouseMoveEvent 126 154 0 0 0 p\n"
                                            "RenderEvent 126 154 0 0 0 p\n"
                                            "MouseMoveEvent 123 153 0 0 0 p\n"
                                            "RenderEvent 123 153 0 0 0 p\n"
                                            "MouseMoveEvent 121 152 0 0 0 p\n"
                                            "RenderEvent 121 152 0 0 0 p\n"
                                            "MouseMoveEvent 118 151 0 0 0 p\n"
                                            "RenderEvent 118 151 0 0 0 p\n"
                                            "MouseMoveEvent 116 149 0 0 0 p\n"
                                            "RenderEvent 116 149 0 0 0 p\n"
                                            "MouseMoveEvent 113 148 0 0 0 p\n"
                                            "RenderEvent 113 148 0 0 0 p\n"
                                            "MouseMoveEvent 111 146 0 0 0 p\n"
                                            "RenderEvent 111 146 0 0 0 p\n"
                                            "MouseMoveEvent 109 145 0 0 0 p\n"
                                            "RenderEvent 109 145 0 0 0 p\n"
                                            "MouseMoveEvent 107 144 0 0 0 p\n"
                                            "RenderEvent 107 144 0 0 0 p\n"
                                            "MouseMoveEvent 106 143 0 0 0 p\n"
                                            "RenderEvent 106 143 0 0 0 p\n"
                                            "MouseMoveEvent 105 142 0 0 0 p\n"
                                            "RenderEvent 105 142 0 0 0 p\n"
                                            "MouseMoveEvent 104 141 0 0 0 p\n"
                                            "RenderEvent 104 141 0 0 0 p\n"
                                            "MouseMoveEvent 102 141 0 0 0 p\n"
                                            "RenderEvent 102 141 0 0 0 p\n"
                                            "MouseMoveEvent 101 140 0 0 0 p\n"
                                            "RenderEvent 101 140 0 0 0 p\n"
                                            "MouseMoveEvent 101 140 0 0 0 p\n"
                                            "RenderEvent 101 140 0 0 0 p\n"
                                            "MouseMoveEvent 100 140 0 0 0 p\n"
                                            "RenderEvent 100 140 0 0 0 p\n"
                                            "MouseMoveEvent 99 139 0 0 0 p\n"
                                            "RenderEvent 99 139 0 0 0 p\n"
                                            "MouseMoveEvent 99 139 0 0 0 p\n"
                                            "RenderEvent 99 139 0 0 0 p\n"
                                            "MouseMoveEvent 98 139 0 0 0 p\n"
                                            "RenderEvent 98 139 0 0 0 p\n"
                                            "MouseMoveEvent 96 138 0 0 0 p\n"
                                            "RenderEvent 96 138 0 0 0 p\n"
                                            "MouseMoveEvent 95 137 0 0 0 p\n"
                                            "RenderEvent 95 137 0 0 0 p\n"
                                            "MouseMoveEvent 95 137 0 0 0 p\n"
                                            "RenderEvent 95 137 0 0 0 p\n"
                                            "MouseMoveEvent 94 137 0 0 0 p\n"
                                            "RenderEvent 94 137 0 0 0 p\n"
                                            "MouseMoveEvent 93 137 0 0 0 p\n"
                                            "RenderEvent 93 137 0 0 0 p\n"
                                            "MouseMoveEvent 92 137 0 0 0 p\n"
                                            "RenderEvent 92 137 0 0 0 p\n"
                                            "MouseMoveEvent 92 137 0 0 0 p\n"
                                            "RenderEvent 92 137 0 0 0 p\n"
                                            "MouseMoveEvent 90 136 0 0 0 p\n"
                                            "RenderEvent 90 136 0 0 0 p\n"
                                            "MouseMoveEvent 89 136 0 0 0 p\n"
                                            "RenderEvent 89 136 0 0 0 p\n"
                                            "MouseMoveEvent 88 136 0 0 0 p\n"
                                            "RenderEvent 88 136 0 0 0 p\n"
                                            "MouseMoveEvent 87 135 0 0 0 p\n"
                                            "RenderEvent 87 135 0 0 0 p\n"
                                            "MouseMoveEvent 86 135 0 0 0 p\n"
                                            "RenderEvent 86 135 0 0 0 p\n"
                                            "MouseMoveEvent 86 135 0 0 0 p\n"
                                            "RenderEvent 86 135 0 0 0 p\n"
                                            "MouseMoveEvent 85 135 0 0 0 p\n"
                                            "RenderEvent 85 135 0 0 0 p\n"
                                            "MouseMoveEvent 85 135 0 0 0 p\n"
                                            "RenderEvent 85 135 0 0 0 p\n"
                                            "LeftButtonReleaseEvent 85 135 0 0 0 p\n"
                                            "RenderEvent 85 135 0 0 0 p\n"
                                            "MouseMoveEvent 85 135 0 0 0 p\n"
                                            "RenderEvent 85 135 0 0 0 p\n"
                                            "MouseMoveEvent 85 134 0 0 0 p\n"
                                            "MouseMoveEvent 85 133 0 0 0 p\n"
                                            "RenderEvent 85 133 0 0 0 p\n"
                                            "MouseMoveEvent 89 126 0 0 0 p\n"
                                            "MouseMoveEvent 142 9 0 0 0 p\n"
                                            "RenderEvent 142 9 0 0 0 p\n"
                                            "MouseMoveEvent 142 9 0 0 0 p\n"
                                            "MouseMoveEvent 146 12 0 0 0 p\n"
                                            "LeftButtonPressEvent 146 12 0 0 0 p\n"
                                            "RenderEvent 146 12 0 0 0 p\n"
                                            "LeftButtonReleaseEvent 146 12 0 0 0 p\n"
                                            "MouseMoveEvent 146 13 0 0 0 p\n"
                                            "MouseMoveEvent 143 26 0 0 0 p\n"
                                            "RenderEvent 143 26 0 0 0 p\n"
                                            "MouseMoveEvent 143 29 0 0 0 p\n"
                                            "RenderEvent 143 29 0 0 0 p\n"
                                            "MouseMoveEvent 142 31 0 0 0 p\n"
                                            "MouseMoveEvent 137 47 0 0 0 p\n"
                                            "RenderEvent 137 47 0 0 0 p\n"
                                            "MouseMoveEvent 136 49 0 0 0 p\n"
                                            "MouseMoveEvent 99 143 0 0 0 p\n"
                                            "RenderEvent 99 143 0 0 0 p\n"
                                            "MouseMoveEvent 99 143 0 0 0 p\n"
                                            "MouseMoveEvent 94 143 0 0 0 p\n"
                                            "LeftButtonPressEvent 94 143 0 0 0 p\n"
                                            "RenderEvent 94 143 0 0 0 p\n"
                                            "MouseMoveEvent 95 143 0 0 0 p\n"
                                            "RenderEvent 95 143 0 0 0 p\n"
                                            "MouseMoveEvent 95 143 0 0 0 p\n"
                                            "RenderEvent 95 143 0 0 0 p\n"
                                            "MouseMoveEvent 95 143 0 0 0 p\n"
                                            "RenderEvent 95 143 0 0 0 p\n"
                                            "MouseMoveEvent 95 143 0 0 0 p\n"
                                            "RenderEvent 95 143 0 0 0 p\n"
                                            "MouseMoveEvent 97 143 0 0 0 p\n"
                                            "RenderEvent 97 143 0 0 0 p\n"
                                            "MouseMoveEvent 102 143 0 0 0 p\n"
                                            "RenderEvent 102 143 0 0 0 p\n"
                                            "MouseMoveEvent 109 142 0 0 0 p\n"
                                            "RenderEvent 109 142 0 0 0 p\n"
                                            "MouseMoveEvent 116 141 0 0 0 p\n"
                                            "RenderEvent 116 141 0 0 0 p\n"
                                            "MouseMoveEvent 123 140 0 0 0 p\n"
                                            "RenderEvent 123 140 0 0 0 p\n"
                                            "MouseMoveEvent 128 140 0 0 0 p\n"
                                            "RenderEvent 128 140 0 0 0 p\n"
                                            "MouseMoveEvent 133 140 0 0 0 p\n"
                                            "RenderEvent 133 140 0 0 0 p\n"
                                            "MouseMoveEvent 138 139 0 0 0 p\n"
                                            "RenderEvent 138 139 0 0 0 p\n"
                                            "MouseMoveEvent 143 138 0 0 0 p\n"
                                            "RenderEvent 143 138 0 0 0 p\n"
                                            "MouseMoveEvent 147 138 0 0 0 p\n"
                                            "RenderEvent 147 138 0 0 0 p\n"
                                            "MouseMoveEvent 150 138 0 0 0 p\n"
                                            "RenderEvent 150 138 0 0 0 p\n"
                                            "MouseMoveEvent 154 138 0 0 0 p\n"
                                            "RenderEvent 154 138 0 0 0 p\n"
                                            "MouseMoveEvent 159 137 0 0 0 p\n"
                                            "RenderEvent 159 137 0 0 0 p\n"
                                            "MouseMoveEvent 163 137 0 0 0 p\n"
                                            "RenderEvent 163 137 0 0 0 p\n"
                                            "MouseMoveEvent 167 136 0 0 0 p\n"
                                            "RenderEvent 167 136 0 0 0 p\n"
                                            "MouseMoveEvent 171 135 0 0 0 p\n"
                                            "RenderEvent 171 135 0 0 0 p\n"
                                            "MouseMoveEvent 174 135 0 0 0 p\n"
                                            "RenderEvent 174 135 0 0 0 p\n"
                                            "MouseMoveEvent 176 135 0 0 0 p\n"
                                            "RenderEvent 176 135 0 0 0 p\n"
                                            "MouseMoveEvent 178 134 0 0 0 p\n"
                                            "RenderEvent 178 134 0 0 0 p\n"
                                            "MouseMoveEvent 180 134 0 0 0 p\n"
                                            "RenderEvent 180 134 0 0 0 p\n"
                                            "MouseMoveEvent 183 134 0 0 0 p\n"
                                            "RenderEvent 183 134 0 0 0 p\n"
                                            "MouseMoveEvent 185 133 0 0 0 p\n"
                                            "RenderEvent 185 133 0 0 0 p\n"
                                            "MouseMoveEvent 187 132 0 0 0 p\n"
                                            "RenderEvent 187 132 0 0 0 p\n"
                                            "MouseMoveEvent 188 132 0 0 0 p\n"
                                            "RenderEvent 188 132 0 0 0 p\n"
                                            "MouseMoveEvent 190 131 0 0 0 p\n"
                                            "RenderEvent 190 131 0 0 0 p\n"
                                            "MouseMoveEvent 192 131 0 0 0 p\n"
                                            "RenderEvent 192 131 0 0 0 p\n"
                                            "MouseMoveEvent 194 131 0 0 0 p\n"
                                            "RenderEvent 194 131 0 0 0 p\n"
                                            "MouseMoveEvent 196 130 0 0 0 p\n"
                                            "RenderEvent 196 130 0 0 0 p\n"
                                            "MouseMoveEvent 197 129 0 0 0 p\n"
                                            "RenderEvent 197 129 0 0 0 p\n"
                                            "MouseMoveEvent 199 128 0 0 0 p\n"
                                            "RenderEvent 199 128 0 0 0 p\n"
                                            "MouseMoveEvent 202 128 0 0 0 p\n"
                                            "RenderEvent 202 128 0 0 0 p\n"
                                            "MouseMoveEvent 204 127 0 0 0 p\n"
                                            "RenderEvent 204 127 0 0 0 p\n"
                                            "MouseMoveEvent 207 125 0 0 0 p\n"
                                            "RenderEvent 207 125 0 0 0 p\n"
                                            "MouseMoveEvent 210 124 0 0 0 p\n"
                                            "RenderEvent 210 124 0 0 0 p\n"
                                            "MouseMoveEvent 213 123 0 0 0 p\n"
                                            "RenderEvent 213 123 0 0 0 p\n"
                                            "MouseMoveEvent 216 121 0 0 0 p\n"
                                            "RenderEvent 216 121 0 0 0 p\n"
                                            "MouseMoveEvent 219 120 0 0 0 p\n"
                                            "RenderEvent 219 120 0 0 0 p\n"
                                            "MouseMoveEvent 222 118 0 0 0 p\n"
                                            "RenderEvent 222 118 0 0 0 p\n"
                                            "MouseMoveEvent 225 117 0 0 0 p\n"
                                            "RenderEvent 225 117 0 0 0 p\n"
                                            "MouseMoveEvent 227 116 0 0 0 p\n"
                                            "RenderEvent 227 116 0 0 0 p\n"
                                            "MouseMoveEvent 229 114 0 0 0 p\n"
                                            "RenderEvent 229 114 0 0 0 p\n"
                                            "MouseMoveEvent 232 113 0 0 0 p\n"
                                            "RenderEvent 232 113 0 0 0 p\n"
                                            "MouseMoveEvent 233 112 0 0 0 p\n"
                                            "RenderEvent 233 112 0 0 0 p\n"
                                            "MouseMoveEvent 235 111 0 0 0 p\n"
                                            "RenderEvent 235 111 0 0 0 p\n"
                                            "MouseMoveEvent 236 111 0 0 0 p\n"
                                            "RenderEvent 236 111 0 0 0 p\n"
                                            "MouseMoveEvent 238 110 0 0 0 p\n"
                                            "RenderEvent 238 110 0 0 0 p\n"
                                            "MouseMoveEvent 239 110 0 0 0 p\n"
                                            "RenderEvent 239 110 0 0 0 p\n"
                                            "MouseMoveEvent 241 109 0 0 0 p\n"
                                            "RenderEvent 241 109 0 0 0 p\n"
                                            "MouseMoveEvent 241 108 0 0 0 p\n"
                                            "RenderEvent 241 108 0 0 0 p\n"
                                            "MouseMoveEvent 242 108 0 0 0 p\n"
                                            "RenderEvent 242 108 0 0 0 p\n"
                                            "MouseMoveEvent 242 108 0 0 0 p\n"
                                            "RenderEvent 242 108 0 0 0 p\n"
                                            "LeftButtonReleaseEvent 242 108 0 0 0 p\n"
                                            "RenderEvent 242 108 0 0 0 p\n"
                                            "MouseMoveEvent 242 108 0 0 0 p\n"
                                            "MouseMoveEvent 156 154 0 0 0 p\n"
                                            "KeyPressEvent 156 154 0 110 1 n\n"
                                            "RenderEvent 156 154 0 110 1 n\n"
                                            "CharEvent 156 154 0 110 1 n\n"
                                            "KeyReleaseEvent 156 154 0 110 1 n\n"
                                            "MouseMoveEvent 157 154 0 0 0 n\n"
                                            "MouseMoveEvent 203 195 0 0 0 n\n"
                                            "KeyPressEvent 203 195 0 100 1 d\n"
                                            "RenderEvent 203 195 0 100 1 d\n"
                                            "CharEvent 203 195 0 100 1 d\n"
                                            "KeyReleaseEvent 203 195 0 100 1 d\n"
                                            "LeaveEvent 303 205 0 0 0 d";

int TestCoordinateFrameWidget(int argc, char* argv[])
{
  // Create a mace out of filters.
  vtkNew<vtkSphereSource> sphere;
  vtkNew<vtkConeSource> cone;
  vtkNew<vtkGlyph3D> glyph;
  glyph->SetInputConnection(sphere->GetOutputPort());
  glyph->SetSourceConnection(cone->GetOutputPort());
  glyph->SetVectorModeToUseNormal();
  glyph->SetScaleModeToScaleByVector();
  glyph->SetScaleFactor(0.25);
  glyph->Update();

  // The sphere and spikes are appended into a single polydata.
  // This just makes things simpler to manage.
  vtkNew<vtkAppendPolyData> apd;
  apd->AddInputConnection(glyph->GetOutputPort());
  apd->AddInputConnection(sphere->GetOutputPort());

  // This portion of the code clips the mace with the vtkPlanes
  // implicit function. The clipped region is colored green.
  vtkNew<vtkPlane> plane;
  vtkNew<vtkClipPolyData> clipper;
  clipper->SetInputConnection(apd->GetOutputPort());
  clipper->SetClipFunction(plane);
  clipper->InsideOutOn();

  vtkNew<vtkPolyDataMapper> selectMapper;
  selectMapper->SetInputConnection(clipper->GetOutputPort());

  vtkNew<vtkLODActor> selectActor;
  selectActor->SetMapper(selectMapper);

  // Create the RenderWindow, Renderer and both Actors
  vtkNew<vtkRenderer> ren1;
  vtkNew<vtkRenderWindow> renWin;
  renWin->AddRenderer(ren1);
  ren1->AddActor(selectActor);

  vtkNew<vtkRenderWindowInteractor> iren;
  iren->SetRenderWindow(renWin);

  vtkNew<vtkCoordinateFrameRepresentation> rep;
  rep->SetPlaceFactor(1.25); // This must be set prior to placing the widget
  rep->PlaceWidget(selectActor->GetBounds());
  rep->SetNormal(plane->GetNormal());

  vtkNew<vtkCoordinateFrameWidget> frameWidget;
  frameWidget->SetInteractor(iren);
  frameWidget->SetRepresentation(rep);

  // Render
  iren->Initialize();
  renWin->Render();
  frameWidget->On();

  return vtkTesting::InteractorEventLoop(argc, argv, iren, TestCoordinateFrameWidgetLog);
}
