"""
    gestion.views_graph, un module pour SLM
    - manipulation de données visualisées comme des graphes

    Copyright (C) 2025 Georges Khaznadar <georgesk@debian.org>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
"""

from .views_common import render_common
from django.utils.translation import gettext_lazy as _
from .models import Classes, Niveaux, Filieres, Digraphe, Digraphe_select

def essai_svg(request):
    """
    page expérimentale pour bricoler des graphes de dépendances
    """
    left_vertices = Digraph_Query(
        Classes.classes_importantes, "libelle", "libelle").vertices()
    right_vertices = Digraph_Query(
        Niveaux.objects.all, "libelle", "libelle", "libelle").vertices()
    return render_common(
        request,
        'gestion/essai_svg.html',
        _("essai SVG"),
        {
            "aide": "",
            "left_vertices": left_vertices,
            "right_vertices": right_vertices,
        })

def svg_from_dot(request):
    """
    Produit un page avec un graphe, et des outils pour le manipuler
    le POST contient digraphe, le nom d'un digraphe (instance de
    Digraph_select, qui fournit de quoi selectionner des descriptions
    de noeuds, et qui est référencée par une instance de Digraph, qui
    a une date de création et un digraphe codé en langage DOT)
    """
    digraphe_name = request.POST.get("digraphe","essai")
    "momentanément ..."
    essai = Digraphe.objects.filter(
        select__name=digraphe_name,
    ).order_by('-date_creation')[0]
    svg_elts = essai.to_svg()
    lr_query = essai.select.lr_query()
    return render_common(
        request,
        'gestion/svg_from_dot.html',
        _("SVG depuis DOT"),
        {
            "aide": "",
            "svg_elts" : svg_elts,
            "lr_query": lr_query,
        })

def digraphe_select(request):
    """
    Page permettant à un administrateur d'éditer les sélecteurs pour digraphes
    et de créer des digraphes
    """
    dgsels = Digraphe_select.objects.all()
    collection = {}
    for dgsel in dgsels:
        dgs = Digraphe.objects.filter(select=dgsel)
        collection[dgsel.name] = {
            "select": dgsel.id,
            "dgs": [d.id for d in dgs],
        }
    return render_common(
        request,
        'gestion/digraphe_select.html',
        _("Gestion des digraphes"),
        {
            "aide": "",
            "collection": collection,
        })
    
