# 2022-01-04 Triage Log

It was a relatively calm, but good week overall. Most of the gains were improvements to rustdoc running times.

Triage done by **@pnkfelix**.
Revision range: [e91ad5fc62bdee4a29c18baa5fad2ca42fc91bf4..2b681ac06b1a6b7ea39525e59363ffee0d1a68e5](https://perf.rust-lang.org/?start=e91ad5fc62bdee4a29c18baa5fad2ca42fc91bf4&end=2b681ac06b1a6b7ea39525e59363ffee0d1a68e5&absolute=false&stat=instructions%3Au)

1 Regressions, 6 Improvements, 1 Mixed; 0 of them in rollups
38 comparisons made in total

#### Regressions

rustc_metadata: Merge items from `extern` blocks into their parent modules during metadata encoding rather than during metadata decoding [#92153](https://github.com/rust-lang/rust/issues/92153)
- Small regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=e91ad5fc62bdee4a29c18baa5fad2ca42fc91bf4&end=442248d6bcc00693922941eb5a9f241e0e9da2c0&stat=instructions:u) (up to 1.2% on `incr-unchanged` builds of `deeply-nested-closures`)
- Seems like it might be noise (all of the data points are annotated with "?").
- Left a [comment](https://github.com/rust-lang/rust/pull/92153#issuecomment-1005109842) saying even if this is real, it is justifiable.

#### Improvements

rustdoc: Remove `String` allocation in iteration in `print_generic_bounds` [#92283](https://github.com/rust-lang/rust/issues/92283)
- Moderate improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=7ae550842635dce84811198446fe87e830de500b&end=8e05bb527c5f00549ea6bc21352638200bceb1a5&stat=instructions:u) (up to -1.3% on `full` builds of `futures`)
- This is an expected improvement to rustdoc

Reverts #92135 because perf regression [#92291](https://github.com/rust-lang/rust/issues/92291)
- Large improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=8e05bb527c5f00549ea6bc21352638200bceb1a5&end=b70cc6422c141191aeb33f5ab6faba992118812b&stat=instructions:u) (up to -4.2% on `full` builds of `keccak`)
- This did indeed recover the performance lost in the regression.

rustc_metadata: Encode list of all crate's traits into metadata [#92244](https://github.com/rust-lang/rust/issues/92244)
- Very large improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=df96fb166f59431e3de443835e50d5b8a7a4adb0&end=78fd0f633faaa5b6dd254fc1456735f63a1b1238&stat=instructions:u) (up to -17.1% on `full` builds of `webrender`)
- This is an expected improvement to rustdoc

Import `SourceFile`s from crate before decoding foreign `Span` [#92175](https://github.com/rust-lang/rust/issues/92175)
- Very large improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=8ed935e92dfb09ae388344b12284bf5110cf9265&end=984a6bf9c11b7356f696c685a145d7136fff051c&stat=instructions:u) (up to -14.5% on `incr-full` builds of `webrender-wrench`)

Add Attribute::meta_kind [#92294](https://github.com/rust-lang/rust/issues/92294)
- Small improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=4d2e0fd96ccbb9ade41f1a3f07b14b7437f8e4ef&end=c9cf9c65072a35585f9521ab95044f32d5fcb9ec&stat=instructions:u) (up to -0.8% on `full` builds of `helloworld`)
- Filed https://github.com/rust-lang/rustc-perf/issues/1135 to see if classification needs improvement here.

Do not use LEB128 for encoding u16 and i16 [#92314](https://github.com/rust-lang/rust/issues/92314)
- Small improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=ddabe0775c5f5b551d5eb54e3c4366fb8bec0c92&end=399ba6bb377ce02224b57c4d6e127e160fa76b34&stat=instructions:u) (up to -1.7% on `incr-unchanged` builds of `helloworld`)
- Added it as a note to issue filed above.

#### Mixed

Mark drop calls in landing pads `cold` instead of `noinline` [#92419](https://github.com/rust-lang/rust/issues/92419)
- Very large improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=028c6f1454787c068ff5117e9000a1de4fd98374&end=4f49627c6fe2a32d1fed6310466bb0e1c535c0c0&stat=instructions:u) (up to -8.2% on `full` builds of `issue-46449`)
- Moderate regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=028c6f1454787c068ff5117e9000a1de4fd98374&end=4f49627c6fe2a32d1fed6310466bb0e1c535c0c0&stat=instructions:u) (up to 1.5% on `incr-full` builds of `ripgrep`)
- This was expected. Left a [comment](https://github.com/rust-lang/rust/pull/92419#issuecomment-1005122279).

#### Untriaged Pull Requests

- [#92419 Mark drop calls in landing pads `cold` instead of `noinline`](https://github.com/rust-lang/rust/pull/92419)
- [#92252 Update pulldown-cmark version to 0.9](https://github.com/rust-lang/rust/pull/92252)
- [#92229 Do not display `~const Drop` in rustdoc](https://github.com/rust-lang/rust/pull/92229)
- [#92227 Rustdoc: use `is_doc_hidden` method on more places](https://github.com/rust-lang/rust/pull/92227)
- [#92153 rustc_metadata: Merge items from `extern` blocks into their parent modules during metadata encoding rather than during metadata decoding](https://github.com/rust-lang/rust/pull/92153)
- [#92149 Fix bad caching of `~const Drop` bounds](https://github.com/rust-lang/rust/pull/92149)
- [#92135 Add `#[inline]` modifier to `TypeId::of`](https://github.com/rust-lang/rust/pull/92135)
- [#92110 Backport LLVM changes to disable deferred inlining](https://github.com/rust-lang/rust/pull/92110)
- [#92106 Rollup of 4 pull requests](https://github.com/rust-lang/rust/pull/92106)
- [#92088 intra-doc: Use an enum to represent URL fragments](https://github.com/rust-lang/rust/pull/92088)
- [#92064 Rollup of 7 pull requests](https://github.com/rust-lang/rust/pull/92064)
- [#92062 Rollup of 7 pull requests](https://github.com/rust-lang/rust/pull/92062)
- [#92041 Remove 'speculative evaluation' of predicates](https://github.com/rust-lang/rust/pull/92041)
- [#92003 Rollup of 7 pull requests](https://github.com/rust-lang/rust/pull/92003)
- [#91996 Rollup of 6 pull requests](https://github.com/rust-lang/rust/pull/91996)
- [#91959 Rollup of 7 pull requests](https://github.com/rust-lang/rust/pull/91959)
- [#91924 Fully serialize AdtDef](https://github.com/rust-lang/rust/pull/91924)
- [#91900 rustdoc: make `--passes` and `--no-defaults` have no effect](https://github.com/rust-lang/rust/pull/91900)
- [#91844 Eliminate `ObligationCauseData`](https://github.com/rust-lang/rust/pull/91844)
- [#91841 Rollup of 5 pull requests](https://github.com/rust-lang/rust/pull/91841)
- [#91838 Do array-slice equality via array equality, rather than always via slices](https://github.com/rust-lang/rust/pull/91838)
- [#91812 rustdoc: Pretty-print assoc const defaults on-demand](https://github.com/rust-lang/rust/pull/91812)
- [#91799 Rollup of 6 pull requests](https://github.com/rust-lang/rust/pull/91799)
- [#91766 Allow `memcmp` for more array comparisons](https://github.com/rust-lang/rust/pull/91766)
- [#91406 Rollup of 4 pull requests](https://github.com/rust-lang/rust/pull/91406)
- [#91354 Cleanup: Eliminate ConstnessAnd](https://github.com/rust-lang/rust/pull/91354)
- [#91318 Reduce boilerplate around infallible folders](https://github.com/rust-lang/rust/pull/91318)
- [#91288 Rollup of 6 pull requests](https://github.com/rust-lang/rust/pull/91288)
- [#91269 Rollup of 7 pull requests](https://github.com/rust-lang/rust/pull/91269)
- [#91255 Implement version of normalize_erasing_regions that allows for normalization failure](https://github.com/rust-lang/rust/pull/91255)
