% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VptreeIndex-class.R
\docType{class}
\name{VptreeIndex}
\alias{VptreeIndex}
\alias{VptreeIndex-class}
\alias{bnorder,VptreeIndex-method}
\alias{VptreeIndex_nodes}
\title{The VptreeIndex class}
\usage{
VptreeIndex(data, nodes, order, NAMES = NULL, distance = "Euclidean")
}
\arguments{
\item{data}{A numeric matrix with data points in columns and dimensions in rows.}

\item{nodes}{A list of vectors specifying the structure of the VP tree.}

\item{order}{An integer vector of length equal to \code{ncol(data)}, specifying the order of observations.}

\item{NAMES}{A character vector of sample names or \code{NULL}.}

\item{distance}{A string specifying the distance metric to use.}
}
\value{
An instance of the VptreeIndex class.
}
\description{
A class to hold the vantage point tree for exact nearest neighbor identification.
}
\details{
The VptreeIndex class holds the indexing structure required to run the VP tree algorithm.
Users should never need to call the constructor explicitly, but should generate instances of VptreeIndex classes with \code{\link{buildVptree}}.

Users can get values from a VptreeIndex object with the usual \code{[[} syntax.
All parameters listed in the constructor can be extracted in this manner.
}
\examples{
example(buildVptree)
str(out[["nodes"]])

}
\seealso{
\code{\link{buildVptree}}, for the index construction.

\linkS4class{BiocNeighborIndex}, for the parent class and its available methods.
}
\author{
Aaron Lun
}
