# UNICODE CHARACTER DATABASE
# This file was generated with the command:
#     generate_unicodedb.py --unidata_version=6.1.0 --output=unicodedb_6_1_0 --base=unicodedb_5_2_0

from rpython.rlib.rarithmetic import r_longlong


import unicodedb_5_2_0 as base_mod
version = '6.1.0'

#____________________________________________________________
# output from build_compression_tree

def trie_lookup(name):
    charnode = 0
    while 0 <= charnode < 0xffff: # 16bit number, 0xffff = None
        charnode *= 3
        leftright = _charnodes[charnode]
        parentstr = _charnodes[charnode + 1]
        codepoint = _charnodes[charnode + 2]

        if leftright < 0:
            # XXX assumes msb is sign
            left = 0x8000 | ((leftright & 0x7fffffff) >> 16)
        else:
            left = (leftright & 0x7fffffff) >> 16
        right = leftright & 0xffff

        if parentstr < 0:
            # XXX assumes msb is sign
            parent = 0x8000 | ((parentstr & 0x7fffffff) >> 16)
        else:
            parent = (parentstr & 0x7fffffff) >> 16
        stridx = parentstr & ((1 << 16) - 1)

        strlen = ord(_stringtable[stridx])
        substring = _stringtable[stridx+1:stridx+1+strlen]

        if codepoint != -1 and name == substring:
            return int(codepoint)
        if name.startswith(substring):
            name = name[strlen:]
            charnode = left
        else:
            charnode = right
    raise KeyError(name)

def name_of_node(charnode):
    res = []
    prevnode = -1
    while 0 <= charnode < 0xffff: # 16bit number, 0xffff = None
        charnode *= 3
        leftright = _charnodes[charnode]
        parentstr = _charnodes[charnode + 1]
        codepoint = _charnodes[charnode + 2]

        if leftright < 0:
            # XXX assumes msg is sign
            left = 0x8000 | ((leftright & 0x7fffffff) >> 16)
        else:
            left = (leftright & 0x7fffffff) >> 16
        right = leftright & 0xffff

        if parentstr < 0:
            # XXX assumes msb is sign
            parent = 0x8000 | ((parentstr & 0x7fffffff) >> 16)
        else:
            parent = (parentstr & 0x7fffffff) >> 16

        if prevnode < 0 or prevnode == left:
            stridx = parentstr & ((1<<16)-1)
            strlen = ord(_stringtable[stridx])
            substring = _stringtable[stridx+1:stridx+1+strlen]
            res.append(substring)

        prevnode = charnode // 3
        charnode = parent

    res.reverse()
    return ''.join(res)


_stringtable = (
'\x01 '
'\x05 AND '
'\x0f AND COLD SWEAT'
'\r AND YEN SIGN'
'\x06 BLOCK'
'\x07 BUTTON'
'\x17 CAKE WITH SWIRL DESIGN'
'\x04 CAR'
'\n CHARACTER'
'\x06 CHART'
'\x0b DECORATION'
'\x07 ENGINE'
'\x06 EPOCH'
'\x05 FACE'
'\x06 FACE '
'\x12 FOR SIMALUNGUN SA'
'\x05 FUJI'
'\x0e IN SILHOUETTE'
'\x06 LARGE'
'\t LEERAEWA'
'\x0b LOCOMOTIVE'
'\x08 LUGGAGE'
'\x07 MAELEE'
'\x07 MAEMBA'
'\x05 MARK'
'\x05 MFON'
'\x07 MUOMAE'
'\x03 NJ'
'\x12 NOT LITTER SYMBOL'
'\x07 OCLOCK'
'\x04 OF '
'\x0c OF ANTIMONY'
'\x08 OF FOOD'
'\x04 ORE'
'\x0f OVER MOUNTAINS'
'\x02 P'
'\x04 POT'
'\x08 SATCHEL'
'\x04 SET'
'\x06 SEVEN'
'\t SPARKLER'
'\x05 STOP'
'\x05 TABS'
'\x06 WITH '
'\x11 WITH BULLET NOSE'
'\x10 WITH BUNNY EARS'
'\x19 WITH CANCELLATION STROKE'
'\x19 WITH CIRCLED ONE OVERLAY'
'\x16 WITH DECORATIVE COVER'
'\t WITH DOT'
'2 WITH EXCLAMATION MARK WITH LEFT RIGHT ARROW ABOVE'
'\n WITH FACE'
'\x17 WITH HALF-CIRCLE BELOW'
'\r WITH INK PEN'
'\x1b WITH LEFTWARDS ARROW ABOVE'
'\x14 WITH OBLIQUE STROKE'
'\x12 WITH SMILING EYES'
'\x12 WITH VERTICAL BAR'
'\x08 YUQ NAE'
'\x01-'
'\x02-2'
'\t-AMMONIAC'
'\x0b-COPPER ORE'
'\x08-EM DASH'
'\x0c-MAIL SYMBOL'
'\x0f-NO-EVIL MONKEY'
'\x07-SHIFT-'
'\x06-SHIRT'
'\x07-THIRTY'
'\x010'
'\x011'
'\x012'
'\x03272'
'\x013'
'\x014'
'\x03408'
'\x015'
'\x03533'
'\x035B6'
'\x016'
'\x017'
'\x0270'
'\x018'
'\x019'
'\x03981'
'\x01A'
'\x02A '
'\x06A MFON'
'\x05A YUE'
'\x03A7A'
'\x02AA'
'\x03AAM'
'\x05AAMAE'
'\x05AARAE'
'\x06AASHAE'
'\x02AB'
'\nABATA TREE'
'\x11ABBREVIATION SIGN'
'\x05ABIC '
'\x11ABLE WATER SYMBOL'
'\x05ABOVE'
'\tABULATION'
'\x07ACE OF '
'\x03ACK'
'\x04ACK '
'\x0bACKNOWLEDGE'
'\x10ACTER TABULATION'
'\x05ACUTE'
'\x02AD'
'\x02AE'
'\rAE WITH GRAVE'
'\x03AEM'
'\x05AEMAE'
'\x05AEMLI'
'\x06AEMMAE'
'\x03AEN'
'\x08AEN NYAM'
'\x03AEP'
'\x05AEPEN'
'\x03AEQ'
'\x05AEREE'
'\x0bAESHAE NYAM'
'\x07AETMEUN'
'\x02AF'
'\x15AF FLUTTERING IN WIND'
'\x10AFFRICATION MARK'
'\x0cAFU LEERAEWA'
'\x04AGON'
'\x02AH'
'\x05AHMI '
'\x03AIN'
'\x04AIN '
'\x02AK'
'\x03AK '
'\x0cAKAARAANSAYA'
'\x06AKEUAE'
'\x02AL'
'\x0bAL COMPUTER'
'\x07AL HORN'
'\x03ALE'
'\x04ALF '
'\x05ALGAR'
'\x04ALL '
'\x03ALO'
'\x02AM'
'\x04AMBA'
'\x07AME DIE'
'\x03AMI'
'\rAMMA WITH DOT'
'\x1dAMOND SHAPE WITH A DOT INSIDE'
'\x0bAMUSED FACE'
'\x02AN'
'\x03ANA'
'\x04ANAE'
'\x08ANAGARI '
'\x03AND'
'\x17AND WOMAN HOLDING HANDS'
'\x04ANDA'
'\tANGE BOOK'
'\x05ANGEL'
'\tANGGEUAET'
'\x07ANGKUOQ'
'\x07ANGLONG'
'\x07ANGOLAT'
'\x04ANGU'
'\x08ANGULAR '
'\x0bANTIMONIATE'
'\x08ANTIMONY'
'\x08ANUSVARA'
'\x03AO '
'\x02AP'
'\x04APAQ'
'\x03APE'
'\x03APP'
'\rAPPED PRESENT'
'\x05APPLE'
'\x02AQ'
'\x02AR'
'\x04ARAE'
'\x08ARCASITE'
'\nARCHAIC YE'
'\x03ARD'
'\x07ARDSMAN'
'\nARFUL FACE'
'\tARM CLOCK'
'\rARRED TRIDENT'
'\x05ARROW'
'\x05ARTAR'
'\x04ARUM'
'\x04ARY '
'\nASPIRATION'
'\x12ASTED SWEET POTATO'
'\x02AT'
'\nAT ON BONE'
'\x13ATED TELLER MACHINE'
'\x07ATH OF '
'\x14ATIN CAPITAL LETTER '
'\x07AU MARK'
'\nAUTOMOBILE'
'\x08AVAGRAHA'
'\x17AVOURING DELICIOUS FOOD'
'\x02AW'
'\x02AY'
'\x08AY-NIGHT'
'\x0bAYING CARD '
'\x01B'
'\x02B '
'\x02BA'
'\nBA SATANGA'
'\x08BACKWARD'
'\x03BAG'
'\x03BAH'
'\x04BALL'
'\x04BAYI'
'\x02BB'
'\x04BBIT'
'\x04BBON'
'\x02BE'
'\x11BE WITH MERIDIANS'
'\x03BEE'
'\x03BEH'
'\x16BEH WITH SMALL V BELOW'
'\x05BELOW'
'\x08BER POLE'
'\x07BERGINE'
'\x06BETAN '
'\x07BETWEEN'
'\x06BGBIEE'
'\x03BHA'
'\x0eBHATTIPROLU AA'
'\tBICYCLIST'
'\x0bBIDAKUON NG'
'\x08BIEE FON'
'\nBILE PHONE'
'\x06BISCUS'
'\x16BKA- SHOG GI MGO RGYAN'
'\x0eBLE CURLY LOOP'
'\x18BLIC ADDRESS LOUDSPEAKER'
'\x06BLIMAT'
'\nBLOND HAIR'
'\x05BLUE '
'\x0cBLUE DIAMOND'
'\x04BOOK'
'\x05BOOTS'
'\x06BOTTLE'
'\rBOWING DEEPLY'
'\x03BOX'
'\x08BOX TRAY'
'\x0cBRATION MODE'
'\x11BRIGHTNESS SYMBOL'
'\x03BSP'
'\x07BUFFALO'
'\x08BUILDING'
'\x07BULANCE'
'\x04BUNG'
'\x06BURGER'
'\x03BUS'
'\x11BUT RELIEVED FACE'
'\x02BY'
'\x01C'
'\x02C '
'\x06C SIGN'
'\nC WITH BAR'
'\x02CA'
'\x0cCABBAGE-TREE'
'\x08CABLEWAY'
'\x03CAH'
'\x05CAKRA'
'\x04CALL'
'\x06CAMERA'
'\x13CANCELLATION STROKE'
'\x0bCANDRABINDU'
'\x07CAP TEN'
'\x15CAPITAL H WITH STROKE'
'\x0fCAPITAL LETTER '
'\x1cCAPITAL LETTER BOHAIRIC KHEI'
'\x0fCAPITAL LETTERS'
'\x03CAR'
'\x08CASSETTE'
'\x06CASTLE'
'\x08CAT FACE'
'\x0eCAT FACE WITH '
'\x19CAT FACE WITH CLOSED EYES'
'\x1aCAT FACE WITH SMILING EYES'
'\x05CCEPT'
'\x04CCHH'
'\x02CE'
'\x03CE '
'\x08CE CREAM'
'\x03CEL'
'\x0eCEPTER OF JOVE'
'\x03CER'
'\x02CH'
'\nCH BALLOON'
'\x03CHA'
'\x14CHARACTER INTRODUCER'
'$CHED LEFT SEMICIRCLE WITH THREE DOTS'
'\x08CHEIKHAN'
'\x14CHEMICAL SYMBOL FOR '
'\x05CHICK'
'\x03CHO'
'\rCHRONOUS IDLE'
'\nCHWA WITH '
'\x0cCIDUOUS TREE'
'\x06CIRCLE'
'\x1dCIRCLED LATIN CAPITAL LETTER '
'\x02CK'
'\x07CK LIME'
'\x0cCK-O-LANTERN'
'\x05CKAGE'
'\x04CKEN'
'\x04CKET'
'\x0cCKTAIL GLASS'
'\x05CKTIE'
'\x07CLEAVER'
'\x05CLONE'
'\x0bCLOSED EYES'
'\x06CLOSET'
'\x07CLOTHES'
'\x05CLUBS'
'\x06CODILE'
'\x08COENG QA'
'\nCOLD SWEAT'
'\nCOMBINING '
'\x07COMING '
'\x0fCOMING ENVELOPE'
'\x05COMMA'
'\nCONSONANT '
'\x10CONSONANT JOINER'
'\x0fCONSONANT SIGN '
'\x15CONSONANT SIGN COENG '
'\x18CONSONANT SIGN PASANGAN '
'\x06COPPER'
'\x12COPPER ANTIMONIATE'
'\x05COVER'
'\x02CR'
'\x07CRACKER'
'\x10CREAMING IN FEAR'
'\x0cCRESCENT BAR'
'\x14CRESCENT MOON SYMBOL'
'\nCROSS MARK'
'\x0cCROSS POMMEE'
'\x06CTOPUS'
'\x04CTOR'
'\x06CTRIC '
'\x05CTURE'
'\x04CTUS'
'\rCULATED LORRY'
'\x12CUP WITHOUT HANDLE'
'\x06CURLY '
'\tCURSIVE L'
'\nCY MESSAGE'
'\x04CYCL'
'\x10CYRILLIC LETTER '
'\x01D'
'\x02D '
'\x07D APPLE'
'\x07D CHIME'
'\x07D INDEX'
'\x06D SIGN'
'\x02DA'
'\nDA SATANGA'
'\x03DAA'
'\x03DAD'
'\x06DAGGER'
'\x03DAH'
'\x05DAIC '
'\x05DAMMA'
'\x08DAMMATAN'
'\x07DANESE '
'\x0bDASH SYMBOL'
'\x05DBOAT'
'\x02DD'
'\x05DDING'
'\nDECORATION'
'\x03DEN'
'\x0bDENT EMBLEM'
'\x03DEO'
'\tDESCENDER'
'\x0bDESK PERSON'
'\x08DESTRIAN'
'\x02DF'
'\x04DGER'
'\x02DH'
'\x07DIAMOND'
'\x08DIAMONDS'
'\x04DIC '
'\x0eDIFIER LETTER '
'\x06DIGIT '
'\x0eDING CHARACTER'
'\x03DIO'
'\x04DISC'
'\x08DIT CARD'
'\x05DLING'
'\x02DO'
'\x0bDOLLAR SIGN'
'\x05DOLLS'
'\x03DOT'
'\tDOT ABOVE'
'\x08DOT REPH'
'$DOUBLE COMMA QUOTATION MARK ORNAMENT'
'\x1bDOUBLE INVERTED BREVE BELOW'
'\x0fDOUBLE TRIANGLE'
'\x04DOWN'
'\x1cDOWN POINTING BACKHAND INDEX'
'\tDOWN SIGN'
'\x1dDOWN-POINTING DOUBLE TRIANGLE'
'(DOWNWARDS AND UPWARDS OPEN CIRCLE ARROWS'
'\x0fDOWNWARDS TREND'
'\x06DPHONE'
'\x04DRAM'
'\x05DRINK'
'\x07DU NJAA'
'\x0bDUATION CAP'
'\x06DUCEUS'
'\x08DUSHENNA'
'\x08DVANTAGE'
'\x02DY'
'\tDY BEETLE'
'\x04DZHA'
'\x01E'
'\x02E '
'\x07E GLASS'
'\x05E OF '
'\x08E OF POO'
'\x0bE WITH VEIL'
'\x03E80'
'\x02EA'
'\x07EAD ORE'
'\x03EAM'
'\x04EANS'
'\x10EART-SHAPED EYES'
'\x05EARTH'
'\x05EBOOK'
'\x0bECTION MARK'
'\x08ED BRICK'
'\x08ED FLAGS'
'\x07ED RICE'
'\x02EE'
'\x03EEE'
'\x04EEEE'
'\x03EEM'
'\x03EEN'
'\x04EEN '
'\x03EEP'
'\x05EESHI'
'\x03EET'
'\x06EFCASE'
'\x02EH'
'\x0cEH WITH LOOP'
'\x02EI'
'\x05EIGHT'
'\tEIGHT OF '
'\x06EIGHTH'
'\x05EKEET'
'\x0cELECTED AREA'
'\x0bELLOW HEART'
'\x04ELVE'
'\x02EM'
'\x05EMBIC'
'\x02EN'
'\x03EN '
'\x08EN NTEUM'
'\x06EN OF '
'\x04ENCH'
'\nENCH FRIES'
'\rENCY EXCHANGE'
'\x05ENJET'
'\x0eENNA WITH BARS'
'\nENS SYMBOL'
'\x07ENSHUET'
'\nENTRY SIGN'
'\x04ENTY'
'\x05EOPLE'
'\x08EPARATOR'
'\x05EPAYA'
'\x02EQ'
'\x02ER'
'\x08ER BOARD'
'\x06ER MUG'
'\tER SYMBOL'
'\x10ERCURY SUBLIMATE'
'\x08ERDIGRIS'
'\rERIAL TRAMWAY'
'\x0fERICAN FOOTBALL'
'\x0fERING MEGAPHONE'
'\x05ERSE '
'\x03ERT'
'\x03ERU'
'\x02ES'
';ESENTATION FORM FOR VERTICAL RIGHT WHITE LENTICULAR BRACKET'
'\x03ESS'
'\x02ET'
'\x06ET KUT'
'\x05ET TU'
'\x03ETE'
'\x0bETEI MAYEK '
'\x06ETTER '
'\tETTI BALL'
'\x02EU'
'\x06EU MBU'
'\x04EUAE'
'\x05EUAEM'
'\x05EUAEN'
'\x06EUAENA'
'\x05EUAEQ'
'\x08EUFEUAET'
'\x03EUM'
'\x03EUN'
'\x0bEUNJOMNDEUQ'
'\x06EUNYAM'
'\x03EUQ'
'\x05EURAE'
'\x06EUREUT'
'\x04EURI'
'\tEURO SIGN'
'\rEUROPE-AFRICA'
'\x03EUT'
'\x03EUX'
'\x04EVEN'
'\x08EVEN OF '
'\x0cEVERING FACE'
'\x02EW'
'\x02EX'
'\x19EXCLAMATION MARK ORNAMENT'
'\x0bEXED BICEPS'
'\x03EXT'
'\x06EXTRA-'
'\x02EY'
'\x03EY '
'\x01F'
'\x02F '
'\x02FA'
'\x04FACE'
'\nFACE WITH '
'\tFACING UP'
'\x10FALLING DIAGONAL'
'\x05FATHA'
'\x0bFATHA WITH '
'\x08FATHATAN'
'\x07FATIGUE'
'\x02FE'
'\x04FEED'
'\x03FEH'
"'FEH WITH DOT BELOW AND THREE DOTS ABOVE"
'\x04FEUQ'
'\x0eFFICE BUILDING'
'\x0bFILE FOLDER'
'\x07FINAGH '
'\x06FINAL '
'\x04FIRE'
'\x04FIRI'
'\x04FISH'
'\x04FIST'
'\x0cFLAG ON POST'
'\x06FLOWER'
'\x04FO F'
'\x0cFOLDED HANDS'
'\x06FOLDER'
'\x03FOM'
'\nFORMATION '
'\x0cFORMING ARTS'
'\x06FORTIS'
'\x07FORWARD'
'\x04FOUR'
'\nFOUR DOTS '
'\x04FREE'
'\x08FROWNING'
'\x02FT'
'\x03FT '
'\rFT ARROWHEAD '
'\x0cFT ICE CREAM'
'\x03FTY'
'\x03FUE'
'\x01G'
'\x06G FACE'
'\x02GA'
'\x03GAA'
'\x03GAH'
'\x12GALI LETTER KHINYA'
'\x04GAME'
'\x07GATIVE '
'\x02GB'
'\x05GBASA'
'\x06GBASAQ'
'\x05GBIEE'
'\x0cGBY FOOTBALL'
'\x02GC'
'\x02GE'
'\x0bGE AT NIGHT'
' GEMINATION AND VOWEL LENGTH MARK'
'\x0fGEMINATION MARK'
'\x03GEN'
'\x03GER'
'\x06GERINE'
'\x0bGGAGE CLAIM'
'\nGGER WITH '
'\x03GGY'
'\x02GH'
'\x05GHAIN'
'\x06GHETTI'
'\x06GHEUAE'
'\x07GHEUGHE'
'\x05GHNUT'
'\x03GHT'
'\x08GHT RAIL'
'\x04GHT-'
'\x13GIBBOUS MOON SYMBOL'
'\x1fGIONAL INDICATOR SYMBOL LETTER '
'\x02GJ'
'\x07GLASSES'
'\x03GLE'
'\x02GO'
'\x06GOBLIN'
'\x05GOLAT'
'\x1cGRAPHIC CHARACTER INTRODUCER'
'\x05GRAVE'
'\nGUA PI MAO'
'\x0cGUARDED AREA'
'\x04GUIN'
'\x05GULUS'
'\x01H'
'\x0bH WITH HOOK'
'\x02HA'
'\x03HAA'
'\x03HAH'
'\x0cHAH WITH DAL'
'\x14HALA CONSONANT SIGN '
'\x04HALF'
'\x05HALQA'
'\x0bHAMZA ABOVE'
'\x04HAND'
'\x1bHANDED INTERLACED PENTAGRAM'
'\nHANDS SIGN'
'\x0bHANG KHUDAM'
'\x03HAQ'
'\tHARD SIGN'
'\x03HAT'
'\x02HE'
'\x07HEADING'
'\x05HEART'
'\x11HEART-SHAPED EYES'
'\x06HEARTS'
'\x10HEAVY CHECK MARK'
'\x0bHEELED SHOE'
'\x04HEEN'
'\x03HEH'
'\x05HEUAE'
'\x06HEUAEP'
'\x02HH'
'\x03HHA'
'\x02HI'
'\rHIEROGLYPHIC '
'\x1fHIGH EXTRA-LOW CONTOUR TONE BAR'
'\x12HILOSOPHERS SULFUR'
'\x07HIOPIC '
'\x07HIUCHUS'
'\x05HMER '
'\x12HOOKED SCHWA WITH '
'\x04HOOL'
'\x04HOST'
'\x05HOTEL'
'\x04HREE'
'\nHREE DOTS '
'\x08HREE OF '
'\x05HROOM'
'\x04HUET'
'\x07HUNDRED'
'\x02HY'
'\x01I'
'\x0eI AND SKI BOOT'
'\x07I NTEUM'
'\x19I SYLLABLE ITERATION MARK'
'\tIAL LINE '
'\x0eIAN RUPEE SIGN'
'\x05ICAL '
'\x0cICE CONTROL '
'\x0cICE OF PIZZA'
'3ICLOCKWISE DOWNWARDS AND UPWARDS OPEN CIRCLE ARROWS'
'\x07ICYCLES'
'\x02ID'
'\x03IDA'
'\x0bIDEOGRAPH A'
'\nIED SHRIMP'
'\x03IEE'
'\x0bIEN MONSTER'
'\x1bIERSTRASS ELLIPTIC FUNCTION'
'\x03IES'
'\x04IGHT'
'\nIGHT RULER'
'\x0fIGHT WITH STARS'
'\x05IGIT '
'\x04IGN '
'\x15IGN INVERTED MCHU CAN'
'\nIGN SAMVAT'
'\tIGN TOMPI'
'\x02IH'
'\x02II'
'\x03IKA'
'\x02IL'
'\tIL POLISH'
'\x05ILED '
'\x04ILET'
'\x05ILVER'
'\nIMALUNGUN '
'\x05IMGBA'
'\x03IMN'
'\x02IN'
'\tINARBORAS'
'\x1dINDEPENDENT VOWEL SIGN COENG '
'\x05INDEX'
'\x04INDI'
'\x03INE'
'\x04ING '
'\x08ING BOWL'
'\x0eING HANDS SIGN'
'\tING HEART'
'\x07ING OF '
'\x11ING POLE AND FISH'
'\x13ING SHIRT WITH SASH'
'\x0eING TERMINATOR'
'\nING-SHIFT '
'\x08INITIAL '
'\x07INNABAR'
'\x04INU '
'\x11INVERTED MCHU CAN'
'\x03ION'
'\x02IP'
'\x02IQ'
'\x02IR'
'\nIRAL SHELL'
'\x05IRAMA'
'\x05IRCUT'
'\x03IRL'
'\x04IRON'
'\x04IRTY'
'\x02IS'
'\x03ISA'
'\nISMUTH ORE'
'\x03IST'
'\x17ISTED RIGHTWARDS ARROWS'
'\x02IT'
'\nIT MBAAKET'
'\x0cIT SEPARATOR'
'\x08ITA MFON'
'\x04ITAR'
'\x04ITE '
'\x03IVE'
'\x07IVE OF '
'\x0bIVERY TRUCK'
'\x0cIVISION SIGN'
'\x02IX'
'\x06IX OF '
'\rIYA FRACTION '
'\x04IYAQ'
'\tIZONTAL T'
'\x01J'
'\x02JA'
'\x08JACK OF '
'\x03JAH'
'\x03JAM'
'\x18JARATI ABBREVIATION SIGN'
'\x04JEEM'
'\x18JEEM WITH TWO DOTS ABOVE'
'\x0bJIHVAMULIYA'
'\x1eJK COMPATIBILITY IDEOGRAPH-FA2'
'\x15JK UNIFIED IDEOGRAPH-'
'\x05JUDUL'
'\x01K'
'\x0bK AND KNIFE'
'\tK GESTURE'
'\x0bK HAND SIGN'
'\x10K PERMITTED HERE'
'\x08K SYMBOL'
'\x15K WITH OBLIQUE STROKE'
'\x02KA'
'\nKA SATANGA'
'\x03KAD'
'\x03KAH'
'\x04KALI'
'\x03KAQ'
'\x05KARO '
'\x07KARO BA'
'\x0cKASHMIRI YEH'
'\x05KASRA'
'\x14KASRA WITH DOT BELOW'
'\x08KASRATAN'
'\tKATAKANA '
'\x02KE'
'\x11KE BOTTLE AND CUP'
'\x07KEUAERI'
'\x04KEUP'
'\x03KEY'
'\x08KEYBOARD'
'\x04KHAH'
'\x05KHMU '
'\nKINDI MVOP'
'\tKING FACE'
'\x04KINI'
'\x04KMA '
'\x04KOKO'
'\x03KOM'
'\x07KPAK WA'
'\x04KPEN'
'\x0bKRAINIAN IE'
'\x04KRI '
'\x03KUE'
'\x05KWAEN'
'\tKYO TOWER'
'\x01L'
'\x1eL WITH RETROFLEX HOOK AND BELT'
'\x02LA'
'\x03LAA'
'\x0bLABIAL SIGN'
'\nLACK JOKER'
'\x0bLACK SULFUR'
'\x03LAH'
'\x03LAM'
'\x13LAM WITH DOUBLE BAR'
'\x14LASHING SWEAT SYMBOL'
'\x06LATIN '
'\x15LATIN CAPITAL LETTER '
'\x03LAW'
'\x0fLAYALAM LETTER '
'\x0bLCE TSA CAN'
'\tLD TAMIL '
'\x05LDER '
'\x0eLDREN CROSSING'
'\x02LE'
'\x03LE '
'\x13LEADING MCHAN RTAGS'
'\x04LED '
'\x05LEERI'
'\x03LEF'
'\nLEFT GUARD'
'\x1cLEFT POINTING BACKHAND INDEX'
'\x1dLEFT-POINTING DOUBLE TRIANGLE'
'\x06LENDAR'
'\x06LETTER'
'\x07LETTER '
'\x1dLETTER SMALL CAPITAL TURNED M'
'\x08LETTER Y'
'\x07LETTERS'
'\x03LEU'
'\x0bLEU SATANGA'
'\x05LEVEN'
'\x07LF FACE'
'\x0fLF SECTION SIGN'
'\x04LFUR'
'\x02LH'
'\x11LHOUETTE OF JAPAN'
'\x05LICE '
'\x08LICOPTER'
'\x0bLIEVED FACE'
'\nLIGHT BULB'
'\x04LINE'
'\tLINE FEED'
'\x05LING '
'\x03LIP'
'\x07LKY WAY'
'\tLLEN LEAF'
'\x0cLLER COASTER'
'\x07LLEYBUS'
'\x07LLIARDS'
'\x06LLIPOP'
'\x0eLLISION SYMBOL'
'\x04LLLA'
'\x05LLOON'
'\x07LM TREE'
'\x02LO'
'\x04LOCK'
'\rLOCK WITH KEY'
'\x03LON'
'\x0fLOOK OF TRIUMPH'
'\x05LOOP '
'\x04LOW '
'\x1fLOW EXTRA-HIGH CONTOUR TONE BAR'
'\x0cLOWERED FLAG'
'\x05LPHIN'
'\x14LTIPLE MUSICAL NOTES'
'\x08LTRY LEG'
'\x05LURAL'
'\x08LWAY CAR'
'\x02LX'
'\x07LY LOOP'
'\x01M'
'\x06M FEED'
'\x0cM NSHUT NYAM'
'\x07M STONE'
'\x02MA'
'\x03MAA'
'\x07MAAYYAA'
'\x0bMACING FACE'
'\tMAEMGBIEE'
'\rMAILBOX WITH '
'\x05MAIZE'
'\x06MALGAM'
'\rMALL HIGH WAW'
'\x0cMALL LETTER '
'\x03MAN'
'\x04MARK'
'\x05MARK '
'\x04MARY'
'\x07MASSAGE'
'\rMATHEMATICAL '
'\x04MATO'
'\x03MBA'
'\x08MBINING '
'\x08MCHU CAN'
'\x08ME BADGE'
'\x0cMEDARY CAMEL'
'\x0cMEDICAL MASK'
'\x06MEDIUM'
'\x04MEEM'
'\x1aMEEM WITH HAH WITH TATWEEL'
'\x1aMEEM WITH THREE DOTS ABOVE'
'\x05MELON'
'\x11MEN HOLDING HANDS'
'\x10MENIAN DRAM SIGN'
'\x03MER'
'\tMER CLOCK'
'\x04MERA'
'\x07MERICAS'
'\x04MFAA'
'\x0bMFON PIPAEM'
'\x04MIL '
'\x0bMILING EYES'
'\x04MILY'
'\nMINUS SIGN'
'\x02MO'
'\rMOBILE PHONES'
'\x03MON'
'\x04MONO'
'\x05MOON '
'\x02MP'
'\x05MSHAE'
'\x03MSP'
'\x04MUCH'
'\x11MUM LETTER PHASE-'
'\x08MY HOUSE'
'\x01N'
'\x02N '
'\nN NGGEUAET'
'\x07N WITH '
'\x16N-POTABLE WATER SYMBOL'
'\x02NA'
'\x08NA METEK'
'\x03NAA'
'\x04NBOW'
'\x04NBSP'
'\x05NCESS'
'\x08NDA FACE'
'\nNDA PA NJI'
'\tNDAILING '
'\x05NDBAG'
'\x13NDRED POINTS SYMBOL'
'\x02NE'
'\x04NED '
'\x05NEGAR'
'\x04NEMA'
'\x03NEY'
'\x02NG'
'\x04NGUE'
'\x02NI'
'\tNIGHT OF '
'\x04NINE'
'\x08NINE OF '
'\x05NING '
'\x04NJAM'
'\x03NJI'
'\x0fNKING BEER MUGS'
'\x06NKNOWN'
'\x02NN'
'\x03NNA'
'\x11NNADA LETTER LLLA'
'\x06NNING '
'\x15NNIS RACQUET AND BALL'
'\x04NNNA'
'\x0fNO GOOD GESTURE'
'\x04NOON'
'\x04NOSE'
'\x04NOTE'
'\nNOTE WITH '
'\x08NOWLEDGE'
'\tNS SYMBOL'
'\x06NSANAQ'
'\x05NSIEE'
'\x05NSUAE'
'\x02NT'
'\x14NT-FACING BABY CHICK'
'\x04NTAA'
'\tNTESSENCE'
'\x0bNTIMONY ORE'
'\x05NUKTA'
'\x07NUMBER '
'\x07NUMBERS'
'\x07NUSVARA'
'\x03NYI'
'\x03NYO'
'\x05NZEUM'
'\x01O'
'\tO LETTER '
'\x06O MARK'
'\x04OALA'
'\x03OAP'
'\x03OAT'
'\x05OBILE'
'\x0eOBLIQUE STROKE'
'\x07OCALIC '
'\x08OCK SALT'
'\x0bOCOLATE BAR'
'\x0cOCTET PRESET'
'\x08OCUS OF '
'\x08ODESTONE'
'\x04ODLE'
'\x02OE'
'\x03OF '
'\x03OFF'
'\x07OFFICER'
'\x04OFUM'
'\x07OGICAL '
'\x08OGOGRAM '
'\x04OGRE'
'\x02OH'
'\x0bOHINGYA YEH'
'\x03OIL'
'\x02OK'
'\nOKEN HEART'
'\x0cOKING SYMBOL'
'\x06OLCANO'
'\x03OLD'
'\x04OLIN'
'\nOLLAR SIGN'
'\rOLVING HEARTS'
'\x02OM'
'\x08OM NTEUM'
'\x04OMBU'
'\x05OMEGA'
'\x05OMMAE'
'\x03OMS'
'\x02ON'
'\x03ON '
'\tON TEUAEQ'
'\x0cON US SYMBOL'
'\x13ON VIEWING CEREMONY'
'\x1eON WITH RIGHTWARDS ARROW ABOVE'
'\x03ONE'
'\x04ONE '
'\x08ONE DOT '
'\x0eONE SOUND WAVE'
'\x19ONE UNDER EIGHTEEN SYMBOL'
'\x04ONE-'
'\x07ONGONAN'
'\x03ONI'
'\x0cONISHED FACE'
'\x04ONTH'
'\x07ONTIEEN'
'\x03OOL'
'\x06OOPED '
'\x02OP'
'\nOP NKAARAE'
'\x05OPARD'
'\x05OPEN '
'\nOPEN MOUTH'
'\x0cOPEN O WITH '
'\tOPERATOR '
'\x06OPPER '
'\x07OPWATCH'
'\x02OQ'
'\x03OQ '
'\x0cOQ NSHUT YUM'
'\x05OQPEN'
'\x02OR'
'\x05ORAIL'
'\x0eORANGE DIAMOND'
'\x04ORAX'
'\rORD SEPARATOR'
'\x03ORE'
'\x07ORGIAN '
'\x04ORNS'
'\nORTHERN TA'
'\x05OSTER'
'\x02OT'
'\nOT MACHINE'
'\x08OT MBUAE'
'\x07OT NGOM'
'\tOTIFIED E'
'\nOTING STAR'
'\x07OTLESS '
'\x08OTPRINTS'
'\x04OTUS'
'\x0bOUBLE DANDA'
'\x1bOUBLE RIGHT ARROWHEAD ABOVE'
'\rOUGHT BALLOON'
'\x05OUNCE'
'\x0bOUNDED FACE'
'\x03OUR'
'\x07OUR OF '
'\x0bOUSEL HORSE'
'\x03OUT'
'\tOUT MOUTH'
'\nOUTHERN TA'
'\x0cOUTING WHALE'
'\tOWBOARDER'
'\nOWEL SIGN '
'\x01P'
'\x02P '
'\x07P PIEET'
'\nP STREAMER'
'\x0bP-POINTING '
'\x02PA'
'\rPA NJI PIPAEM'
'\x03PAH'
'\x08PAKPAK E'
'\x03PAN'
'\x07PANESE '
'\x05PARAQ'
'\x0ePARTMENT STORE'
'\x06PBOARD'
'\x0bPEDESTRIANS'
'\tPEN MOUTH'
'\x0fPENSION RAILWAY'
'\x07PERCLIP'
'\x03PES'
'\x04PEUX'
'\x02PH'
'\x05PHANT'
'\x05PHONE'
'\x0ePHONE RECEIVER'
'\x06PICKET'
'\x05PIRIT'
'\tPLE HEART'
'\x08PLE LEAF'
'\x04PLET'
'\x19PLICATION PROGRAM COMMAND'
'\x04PLUG'
'\tPLUS SIGN'
'\x13POINTING DOWNWARDS '
'\x19POINTING MAGNIFYING GLASS'
'\nPOLICE CAR'
'\x06POMMEE'
'\x0ePOMOFO LETTER '
'\x03POQ'
'\x0bPOST OFFICE'
'\nPOUND SIGN'
'\x0cPOUTING FACE'
'\x08PPY DISK'
'\x1bPPY PERSON RAISING ONE HAND'
'\x11PRESSIONLESS FACE'
'\x0ePROTECTED AREA'
'\x06PSTICK'
'\x05PTIC '
'\x0bPUNCTUATION'
'\x0cPUNCTUATION '
'\x12PUNCTUATION BINDU '
'\x03PUQ'
'\x0bPUT MORTUUM'
'\x0fPUT SYMBOL FOR '
'\x01Q'
'\x02QA'
'\x03QAF'
'\x12QAF WITH DOT BELOW'
'\x03QUA'
'\x07QUARED '
'\x07QUARTER'
'\x08QUARTERS'
'\tQUEEN OF '
'\x0bQUERED FLAG'
'\rQUESTION MARK'
'\x16QUESTION MARK ORNAMENT'
'\x03QUI'
'\x01R'
'\x06R FACE'
'\x15R WITH OBLIQUE STROKE'
'\x0eR-OFF CALENDAR'
'\x02RA'
'\x0bRA SOMPENG '
'\x03RAA'
'\x06RACING'
'\x05RADA '
'\x03RAE'
'\x0cRAFFIC LIGHT'
'\x0eRAGANA LETTER '
'\x03RAH'
'\x07RAILWAY'
'\x0bRAISED FLAG'
'!RAISING BOTH HANDS IN CELEBRATION'
'\x04RAMA'
'\x0bRANSMISSION'
'\x15RATING SYSTEM COMMAND'
'\x13RATUM SUPER STRATUM'
'\x02RB'
'\x02RC'
'\x07RCHAIC '
'\x08RCHAIC E'
'\tRCHAIC SA'
'\tREAK HERE'
'\x11REATIONAL VEHICLE'
'\nRECIPITATE'
'\x08RECT HIT'
'\nRED CIRCLE'
'\x08RED FACE'
'\x0cRED TRIANGLE'
'\x03REE'
'\x0bREE-EM DASH'
'\tREFORMED '
'\nREFORMED T'
'\x05REGIA'
'\x03REH'
'\x06REMEDY'
'\x03REU'
'\x0cREVERSED TSE'
'\x04RFER'
'\x04RGE '
'\x18RGLASS WITH FLOWING SAND'
'\x02RI'
'\x0cRIAGE RETURN'
'\x06RIBBON'
'\x04RICE'
'\x04RICK'
'\x06RIDENT'
'\x05RIEEN'
'\x04RIFY'
'\x05RIGHT'
'\x10RIGHT ARROWHEAD '
'\x0bRIGHT GUARD'
'\x1dRIGHT POINTING BACKHAND INDEX'
'\x0fRIGHT-POINTING '
'+RIGHTWARDS AND LEFTWARDS OPEN CIRCLE ARROWS'
'\x03RII'
'\x07RILLIC '
'\x04RING'
'\x05RINGE'
'\x04RISE'
'\x0fRISING DIAGONAL'
'\x0cRISTMAS TREE'
'\nRKING FACE'
'\x03RKL'
'\x03RMT'
'\x02RO'
'\x07ROITIC '
'\x04ROLL'
'\x03ROM'
'\x1bRONOMICAL SYMBOL FOR URANUS'
'\x14ROTATED ARDHAVISARGA'
'\nROUNDED ER'
'\x02RR'
'\x03RRA'
'\nRRIED FACE'
'\nRRIS WHEEL'
'\x08RSE DUNG'
'\x06RSENIC'
'\x02RT'
'\x06RT OF '
'\x06RTCAKE'
'\x08RTICAL T'
'\x03RTY'
'\x02RU'
'\x05RULER'
'\x02RY'
'\x07RY FACE'
'\x01S'
'\x02S '
'\x0fS IN SILHOUETTE'
'\x11S REVOLVING LIGHT'
'\x06S SHOE'
'\x15S WITH OBLIQUE STROKE'
'\x02SA'
'\x03SAA'
'\x03SAH'
'\nSALIZATION'
'\x08SALT OF '
'\x06SANDAL'
'\x0bSAPPOINTED '
'\x05SARGA'
'\x02SC'
'\nSCENT MOON'
'\x05SCOPE'
'\x05SCORE'
'\x02SE'
'\x03SE '
'\x04SED '
'\rSELECTED AREA'
'\tSEMICOLON'
'\tSEPARATOR'
'\nSEPARATOR '
'\x0eSEPARATOR MARK'
'\x03SET'
'\x12SET OVER BUILDINGS'
'\x02SH'
'\tSH SYMBOL'
'\x03SHA'
'\x04SHAE'
'\tSHED FACE'
'\x04SHES'
'\x13SHHA WITH DESCENDER'
'\x07SHIFT T'
'\x05SHPIN'
'\x02SI'
'\rSIA-AUSTRALIA'
'\x04SIGN'
'\x05SIGN '
'\x0bSIGN VIRAMA'
'$SINGLE COMMA QUOTATION MARK ORNAMENT'
'\tSIVE FACE'
'\tSIXTEENTH'
'\nSIXTEENTHS'
'\x11SKETBALL AND HOOP'
'\rSMALL LETTER '
'\x1aSMALL LETTER BOHAIRIC KHEI'
'\rSMALL LETTERS'
'\x11SMALL LIGATURE OE'
'\x12SMALL RED TRIANGLE'
'\nSMALL TAH '
'\x0cSMILING EYES'
'\x0eSMOKING SYMBOL'
'\tSOFT SIGN'
'\x08SOFTNESS'
'\x05SOLVE'
'\x03SOS'
'\x02SP'
'\x05SPACE'
'\x06SPADES'
'\x06SPAPER'
'\x0bSPEED TRAIN'
'\x06SPITAL'
'\rSQUARE BUTTON'
'\x08SQUARED '
'\x02SS'
'\rSSAGE WAITING'
'\x04SSOM'
'\x0eSSPORT CONTROL'
'\x02ST'
'\nST PALETTE'
'\x10ST QUARTER MOON '
'\tSTAL BALL'
'\tSTER FACE'
'\x07STITUTE'
'\x05STNUT'
'\x04STOL'
'\x06STRING'
'\x06STROOM'
'\nSTRUCTION '
'\x10STUCK-OUT TONGUE'
'\x05SURYA'
'\x08SWIMMING'
'\tSYLLABLE '
'\x18SYLLABLE REPETITION MARK'
'\x06SYMBOL'
'\x13SYMBOL FOR BEGINNER'
'\x0bSYMBOL VIDJ'
'\x07SYMBOLS'
'\x01T'
'\x02T '
'\nT AND BOLT'
'\x07T ASHES'
'\x1cT LITTER IN ITS PLACE SYMBOL'
'\x0cT MONGKEUAEQ'
'\x08T NGGEET'
'\x06T NJAQ'
'\x10T TRANSMIT STATE'
'\x07T WITH '
'\x02TA'
'\x0eTA LINK ESCAPE'
'\nTABULATION'
'\x06TAGRAM'
'\x03TAH'
'\x17TAH WITH TWO DOTS ABOVE'
'\x0eTAKANA LETTER '
'\x03TAN'
'\x04TAXI'
'\x0cTCHING CHICK'
'\rTE ORDER MARK'
'\x06TE USE'
'\x0cTEARS OF JOY'
'\rTED HAND SIGN'
'\x03TEE'
'\x03TEL'
'\x0fTELLITE ANTENNA'
'\x03TER'
'\x04TERY'
'\x06TEUWEN'
'\x04TEXT'
'\x04TFON'
'\x02TH'
'\tTH GLOBE '
'\nTHDAY CAKE'
'\x0bTHEMATICAL '
'\x0eTHER CHRISTMAS'
'\x0cTHLETIC SHOE'
'\x08THOUSAND'
'\x06THREE '
'\x11THREE SOUND WAVES'
'\x0fTHROWING A KISS'
'\x02TI'
'\nTICAL DISC'
'\x0bTIEE SHEUOQ'
'\x13TIGHTLY-CLOSED EYES'
'\x04TILL'
'\x04TIN '
'\x05TING '
'\nTING HEART'
'\x03TLE'
'\x06TLESS '
'\x06TO BOX'
'\x03TOM'
'\x05TONE '
'\x11TONE CANDRA ABOVE'
'\tTOP RIGHT'
'\x05TORCH'
'\x04TORT'
'\x04TORY'
'\x14TRAILING MCHAN RTAGS'
'\x14TRATERRESTRIAL ALIEN'
'\x03TRE'
'\nTREFACTION'
'\tTRETCHED '
'\x0bTRIAN CAMEL'
'!TRIANGLE WITH DOUBLE VERTICAL BAR'
'\x05TRING'
'\x05TRIOL'
'\x03TRO'
'\x18TROL SEQUENCE INTRODUCER'
'\x02TT'
'\x05TTER '
'\x03TTH'
'\x04TTTA'
'\x03TUB'
'\x06TURBAN'
'\x08TURNED H'
'\x0eTURNED V WITH '
'\x03TWO'
'\tTWO DOTS '
'\x02TY'
'\x0fTYSCAPE AT DUSK'
'\x01U'
'\x02U '
'\x06U MBIT'
'\x07U-BRJGU'
'\x03UAE'
'\x04UAEM'
'\x04UAEN'
'\x04UAEP'
'\x06UAEQTU'
'\x04UAET'
'\x0eUBJOINED SIGN '
'\x08UBLE DOT'
'\x17UBLE VERTICAL BAR BELOW'
'\x0cUBLE-STRUCK '
'\x16UBSCRIPT SMALL LETTER '
'\x06UCIBLE'
'\x10UDLY CRYING FACE'
'\x02UE'
'\x03UE '
'\tUE MAEMBA'
'\rUE OF LIBERTY'
'\x03UEQ'
'\x02UH'
'\x04UIRY'
'\x0bUISHED FACE'
'\x08UKEUTNDA'
'\x03ULL'
'\tULL MOON '
'\x02UM'
'\x08UMBRELLA'
'\x05UMBS '
'\x05UMPET'
'\x02UN'
'\x07UN MEUT'
'\x0bUND PUSHPIN'
'\x06UNGAAM'
'\x05UNGBA'
'\tUNGLASSES'
'\x02UO'
'\x03UOM'
'\x03UOQ'
'\x02UP'
'\x1aUP POINTING BACKHAND INDEX'
'\x0cUP SEPARATOR'
'\x07UP SIGN'
'\x18UP WITH EXCLAMATION MARK'
'\x1bUP-POINTING DOUBLE TRIANGLE'
'\x0bUPADHMANIYA'
'\x0fUPLE WITH HEART'
'\rUPWARDS TREND'
'\x02UQ'
'\x03UQA'
'\x05UQUET'
'\x02UR'
'\x0eUR LEAF CLOVER'
'\x05URINE'
'\nURIPIGMENT'
'\x06URNAMA'
'\x08UROPEAN '
'\x07US TENT'
'\tUSED FACE'
'\nUSHED FACE'
'\x07USHENNA'
'\x02UT'
'\x04UTAE'
'\nUTBOX TRAY'
'\x05UTEUX'
'\nUTRAL FACE'
'\x04UTTY'
'\x02UU'
'\x02UX'
'\x01V'
'\x02VA'
'\x07VAGRAHA'
'\x03VAH'
'\x07VAPOURS'
'\x02VD'
'\x02VE'
'\x03VE '
'\x07VED ICE'
'\x03VEE'
'!VELOPE WITH DOWNWARDS ARROW ABOVE'
'\x0eVENIENCE STORE'
'\rVERGREEN TREE'
'\x10VERTED PENTAGRAM'
'\x0bVERTICALLY '
'\x03VEU'
'\tVEUAENGAM'
'\x04VEUM'
'\x04VEUX'
'\x02VI'
'\nVIE CAMERA'
'\x0eVING HAND SIGN'
'\x07VISARGA'
'\x06VISION'
'\x05VITAE'
'\x02VO'
'\x08VOCALIC '
'\x11VOCALIZATION MARK'
'\x07VOICING'
'\x03VOP'
'\x11VOWEL LENGTH MARK'
'\x0bVOWEL SIGN '
'\x02VS'
'\x04VUEQ'
'\x03VY '
'\x01W'
'\x13W BRIGHTNESS SYMBOL'
'\x08W PRINTS'
'\x02WA'
'\x03WAA'
'\x04WAEN'
'\x04WAET'
'\x04WAVE'
'\x10WAVY HAMZA BELOW'
'\x03WAW'
'\x13WAW WITH DOT WITHIN'
'\x06WBERRY'
'\x05WBOAT'
'\x02WC'
'\x04WDER'
'\x03WER'
'\x11WER PLAYING CARDS'
'\x05WFISH'
'\x0bWHITE JOKER'
'\x06WIMMER'
'\nWING HEART'
'\tWING STAR'
'\x0bWINKING EYE'
'\x05WISE '
'\x04WITH'
'\x05WITH '
'\tWITH CURL'
'\tWITH FACE'
'\x0bWITH GARDEN'
'\x12WITH JUSTIFICATION'
'\x1aWITH LEFTWARDS ARROW ABOVE'
'\x1dWITH RIGHTWARDS ARROW AT LEFT'
'\x18WITH UPWARDS ARROW ABOVE'
'\nWITH WINGS'
'\x05WLING'
'\x02WN'
'\x0cWN-POINTING '
'\x1aWNING FACE WITH OPEN MOUTH'
'\x02WO'
'\x08WO DOTS '
'\x06WO OF '
'\x05WOMAN'
'\x13WOMEN HOLDING HANDS'
'\x03WOQ'
'\x14WORD REPETITION MARK'
'\x04WORK'
'\x06WORKER'
'\tWRY SMILE'
'\x05WUAET'
'\x01X'
'\tX MACHINE'
'\x1eX POINTED STAR WITH MIDDLE DOT'
'\x02XA'
'\x02XI'
'\x05XING '
'\x07XOPHONE'
'\x07XT LINE'
'\x01Y'
'\nY AND RICE'
'\tY BLOSSOM'
'\x06Y FACE'
'\x08Y POPPER'
'\x02YA'
'\x03YAA'
'\x03YAH'
'\x03YAI'
'\x07YANSAYA'
'\x02YE'
'\x03YEE'
'\x03YEH'
'\x1cYEH WITH TWO DOTS BELOW AND '
'\x08YEN SIGN'
'\x04YEUX'
'\x02YI'
'\x03YI '
'\x10YIR MKPARAQ MEUN'
'\x06YMBOL '
'\x0cYMBOL BINDU '
'\x02YN'
'\x02YO'
'\x01Z'
'\x02ZA'
'\x03ZAH'
'\x0eZAKAYA LANTERN'
'2ZANTINE MUSICAL SYMBOL FTHORA SKLIRON CHROMA VASIS'
'\x04ZERO'
'\x02ZW'
'\x02ZY'
'\x03ZZA'
'\x04ZZY '
)
_charnodes =[66678,
 -63742,
 -1,
 131991,
 838,
 -1,
 197428,
 74028,
 -1,
 262370,
 134979,
 -1,
 327744,
 205127,
 -1,
 393247,
 267261,
 -1,
 458767,
 334597,
 -1,
 524298,
 406344,
 -1,
 -65527,
 468621,
 92598,
 -1,
 532321,
 92619,
 720909,
 463285,
 -1,
 -65524,
 669900,
 92543,
 -1,
 721926,
 92553,
 983039,
 656198,
 92531,
 -1,
 853242,
 92601,
 1048600,
 398333,
 -1,
 1114132,
 996168,
 -1,
 -65518,
 1059190,
 92550,
 -65517,
 1123981,
 92624,
 -1,
 1180734,
 92563,
 1441791,
 1052481,
 -1,
 1441815,
 1323868,
 92607,
 -1,
 1388579,
 92535,
 -1,
 1380295,
 92557,
 1638426,
 996188,
 92640,
 -1,
 1585187,
 92657,
 1769501,
 1581848,
 -1,
 -65508,
 1714352,
 92544,
 -1,
 1779341,
 92541,
 -65506,
 1708555,
 92579,
 -1,
 1901382,
 92658,
 2097193,
 330967,
 -1,
 2162725,
 2032454,
 -1,
 2228260,
 2097992,
 -1,
 -65501,
 2174681,
 92562,
 -1,
 2236734,
 92637,
 -1,
 2172557,
 92518,
 2490408,
 2103101,
 -1,
 -65497,
 2435248,
 92558,
 -1,
 2491890,
 92592,
 -1,
 2438221,
 92528,
 2752559,
 2038385,
 -1,
 2818094,
 2690881,
 -1,
 2883629,
 2756417,
 92628,
 -1,
 2818168,
 92648,
 -1,
 2831785,
 92547,
 -1,
 2753552,
 92554,
 3145780,
 2698631,
 -1,
 3211315,
 3093320,
 -1,
 -65486,
 3155190,
 92527,
 -1,
 3215169,
 92545,
 -1,
 3151875,
 92540,
 3473463,
 3094969,
 -1,
 -65482,
 3421464,
 92609,
 -1,
 3474930,
 92583,
 3670074,
 3422602,
 -1,
 -65479,
 3607330,
 92589,
 -1,
 3671951,
 92608,
 3866685,
 3616803,
 -1,
 -65476,
 3814453,
 92604,
 -1,
 3868110,
 92622,
 4063295,
 3801926,
 92662,
 -1,
 4001601,
 92613,
 -1,
 4004895,
 92584,
 4259928,
 272013,
 -1,
 4325447,
 4207432,
 92576,
 4390981,
 4260678,
 -1,
 -65468,
 4335792,
 92618,
 -1,
 4394817,
 92529,
 -65466,
 4333409,
 92561,
 -1,
 4525889,
 92649,
 4718669,
 4260678,
 -1,
 4784202,
 4653894,
 92524,
 -1,
 4726625,
 92536,
 4980735,
 4718925,
 -1,
 -65460,
 4857671,
 92634,
 -1,
 4919478,
 92625,
 5111889,
 4659005,
 92663,
 5242879,
 5050177,
 -1,
 -65456,
 5124131,
 92621,
 -1,
 5181643,
 92593,
 5374038,
 5050177,
 -1,
 5439573,
 5321544,
 -1,
 -65452,
 5388492,
 92647,
 -1,
 5451811,
 92605,
 -1,
 5378112,
 92548,
 5767167,
 5317400,
 92568,
 -1,
 5645364,
 92610,
 5832811,
 4202337,
 -1,
 5898334,
 5768006,
 92667,
 5963868,
 5836609,
 92600,
 -1,
 5906273,
 92542,
 -65443,
 5908656,
 92668,
 -1,
 6039181,
 92555,
 6226016,
 5838653,
 92654,
 -1,
 6164420,
 92611,
 6357091,
 6165553,
 -1,
 -65438,
 6295625,
 92581,
 -1,
 6357830,
 92551,
 6553702,
 6293309,
 -1,
 -65435,
 6501429,
 92520,
 -1,
 6557505,
 92582,
 -65433,
 6501967,
 92617,
 -65432,
 6697820,
 92614,
 -65431,
 6759476,
 92671,
 -65430,
 6820634,
 92591,
 -1,
 6885449,
 92666,
 7078014,
 5779491,
 -1,
 7143538,
 7013190,
 -1,
 7209071,
 7078726,
 92635,
 -1,
 7153840,
 92577,
 -65424,
 7153840,
 92636,
 -65423,
 7282529,
 92530,
 -1,
 7344208,
 92559,
 7536758,
 7091016,
 -1,
 7602293,
 7479137,
 92586,
 -1,
 7537653,
 92569,
 -1,
 7537653,
 92566,
 7798906,
 7480088,
 -1,
 7864441,
 7742232,
 92537,
 -1,
 7807303,
 92519,
 -1,
 7809200,
 92630,
 8126463,
 7737153,
 -1,
 8126589,
 8008520,
 92669,
 -1,
 8062004,
 92572,
 -1,
 8069447,
 92672,
 8323216,
 7026963,
 -1,
 8388740,
 8270664,
 -1,
 -65407,
 8333488,
 92644,
 -65406,
 8397127,
 92645,
 -65405,
 8458443,
 92594,
 -1,
 8520733,
 92641,
 8716425,
 8327605,
 -1,
 8781959,
 8651765,
 92567,
 -1,
 8728611,
 92623,
 -65400,
 8730828,
 92639,
 -1,
 8855393,
 92606,
 9044108,
 8660292,
 -1,
 -65397,
 8990664,
 92642,
 -1,
 9047050,
 92643,
 9240719,
 8984381,
 -1,
 -65394,
 9187363,
 92590,
 -1,
 9244612,
 92564,
 -1,
 9176526,
 92588,
 9502876,
 8268946,
 -1,
 9568406,
 9442705,
 -1,
 9633940,
 9511704,
 92659,
 -1,
 9578672,
 92660,
 -65387,
 9574814,
 92638,
 -1,
 9703895,
 92580,
 9896089,
 9506625,
 -1,
 -65384,
 9842723,
 92560,
 -1,
 9899841,
 92534,
 -65382,
 9843557,
 92571,
 -65381,
 10036243,
 92525,
 -1,
 10093404,
 92549,
 10289321,
 9444437,
 -1,
 10354851,
 10232600,
 -1,
 10420385,
 10298136,
 -1,
 -65376,
 10367011,
 92556,
 -1,
 10428743,
 92523,
 -65374,
 10365104,
 92664,
 -1,
 10559329,
 92539,
 10748071,
 10289990,
 -1,
 -65371,
 10692784,
 92633,
 -65370,
 10757773,
 92521,
 -1,
 10814698,
 92575,
 -65368,
 10695496,
 92653,
 -1,
 10949060,
 92595,
 11141302,
 10230533,
 -1,
 11206830,
 11088712,
 -1,
 -65364,
 11153443,
 92620,
 -65363,
 11216118,
 92538,
 -1,
 11276676,
 92587,
 11468979,
 11145025,
 -1,
 11534514,
 11416392,
 -1,
 -65359,
 11483340,
 92646,
 -1,
 11535349,
 92570,
 -1,
 11481123,
 92599,
 -65356,
 11413289,
 92532,
 -65355,
 11739928,
 92665,
 -1,
 11802429,
 92670,
 11993282,
 11080336,
 -1,
 12058814,
 11940680,
 -1,
 12124348,
 11993088,
 -1,
 -65350,
 12069548,
 92661,
 -65349,
 12130109,
 92616,
 -1,
 12192014,
 92626,
 12451839,
 12062529,
 92596,
 -1,
 12333091,
 92612,
 12517568,
 11993926,
 92603,
 -1,
 12462256,
 92673,
 -65343,
 12461075,
 92627,
 -1,
 12586948,
 92651,
 12779727,
 11932669,
 -1,
 12845260,
 12719505,
 -1,
 12910794,
 12783425,
 -1,
 12976329,
 12858184,
 -1,
 -65337,
 12925132,
 92552,
 -65336,
 12984647,
 92565,
 -1,
 13042677,
 92615,
 -1,
 12922915,
 92602,
 -65333,
 12854291,
 92674,
 -1,
 13239139,
 92578,
 13500415,
 12781373,
 -1,
 -65330,
 13383081,
 92597,
 -1,
 13447203,
 92585,
 13631701,
 12724520,
 -1,
 13697235,
 13566790,
 -1,
 -65326,
 13641904,
 92526,
 -1,
 13700929,
 92656,
 -65324,
 13637820,
 92546,
 -1,
 13832755,
 92655,
 14024922,
 13579989,
 -1,
 14090457,
 13972296,
 -1,
 -65320,
 14033688,
 92533,
 -1,
 14094145,
 92650,
 -1,
 14029363,
 92574,
 14352607,
 13972908,
 -1,
 14418142,
 14290753,
 -1,
 -65315,
 14365532,
 92573,
 -1,
 14421825,
 92652,
 -1,
 14361619,
 92522,
 -65312,
 14295832,
 92631,
 -65311,
 14620477,
 92632,
 -1,
 14680902,
 92629,
 14877065,
 199897,
 -1,
 14942487,
 14819655,
 -1,
 15007989,
 14881789,
 -1,
 15073517,
 14949125,
 -1,
 15139049,
 15012277,
 -1,
 -65304,
 15084263,
 92432,
 -1,
 15139892,
 92457,
 -65302,
 15087956,
 92435,
 -65301,
 15283277,
 92412,
 -65300,
 15341571,
 92476,
 -1,
 15402446,
 92414,
 15663103,
 15012861,
 -1,
 15663346,
 15532870,
 -1,
 15728881,
 15598826,
 92465,
 -1,
 15664117,
 92409,
 -1,
 15672973,
 92483,
 -65293,
 15611643,
 92467,
 -65292,
 15873150,
 92485,
 -1,
 15929907,
 92475,
 16122109,
 14948977,
 -1,
 16187640,
 16062269,
 92403,
 -1,
 16125892,
 92405,
 16318715,
 16126389,
 -1,
 -65286,
 16265251,
 92407,
 -1,
 16319494,
 92430,
 -65284,
 16266246,
 92487,
 -1,
 16451022,
 92418,
 16646405,
 16067730,
 -1,
 16711937,
 16586755,
 -1,
 -65280,
 16658467,
 92459,
 -1,
 16721549,
 92447,
 16908548,
 16651665,
 -1,
 -65277,
 16856445,
 92486,
 -1,
 16912324,
 92408,
 -1,
 16856117,
 92480,
 17170698,
 16595219,
 -1,
 -65273,
 17118183,
 92463,
 -65272,
 17176381,
 92493,
 -65271,
 17240452,
 92450,
 -1,
 17302762,
 92410,
 17498384,
 17108183,
 -1,
 17563918,
 17436481,
 -1,
 -65267,
 17511849,
 92425,
 -1,
 17567553,
 92437,
 -65265,
 17507380,
 92440,
 -1,
 17695978,
 92471,
 17891605,
 17444899,
 -1,
 17957140,
 17829697,
 -1,
 -65261,
 17904693,
 92472,
 -1,
 17960769,
 92505,
 -1,
 17905062,
 92514,
 -65258,
 17838920,
 92503,
 -1,
 18159421,
 92507,
 18350386,
 14884705,
 92497,
 18415903,
 18289296,
 -1,
 18481435,
 18359064,
 92445,
 -1,
 18424135,
 92404,
 18612510,
 18420149,
 -1,
 -65251,
 18559011,
 92424,
 -1,
 18613237,
 92458,
 -1,
 18552835,
 92466,
 18874659,
 18355249,
 -1,
 -65247,
 18817953,
 92438,
 -65246,
 18880515,
 92444,
 -1,
 18944490,
 92442,
 19136808,
 18812737,
 -1,
 19202343,
 19084104,
 -1,
 -65242,
 19148835,
 92427,
 -1,
 19210567,
 92478,
 -1,
 19140551,
 92496,
 19464492,
 19072770,
 -1,
 19530027,
 19399516,
 92448,
 -1,
 19464547,
 92515,
 -1,
 19477627,
 92401,
 19726639,
 19399494,
 -1,
 -65234,
 19668301,
 92426,
 -1,
 19730558,
 92482,
 -65232,
 19674791,
 92510,
 -65231,
 19870536,
 92499,
 -1,
 19932365,
 92441,
 20119877,
 18295954,
 -1,
 20185404,
 20059537,
 -1,
 20250937,
 20123457,
 -1,
 20316472,
 20198216,
 -1,
 -65225,
 20265164,
 92501,
 -1,
 20317173,
 92417,
 -1,
 20254529,
 92413,
 -65222,
 20198216,
 92504,
 -65221,
 20522305,
 92508,
 -1,
 20584588,
 92500,
 20775232,
 20132680,
 -1,
 -65218,
 20722504,
 92498,
 -65217,
 20778817,
 92419,
 -1,
 20841461,
 92473,
 21037379,
 20710214,
 -1,
 -65214,
 20981936,
 92516,
 -1,
 21046925,
 92423,
 -65212,
 20981160,
 92452,
 -1,
 21172695,
 92428,
 21365075,
 20060933,
 -1,
 21430605,
 21303105,
 -1,
 21496140,
 21377864,
 -1,
 -65207,
 21440141,
 92460,
 -65206,
 21505462,
 92431,
 -65205,
 21569377,
 92454,
 -1,
 21627978,
 92415,
 -1,
 21442595,
 92420,
 21889361,
 21377864,
 92489,
 -65201,
 21833904,
 92479,
 -65200,
 21898259,
 92422,
 -1,
 21963079,
 92474,
 -65198,
 21838164,
 92502,
 -1,
 22099712,
 92449,
 22282591,
 21311523,
 -1,
 22348122,
 22220609,
 -1,
 22413657,
 22295368,
 -1,
 -65193,
 22360099,
 92416,
 -65192,
 22421831,
 92481,
 -1,
 22479901,
 92451,
 -1,
 22351815,
 92456,
 22741340,
 22295368,
 92433,
 -1,
 22685096,
 92477,
 -65187,
 22684993,
 92492,
 -65186,
 22812477,
 92513,
 -1,
 22873077,
 92491,
 23069033,
 22223957,
 -1,
 23134566,
 23007041,
 -1,
 23200100,
 23081800,
 -1,
 -65181,
 23142241,
 92484,
 -1,
 23200810,
 92439,
 -65179,
 23146531,
 92464,
 -1,
 23334855,
 92495,
 -65177,
 23082037,
 92446,
 -65176,
 23471425,
 92511,
 -1,
 23533571,
 92406,
 23724402,
 23013005,
 -1,
 23789933,
 23671624,
 -1,
 -65172,
 23737725,
 92443,
 -1,
 23799984,
 92509,
 23986544,
 23727937,
 -1,
 -65169,
 23934336,
 92462,
 -1,
 23990081,
 92506,
 -65167,
 23927195,
 92461,
 -1,
 24118734,
 92469,
 24314234,
 23673107,
 -1,
 24379768,
 24261448,
 -1,
 24445303,
 24322840,
 -1,
 -65162,
 24389261,
 92470,
 -1,
 24452961,
 92468,
 -1,
 24393879,
 92453,
 -65159,
 24318025,
 92429,
 -1,
 24642582,
 92421,
 24838528,
 24258856,
 -1,
 24904062,
 24776780,
 -1,
 -65155,
 24847345,
 92490,
 -1,
 24912167,
 92512,
 -65153,
 24844428,
 92494,
 -1,
 25035782,
 92455,
 25231747,
 24786645,
 -1,
 -65150,
 25178981,
 92411,
 -1,
 25232846,
 92402,
 25428358,
 25171137,
 -1,
 -65147,
 25366975,
 92488,
 -1,
 25428828,
 92434,
 25690111,
 25367184,
 -1,
 -65144,
 25563613,
 92436,
 -1,
 25625436,
 92517,
 25821724,
 14813398,
 -1,
 25887166,
 25764167,
 -1,
 25952664,
 25826301,
 -1,
 26018195,
 25891837,
 -1,
 26083730,
 25965384,
 92362,
 -65137,
 26027060,
 92341,
 -65136,
 26091361,
 92347,
 -65135,
 26152935,
 92370,
 -1,
 26215457,
 92336,
 -1,
 26021961,
 92307,
 26476950,
 25959173,
 -1,
 -65131,
 26424302,
 92303,
 -1,
 26478066,
 92309,
 -65129,
 26420243,
 92368,
 -1,
 26609138,
 92395,
 26804640,
 25898130,
 -1,
 26870172,
 26751816,
 -1,
 -65125,
 26813887,
 92359,
 -1,
 26878279,
 92374,
 -65123,
 26813459,
 92371,
 -65122,
 27006491,
 92351,
 -65121,
 27070922,
 92325,
 -1,
 27132742,
 92350,
 27328937,
 26741975,
 -1,
 27394468,
 27267509,
 -1,
 -65117,
 27340835,
 92349,
 -1,
 27395128,
 92308,
 27591079,
 27329350,
 -1,
 -65114,
 27534989,
 92378,
 -1,
 27598689,
 92375,
 -65112,
 27534367,
 92317,
 -1,
 27727848,
 92331,
 27918769,
 27269745,
 -1,
 27984301,
 27856705,
 -1,
 -65108,
 27932073,
 92389,
 -1,
 27987911,
 92360,
 28180912,
 27919174,
 -1,
 -65105,
 28122977,
 92367,
 -1,
 28184640,
 92356,
 -1,
 28128262,
 92333,
 28443063,
 27865123,
 -1,
 28508597,
 28380993,
 -1,
 -65100,
 28456043,
 92345,
 -1,
 28516679,
 92372,
 -65098,
 28455757,
 92314,
 -1,
 28640092,
 92340,
 28836282,
 28391865,
 -1,
 -65095,
 28774886,
 92323,
 -1,
 28836678,
 92304,
 29032893,
 28771142,
 -1,
 -65092,
 28977328,
 92396,
 -1,
 29041318,
 92338,
 -1,
 28981646,
 92313,
 29295067,
 25829217,
 -1,
 29360593,
 29230850,
 -1,
 29426118,
 29298497,
 -1,
 29491652,
 29373256,
 -1,
 -65085,
 29440204,
 92385,
 -1,
 29499233,
 92315,
 -65083,
 29436278,
 92354,
 -1,
 29626396,
 92311,
 29819337,
 29366077,
 92381,
 -65080,
 29765667,
 92326,
 -1,
 29829903,
 92343,
 30015950,
 29754182,
 -1,
 30081485,
 29950792,
 -1,
 -65076,
 30025548,
 92387,
 -1,
 30083310,
 92318,
 -1,
 30024458,
 92383,
 30408703,
 29963080,
 -1,
 -65072,
 30281537,
 92324,
 -1,
 30344198,
 92364,
 30540248,
 29295430,
 -1,
 30605781,
 30478145,
 -1,
 -65068,
 30551502,
 92363,
 -1,
 30613513,
 92382,
 30867455,
 30539776,
 -1,
 -65065,
 30745261,
 92376,
 -1,
 30809046,
 92339,
 -65063,
 30487388,
 92391,
 -65062,
 30939139,
 92390,
 -1,
 31003706,
 92344,
 31195628,
 29235973,
 -1,
 31261159,
 31133505,
 -1,
 31326691,
 31208264,
 -1,
 31392225,
 31272082,
 -1,
 -65056,
 31331971,
 92319,
 -1,
 31396403,
 92384,
 -65054,
 31334241,
 92386,
 -1,
 31529844,
 92321,
 31719910,
 31269193,
 -1,
 -65051,
 31661294,
 92393,
 -1,
 31724254,
 92394,
 -1,
 31666211,
 92361,
 31982058,
 31208264,
 -1,
 -65047,
 31928355,
 92366,
 -1,
 31991033,
 92373,
 -65045,
 31925979,
 92328,
 -1,
 32113500,
 92329,
 32309747,
 31144211,
 -1,
 32375281,
 32256840,
 -1,
 -65041,
 32323735,
 92388,
 -65040,
 32382817,
 92305,
 -1,
 32440566,
 92322,
 -65038,
 32313857,
 92327,
 -1,
 32572252,
 92377,
 32768507,
 32256035,
 -1,
 32834039,
 32709111,
 -1,
 -65034,
 32781162,
 92358,
 -1,
 32834386,
 92334,
 33030650,
 32771905,
 -1,
 -65031,
 32978320,
 92346,
 -1,
 33042467,
 92400,
 -1,
 32965487,
 92332,
 33292803,
 32713874,
 -1,
 33358335,
 33232273,
 -1,
 -65026,
 33305606,
 92379,
 -1,
 33364382,
 92392,
 33554946,
 33296193,
 -1,
 -65023,
 33502633,
 92330,
 -1,
 33567056,
 92380,
 -1,
 33502070,
 92335,
 33817097,
 33234005,
 -1,
 33882631,
 33751878,
 -1,
 -65018,
 33826445,
 92342,
 -1,
 33890145,
 92357,
 -65016,
 33829704,
 92365,
 -1,
 34019742,
 92397,
 34210318,
 33760909,
 -1,
 34275853,
 34150205,
 -1,
 -65012,
 34220815,
 92316,
 -1,
 34283847,
 92398,
 -1,
 34213961,
 92399,
 34538003,
 34149373,
 -1,
 34603538,
 34477471,
 -1,
 -65007,
 34548086,
 92310,
 -1,
 34612877,
 92320,
 -1,
 34539307,
 92312,
 34865686,
 34485973,
 -1,
 -65003,
 34813062,
 92369,
 -1,
 34866566,
 92306,
 35062297,
 34813495,
 -1,
 -65000,
 35010764,
 92337,
 -1,
 35062830,
 92353,
 -64998,
 35007614,
 92355,
 -64997,
 35197945,
 92348,
 -1,
 35260591,
 92352,
 35455642,
 25756488,
 -1,
 35521088,
 35397959,
 -1,
 35586596,
 35467299,
 -1,
 35652131,
 35521998,
 92223,
 35782655,
 35586048,
 -1,
 -64990,
 35660497,
 92194,
 -1,
 35725512,
 92185,
 -1,
 35595605,
 92178,
 35979818,
 35525629,
 -1,
 36045352,
 35920961,
 -1,
 -64985,
 35988242,
 92182,
 -1,
 36045040,
 92160,
 -64983,
 35984535,
 92229,
 -1,
 36177310,
 92173,
 36373038,
 35928339,
 -1,
 36438573,
 36312893,
 92239,
 -1,
 36384856,
 92225,
 -1,
 36376964,
 92233,
 36635185,
 36321721,
 -1,
 -64976,
 36582480,
 92191,
 -1,
 36635467,
 92167,
 36831796,
 36580743,
 -1,
 -64973,
 36771843,
 92237,
 -1,
 36832070,
 92241,
 37028407,
 36772613,
 -1,
 -64970,
 36968695,
 92180,
 -1,
 37028713,
 92227,
 37225018,
 36965627,
 -1,
 -64967,
 37160316,
 92212,
 -1,
 37224635,
 92201,
 37421629,
 37159750,
 -1,
 -64964,
 37365936,
 92245,
 -1,
 37421899,
 92164,
 -64962,
 37362307,
 92231,
 -64961,
 37558415,
 92204,
 -1,
 37621833,
 92244,
 37814871,
 35463009,
 -1,
 37880396,
 37749574,
 -1,
 37945930,
 37818177,
 -1,
 38011463,
 37887841,
 92238,
 -64955,
 37959242,
 92174,
 -64954,
 38018091,
 92203,
 -1,
 38078359,
 92171,
 -64952,
 37957070,
 92230,
 -64951,
 38216458,
 92210,
 -1,
 38280158,
 92186,
 -64949,
 37889682,
 92221,
 -1,
 38412979,
 92175,
 38601297,
 37823256,
 -1,
 38666832,
 38544403,
 -1,
 -64945,
 38611088,
 92198,
 -1,
 38670895,
 92214,
 -1,
 38609228,
 92190,
 38928980,
 38536967,
 -1,
 -64941,
 38873264,
 92246,
 -1,
 38937354,
 92232,
 -64939,
 38876731,
 92176,
 -64938,
 39064628,
 92196,
 -1,
 39129582,
 92197,
 39322215,
 37760146,
 -1,
 39387744,
 39261585,
 -1,
 39453276,
 39334728,
 -1,
 -64933,
 39395169,
 92215,
 -1,
 39456926,
 92165,
 39649887,
 39393085,
 -1,
 -64930,
 39594358,
 92222,
 -1,
 39657887,
 92168,
 -1,
 39593288,
 92224,
 39912036,
 39330584,
 -1,
 -64926,
 39858211,
 92235,
 -64925,
 39921840,
 92220,
 -1,
 39985678,
 92208,
 -64923,
 39859622,
 92181,
 -64922,
 40114636,
 92195,
 -1,
 40178170,
 92177,
 40370808,
 39265933,
 -1,
 40436335,
 40305478,
 -1,
 40501868,
 40371014,
 -1,
 -64917,
 40446326,
 92226,
 -1,
 40509281,
 92236,
 -64915,
 40447384,
 92187,
 -64914,
 40640797,
 92189,
 -1,
 40698043,
 92200,
 40895094,
 40379447,
 -1,
 40960627,
 40838836,
 -1,
 -64910,
 40899649,
 92169,
 -1,
 40961799,
 92170,
 41222143,
 40902861,
 -1,
 -64907,
 41096257,
 92162,
 -1,
 41158407,
 92163,
 -64905,
 40842374,
 92205,
 -1,
 41292164,
 92202,
 41484929,
 40311557,
 -1,
 41550460,
 41422657,
 -1,
 -64901,
 41497630,
 92179,
 -1,
 41562147,
 92211,
 41747071,
 41485126,
 -1,
 -64898,
 41691312,
 92240,
 -1,
 41751189,
 92199,
 -64896,
 41694338,
 92213,
 -1,
 41887721,
 92219,
 42074761,
 41431075,
 -1,
 42140293,
 42021704,
 -1,
 -64892,
 42075178,
 92206,
 -1,
 42139874,
 92172,
 42336904,
 42078645,
 -1,
 -64889,
 42283332,
 92209,
 -1,
 42337309,
 92234,
 -1,
 42277394,
 92166,
 42599055,
 42015829,
 -1,
 42664588,
 42545992,
 92243,
 -1,
 42599466,
 92207,
 -64883,
 42607658,
 92216,
 -64882,
 42733959,
 92184,
 -1,
 42796497,
 92183,
 42992276,
 42537981,
 -1,
 43057811,
 42931837,
 -1,
 -64878,
 43002230,
 92188,
 -1,
 43062481,
 92193,
 -1,
 42993607,
 92161,
 43319959,
 42939208,
 -1,
 -64874,
 43262503,
 92228,
 -1,
 43319994,
 92192,
 -64872,
 43267543,
 92242,
 -64871,
 43461619,
 92218,
 -1,
 43520846,
 92217,
 43713259,
 35391236,
 -1,
 43778734,
 43655009,
 -1,
 43844259,
 43714306,
 -1,
 43909792,
 43778886,
 -1,
 -64865,
 43845112,
 92255,
 -1,
 43909338,
 92252,
 -64863,
 43857026,
 92292,
 -64862,
 44046842,
 92268,
 -1,
 44110354,
 92286,
 44303015,
 43778886,
 92300,
 44433407,
 44237054,
 -1,
 -64858,
 44315931,
 92296,
 -1,
 44372432,
 92295,
 44565162,
 44241552,
 -1,
 -64855,
 44508219,
 92267,
 -1,
 44571234,
 92284,
 44761773,
 44503477,
 -1,
 -64852,
 44707941,
 92290,
 -1,
 44771504,
 92281,
 -1,
 44704995,
 92287,
 45023935,
 43721031,
 -1,
 45089463,
 44962813,
 -1,
 45154997,
 45028349,
 -1,
 45220531,
 45102210,
 92282,
 -1,
 45154484,
 92283,
 -64844,
 45158840,
 92277,
 -1,
 45286239,
 92298,
 -64842,
 45098003,
 92302,
 -1,
 45423611,
 92276,
 45613754,
 45037843,
 -1,
 -64839,
 45553486,
 92269,
 -1,
 45614090,
 92288,
 45810365,
 45558930,
 -1,
 -64836,
 45750061,
 92247,
 -1,
 45813833,
 92299,
 -64834,
 45756885,
 92260,
 -1,
 45944578,
 92261,
 46138055,
 44969106,
 -1,
 46203587,
 46077485,
 -1,
 -64830,
 46150511,
 92266,
 -1,
 46215278,
 92265,
 -64828,
 46150631,
 92285,
 -64827,
 46340099,
 92249,
 -64826,
 46403982,
 92250,
 -1,
 46466228,
 92279,
 46662352,
 46078725,
 -1,
 46727884,
 46600629,
 -1,
 -64822,
 46676354,
 92272,
 -64821,
 46737552,
 92270,
 -1,
 46793734,
 92294,
 46990031,
 46667581,
 -1,
 -64818,
 46934192,
 92301,
 -1,
 46993360,
 92253,
 -1,
 46925034,
 92256,
 47252181,
 46605965,
 -1,
 -64814,
 47199332,
 92289,
 -64813,
 47258103,
 92263,
 -64812,
 47321057,
 92257,
 -1,
 47384140,
 92274,
 47579867,
 47193173,
 -1,
 47645401,
 47514438,
 -1,
 -64808,
 47587178,
 92259,
 -1,
 47646013,
 92273,
 -64806,
 47588374,
 92251,
 -1,
 47780228,
 92297,
 47973088,
 47525923,
 -1,
 48038623,
 47919946,
 -1,
 -64802,
 47981229,
 92264,
 -1,
 48045978,
 92248,
 -1,
 47973215,
 92280,
 48300771,
 47921427,
 -1,
 -64798,
 48239109,
 92254,
 -1,
 48301180,
 92258,
 48497382,
 48239832,
 -1,
 -64795,
 48444256,
 92262,
 -1,
 48505159,
 92271,
 48693993,
 48435942,
 -1,
 -64792,
 48641449,
 92291,
 -1,
 48697153,
 92293,
 -64790,
 48642246,
 92278,
 -1,
 48838213,
 92275,
 49086463,
 43651730,
 -1,
 49087226,
 48963911,
 -1,
 49152751,
 49034056,
 92697,
 -1,
 49087477,
 92696,
 49283826,
 49093233,
 -1,
 -64783,
 49230684,
 92698,
 -1,
 49284102,
 92688,
 49480437,
 49222653,
 -1,
 -64780,
 49421381,
 92711,
 -1,
 49484806,
 92712,
 -64778,
 49428871,
 92681,
 -64777,
 49623331,
 92704,
 -64776,
 49687956,
 92702,
 -64775,
 49747773,
 92708,
 -1,
 49810697,
 92687,
 50004739,
 49032338,
 -1,
 50070271,
 49943953,
 -1,
 -64771,
 50017096,
 92700,
 -64770,
 50078488,
 92713,
 -1,
 50141324,
 92691,
 -64768,
 50017702,
 92690,
 -64767,
 50272061,
 92692,
 -64766,
 50336307,
 92693,
 -1,
 50398445,
 92727,
 50594572,
 49945349,
 -1,
 50660103,
 50532161,
 -1,
 -64762,
 50606115,
 92695,
 -1,
 50667847,
 92710,
 -64760,
 50608468,
 92694,
 -64759,
 50803528,
 92677,
 -64758,
 50865841,
 92726,
 -64757,
 50930456,
 92719,
 -1,
 50987846,
 92675,
 51184405,
 50538792,
 -1,
 51249937,
 51121985,
 -1,
 -64753,
 51197353,
 92709,
 -64752,
 51257671,
 92721,
 -1,
 51318593,
 92679,
 51512084,
 51189565,
 -1,
 -64749,
 51451709,
 92683,
 -1,
 51515332,
 92684,
 -1,
 51458888,
 92707,
 51774236,
 51126113,
 92689,
 51839769,
 51709698,
 -1,
 -64744,
 51777609,
 92720,
 -1,
 51839836,
 92724,
 -64742,
 51782424,
 92723,
 -64741,
 51974091,
 92685,
 -1,
 52036422,
 92722,
 52232993,
 51720227,
 -1,
 52298528,
 52167494,
 -1,
 -64737,
 52236097,
 92680,
 -1,
 52298566,
 92686,
 -1,
 52236676,
 92725,
 52560678,
 52176525,
 -1,
 52626213,
 52498241,
 -1,
 -64732,
 52573609,
 92703,
 -1,
 52629313,
 92706,
 -1,
 52573020,
 92714,
 52888362,
 52501589,
 -1,
 -64728,
 52831553,
 92718,
 -64727,
 52893501,
 92717,
 -1,
 52953926,
 92682,
 53150509,
 52836627,
 -1,
 -64724,
 53093697,
 92699,
 -1,
 53150534,
 92701,
 53347120,
 53098197,
 -1,
 -64721,
 53294055,
 92705,
 -1,
 53347142,
 92716,
 -64719,
 53294796,
 92728,
 -64718,
 53490504,
 92676,
 -64717,
 53547914,
 92715,
 -1,
 53612484,
 92678,
 53805950,
 143395,
 -1,
 53871483,
 53740707,
 -1,
 53936994,
 53812651,
 -1,
 54002501,
 53882002,
 -1,
 54068035,
 53942449,
 -1,
 -64710,
 54016314,
 7132,
 -64709,
 54081268,
 7116,
 -64708,
 54144214,
 7129,
 -64707,
 54208854,
 7123,
 -64706,
 54273713,
 7112,
 -64705,
 54337407,
 7125,
 -64704,
 54402166,
 7135,
 -64703,
 54465951,
 7107,
 -64702,
 54531078,
 7119,
 -1,
 54592326,
 7105,
 -64700,
 54011488,
 7126,
 -1,
 54723398,
 7128,
 54920011,
 53944647,
 -1,
 -64697,
 54868282,
 7136,
 -64696,
 54928791,
 7127,
 -64695,
 54989830,
 7133,
 -64694,
 55053563,
 7138,
 -1,
 55116614,
 7113,
 55313234,
 54861665,
 -1,
 55378769,
 55247686,
 7124,
 55508991,
 55321002,
 -1,
 -64689,
 55389398,
 7130,
 -64688,
 55452022,
 7114,
 -1,
 55514527,
 7108,
 -1,
 55314183,
 7139,
 55771988,
 55256753,
 7111,
 -1,
 55712803,
 7117,
 -64683,
 55720250,
 7131,
 -64682,
 55850740,
 7115,
 -64681,
 55915336,
 7141,
 -64680,
 55978326,
 7122,
 -64679,
 56040566,
 7134,
 -64678,
 56105854,
 7110,
 -64677,
 56171123,
 7120,
 -64676,
 56235837,
 7140,
 -64675,
 56300959,
 7106,
 -64674,
 56366086,
 7118,
 -64673,
 56429819,
 7121,
 -64672,
 56494315,
 7137,
 -64671,
 56559367,
 7109,
 -1,
 56623942,
 7104,
 56820589,
 53884605,
 -1,
 56886117,
 56767304,
 7150,
 -1,
 56819852,
 7151,
 57017192,
 56826744,
 -1,
 -64665,
 56959768,
 7149,
 -1,
 57022269,
 7147,
 57213802,
 56954689,
 7143,
 -1,
 57151297,
 7145,
 -64661,
 57157318,
 7144,
 -64660,
 57287448,
 7148,
 -1,
 57349949,
 7146,
 57541493,
 56765586,
 -1,
 57607028,
 57489830,
 -1,
 57672562,
 57550477,
 -1,
 -64655,
 57612489,
 7165,
 -1,
 57673110,
 7167,
 -64653,
 57614713,
 7164,
 -1,
 57809663,
 7166,
 -1,
 57546879,
 7142,
 58065784,
 57485007,
 -1,
 -64649,
 58008773,
 7155,
 -1,
 58070341,
 7154,
 58327039,
 58002353,
 -1,
 -64646,
 58204645,
 7152,
 -1,
 58267025,
 7153,
 58459005,
 53810577,
 128704,
 -1,
 58405636,
 128705,
 -1,
 58405183,
 128267,
 58655622,
 53748039,
 -1,
 58721157,
 58596101,
 127974,
 58851327,
 58663560,
 -1,
 -64638,
 58734969,
 128180,
 -64637,
 58796025,
 128183,
 -64636,
 58855959,
 128182,
 -1,
 58920435,
 128181,
 -1,
 58656057,
 127820,
 59179916,
 58591441,
 128118,
 59310079,
 59113472,
 -1,
 -64631,
 59191284,
 128700,
 -64630,
 59247250,
 128036,
 -64629,
 59312209,
 127868,
 -1,
 59377014,
 128124,
 59573137,
 59115732,
 -1,
 59638672,
 59513605,
 -1,
 -64625,
 59584239,
 983056,
 -1,
 59638371,
 128281,
 -1,
 59585179,
 128043,
 59900820,
 59517224,
 -1,
 -64621,
 59836279,
 128136,
 -1,
 59899997,
 128202,
 -64619,
 59846202,
 127936,
 -64618,
 60038835,
 127880,
 -1,
 60101798,
 128708,
 60294197,
 76072,
 -1,
 60359724,
 60228753,
 -1,
 60425181,
 60300715,
 -1,
 60490657,
 60372396,
 -1,
 60556192,
 60433229,
 -1,
 60621726,
 60500264,
 69643,
 -1,
 60565800,
 69644,
 60817407,
 60562517,
 69645,
 -1,
 60693589,
 69646,
 -1,
 60490566,
 69679,
 60949415,
 60436515,
 -1,
 61014949,
 60895267,
 -1,
 -64604,
 60954015,
 69662,
 -1,
 61014854,
 69661,
 -64602,
 60954015,
 69667,
 -1,
 61145926,
 69666,
 61342636,
 60891928,
 69649,
 61472767,
 61283598,
 -1,
 -64598,
 61353014,
 69686,
 -64597,
 61416036,
 69687,
 -1,
 61480622,
 69685,
 61670321,
 61284679,
 -1,
 -64594,
 61618490,
 69660,
 -64593,
 61677942,
 69665,
 -64592,
 61740038,
 69655,
 -1,
 61801286,
 69670,
 61998007,
 61607127,
 -1,
 62063541,
 61934807,
 -1,
 -64588,
 62002591,
 69664,
 -1,
 62063430,
 69663,
 -64586,
 62002591,
 69669,
 -1,
 62194502,
 69668,
 62391227,
 61932358,
 69637,
 -64583,
 62337864,
 69650,
 -64582,
 62396221,
 69648,
 -1,
 62456646,
 69638,
 62653375,
 62336146,
 -1,
 -64579,
 62598358,
 69681,
 -64578,
 62657951,
 69680,
 -1,
 62718790,
 69682,
 62915521,
 62600008,
 69641,
 -1,
 62862152,
 69642,
 63046596,
 62858893,
 -1,
 -64573,
 62985631,
 69672,
 -1,
 63046470,
 69671,
 63243207,
 62987349,
 -1,
 -64570,
 63183990,
 69684,
 -1,
 63243078,
 69678,
 63439818,
 63183621,
 -1,
 -64567,
 63378847,
 69652,
 -1,
 63439686,
 69651,
 63636429,
 63380081,
 -1,
 -64564,
 63575455,
 69659,
 -1,
 63636294,
 69658,
 63833039,
 63575869,
 69639,
 -1,
 63772477,
 69640,
 63964114,
 63771645,
 -1,
 -64559,
 63903135,
 69654,
 -1,
 63963974,
 69653,
 64160725,
 63899860,
 -1,
 -64556,
 64099743,
 69657,
 -1,
 64160582,
 69656,
 64357336,
 64096002,
 -1,
 -64553,
 64296351,
 69674,
 -1,
 64357190,
 69673,
 -64551,
 64305466,
 69676,
 -64550,
 64498006,
 69677,
 -64549,
 64561023,
 69675,
 -64548,
 64624031,
 69683,
 -1,
 64687937,
 69647,
 64881658,
 60367602,
 -1,
 64947174,
 64827427,
 -1,
 65012706,
 64894677,
 -1,
 -64543,
 64955160,
 69715,
 -1,
 65015985,
 69724,
 65209317,
 64951697,
 -1,
 -64540,
 65153661,
 69716,
 -1,
 65214916,
 69725,
 -1,
 65146953,
 69723,
 65471467,
 64892050,
 -1,
 65537001,
 65411658,
 69719,
 -1,
 65483573,
 69728,
 65732607,
 65475127,
 69720,
 -1,
 65614645,
 69729,
 65799154,
 65409680,
 -1,
 65864687,
 65741592,
 -1,
 -64530,
 65811749,
 69717,
 -1,
 65875066,
 69726,
 66125823,
 65804093,
 -1,
 -64527,
 66008520,
 69718,
 -1,
 66065397,
 69727,
 66257910,
 65741957,
 69714,
 66387967,
 66191360,
 -1,
 -64523,
 66269589,
 69733,
 -1,
 66328370,
 69732,
 66520056,
 66200058,
 69722,
 -1,
 66466613,
 69731,
 66715647,
 66457605,
 69721,
 -1,
 66599187,
 69730,
 66782221,
 64828844,
 -1,
 66847756,
 66725506,
 -1,
 66913281,
 66795140,
 -1,
 66978815,
 66857256,
 69694,
 -1,
 66922792,
 69695,
 67174399,
 66919509,
 69696,
 -1,
 67050581,
 69697,
 67240965,
 66847558,
 -1,
 -64509,
 67187528,
 69701,
 -64508,
 67245885,
 69699,
 -1,
 67306310,
 69688,
 67503111,
 67187528,
 69692,
 -1,
 67449672,
 69693,
 67634185,
 67442493,
 69690,
 -1,
 67573565,
 69691,
 -64502,
 67576600,
 69700,
 -64501,
 67702593,
 69698,
 -1,
 67766178,
 69689,
 -1,
 66787759,
 69702,
 68027422,
 66718935,
 -1,
 68092956,
 67967059,
 -1,
 68158482,
 68038691,
 -1,
 -64495,
 68106346,
 69736,
 -1,
 68163342,
 69737,
 68355093,
 68103314,
 -1,
 -64492,
 68295242,
 69740,
 -1,
 68358711,
 69741,
 68551704,
 68293264,
 -1,
 -64489,
 68494906,
 69738,
 -1,
 68557349,
 69739,
 -64487,
 68499972,
 69734,
 -64486,
 68691077,
 69735,
 -64485,
 68755962,
 69743,
 -1,
 68816901,
 69742,
 -64483,
 68036082,
 69704,
 -1,
 68945255,
 69703,
 69141540,
 67972580,
 -1,
 -64480,
 69088876,
 69634,
 -64479,
 69154030,
 69636,
 -64478,
 69212862,
 69635,
 -64477,
 69273902,
 69632,
 -1,
 69338561,
 69633,
 69599231,
 69085296,
 -1,
 69600296,
 69475413,
 -1,
 -64473,
 69543405,
 69709,
 -1,
 69605628,
 69707,
 69796907,
 69537264,
 -1,
 -64470,
 69743498,
 69706,
 -1,
 69808163,
 69705,
 -1,
 69733420,
 69708,
 70059057,
 60299069,
 -1,
 70124592,
 69995735,
 -1,
 -64465,
 70063194,
 127753,
 -1,
 70127453,
 128112,
 -1,
 70062059,
 128188,
 70386740,
 69996397,
 -1,
 -64461,
 70327081,
 983124,
 -1,
 70388951,
 127838,
 -1,
 70329298,
 128148,
 70648903,
 60234837,
 -1,
 70714433,
 70583242,
 -1,
 70779963,
 70658907,
 -1,
 70845498,
 70717021,
 9193,
 -1,
 70779559,
 9197,
 -1,
 70791847,
 9199,
 71042109,
 70720895,
 9194,
 -1,
 70976167,
 9198,
 -64450,
 70989010,
 9195,
 -64449,
 71118614,
 128306,
 -64448,
 71182605,
 10067,
 -1,
 71241369,
 9196,
 71435332,
 70661098,
 -1,
 -64445,
 71374392,
 128153,
 -1,
 71436358,
 128216,
 71696383,
 71377688,
 -1,
 -64442,
 71579486,
 128033,
 -1,
 71642942,
 127804,
 71828566,
 70591256,
 -1,
 71894092,
 71772122,
 -1,
 -64438,
 71842316,
 12730,
 -64437,
 71900693,
 12729,
 -1,
 71963841,
 12728,
 72156240,
 71836623,
 -1,
 72221775,
 72097758,
 128278,
 -1,
 72155514,
 128209,
 -1,
 72166546,
 128218,
 72418386,
 72097633,
 983246,
 -1,
 72353538,
 128163,
 -64429,
 72366355,
 128102,
 -64428,
 72497209,
 127923,
 -64427,
 72561951,
 128144,
 -1,
 72615413,
 128023,
 72811617,
 71765825,
 -1,
 72877146,
 72752213,
 983055,
 73007103,
 72817749,
 128276,
 -1,
 72876458,
 128277,
 73073757,
 72819015,
 -1,
 -64420,
 73019931,
 127857,
 -1,
 73077777,
 983621,
 73270368,
 73007942,
 -1,
 -64417,
 73216517,
 128147,
 -1,
 73279786,
 128059,
 -1,
 73208026,
 127866,
 73532522,
 72750909,
 -1,
 73598053,
 73476392,
 -1,
 -64412,
 73544034,
 127874,
 -1,
 73600215,
 128038,
 73794664,
 73534657,
 -1,
 -64409,
 73734619,
 128692,
 -1,
 73797441,
 128690,
 -64407,
 73735824,
 127921,
 -1,
 73931792,
 128089,
 74122353,
 73478984,
 -1,
 74187888,
 74067090,
 128652,
 74253423,
 74133539,
 -1,
 -64402,
 74198167,
 128101,
 -1,
 74252453,
 128100,
 -1,
 74187124,
 128655,
 -1,
 74126333,
 128027,
 74581108,
 74070291,
 -1,
 -64397,
 74529233,
 983248,
 -1,
 74592499,
 983245,
 -64395,
 74525842,
 983057,
 -1,
 74721070,
 983125,
 74909310,
 12323,
 -1,
 74974762,
 74842950,
 -1,
 75040204,
 74916057,
 -1,
 75105715,
 74985425,
 -1,
 75171003,
 75047239,
 -1,
 75236501,
 75112775,
 -1,
 75302025,
 75178311,
 -1,
 75367553,
 75236166,
 -1,
 -64385,
 75313992,
 983843,
 -64384,
 75372349,
 983840,
 -1,
 75432774,
 983833,
 75629699,
 75313992,
 983836,
 -1,
 75576136,
 983837,
 75760773,
 75571992,
 983841,
 -1,
 75703064,
 983842,
 75891847,
 75700029,
 983834,
 -1,
 75831101,
 983835,
 76087295,
 75829057,
 983838,
 -1,
 75960129,
 983839,
 76153997,
 75236166,
 -1,
 -64373,
 76100424,
 983711,
 -64372,
 76158781,
 983708,
 -1,
 76219206,
 983701,
 76416143,
 76100424,
 983704,
 -1,
 76362568,
 983705,
 76547217,
 76358424,
 983709,
 -1,
 76489496,
 983710,
 76678291,
 76486461,
 983702,
 -1,
 76617533,
 983703,
 76873727,
 76615489,
 983706,
 -1,
 76746561,
 983707,
 76940450,
 75184403,
 -1,
 77005978,
 76874566,
 -1,
 -64360,
 76952392,
 983689,
 -64359,
 77010749,
 983686,
 -1,
 77071174,
 983679,
 77268124,
 76952392,
 983682,
 -1,
 77214536,
 983683,
 77399198,
 77210392,
 983687,
 -1,
 77341464,
 983688,
 77530272,
 77338429,
 983680,
 -1,
 77469501,
 983681,
 77725695,
 77467457,
 983684,
 -1,
 77598529,
 983685,
 77792431,
 76878845,
 -1,
 77857959,
 77726534,
 -1,
 -64347,
 77804360,
 983667,
 -64346,
 77862717,
 983664,
 -1,
 77923142,
 983657,
 78120105,
 77804360,
 983660,
 -1,
 78066504,
 983661,
 78251179,
 78062360,
 983665,
 -1,
 78193432,
 983666,
 78382253,
 78190397,
 983658,
 -1,
 78321469,
 983659,
 78577663,
 78319425,
 983662,
 -1,
 78450497,
 983663,
 78644403,
 77726534,
 -1,
 -64335,
 78590792,
 983733,
 -64334,
 78649149,
 983730,
 -1,
 78709574,
 983723,
 78906549,
 78590792,
 983726,
 -1,
 78852936,
 983727,
 79037623,
 78848792,
 983731,
 -1,
 78979864,
 983732,
 79168697,
 78976829,
 983724,
 -1,
 79107901,
 983725,
 79364095,
 79105857,
 983728,
 -1,
 79236929,
 983729,
 79430883,
 75115666,
 -1,
 79496394,
 79369617,
 -1,
 79561921,
 79430470,
 -1,
 -64321,
 79508296,
 983865,
 -64320,
 79566653,
 983862,
 -1,
 79627078,
 983855,
 79824067,
 79508296,
 983858,
 -1,
 79770440,
 983859,
 79955141,
 79766296,
 983863,
 -1,
 79897368,
 983864,
 80086215,
 79894333,
 983856,
 -1,
 80025405,
 983857,
 80217289,
 80023361,
 983860,
 -1,
 80154433,
 983861,
 -1,
 80161687,
 983911,
 80413911,
 79441042,
 -1,
 80479439,
 80347974,
 -1,
 -64307,
 80425800,
 983876,
 -64306,
 80484157,
 983873,
 -1,
 80544582,
 983866,
 80741585,
 80425800,
 983869,
 -1,
 80687944,
 983870,
 80872659,
 80683800,
 983874,
 -1,
 80814872,
 983875,
 81003733,
 80811837,
 983867,
 -1,
 80942909,
 983868,
 81199103,
 80940865,
 983871,
 -1,
 81071937,
 983872,
 81265883,
 80347974,
 -1,
 -64295,
 81212232,
 983887,
 -64294,
 81270589,
 983884,
 -1,
 81331014,
 983877,
 81528029,
 81212232,
 983880,
 -1,
 81474376,
 983881,
 81659103,
 81470232,
 983885,
 -1,
 81601304,
 983886,
 81790177,
 81598269,
 983878,
 -1,
 81729341,
 983879,
 81985535,
 81727297,
 983882,
 -1,
 81858369,
 983883,
 82052362,
 79371349,
 -1,
 82117886,
 81992789,
 -1,
 82183410,
 82058325,
 -1,
 82248938,
 82117446,
 -1,
 -64280,
 82195272,
 983810,
 -64279,
 82253629,
 983807,
 -1,
 82314054,
 983800,
 82511084,
 82195272,
 983803,
 -1,
 82457416,
 983804,
 82642158,
 82453272,
 983808,
 -1,
 82584344,
 983809,
 82773232,
 82581309,
 983801,
 -1,
 82712381,
 983802,
 82968575,
 82710337,
 983805,
 -1,
 82841409,
 983806,
 83035382,
 82117446,
 -1,
 -64268,
 82981704,
 983821,
 -64267,
 83040061,
 983818,
 -1,
 83100486,
 983811,
 83297528,
 82981704,
 983814,
 -1,
 83243848,
 983815,
 83428602,
 83239704,
 983819,
 -1,
 83370776,
 983820,
 83559676,
 83367741,
 983812,
 -1,
 83498813,
 983813,
 83755007,
 83496769,
 983816,
 -1,
 83627841,
 983817,
 83821826,
 82051910,
 -1,
 -64256,
 83768136,
 983788,
 -64255,
 83826493,
 983785,
 -1,
 83886918,
 983778,
 84083972,
 83768136,
 983781,
 -1,
 84030280,
 983782,
 84215046,
 84026136,
 983786,
 -1,
 84157208,
 983787,
 84346120,
 84154173,
 983779,
 -1,
 84285245,
 983780,
 84541439,
 84283201,
 983783,
 -1,
 84414273,
 983784,
 84608292,
 81992453,
 -1,
 84673816,
 84553517,
 -1,
 84739344,
 84607814,
 983899,
 -64242,
 84685640,
 983910,
 -64241,
 84743997,
 983907,
 -1,
 84804422,
 983900,
 85001490,
 84685640,
 983903,
 -1,
 84947784,
 983904,
 85132564,
 84943640,
 983908,
 -1,
 85074712,
 983909,
 85263638,
 85071677,
 983901,
 -1,
 85202749,
 983902,
 85458943,
 85200705,
 983905,
 -1,
 85331777,
 983906,
 85525788,
 84607814,
 -1,
 -64230,
 85472072,
 983656,
 -64229,
 85530429,
 983653,
 -1,
 85590854,
 983646,
 85787934,
 85472072,
 983649,
 -1,
 85734216,
 983650,
 85919008,
 85730072,
 983654,
 -1,
 85861144,
 983655,
 86050082,
 85858109,
 983647,
 -1,
 85989181,
 983648,
 86245375,
 85987137,
 983651,
 -1,
 86118209,
 983652,
 86312254,
 84553763,
 -1,
 86377778,
 86257699,
 -1,
 86443306,
 86311750,
 -1,
 -64216,
 86389576,
 983700,
 -64215,
 86447933,
 983697,
 -1,
 86508358,
 983690,
 86705452,
 86389576,
 983693,
 -1,
 86651720,
 983694,
 86836526,
 86647576,
 983698,
 -1,
 86778648,
 983699,
 86967600,
 86775613,
 983691,
 -1,
 86906685,
 983692,
 87162879,
 86904641,
 983695,
 -1,
 87035713,
 983696,
 87229750,
 86311750,
 -1,
 -64204,
 87176008,
 983722,
 -64203,
 87234365,
 983719,
 -1,
 87294790,
 983712,
 87491896,
 87176008,
 983715,
 -1,
 87438152,
 983716,
 87622970,
 87434008,
 983720,
 -1,
 87565080,
 983721,
 87754044,
 87562045,
 983713,
 -1,
 87693117,
 983714,
 87949311,
 87691073,
 983717,
 -1,
 87822145,
 983718,
 88016216,
 86255912,
 -1,
 88081740,
 87959848,
 -1,
 88147268,
 88015686,
 -1,
 -64190,
 88093512,
 983832,
 -64189,
 88151869,
 983829,
 -1,
 88212294,
 983822,
 88409414,
 88093512,
 983825,
 -1,
 88355656,
 983826,
 88540488,
 88351512,
 983830,
 -1,
 88482584,
 983831,
 88671562,
 88479549,
 983823,
 -1,
 88610621,
 983824,
 88866815,
 88608577,
 983827,
 -1,
 88739649,
 983828,
 88933712,
 88015686,
 -1,
 -64178,
 88879944,
 983777,
 -64177,
 88938301,
 983774,
 -1,
 88998726,
 983767,
 89195858,
 88879944,
 983770,
 -1,
 89142088,
 983771,
 89326932,
 89137944,
 983775,
 -1,
 89269016,
 983776,
 89458006,
 89265981,
 983768,
 -1,
 89397053,
 983769,
 89653247,
 89395009,
 983772,
 -1,
 89526081,
 983773,
 89720165,
 87963923,
 -1,
 89785693,
 89654086,
 -1,
 -64165,
 89731912,
 983766,
 -64164,
 89790269,
 983763,
 -1,
 89850694,
 983756,
 90047839,
 89731912,
 983759,
 -1,
 89994056,
 983760,
 90178913,
 89989912,
 983764,
 -1,
 90120984,
 983765,
 90309987,
 90117949,
 983757,
 -1,
 90249021,
 983758,
 90505215,
 90246977,
 983761,
 -1,
 90378049,
 983762,
 90572146,
 89666988,
 -1,
 90637674,
 90506054,
 -1,
 -64152,
 90583880,
 983799,
 -64151,
 90642237,
 983796,
 -1,
 90702662,
 983789,
 90899820,
 90583880,
 983792,
 -1,
 90846024,
 983793,
 91030894,
 90841880,
 983797,
 -1,
 90972952,
 983798,
 91161968,
 90969917,
 983790,
 -1,
 91100989,
 983791,
 91357183,
 91098945,
 983794,
 -1,
 91230017,
 983795,
 91424127,
 90515085,
 -1,
 91489655,
 91358022,
 -1,
 -64139,
 91435848,
 983744,
 -64138,
 91494205,
 983741,
 -1,
 91554630,
 983734,
 91751801,
 91435848,
 983737,
 -1,
 91697992,
 983738,
 91882875,
 91693848,
 983742,
 -1,
 91824920,
 983743,
 92013949,
 91821885,
 983735,
 -1,
 91952957,
 983736,
 92209151,
 91950913,
 983739,
 -1,
 92081985,
 983740,
 92276108,
 91365217,
 -1,
 92341636,
 92209990,
 -1,
 -64126,
 92287816,
 983755,
 -64125,
 92346173,
 983752,
 -1,
 92406598,
 983745,
 92603782,
 92287816,
 983748,
 -1,
 92549960,
 983749,
 92734856,
 92545816,
 983753,
 -1,
 92676888,
 983754,
 92865930,
 92673853,
 983746,
 -1,
 92804925,
 983747,
 93061119,
 92802881,
 983750,
 -1,
 92933953,
 983751,
 93128089,
 92215921,
 -1,
 93193617,
 93061958,
 -1,
 -64113,
 93139784,
 983854,
 -64112,
 93198141,
 983851,
 -1,
 93258566,
 983844,
 93455763,
 93139784,
 983847,
 -1,
 93401928,
 983848,
 93586837,
 93397784,
 983852,
 -1,
 93528856,
 983853,
 93717911,
 93525821,
 983845,
 -1,
 93656893,
 983846,
 93913087,
 93654849,
 983849,
 -1,
 93785921,
 983850,
 93980070,
 93066641,
 -1,
 94045598,
 93913926,
 -1,
 -64100,
 93991752,
 983898,
 -64099,
 94050109,
 983895,
 -1,
 94110534,
 983888,
 94307744,
 93991752,
 983891,
 -1,
 94253896,
 983892,
 94438818,
 94249752,
 983896,
 -1,
 94380824,
 983897,
 94569892,
 94377789,
 983889,
 -1,
 94508861,
 983890,
 94765055,
 94506817,
 983893,
 -1,
 94637889,
 983894,
 94896127,
 93915348,
 -1,
 94897579,
 94765894,
 -1,
 -64087,
 94843720,
 983678,
 -64086,
 94902077,
 983675,
 -1,
 94962502,
 983668,
 95159725,
 94843720,
 983671,
 -1,
 95105864,
 983672,
 95290799,
 95101720,
 983676,
 -1,
 95232792,
 983677,
 95421873,
 95229757,
 983669,
 -1,
 95360829,
 983670,
 95617023,
 95358785,
 983673,
 -1,
 95489857,
 983674,
 95748095,
 75041685,
 -1,
 95749561,
 95625543,
 983629,
 95815095,
 95691079,
 983627,
 -1,
 95756615,
 983639,
 -64072,
 95762707,
 983625,
 -1,
 95884285,
 983623,
 96077244,
 95693970,
 983643,
 -64069,
 96021650,
 983642,
 -1,
 96081297,
 983641,
 96273855,
 96017493,
 983634,
 96403455,
 96214101,
 983637,
 -1,
 96279637,
 983636,
 96470465,
 96219171,
 983628,
 -1,
 96415779,
 983626,
 96601539,
 96413992,
 983633,
 -1,
 96545064,
 983638,
 96732613,
 96541445,
 983622,
 -1,
 96677677,
 983645,
 -64058,
 96680211,
 983632,
 -64057,
 96810412,
 983635,
 -64056,
 96872077,
 983630,
 -64055,
 96935777,
 983631,
 -64054,
 97000049,
 983640,
 -64053,
 97064337,
 983644,
 -1,
 97126612,
 983624,
 97322533,
 74980412,
 -1,
 97388038,
 97263019,
 -1,
 97453524,
 97333283,
 -1,
 97519058,
 97398819,
 -1,
 -64047,
 97457567,
 71317,
 -1,
 97518406,
 71316,
 -64045,
 97457567,
 71322,
 -1,
 97649478,
 71321,
 97846745,
 97395015,
 -1,
 -64042,
 97794362,
 71315,
 -64041,
 97853814,
 71320,
 -64040,
 97915910,
 71310,
 -1,
 97977158,
 71325,
 98174431,
 97782999,
 -1,
 98239965,
 98110679,
 -1,
 -64036,
 98178463,
 71319,
 -1,
 98239302,
 71318,
 -64034,
 98178463,
 71324,
 -1,
 98370374,
 71323,
 98567651,
 98108230,
 71296,
 -64031,
 98513736,
 71305,
 -64030,
 98572093,
 71303,
 -1,
 98632518,
 71297,
 98829797,
 98513736,
 71300,
 -1,
 98775880,
 71301,
 98960872,
 98774162,
 -1,
 -64025,
 98899359,
 71335,
 -1,
 98960198,
 71336,
 99157483,
 98904360,
 -1,
 -64022,
 99101014,
 71338,
 -1,
 99156806,
 71332,
 99354094,
 99100301,
 -1,
 -64019,
 99292575,
 71327,
 -1,
 99353414,
 71326,
 99550705,
 99293957,
 -1,
 -64016,
 99489183,
 71307,
 -1,
 99550022,
 71306,
 99747316,
 99490417,
 -1,
 -64013,
 99685791,
 71314,
 -1,
 99746630,
 71313,
 99943926,
 99686205,
 71298,
 -1,
 99882813,
 71299,
 100075001,
 99881981,
 -1,
 -64008,
 100013471,
 71309,
 -1,
 100074310,
 71308,
 100271612,
 100010196,
 -1,
 -64005,
 100210079,
 71312,
 -1,
 100270918,
 71311,
 100468223,
 100206338,
 -1,
 -64002,
 100406687,
 71329,
 -1,
 100467526,
 71328,
 -64000,
 100415802,
 71331,
 -63999,
 100611502,
 71334,
 -63998,
 100672280,
 71304,
 -63997,
 100736895,
 71330,
 -63996,
 100801654,
 71333,
 -63995,
 100865439,
 71337,
 -1,
 100929345,
 71302,
 101123604,
 97324482,
 -1,
 101189130,
 101068835,
 -1,
 -63991,
 101136490,
 71362,
 -1,
 101193486,
 71363,
 101385741,
 101133458,
 -1,
 -63988,
 101325386,
 71366,
 -1,
 101388855,
 71367,
 101582352,
 101323408,
 -1,
 -63985,
 101525050,
 71364,
 -1,
 101587493,
 71365,
 -63983,
 101530116,
 71360,
 -63982,
 101721221,
 71361,
 -63981,
 101786106,
 71369,
 -1,
 101847045,
 71368,
 102041119,
 101070525,
 -1,
 102106649,
 101974854,
 -1,
 -63977,
 102052680,
 71349,
 -63976,
 102111037,
 71347,
 -1,
 102171462,
 71341,
 102368795,
 102052680,
 71344,
 -1,
 102314824,
 71345,
 102499869,
 102307645,
 71342,
 -1,
 102438717,
 71343,
 -63970,
 102441752,
 71348,
 -1,
 102567745,
 71346,
 102825983,
 101985764,
 -1,
 102827555,
 102708815,
 -1,
 -63966,
 102771976,
 71340,
 -1,
 102836688,
 71350,
 -63964,
 102769388,
 71351,
 -1,
 102958529,
 71339,
 103155240,
 97263943,
 -1,
 -63961,
 103093407,
 127818,
 -1,
 103154553,
 127883,
 -63959,
 103102714,
 128661,
 -1,
 103286530,
 983061,
 103482945,
 74913597,
 -1,
 103548470,
 103417736,
 -1,
 103614002,
 103492754,
 -1,
 103679537,
 103560059,
 -1,
 -63953,
 103620630,
 3982,
 -63952,
 103685378,
 3981,
 -1,
 103750021,
 3983,
 -1,
 103618654,
 3980,
 104071167,
 103555043,
 -1,
 -63948,
 103952984,
 4058,
 -63947,
 104013108,
 4057,
 -1,
 104073186,
 983206,
 104269372,
 103486266,
 -1,
 104334906,
 104209873,
 -1,
 -63943,
 104276760,
 11623,
 -1,
 104337217,
 11622,
 -63941,
 104279393,
 11632,
 -1,
 104467360,
 11647,
 104662590,
 104207515,
 128005,
 -1,
 104595583,
 128047,
 -63937,
 104606311,
 128555,
 -63936,
 104734897,
 9202,
 -1,
 104794890,
 127915,
 104990292,
 103426344,
 -1,
 105055817,
 104932120,
 -1,
 105121352,
 104998541,
 -1,
 105186887,
 105060233,
 -1,
 -63930,
 105124691,
 128032,
 -1,
 105189116,
 127865,
 -1,
 105125690,
 127942,
 -1,
 105062024,
 128654,
 105514574,
 104989510,
 -1,
 105580108,
 105455457,
 128650,
 -1,
 105513037,
 128651,
 -63923,
 105519302,
 128646,
 -1,
 105647213,
 128668,
 105842259,
 105453373,
 -1,
 105907794,
 105776547,
 -1,
 -63919,
 105852033,
 128208,
 -1,
 105911133,
 128681,
 -1,
 105844067,
 128305,
 -1,
 105788487,
 127930,
 106235486,
 104932120,
 -1,
 106301018,
 106178191,
 -1,
 106366553,
 106239391,
 -1,
 -63912,
 106311715,
 127913,
 -1,
 106372608,
 11833,
 -1,
 106313749,
 128285,
 -63909,
 106242536,
 128069,
 -63908,
 106569732,
 127813,
 -63907,
 106634315,
 128508,
 -1,
 106698918,
 128701,
 106890855,
 106172225,
 -1,
 106956387,
 106831149,
 -1,
 -63903,
 106903156,
 128250,
 -63902,
 106966300,
 128301,
 -1,
 107030333,
 128222,
 107218534,
 106890054,
 -1,
 -63899,
 107161927,
 128198,
 -1,
 107220114,
 127861,
 -1,
 107160142,
 127934,
 107480687,
 106837717,
 -1,
 107546222,
 107422488,
 -1,
 107611757,
 107479040,
 -1,
 -63893,
 107559043,
 128109,
 -63892,
 107618442,
 128108,
 -1,
 107681360,
 128149,
 -1,
 107545310,
 11834,
 -1,
 107485663,
 128256,
 108004983,
 107426632,
 -1,
 108070518,
 107948328,
 -1,
 108136053,
 108011985,
 -1,
 -63885,
 108080450,
 11829,
 -63884,
 108137745,
 11832,
 -1,
 108202895,
 11826,
 -1,
 108081680,
 128034,
 -1,
 108011109,
 127799,
 108529277,
 107943313,
 -1,
 108594811,
 108475457,
 -1,
 -63878,
 108541105,
 128077,
 -1,
 108596879,
 128078,
 -63876,
 108538497,
 11835,
 -1,
 108733978,
 128173,
 -1,
 108462860,
 128085,
 108988500,
 74842950,
 -1,
 109053843,
 108931368,
 -1,
 109119375,
 108987286,
 -1,
 109184828,
 109060086,
 -1,
 109250219,
 109120727,
 -1,
 109315752,
 109191960,
 -1,
 109381283,
 109261739,
 -1,
 109446795,
 109326371,
 -1,
 109512329,
 109385105,
 -1,
 -63864,
 109449202,
 126646,
 -1,
 109511867,
 126648,
 -63862,
 109449202,
 126645,
 -1,
 109642894,
 126632,
 109840015,
 109390994,
 -1,
 -63859,
 109778548,
 126644,
 -63858,
 109842388,
 126638,
 -1,
 109904882,
 126641,
 110102162,
 109787579,
 -1,
 -63855,
 110041286,
 126630,
 -1,
 110106001,
 126650,
 110298773,
 110038267,
 -1,
 -63852,
 110238805,
 126627,
 -1,
 110300375,
 126649,
 -63850,
 110246232,
 126633,
 -63849,
 110442267,
 126629,
 -63848,
 110504616,
 126643,
 -63847,
 110569653,
 126642,
 -63846,
 110633593,
 126637,
 -63845,
 110698569,
 126636,
 -63844,
 110763172,
 126635,
 -63843,
 110828528,
 126647,
 -63842,
 110893728,
 126626,
 -63841,
 110957990,
 126631,
 -63840,
 111023300,
 126651,
 -63839,
 111088366,
 126640,
 -63838,
 111150934,
 126625,
 -1,
 111215767,
 126639,
 111476735,
 109326868,
 -1,
 -63835,
 111356085,
 126495,
 -63834,
 111420025,
 126493,
 -63833,
 111481582,
 126494,
 -1,
 111544150,
 126492,
 111804415,
 109249350,
 -1,
 -63830,
 111680597,
 126467,
 -1,
 111742167,
 126489,
 111937232,
 109190229,
 -1,
 112002767,
 111879407,
 -1,
 112068275,
 111947811,
 -1,
 112133809,
 112006545,
 -1,
 -63824,
 112070642,
 126614,
 -1,
 112133307,
 126616,
 -63822,
 112070642,
 126613,
 -1,
 112264334,
 126600,
 112461495,
 112012434,
 -1,
 -63819,
 112399988,
 126612,
 -63818,
 112463828,
 126606,
 -1,
 112526322,
 126609,
 112723642,
 112409019,
 -1,
 -63815,
 112662726,
 126598,
 -1,
 112727441,
 126618,
 112920253,
 112661905,
 -1,
 -63812,
 112857074,
 126596,
 -1,
 112919694,
 126599,
 113116864,
 112856315,
 -1,
 -63809,
 113056853,
 126595,
 -1,
 113118423,
 126617,
 113313475,
 113050438,
 -1,
 -63806,
 113253715,
 126592,
 -1,
 113318086,
 126607,
 -63804,
 113260888,
 126601,
 -63803,
 113456923,
 126597,
 -63802,
 113519272,
 126611,
 -63801,
 113584309,
 126610,
 -63800,
 113648249,
 126605,
 -63799,
 113713225,
 126604,
 -63798,
 113777828,
 126603,
 -63797,
 113843184,
 126615,
 -63796,
 113908384,
 126594,
 -63795,
 113972420,
 126619,
 -63794,
 114037486,
 126608,
 -1,
 114100054,
 126593,
 -1,
 111936746,
 126475,
 114362098,
 111881362,
 -1,
 114427631,
 114307729,
 -1,
 114493142,
 114372643,
 -1,
 -63788,
 114431609,
 126582,
 -63787,
 114495474,
 126581,
 -1,
 114558094,
 126568,
 114755290,
 114437266,
 -1,
 -63784,
 114693748,
 126580,
 -63783,
 114757588,
 126574,
 -1,
 114820082,
 126577,
 115017439,
 114691287,
 -1,
 115082974,
 114959836,
 -1,
 -63779,
 115020526,
 126590,
 -1,
 115083094,
 126588,
 -1,
 115016690,
 126585,
 115345122,
 114957061,
 -1,
 -63775,
 115283366,
 126583,
 -1,
 115344466,
 126570,
 115541733,
 115283345,
 -1,
 -63772,
 115478514,
 126564,
 -1,
 115541134,
 126567,
 -63770,
 115489214,
 126586,
 -63769,
 115685720,
 126569,
 -63768,
 115746997,
 126578,
 -63767,
 115810937,
 126573,
 -63766,
 115875913,
 126572,
 -63765,
 115940000,
 126562,
 -63764,
 116004036,
 126587,
 -63763,
 116069102,
 126576,
 -63762,
 116131670,
 126561,
 -1,
 116196503,
 126575,
 -63760,
 114366068,
 126484,
 -63759,
 116330452,
 126478,
 -1,
 116392946,
 126481,
 116590347,
 114301295,
 -1,
 116655863,
 116534418,
 -1,
 -63755,
 116594292,
 126516,
 -63754,
 116658132,
 126510,
 -1,
 116720626,
 126513,
 116918010,
 116600867,
 -1,
 -63751,
 116856441,
 126518,
 -1,
 116920306,
 126517,
 117114621,
 116857605,
 -1,
 -63748,
 117052838,
 126519,
 -1,
 117113938,
 126506,
 117311232,
 117052817,
 -1,
 -63745,
 117247986,
 126500,
 -1,
 117310606,
 126503,
 -63743,
 117258584,
 126505,
 -63742,
 117450933,
 126514,
 -63741,
 117514873,
 126509,
 -63740,
 117579849,
 126508,
 -63739,
 117644452,
 126507,
 -63738,
 117709472,
 126498,
 -63737,
 117773508,
 126523,
 -63736,
 117838574,
 126512,
 -63735,
 117902605,
 126521,
 -63734,
 117966678,
 126497,
 -1,
 118031511,
 126511,
 118228773,
 116535331,
 -1,
 118294305,
 118162246,
 -1,
 118359840,
 118233248,
 -1,
 118425362,
 118303890,
 -1,
 -63728,
 118363764,
 126548,
 -63727,
 118427604,
 126542,
 -1,
 118490098,
 126545,
 118687511,
 118361303,
 -1,
 118753046,
 118629852,
 -1,
 -63723,
 118696117,
 126559,
 -1,
 118760057,
 126557,
 -1,
 118686706,
 126553,
 -63720,
 118634840,
 126537,
 -63719,
 118958261,
 126546,
 -63718,
 119022201,
 126541,
 -63717,
 119086244,
 126539,
 -63716,
 119151600,
 126551,
 -63715,
 119216800,
 126530,
 -63714,
 119281062,
 126535,
 -63713,
 119346372,
 126555,
 -1,
 119407767,
 126543,
 -1,
 118298001,
 126472,
 119670564,
 118232465,
 -1,
 -63709,
 119607282,
 126486,
 -1,
 119669947,
 126488,
 -1,
 119607282,
 126485,
 119932712,
 118176187,
 -1,
 -63705,
 119871686,
 126470,
 -1,
 119936401,
 126490,
 120129323,
 119874856,
 -1,
 -63702,
 120070222,
 126704,
 -1,
 120133034,
 126705,
 120325934,
 120068869,
 -1,
 -63699,
 120264102,
 126487,
 -1,
 120325202,
 126474,
 120522545,
 120259398,
 -1,
 -63696,
 120462675,
 126464,
 -1,
 120527046,
 126479,
 -63694,
 120469848,
 126473,
 -63693,
 120665883,
 126469,
 -63692,
 120728232,
 126483,
 -63691,
 120793269,
 126482,
 -63690,
 120857209,
 126477,
 -63689,
 120922185,
 126476,
 -63688,
 120986272,
 126466,
 -63687,
 121050534,
 126471,
 -63686,
 121115844,
 126491,
 -63685,
 121180910,
 126480,
 -1,
 121243478,
 126465,
 121440089,
 109128850,
 -1,
 121505623,
 121387423,
 -1,
 121571147,
 121450531,
 -1,
 121636677,
 121518189,
 -1,
 121702211,
 121583147,
 -1,
 -63678,
 121636721,
 64446,
 -1,
 121701294,
 64445,
 -63676,
 121636721,
 64437,
 -1,
 121832366,
 64436,
 122093567,
 121575187,
 -1,
 122095433,
 121972634,
 -1,
 -63672,
 122029937,
 64441,
 -1,
 122094510,
 64440,
 -63670,
 122029937,
 64439,
 -1,
 122225582,
 64438,
 122423120,
 121507312,
 -1,
 122488655,
 122368037,
 -1,
 -63666,
 122423153,
 64435,
 -1,
 122487726,
 64434,
 -1,
 122434451,
 64444,
 122750803,
 122367656,
 -1,
 -63662,
 122685297,
 64449,
 -1,
 122749870,
 64448,
 122947414,
 122688442,
 -1,
 -63659,
 122881905,
 64443,
 -1,
 122946478,
 64442,
 -1,
 122891171,
 64447,
 -63656,
 121446335,
 2291,
 -1,
 123148404,
 1540,
 123340653,
 121380141,
 -1,
 123406186,
 123286261,
 -1,
 123471710,
 123353436,
 -1,
 -63651,
 123409879,
 2216,
 -1,
 123473417,
 2217,
 123668321,
 123414824,
 -1,
 -63648,
 123610047,
 2220,
 -1,
 123670517,
 2218,
 -63646,
 123615007,
 2219,
 -63645,
 123809974,
 2211,
 -63644,
 123873465,
 2213,
 -63643,
 123936873,
 2215,
 -63642,
 124001448,
 2214,
 -63641,
 124066694,
 1568,
 -63640,
 124132005,
 2210,
 -63639,
 124195570,
 2212,
 -1,
 124258138,
 2208,
 124518399,
 123343834,
 -1,
 -63636,
 124389233,
 2297,
 -1,
 124453806,
 2295,
 124651383,
 123286054,
 -1,
 124716913,
 124597035,
 -1,
 -63632,
 124651377,
 2286,
 -1,
 124715950,
 2283,
 124913524,
 124658830,
 -1,
 -63629,
 124847985,
 2285,
 -1,
 124912558,
 2282,
 125173759,
 124853995,
 -1,
 -63626,
 125044593,
 2287,
 -1,
 125109166,
 2284,
 125306750,
 124587173,
 -1,
 125372282,
 125246355,
 2278,
 -1,
 125317341,
 2281,
 125503356,
 125309635,
 2276,
 -1,
 125448413,
 2279,
 125698047,
 125439266,
 2277,
 -1,
 125579485,
 2280,
 125765506,
 125250336,
 -1,
 125831041,
 125698990,
 2296,
 -1,
 125764085,
 2301,
 -1,
 125765489,
 2298,
 126027654,
 125707530,
 -1,
 -63612,
 125967278,
 2290,
 -63611,
 126030549,
 2288,
 -1,
 126094632,
 2289,
 126289802,
 125963479,
 -1,
 126355337,
 126232062,
 2299,
 -1,
 126288373,
 2300,
 -1,
 126289150,
 2302,
 126551949,
 126227145,
 -1,
 -63604,
 126495651,
 2292,
 -1,
 126553609,
 2293,
 -63602,
 126498570,
 1631,
 -1,
 126688153,
 2294,
 126879634,
 109064647,
 -1,
 -63599,
 126824277,
 127912,
 -1,
 126880900,
 128667,
 -1,
 126820508,
 1423,
 127141946,
 108993621,
 -1,
 127207479,
 127076989,
 -1,
 127272878,
 127151250,
 -1,
 127338400,
 127218504,
 -1,
 127403935,
 127272993,
 -1,
 127469470,
 127340366,
 -1,
 127535004,
 127413484,
 -1,
 -63589,
 127470576,
 128807,
 -1,
 127534520,
 128814,
 -63587,
 127470576,
 128802,
 -1,
 127665592,
 128812,
 -1,
 127408535,
 128862,
 -1,
 127344144,
 128781,
 127993766,
 127272123,
 -1,
 128059301,
 127938595,
 128788,
 128188415,
 127992093,
 -1,
 -63580,
 128060407,
 128806,
 -1,
 128124344,
 128813,
 -1,
 127992520,
 128825,
 128386986,
 127938595,
 -1,
 128452521,
 128330231,
 128860,
 -1,
 128385733,
 128861,
 -1,
 128386610,
 128850,
 -63573,
 128329555,
 128839,
 -63572,
 128590640,
 128852,
 -63571,
 128653483,
 128795,
 -1,
 128715285,
 128847,
 128911297,
 127206214,
 -1,
 128976822,
 128854220,
 -1,
 129042357,
 128909312,
 -1,
 129107891,
 128988795,
 128776,
 -1,
 129041093,
 128777,
 129302527,
 129051298,
 128774,
 -1,
 129172165,
 128775,
 -1,
 128979878,
 128773,
 129435579,
 128916565,
 -1,
 129501113,
 129375087,
 128822,
 -1,
 129434309,
 128823,
 -63558,
 129446965,
 128837,
 -1,
 129568835,
 128874,
 -63556,
 129381693,
 128829,
 -63555,
 129707431,
 128855,
 -63554,
 129772633,
 128826,
 -63553,
 129835744,
 128811,
 -63552,
 129900472,
 128859,
 -1,
 129964449,
 128769,
 130156501,
 128846036,
 -1,
 130222029,
 130099496,
 -1,
 130287561,
 130167759,
 128869,
 130416639,
 130220739,
 -1,
 -63546,
 130286381,
 128873,
 -63545,
 130351911,
 128872,
 -63544,
 130417445,
 128871,
 -1,
 130482975,
 128870,
 130744319,
 130229111,
 -1,
 130746316,
 130616304,
 128803,
 -1,
 130679493,
 128804,
 -1,
 130685375,
 128798,
 130942929,
 130155334,
 -1,
 -63537,
 130885780,
 128846,
 -63536,
 130948950,
 128844,
 -1,
 131010326,
 128848,
 131205076,
 130884914,
 -1,
 -63533,
 131147142,
 128800,
 -1,
 131204524,
 128805,
 -1,
 131144056,
 128787,
 131467237,
 130099496,
 -1,
 131532771,
 131403585,
 -1,
 131598304,
 131470731,
 128818,
 131663836,
 131531459,
 -1,
 -63526,
 131597095,
 128821,
 -63525,
 131662629,
 128820,
 -1,
 131728159,
 128819,
 131989503,
 131596573,
 -1,
 131991519,
 131859896,
 128816,
 -1,
 131924677,
 128817,
 -1,
 131930559,
 128799,
 132188130,
 131531995,
 128827,
 -1,
 132121285,
 128828,
 -1,
 132133454,
 128877,
 132448255,
 131474261,
 128792,
 -1,
 132317893,
 128793,
 132515824,
 131401474,
 -1,
 132581354,
 132457843,
 128834,
 132710399,
 132514499,
 -1,
 -63511,
 132580133,
 128836,
 -1,
 132645663,
 128835,
 132843501,
 132515478,
 -1,
 -63508,
 132789693,
 128876,
 -1,
 132849641,
 128875,
 -63506,
 132786947,
 128857,
 -63505,
 132979860,
 128783,
 -1,
 133044688,
 128830,
 133236730,
 132461996,
 -1,
 133302265,
 133175101,
 -1,
 133367799,
 133243350,
 128778,
 133433334,
 133300931,
 -1,
 -63499,
 133366565,
 128780,
 -1,
 133432095,
 128779,
 -1,
 133366050,
 128815,
 133758975,
 133313231,
 128790,
 -1,
 133628613,
 128791,
 -1,
 133239036,
 128808,
 133892100,
 133179021,
 -1,
 133957631,
 133833496,
 -1,
 134023166,
 133904195,
 128843,
 -1,
 133959594,
 128858,
 -1,
 133967923,
 128856,
 134219778,
 133903176,
 -1,
 -63487,
 134165126,
 128868,
 -1,
 134228757,
 128867,
 -63485,
 134163016,
 128863,
 -1,
 134354626,
 128782,
 134547468,
 133836835,
 -1,
 134613000,
 134486214,
 -1,
 -63481,
 134548601,
 128840,
 -1,
 134611256,
 128809,
 134809610,
 134547014,
 128831,
 -1,
 134742725,
 128832,
 -63477,
 134755745,
 128845,
 -1,
 134884104,
 128849,
 135071763,
 134487905,
 -1,
 135137297,
 135008491,
 128784,
 135266303,
 135070403,
 -1,
 -63472,
 135136037,
 128786,
 -1,
 135201567,
 128785,
 -63470,
 135079134,
 128881,
 -1,
 135333373,
 128824,
 135530522,
 135009681,
 -1,
 135596055,
 135471896,
 -1,
 -63466,
 135542053,
 128878,
 -1,
 135605328,
 128854,
 135856127,
 135529686,
 -1,
 -63463,
 135734824,
 128883,
 -1,
 135794423,
 128882,
 135989280,
 135466199,
 -1,
 136054815,
 135928265,
 -1,
 136120350,
 135999202,
 128865,
 -1,
 136053445,
 128866,
 -1,
 136065525,
 128864,
 -1,
 135988973,
 128880,
 136382500,
 135928255,
 -1,
 136448035,
 136315192,
 128796,
 -1,
 136381125,
 128797,
 -1,
 136381138,
 128801,
 136644647,
 136328948,
 -1,
 -63450,
 136591564,
 128842,
 -1,
 136655163,
 128772,
 136841258,
 136587556,
 -1,
 -63447,
 136782550,
 128768,
 -1,
 136841962,
 128833,
 137037869,
 136782317,
 -1,
 -63444,
 136983170,
 128789,
 -1,
 137041126,
 128879,
 137234480,
 136977493,
 -1,
 -63441,
 137175936,
 128851,
 -1,
 137236336,
 128810,
 137431091,
 137171965,
 -1,
 -63438,
 137376821,
 128841,
 -1,
 137438193,
 128794,
 -63436,
 137377079,
 128853,
 -63435,
 137569227,
 128838,
 -63434,
 137630537,
 128770,
 -1,
 137695122,
 128771,
 -63432,
 127145991,
 128126,
 -63431,
 137826617,
 983054,
 -1,
 137889320,
 9200,
 138086466,
 127082823,
 -1,
 138151998,
 138031139,
 128028,
 -63427,
 138090409,
 128260,
 -1,
 138154116,
 128246,
 138412031,
 138089469,
 -1,
 -63424,
 138294290,
 128551,
 -63423,
 138357898,
 128544,
 -1,
 138416353,
 128162,
 138610759,
 138031944,
 -1,
 138676294,
 138555938,
 -1,
 -63419,
 138617656,
 128663,
 -1,
 138675842,
 127975,
 -1,
 138610560,
 127814,
 138938442,
 138555218,
 -1,
 -63415,
 138882039,
 9954,
 -1,
 138945745,
 128562,
 139135053,
 138880653,
 -1,
 -63412,
 139077489,
 983194,
 -1,
 139135188,
 983195,
 139331664,
 139075425,
 -1,
 -63409,
 139268371,
 127944,
 -1,
 139331751,
 128657,
 139528274,
 139266791,
 983053,
 -1,
 139469459,
 983052,
 -63405,
 139473288,
 128095,
 -1,
 139596037,
 128673,
 139790809,
 108928865,
 -1,
 139856141,
 139728701,
 -1,
 139921666,
 139789770,
 -1,
 139987148,
 139861419,
 -1,
 140052586,
 139931683,
 -1,
 140118113,
 139994304,
 -1,
 -63397,
 140051262,
 94105,
 -63396,
 140116793,
 94104,
 -63395,
 140182327,
 94103,
 -63394,
 140247853,
 94102,
 -63393,
 140313383,
 94101,
 -63392,
 140378917,
 94100,
 -1,
 140444447,
 94099,
 140642405,
 140061842,
 -1,
 -63389,
 140586198,
 93994,
 -63388,
 140645791,
 93998,
 -1,
 140706630,
 94007,
 140904552,
 140582421,
 -1,
 -63385,
 140851514,
 93980,
 -1,
 140903238,
 93978,
 -63383,
 140849294,
 93966,
 -1,
 141034310,
 93962,
 141232247,
 139993415,
 -1,
 141297774,
 141179155,
 -1,
 -63379,
 141235615,
 93997,
 -1,
 141296454,
 93996,
 141494385,
 141238599,
 -1,
 -63376,
 141432223,
 93973,
 -1,
 141493062,
 93972,
 141690996,
 141431805,
 -1,
 -63373,
 141628831,
 93988,
 -1,
 141689670,
 93987,
 141887606,
 141624134,
 93968,
 -1,
 141831393,
 94032,
 -1,
 141825439,
 93969,
 142084227,
 141179321,
 -1,
 142149758,
 142031289,
 -1,
 142215292,
 142093458,
 -1,
 -63365,
 142162234,
 94017,
 -1,
 142213958,
 94014,
 -63363,
 142162234,
 94016,
 -1,
 142345030,
 94013,
 142542977,
 142093458,
 -1,
 -63360,
 142480799,
 94006,
 -1,
 142541638,
 94012,
 -63358,
 142480799,
 94005,
 -1,
 142672710,
 94011,
 142870670,
 142031242,
 -1,
 142936202,
 142815267,
 -1,
 143001736,
 142879890,
 -1,
 -63353,
 142939551,
 94000,
 -1,
 143000390,
 94009,
 -63351,
 142946446,
 93964,
 -1,
 143131462,
 93965,
 -63349,
 142878385,
 93954,
 -63348,
 143270449,
 93970,
 -63347,
 143334233,
 93984,
 -1,
 143396668,
 94001,
 143591575,
 142813847,
 -1,
 143657110,
 143533248,
 -1,
 -63343,
 143590206,
 94111,
 -63342,
 143655735,
 94110,
 -63341,
 143721261,
 94109,
 -63340,
 143786791,
 94108,
 -63339,
 143852319,
 94107,
 -1,
 143917853,
 94106,
 -1,
 143601044,
 94002,
 144181409,
 143527127,
 -1,
 144246940,
 144128441,
 -1,
 -63334,
 144193979,
 93995,
 -63333,
 144250271,
 93999,
 -1,
 144311110,
 94008,
 144509087,
 144186901,
 -1,
 -63330,
 144455994,
 93981,
 -1,
 144507718,
 93979,
 -63328,
 144444667,
 93967,
 -1,
 144638790,
 93963,
 144836777,
 144114502,
 -1,
 144902312,
 144779793,
 -1,
 144967846,
 144843079,
 -1,
 -63323,
 144905222,
 93989,
 -1,
 144966470,
 93971,
 -63321,
 144914959,
 94015,
 -1,
 145104767,
 93958,
 -1,
 144840081,
 94019,
 145361071,
 144776277,
 -1,
 145426605,
 145298833,
 -1,
 -63316,
 145373498,
 93977,
 -1,
 145425222,
 93976,
 -63314,
 145373498,
 93975,
 -1,
 145556294,
 93974,
 145754291,
 145304722,
 -1,
 -63311,
 145698006,
 94004,
 -63310,
 145757599,
 94003,
 -1,
 145818438,
 94010,
 146016440,
 145691645,
 -1,
 146081975,
 145954193,
 -1,
 -63306,
 146019743,
 93993,
 -1,
 146080582,
 93992,
 -1,
 146015046,
 93983,
 146344123,
 145962412,
 -1,
 -63302,
 146281109,
 93961,
 -1,
 146342726,
 93960,
 146540734,
 146286768,
 -1,
 -63299,
 146478086,
 93986,
 -1,
 146539334,
 93985,
 146737345,
 146482829,
 -1,
 -63296,
 146676854,
 93955,
 -1,
 146735942,
 93952,
 146933956,
 146677601,
 -1,
 -63293,
 146871711,
 93957,
 -1,
 146932550,
 93956,
 147130567,
 146871697,
 -1,
 -63290,
 147068319,
 94020,
 -1,
 147129158,
 93990,
 -63288,
 147077367,
 93991,
 -63287,
 147273460,
 94018,
 -63286,
 147331929,
 93982,
 -63285,
 147395221,
 93959,
 -1,
 147457799,
 93953,
 147654904,
 139933373,
 -1,
 147720406,
 147593021,
 94049,
 147785937,
 147653446,
 94050,
 147914751,
 147726663,
 94051,
 -1,
 147788797,
 94052,
 -63278,
 147731272,
 94056,
 -63277,
 147923736,
 94053,
 -63276,
 147988965,
 94057,
 -63275,
 148051773,
 94055,
 -1,
 148115265,
 94054,
 148310239,
 147653446,
 94036,
 148375769,
 148250951,
 94039,
 -1,
 148313085,
 94040,
 148506843,
 148311873,
 94067,
 -1,
 148442945,
 94068,
 -63268,
 148452168,
 94075,
 -63267,
 148576061,
 94073,
 -63266,
 148641418,
 94038,
 -1,
 148702022,
 94037,
 148900070,
 148255560,
 94058,
 148965603,
 148833094,
 94059,
 149094399,
 148906311,
 94060,
 -1,
 148968445,
 94061,
 -63260,
 148910920,
 94062,
 -63259,
 149103077,
 94064,
 -1,
 149164034,
 94063,
 149358828,
 148836161,
 94045,
 149424361,
 149301544,
 94071,
 -1,
 149367080,
 94069,
 149555435,
 149365063,
 94046,
 -1,
 149492733,
 94047,
 -1,
 149493565,
 94074,
 149752048,
 149299992,
 94041,
 -63250,
 149697352,
 94076,
 -63249,
 149758744,
 94042,
 -1,
 149820041,
 94048,
 150014194,
 149698835,
 94065,
 -1,
 149952317,
 94066,
 150145268,
 149960405,
 94044,
 -1,
 150086424,
 94043,
 150276342,
 150088744,
 94072,
 -1,
 150219048,
 94070,
 150470655,
 150217031,
 94077,
 -1,
 150344701,
 94078,
 150538493,
 147599910,
 -1,
 -63238,
 150483518,
 94096,
 -63237,
 150547226,
 94095,
 -63236,
 150603633,
 94098,
 -1,
 150668206,
 94097,
 150929407,
 150482404,
 -1,
 150931713,
 150809229,
 -1,
 -63232,
 150877855,
 94034,
 -1,
 150931030,
 94035,
 -1,
 150865494,
 94033,
 151193865,
 139856912,
 -1,
 151259398,
 151135000,
 -1,
 -63227,
 151203100,
 128300,
 -1,
 151267127,
 127908,
 151519231,
 151191552,
 -1,
 -63224,
 151397445,
 983225,
 -1,
 151457081,
 983226,
 151652620,
 151134701,
 -1,
 -63221,
 151588316,
 128189,
 -1,
 151652539,
 128656,
 -1,
 151592553,
 127756,
 151914878,
 139792193,
 -1,
 151980374,
 151858150,
 -1,
 152045877,
 151918228,
 -1,
 152111411,
 151985579,
 -1,
 152176919,
 152055843,
 -1,
 152242452,
 152112961,
 67994,
 -1,
 152175301,
 67995,
 152373526,
 152175430,
 67992,
 -1,
 152306373,
 67993,
 -1,
 152314648,
 67996,
 152570140,
 152117575,
 -1,
 152635674,
 152506177,
 67980,
 -1,
 152568517,
 67981,
 152829951,
 152568646,
 67978,
 -1,
 152699589,
 67979,
 152897824,
 152513682,
 -1,
 152963359,
 152830790,
 67987,
 -1,
 152896197,
 67988,
 -1,
 152899393,
 67989,
 153159970,
 152840534,
 67982,
 -1,
 153092805,
 67983,
 153291045,
 153099013,
 -1,
 -63196,
 153228703,
 67985,
 -1,
 153289542,
 67990,
 153487655,
 153224967,
 67974,
 -1,
 153420485,
 67975,
 -63192,
 153434426,
 67972,
 -63191,
 153564916,
 67973,
 -63190,
 153626802,
 67991,
 -63189,
 153691825,
 67976,
 -63188,
 153756440,
 67971,
 -63187,
 153821055,
 67977,
 -63186,
 153885814,
 67984,
 -63185,
 153950013,
 67970,
 -63184,
 154015373,
 67986,
 -63183,
 154079041,
 67969,
 -63182,
 154143995,
 67997,
 -1,
 154207046,
 67968,
 154468351,
 152055823,
 67998,
 -1,
 154337989,
 67999,
 154599423,
 151981228,
 -1,
 154601811,
 154472868,
 -1,
 154667323,
 154546211,
 -1,
 -63175,
 154608408,
 68022,
 -63174,
 154668865,
 68021,
 -1,
 154731334,
 68020,
 154929470,
 154610834,
 -1,
 -63171,
 154865473,
 68017,
 -1,
 154927942,
 68015,
 155126081,
 154870087,
 -1,
 -63168,
 155062081,
 68010,
 -1,
 155124550,
 68009,
 155322692,
 155065093,
 -1,
 -63165,
 155260319,
 68013,
 -1,
 155321158,
 68018,
 155519302,
 155255622,
 68000,
 -1,
 155462178,
 68016,
 -63161,
 155466042,
 68004,
 -63160,
 155596532,
 68005,
 -63159,
 155658582,
 68011,
 -63158,
 155723954,
 68019,
 -63157,
 155788977,
 68007,
 -63156,
 155853592,
 68003,
 -63155,
 155918207,
 68008,
 -63154,
 155982966,
 68012,
 -63153,
 156047165,
 68002,
 -63152,
 156112525,
 68014,
 -63151,
 156176193,
 68001,
 -63150,
 156241147,
 68023,
 -1,
 156305159,
 68006,
 156565503,
 154543022,
 -1,
 -63147,
 156445663,
 68030,
 -1,
 156506306,
 68031,
 156699000,
 151916952,
 -1,
 156764519,
 156638635,
 -1,
 156830043,
 156709618,
 -1,
 -63142,
 156767647,
 43749,
 -1,
 156828486,
 43748,
 157026654,
 156773522,
 -1,
 -63139,
 156970198,
 43754,
 -1,
 157029791,
 43753,
 157223265,
 156967239,
 -1,
 -63136,
 157169978,
 43747,
 -1,
 157229430,
 43752,
 157419876,
 157158731,
 -1,
 -63133,
 157357471,
 43751,
 -1,
 157418310,
 43750,
 -63131,
 157360920,
 43745,
 -63130,
 157552449,
 43744,
 -1,
 157616694,
 43746,
 157813106,
 156710316,
 -1,
 157878641,
 157755010,
 -1,
 157944174,
 157811526,
 -1,
 158009709,
 157877062,
 -1,
 -63124,
 157954888,
 43759,
 -1,
 158013245,
 43757,
 -1,
 157954888,
 43758,
 -63121,
 157890156,
 43765,
 -63120,
 158217638,
 43756,
 -1,
 158275724,
 43755,
 -1,
 157817263,
 43766,
 158534005,
 157745990,
 -1,
 -63116,
 158474771,
 43762,
 -1,
 158537231,
 43761,
 -63114,
 158480539,
 43764,
 -63113,
 158674907,
 43763,
 -1,
 158730868,
 43760,
 -63111,
 156644053,
 128647,
 -63110,
 158871344,
 983172,
 -63109,
 158933660,
 128697,
 -63108,
 158998778,
 128221,
 -63107,
 159063767,
 127816,
 -1,
 159123063,
 127830,
 159320495,
 151847750,
 -1,
 159386023,
 159260999,
 128104,
 159451553,
 159321372,
 -1,
 159517085,
 159391147,
 -1,
 159582614,
 159449926,
 -1,
 159648134,
 159526034,
 2126,
 -63099,
 159594937,
 2129,
 -1,
 159651217,
 2132,
 159844744,
 159592483,
 2133,
 -1,
 159789091,
 2120,
 159975818,
 159783685,
 2122,
 -1,
 159919318,
 2121,
 -63093,
 159922617,
 2118,
 -63092,
 160049448,
 2131,
 -63091,
 160114864,
 2130,
 -63090,
 160179853,
 2128,
 -63089,
 160244039,
 2125,
 -63088,
 160309089,
 2124,
 -63087,
 160373845,
 2123,
 -63086,
 160438470,
 2136,
 -63085,
 160503185,
 2116,
 -63084,
 160568317,
 2114,
 -63083,
 160632023,
 2115,
 -1,
 160696066,
 2113,
 160893337,
 159520573,
 -1,
 -63080,
 160837667,
 2119,
 -1,
 160899399,
 2127,
 -63078,
 160839029,
 2117,
 -63077,
 161028967,
 2135,
 -63076,
 161093073,
 2112,
 -1,
 161156893,
 2134,
 -63074,
 159463053,
 2138,
 -63073,
 161294436,
 2142,
 -63072,
 161354887,
 2139,
 -1,
 161416299,
 2137,
 161614246,
 159383552,
 -1,
 161679781,
 161560483,
 -1,
 -63068,
 161624840,
 128115,
 -1,
 161682798,
 128114,
 -1,
 161613135,
 128107,
 -1,
 161557689,
 128094,
 162007467,
 159325426,
 -1,
 -63063,
 161952511,
 3386,
 -63062,
 162013796,
 3369,
 -1,
 162074131,
 3406,
 162269614,
 161952109,
 -1,
 -63059,
 162212787,
 10187,
 -1,
 162271922,
 10189,
 -1,
 162211683,
 127809,
 162531790,
 159261464,
 -1,
 162597306,
 162476872,
 -1,
 162662839,
 162538169,
 -1,
 162728374,
 162595995,
 -1,
 -63052,
 162671002,
 128670,
 -63051,
 162728187,
 128672,
 -1,
 162793393,
 128693,
 -1,
 162660511,
 128507,
 163056057,
 162606376,
 128001,
 -1,
 162988159,
 128045,
 -1,
 163000661,
 128068,
 163252673,
 162537799,
 -1,
 163318205,
 163191779,
 128018,
 -1,
 163250303,
 128053,
 163449280,
 163254924,
 -1,
 -63041,
 163395630,
 128184,
 -1,
 163448606,
 128176,
 -1,
 163390814,
 128669,
 163711431,
 163188147,
 -1,
 163776965,
 163648130,
 -1,
 -63036,
 163716854,
 983972,
 -1,
 163780258,
 983971,
 -63034,
 163720835,
 43001,
 -1,
 163907906,
 43000,
 164104651,
 163645392,
 128241,
 164233215,
 164036608,
 -1,
 -63030,
 164116471,
 128242,
 -1,
 164176789,
 128244,
 -63028,
 164051269,
 128511,
 -63027,
 164312658,
 127909,
 -1,
 164373586,
 127889,
 164563414,
 162476872,
 -1,
 164628949,
 164506770,
 -1,
 164694484,
 164566921,
 -1,
 -63022,
 164637986,
 127932,
 -63021,
 164700803,
 127925,
 -1,
 164764647,
 127929,
 -1,
 164632359,
 127812,
 -1,
 164568873,
 127926,
 -63017,
 164509397,
 983173,
 -63016,
 165033673,
 983210,
 -1,
 165093667,
 983222,
 165284710,
 139734162,
 -1,
 165349976,
 165221777,
 -1,
 165415501,
 165282630,
 -1,
 165481036,
 165357936,
 -1,
 165546525,
 165420459,
 -1,
 165612005,
 165492140,
 -1,
 165677540,
 165552973,
 -1,
 165743074,
 165620008,
 70025,
 -1,
 165685544,
 70026,
 165937151,
 165682261,
 70027,
 -1,
 165813333,
 70028,
 -1,
 165610310,
 70062,
 166070763,
 165556259,
 -1,
 166136297,
 166015011,
 -1,
 -63000,
 166073759,
 70044,
 -1,
 166134598,
 70043,
 -62998,
 166073759,
 70049,
 -1,
 166265670,
 70048,
 166463984,
 166011207,
 -1,
 -62995,
 166410554,
 70042,
 -62994,
 166470006,
 70047,
 -62993,
 166532102,
 70037,
 -1,
 166593350,
 70052,
 166791670,
 166399191,
 -1,
 166857204,
 166726871,
 -1,
 -62989,
 166794655,
 70046,
 -1,
 166855494,
 70045,
 -62987,
 166794655,
 70051,
 -1,
 166986566,
 70050,
 167184890,
 166724422,
 70019,
 -62984,
 167129928,
 70032,
 -62983,
 167188285,
 70030,
 -1,
 167248710,
 70020,
 167447038,
 167128210,
 -1,
 -62980,
 167390422,
 70064,
 -62979,
 167450015,
 70063,
 -1,
 167510854,
 70065,
 167709184,
 167392072,
 70023,
 -1,
 167654216,
 70024,
 167840259,
 167650957,
 -1,
 -62974,
 167777695,
 70054,
 -1,
 167838534,
 70053,
 168036870,
 167779413,
 -1,
 -62971,
 167976054,
 70061,
 -1,
 168035142,
 70060,
 168233481,
 167975685,
 -1,
 -62968,
 168170911,
 70034,
 -1,
 168231750,
 70033,
 168430092,
 168172145,
 -1,
 -62965,
 168367519,
 70041,
 -1,
 168428358,
 70040,
 168626702,
 168367933,
 70021,
 -1,
 168564541,
 70022,
 168757777,
 168563709,
 -1,
 -62960,
 168695199,
 70036,
 -1,
 168756038,
 70035,
 168954388,
 168691924,
 -1,
 -62957,
 168891807,
 70039,
 -1,
 168952646,
 70038,
 169150999,
 168888066,
 -1,
 -62954,
 169088415,
 70056,
 -1,
 169149254,
 70055,
 -62952,
 169097530,
 70058,
 -62951,
 169290070,
 70059,
 -62950,
 169354008,
 70031,
 -62949,
 169418623,
 70057,
 -62948,
 169481631,
 70066,
 -1,
 169545537,
 70029,
 169740845,
 165492413,
 -1,
 169806371,
 169686660,
 -1,
 169871905,
 169748776,
 70072,
 -1,
 169814312,
 70073,
 170065919,
 169811029,
 70074,
 -1,
 169942101,
 70075,
 170134055,
 169739078,
 -1,
 -62939,
 170079048,
 70079,
 -62938,
 170137405,
 70077,
 -1,
 170197830,
 70067,
 170396201,
 170079048,
 70070,
 -1,
 170341192,
 70071,
 170527275,
 170334013,
 70068,
 -1,
 170465085,
 70069,
 -62932,
 170468120,
 70078,
 -1,
 170594113,
 70076,
 170789438,
 169675991,
 -1,
 170854972,
 170727507,
 -1,
 170920498,
 170799139,
 -1,
 -62927,
 170866794,
 70098,
 -1,
 170923790,
 70099,
 171117109,
 170863762,
 -1,
 -62924,
 171055690,
 70102,
 -1,
 171119159,
 70103,
 171313720,
 171053712,
 -1,
 -62921,
 171255354,
 70100,
 -1,
 171317797,
 70101,
 -62919,
 171260420,
 70096,
 -62918,
 171451525,
 70097,
 -62917,
 171516410,
 70105,
 -1,
 171577349,
 70104,
 -62915,
 170796530,
 70086,
 -1,
 171705703,
 70085,
 171903562,
 170732690,
 -1,
 171969097,
 171841625,
 -1,
 172034627,
 171914831,
 -1,
 -62910,
 171977992,
 70018,
 -1,
 172042704,
 70080,
 172231238,
 171967302,
 -1,
 -62907,
 172176817,
 70081,
 -1,
 172237570,
 70017,
 -62905,
 172176622,
 70083,
 -62904,
 172366526,
 70082,
 -1,
 172427566,
 70016,
 -1,
 171905212,
 70088,
 -62901,
 171844627,
 70084,
 -1,
 172622724,
 70087,
 -1,
 165426639,
 127847,
 172886609,
 165356312,
 -1,
 -62897,
 172832584,
 128703,
 -62896,
 172895338,
 127856,
 -1,
 172959185,
 127776,
 173148758,
 172824381,
 -1,
 173214293,
 173085654,
 -1,
 -62892,
 173155922,
 983075,
 -1,
 173217990,
 983078,
 -1,
 173155981,
 128674,
 -62889,
 173095187,
 983197,
 -1,
 173412317,
 128017,
 173607569,
 165292240,
 -1,
 173673075,
 173546581,
 -1,
 173738608,
 173606558,
 -1,
 -62884,
 173685177,
 127305,
 -62883,
 173750547,
 127304,
 -62882,
 173816012,
 127303,
 -62881,
 173880748,
 127301,
 -62880,
 173945672,
 127300,
 -62879,
 174010403,
 127299,
 -62878,
 174074152,
 127297,
 -62877,
 174139568,
 127296,
 -62876,
 174203672,
 127294,
 -62875,
 174268257,
 127292,
 -62874,
 174333013,
 127291,
 -62873,
 174398213,
 127290,
 -62872,
 174463601,
 127289,
 -62871,
 174528317,
 127288,
 -62870,
 174593425,
 127287,
 -62869,
 174658557,
 127286,
 -62868,
 174723728,
 127285,
 -62867,
 174788417,
 127284,
 -62866,
 174853335,
 127283,
 -62865,
 174917844,
 127282,
 -1,
 174981958,
 127280,
 175243263,
 173679526,
 -1,
 -62862,
 175121755,
 10191,
 -1,
 175179083,
 10190,
 175377028,
 173607124,
 -1,
 175442562,
 175315689,
 -1,
 175508089,
 175375161,
 -1,
 -62857,
 175440728,
 127539,
 -62856,
 175506242,
 127538,
 -1,
 175571759,
 127544,
 175770238,
 175440695,
 -1,
 175835773,
 175702843,
 -1,
 -62852,
 175768384,
 127542,
 -1,
 175833918,
 127543,
 -1,
 175771497,
 127541,
 176160767,
 175702829,
 -1,
 -62848,
 176030515,
 127546,
 -62847,
 176096041,
 127540,
 -1,
 176161569,
 127545,
 -62845,
 175383787,
 127378,
 -1,
 176299093,
 127377,
 176491143,
 175317319,
 -1,
 -62842,
 176428029,
 127382,
 -1,
 176493138,
 127381,
 176687754,
 176430007,
 -1,
 -62839,
 176630998,
 127490,
 -1,
 176692250,
 127489,
 -62837,
 176633664,
 127311,
 -62836,
 176830153,
 127386,
 -62835,
 176895161,
 127385,
 -62834,
 176959208,
 127384,
 -62833,
 177021903,
 127383,
 -62832,
 177084389,
 127380,
 -1,
 177148869,
 127379,
 177343170,
 173548312,
 983077,
 177408702,
 177285465,
 -1,
 177474224,
 177348011,
 -1,
 177539736,
 177414471,
 -1,
 -62826,
 177486145,
 69857,
 -62825,
 177542157,
 69847,
 -1,
 177603726,
 69849,
 177801883,
 177479551,
 -1,
 -62822,
 177739153,
 69846,
 -1,
 177803073,
 69864,
 177998494,
 177737537,
 -1,
 -62819,
 177935761,
 69863,
 -1,
 177999858,
 69859,
 -62817,
 177944897,
 69852,
 -62816,
 178140601,
 69850,
 -62815,
 178205706,
 69861,
 -62814,
 178270386,
 69841,
 -62813,
 178334941,
 69840,
 -62812,
 178399638,
 69853,
 -62811,
 178464450,
 69851,
 -62810,
 178529212,
 69862,
 -62809,
 178592928,
 69848,
 -62808,
 178658155,
 69855,
 -62807,
 178723455,
 69856,
 -62806,
 178788489,
 69860,
 -62805,
 178853286,
 69854,
 -62804,
 178918413,
 69845,
 -62803,
 178982168,
 69844,
 -62802,
 179046660,
 69843,
 -62801,
 179111714,
 69842,
 -1,
 179176590,
 69858,
 179437567,
 177409474,
 -1,
 179440308,
 179318819,
 -1,
 -62797,
 179386474,
 69874,
 -1,
 179443470,
 69875,
 179636919,
 179383442,
 -1,
 -62794,
 179575370,
 69878,
 -1,
 179638839,
 69879,
 179833530,
 179573392,
 -1,
 -62791,
 179775034,
 69876,
 -1,
 179837477,
 69877,
 -62789,
 179780100,
 69872,
 -62788,
 179971205,
 69873,
 -62787,
 180036090,
 69881,
 -1,
 180097029,
 69880,
 -62785,
 177351826,
 983181,
 -62784,
 180233318,
 128284,
 -62783,
 180295057,
 983043,
 -1,
 180360168,
 127846,
 180554470,
 177288008,
 -1,
 180620000,
 180494663,
 -1,
 180685531,
 180555057,
 -1,
 180751055,
 180627581,
 -1,
 180816585,
 180692621,
 -1,
 -62776,
 180761928,
 7362,
 -1,
 180815246,
 7361,
 -62774,
 180760514,
 7360,
 -62773,
 180952550,
 7364,
 -62772,
 181017436,
 7365,
 -62771,
 181079294,
 7366,
 -62770,
 181143816,
 7363,
 -1,
 181208842,
 7367,
 181406422,
 180690347,
 -1,
 181471955,
 181343042,
 -1,
 -62766,
 181411681,
 7103,
 -1,
 181476101,
 7102,
 -62764,
 181414579,
 7099,
 -62763,
 181607906,
 7100,
 -1,
 181667742,
 7101,
 181865177,
 181341143,
 -1,
 -62760,
 181810932,
 7085,
 -1,
 181870463,
 7084,
 -62758,
 181808618,
 7083,
 -1,
 181995206,
 7098,
 182192861,
 180628398,
 127749,
 -1,
 182124861,
 127748,
 -62754,
 182136180,
 127751,
 -62753,
 182260586,
 127803,
 -1,
 182321714,
 127774,
 182520547,
 180563090,
 -1,
 -62750,
 182462221,
 128671,
 -1,
 182523537,
 127843,
 182717157,
 182454018,
 983102,
 -1,
 182660997,
 983101,
 -1,
 182659780,
 127940,
 182913790,
 180498467,
 983189,
 182979315,
 182846278,
 -1,
 183044848,
 182922339,
 -1,
 183110380,
 182987922,
 -1,
 -62741,
 183055049,
 983180,
 -1,
 183111714,
 983132,
 -62739,
 183054667,
 983044,
 -62738,
 183248968,
 983175,
 -62737,
 183309872,
 983042,
 -1,
 183375225,
 983174,
 183631871,
 182988835,
 -1,
 -62734,
 183514104,
 128509,
 -1,
 183572887,
 128649,
 183765752,
 182921512,
 -1,
 183831287,
 183698246,
 -1,
 -62730,
 183777075,
 127827,
 -1,
 183834680,
 128207,
 -1,
 183769429,
 983188,
 184093435,
 183701368,
 -1,
 -62726,
 184031493,
 127836,
 -1,
 184090821,
 128642,
 -62724,
 184039628,
 983045,
 -62723,
 184233106,
 983169,
 -1,
 184296761,
 9201,
 184486674,
 182855309,
 983117,
 184552202,
 184422209,
 -1,
 184617735,
 184485024,
 -1,
 184683270,
 184553678,
 128264,
 184811519,
 184615296,
 -1,
 -62716,
 184693157,
 128266,
 -62715,
 184755351,
 128265,
 -1,
 184813850,
 128263,
 -1,
 184615668,
 128586,
 185139199,
 184553281,
 -1,
 -62711,
 185011525,
 128676,
 -1,
 185076267,
 128172,
 185273103,
 184484678,
 983176,
 185338638,
 185215963,
 -1,
 -62707,
 185276701,
 128150,
 -1,
 185340225,
 10024,
 -1,
 185275594,
 127837,
 -62704,
 185214571,
 128051,
 -62703,
 185539772,
 128166,
 -1,
 185604516,
 128026,
 185797418,
 184426337,
 -1,
 185862950,
 185734973,
 -1,
 185928485,
 185802335,
 -1,
 185994018,
 185864861,
 -1,
 186059547,
 185935120,
 128515,
 186187775,
 185991170,
 -1,
 -62695,
 186069473,
 128518,
 -62694,
 186134195,
 128516,
 -1,
 186190689,
 128517,
 186387231,
 185996689,
 -1,
 -62691,
 186328466,
 128520,
 -62690,
 186388353,
 128525,
 -1,
 186451174,
 128519,
 186712063,
 186330258,
 -1,
 -62687,
 186594417,
 128526,
 -1,
 186654942,
 128522,
 186908671,
 185928114,
 -1,
 -62684,
 186787088,
 128570,
 -1,
 186848830,
 128571,
 -1,
 185871312,
 128527,
 187108137,
 185795809,
 -1,
 -62680,
 187049316,
 128312,
 -1,
 187107385,
 128313,
 -1,
 187048925,
 128684,
 187370301,
 185734973,
 983080,
 187435835,
 187310407,
 -1,
 187501366,
 187372855,
 -1,
 187566899,
 187432960,
 -1,
 187632433,
 187510208,
 -1,
 -62672,
 187578474,
 983154,
 -1,
 187635470,
 983157,
 -62670,
 187569483,
 983182,
 -1,
 187763258,
 983184,
 188022783,
 187499268,
 -1,
 -62667,
 187892517,
 983158,
 -1,
 187958047,
 983155,
 188219391,
 187438519,
 -1,
 188222266,
 188098856,
 -1,
 -62663,
 188158149,
 983914,
 -1,
 188220583,
 983913,
 -1,
 188168521,
 983912,
 -62660,
 187381976,
 128303,
 -1,
 188423704,
 128510,
 188615493,
 187309141,
 -1,
 188681027,
 188551133,
 -1,
 188746562,
 188619008,
 -1,
 -62655,
 188690420,
 128164,
 -1,
 188748440,
 128564,
 -1,
 188692778,
 128554,
 -62652,
 188622251,
 127920,
 -1,
 188946332,
 127829,
 189139787,
 188550977,
 -1,
 189205321,
 189075265,
 -1,
 -62648,
 189140458,
 127793,
 -1,
 189203188,
 128584,
 -62646,
 189149301,
 983168,
 -1,
 189335156,
 128186,
 189533008,
 189073620,
 -1,
 189598542,
 189470462,
 127979,
 -1,
 189530453,
 127890,
 -62641,
 189541358,
 128220,
 -1,
 189667133,
 983185,
 189860692,
 189479187,
 -1,
 189926227,
 189800775,
 983094,
 -1,
 189860508,
 983093,
 -1,
 189868968,
 128137,
 190122840,
 189803666,
 -1,
 -62634,
 190055238,
 983133,
 -62633,
 190120741,
 983159,
 -1,
 190186271,
 983156,
 190384989,
 190062919,
 -1,
 190450524,
 190317382,
 -1,
 -62629,
 190389185,
 128013,
 -1,
 190453907,
 128012,
 -1,
 190391928,
 127938,
 190712673,
 190317382,
 -1,
 -62625,
 190658819,
 127927,
 -62624,
 190722347,
 128225,
 -1,
 190782404,
 127862,
 190974820,
 190651141,
 -1,
 -62621,
 190919719,
 128128,
 -1,
 190977855,
 127935,
 -62619,
 190920560,
 127946,
 -1,
 191108180,
 983183,
 191302782,
 165229996,
 -1,
 191368296,
 191245458,
 -1,
 191433687,
 191300381,
 983229,
 191499124,
 191365952,
 983251,
 -62613,
 191431488,
 983431,
 -62612,
 191497022,
 983430,
 -62611,
 191562553,
 983429,
 -62610,
 191628087,
 983428,
 -62609,
 191693613,
 983427,
 -62608,
 191759143,
 983426,
 -62607,
 191824677,
 983425,
 -62606,
 191890207,
 983424,
 -62605,
 191955741,
 983423,
 -1,
 192021275,
 983422,
 192220031,
 191431486,
 983250,
 -62602,
 192152384,
 983421,
 -62601,
 192217918,
 983420,
 -62600,
 192283449,
 983419,
 -62599,
 192348983,
 983418,
 -62598,
 192414509,
 983417,
 -62597,
 192480039,
 983416,
 -62596,
 192545573,
 983415,
 -62595,
 192611103,
 983414,
 -62594,
 192676637,
 983413,
 -1,
 192742171,
 983412,
 192940938,
 192152377,
 983249,
 -62591,
 192873280,
 983411,
 -62590,
 192938814,
 983410,
 -62589,
 193004345,
 983409,
 -62588,
 193069879,
 983408,
 -62587,
 193135405,
 983407,
 -62586,
 193200935,
 983406,
 -62585,
 193266469,
 983405,
 -62584,
 193331999,
 983404,
 -62583,
 193397533,
 983403,
 -1,
 193463067,
 983402,
 193661845,
 192873271,
 983244,
 -62580,
 193594176,
 983401,
 -62579,
 193659710,
 983400,
 -62578,
 193725241,
 983399,
 -62577,
 193790775,
 983398,
 -62576,
 193856301,
 983397,
 -62575,
 193921831,
 983396,
 -62574,
 193987365,
 983395,
 -62573,
 194052895,
 983394,
 -62572,
 194118429,
 983393,
 -1,
 194183963,
 983392,
 194382752,
 193594157,
 983243,
 -62569,
 194315072,
 983391,
 -62568,
 194380606,
 983390,
 -62567,
 194446137,
 983389,
 -62566,
 194511671,
 983388,
 -62565,
 194577197,
 983387,
 -62564,
 194642727,
 983386,
 -62563,
 194708261,
 983385,
 -62562,
 194773791,
 983384,
 -62561,
 194839325,
 983383,
 -1,
 194904859,
 983382,
 195103659,
 194315047,
 983242,
 -62558,
 195035968,
 983381,
 -62557,
 195101502,
 983380,
 -62556,
 195167033,
 983379,
 -62555,
 195232567,
 983378,
 -62554,
 195298093,
 983377,
 -62553,
 195363623,
 983376,
 -62552,
 195429157,
 983375,
 -62551,
 195494687,
 983374,
 -62550,
 195560221,
 983373,
 -1,
 195625755,
 983372,
 195824566,
 195035941,
 983241,
 -62547,
 195756864,
 983371,
 -62546,
 195822398,
 983370,
 -62545,
 195887929,
 983369,
 -62544,
 195953463,
 983368,
 -62543,
 196018989,
 983367,
 -62542,
 196084519,
 983366,
 -62541,
 196150053,
 983365,
 -62540,
 196215583,
 983364,
 -62539,
 196281117,
 983363,
 -1,
 196346651,
 983362,
 196545473,
 195756831,
 983240,
 -62536,
 196477760,
 983361,
 -62535,
 196543294,
 983360,
 -62534,
 196608825,
 983359,
 -62533,
 196674359,
 983358,
 -62532,
 196739885,
 983357,
 -62531,
 196805415,
 983356,
 -62530,
 196870949,
 983355,
 -62529,
 196936479,
 983354,
 -62528,
 197002013,
 983353,
 -1,
 197067547,
 983352,
 197266380,
 196477725,
 983239,
 -62525,
 197198656,
 983351,
 -62524,
 197264190,
 983350,
 -62523,
 197329721,
 983349,
 -62522,
 197395255,
 983348,
 -62521,
 197460781,
 983347,
 -62520,
 197526311,
 983346,
 -62519,
 197591845,
 983345,
 -62518,
 197657375,
 983344,
 -62517,
 197722909,
 983343,
 -1,
 197788443,
 983342,
 198049791,
 197198619,
 983238,
 -62514,
 197919552,
 983341,
 -62513,
 197985086,
 983340,
 -62512,
 198050617,
 983339,
 -62511,
 198116151,
 983338,
 -62510,
 198181677,
 983337,
 -62509,
 198247207,
 983336,
 -62508,
 198312741,
 983335,
 -62507,
 198378271,
 983334,
 -62506,
 198443805,
 983333,
 -1,
 198509339,
 983332,
 198708251,
 191365919,
 983230,
 198773731,
 198640423,
 983256,
 -62502,
 198705984,
 983481,
 -62501,
 198771518,
 983480,
 -62500,
 198837049,
 983479,
 -62499,
 198902583,
 983478,
 -62498,
 198968109,
 983477,
 -62497,
 199033639,
 983476,
 -62496,
 199099173,
 983475,
 -62495,
 199164703,
 983474,
 -62494,
 199230237,
 983473,
 -1,
 199295771,
 983472,
 199494638,
 198705957,
 983255,
 -62491,
 199426880,
 983471,
 -62490,
 199492414,
 983470,
 -62489,
 199557945,
 983469,
 -62488,
 199623479,
 983468,
 -62487,
 199689005,
 983467,
 -62486,
 199754535,
 983466,
 -62485,
 199820069,
 983465,
 -62484,
 199885599,
 983464,
 -62483,
 199951133,
 983463,
 -1,
 200016667,
 983462,
 200215545,
 199426847,
 983254,
 -62480,
 200147776,
 983461,
 -62479,
 200213310,
 983460,
 -62478,
 200278841,
 983459,
 -62477,
 200344375,
 983458,
 -62476,
 200409901,
 983457,
 -62475,
 200475431,
 983456,
 -62474,
 200540965,
 983455,
 -62473,
 200606495,
 983454,
 -62472,
 200672029,
 983453,
 -1,
 200737563,
 983452,
 200936452,
 200147741,
 983253,
 -62469,
 200868672,
 983451,
 -62468,
 200934206,
 983450,
 -62467,
 200999737,
 983449,
 -62466,
 201065271,
 983448,
 -62465,
 201130797,
 983447,
 -62464,
 201196327,
 983446,
 -62463,
 201261861,
 983445,
 -62462,
 201327391,
 983444,
 -62461,
 201392925,
 983443,
 -1,
 201458459,
 983442,
 201657359,
 200868635,
 983252,
 -62458,
 201589568,
 983441,
 -62457,
 201655102,
 983440,
 -62456,
 201720633,
 983439,
 -62455,
 201786167,
 983438,
 -62454,
 201851693,
 983437,
 -62453,
 201917223,
 983436,
 -62452,
 201982757,
 983435,
 -62451,
 202048287,
 983434,
 -62450,
 202113821,
 983433,
 -1,
 202179355,
 983432,
 202378263,
 201589549,
 983257,
 -62447,
 202310455,
 983488,
 -62446,
 202375981,
 983487,
 -62445,
 202441511,
 983486,
 -62444,
 202507045,
 983485,
 -62443,
 202572575,
 983484,
 -62442,
 202638109,
 983483,
 -1,
 202703643,
 983482,
 -62440,
 202310464,
 983261,
 -62439,
 202834750,
 983260,
 -62438,
 202900281,
 983259,
 -1,
 202965815,
 983258,
 203164710,
 198640448,
 983237,
 -62435,
 203096896,
 983331,
 -62434,
 203162430,
 983330,
 -62433,
 203227961,
 983329,
 -62432,
 203293495,
 983328,
 -62431,
 203359021,
 983327,
 -62430,
 203424551,
 983326,
 -62429,
 203490085,
 983325,
 -62428,
 203555615,
 983324,
 -62427,
 203621149,
 983323,
 -1,
 203686683,
 983322,
 203885617,
 203096894,
 983236,
 -62424,
 203817792,
 983321,
 -62423,
 203883326,
 983320,
 -62422,
 203948857,
 983319,
 -62421,
 204014391,
 983318,
 -62420,
 204079917,
 983317,
 -62419,
 204145447,
 983316,
 -62418,
 204210981,
 983315,
 -62417,
 204276511,
 983314,
 -62416,
 204342045,
 983313,
 -1,
 204407579,
 983312,
 204606524,
 203817785,
 983235,
 -62413,
 204538688,
 983311,
 -62412,
 204604222,
 983310,
 -62411,
 204669753,
 983309,
 -62410,
 204735287,
 983308,
 -62409,
 204800813,
 983307,
 -62408,
 204866343,
 983306,
 -62407,
 204931877,
 983305,
 -62406,
 204997407,
 983304,
 -62405,
 205062941,
 983303,
 -1,
 205128475,
 983302,
 205327431,
 204538679,
 983234,
 -62402,
 205259584,
 983301,
 -62401,
 205325118,
 983300,
 -62400,
 205390649,
 983299,
 -62399,
 205456183,
 983298,
 -62398,
 205521709,
 983297,
 -62397,
 205587239,
 983296,
 -62396,
 205652773,
 983295,
 -62395,
 205718303,
 983294,
 -62394,
 205783837,
 983293,
 -1,
 205849371,
 983292,
 206048338,
 205259565,
 983233,
 -62391,
 205980480,
 983291,
 -62390,
 206046014,
 983290,
 -62389,
 206111545,
 983289,
 -62388,
 206177079,
 983288,
 -62387,
 206242605,
 983287,
 -62386,
 206308135,
 983286,
 -62385,
 206373669,
 983285,
 -62384,
 206439199,
 983284,
 -62383,
 206504733,
 983283,
 -1,
 206570267,
 983282,
 206769245,
 205980455,
 983232,
 -62380,
 206701376,
 983281,
 -62379,
 206766910,
 983280,
 -62378,
 206832441,
 983279,
 -62377,
 206897975,
 983278,
 -62376,
 206963501,
 983277,
 -62375,
 207029031,
 983276,
 -62374,
 207094565,
 983275,
 -62373,
 207160095,
 983274,
 -62372,
 207225629,
 983273,
 -1,
 207291163,
 983272,
 207552511,
 206701349,
 983231,
 -62369,
 207422272,
 983271,
 -62368,
 207487806,
 983270,
 -62367,
 207553337,
 983269,
 -62366,
 207618871,
 983268,
 -62365,
 207684397,
 983267,
 -62364,
 207749927,
 983266,
 -62363,
 207815461,
 983265,
 -62362,
 207880991,
 983264,
 -62361,
 207946525,
 983263,
 -1,
 208012059,
 983262,
 208211059,
 191303489,
 -1,
 208276591,
 208145838,
 -1,
 208342126,
 208219620,
 -1,
 -62356,
 208286958,
 7414,
 -62355,
 208350227,
 7411,
 -1,
 208411326,
 7413,
 -1,
 208286252,
 7412,
 208732159,
 208219249,
 -1,
 208735346,
 208602036,
 983069,
 -1,
 208666974,
 983143,
 -1,
 208677242,
 128678,
 208931963,
 208148285,
 -1,
 208997497,
 208866671,
 -1,
 209063032,
 208928768,
 -1,
 -62345,
 208999460,
 127918,
 -1,
 209062163,
 128249,
 -1,
 208996761,
 128252,
 -62342,
 208937973,
 127931,
 -1,
 209258611,
 128243,
 209456253,
 208875555,
 983070,
 -1,
 209398930,
 983144,
 -1,
 209396714,
 127755,
 209653145,
 191236308,
 -1,
 209718512,
 209589649,
 -1,
 209784036,
 209650502,
 -1,
 209849563,
 209722389,
 -1,
 209915059,
 209788331,
 -1,
 209980553,
 209858595,
 -1,
 210046087,
 209924131,
 -1,
 -62330,
 209982882,
 69906,
 -1,
 210043740,
 69905,
 -62328,
 209982882,
 69911,
 -1,
 210174812,
 69910,
 210373774,
 209920327,
 -1,
 -62325,
 210319677,
 69904,
 -62324,
 210379138,
 69909,
 -62323,
 210441225,
 69899,
 -1,
 210502492,
 69914,
 210701460,
 210308311,
 -1,
 210766994,
 210635991,
 -1,
 -62319,
 210703778,
 69908,
 -1,
 210764636,
 69907,
 -62317,
 210703778,
 69913,
 -1,
 210895708,
 69912,
 211094679,
 210647315,
 -1,
 -62314,
 211040573,
 69920,
 -1,
 211092316,
 69921,
 211291290,
 211035789,
 -1,
 -62311,
 211228066,
 69916,
 -1,
 211288924,
 69915,
 211487901,
 211229445,
 -1,
 -62308,
 211424674,
 69896,
 -1,
 211485532,
 69895,
 211684512,
 211425905,
 -1,
 -62305,
 211621282,
 69903,
 -1,
 211682140,
 69902,
 211881123,
 211620861,
 -1,
 -62302,
 211817890,
 69898,
 -1,
 211878748,
 69897,
 212077734,
 211814612,
 -1,
 -62299,
 212014498,
 69901,
 -1,
 212075356,
 69900,
 212274345,
 212010754,
 -1,
 -62296,
 212211106,
 69918,
 -1,
 212271964,
 69917,
 -62294,
 212219639,
 69924,
 -62293,
 212415304,
 69893,
 -62292,
 212479193,
 69925,
 -62291,
 212543845,
 69922,
 -62290,
 212606850,
 69919,
 -62289,
 212671609,
 69923,
 -62288,
 212735805,
 69892,
 -62287,
 212800930,
 69926,
 -62286,
 212864833,
 69894,
 -1,
 212927324,
 69891,
 213126340,
 209849559,
 -1,
 213191874,
 213063763,
 -1,
 213257400,
 213135395,
 -1,
 -62281,
 213203050,
 69944,
 -1,
 213260046,
 69945,
 213454011,
 213200018,
 -1,
 -62278,
 213391946,
 69948,
 -1,
 213455415,
 69949,
 213650622,
 213389968,
 -1,
 -62275,
 213591610,
 69946,
 -1,
 213654053,
 69947,
 -62273,
 213596676,
 69942,
 -62272,
 213787781,
 69943,
 -62271,
 213852666,
 69951,
 -1,
 213913605,
 69950,
 -62269,
 213132786,
 69954,
 -1,
 214041959,
 69953,
 214240465,
 213071276,
 -1,
 214306000,
 214181506,
 -1,
 214371529,
 214238022,
 69927,
 -62264,
 214315848,
 69935,
 -1,
 214374205,
 69933,
 214568139,
 214315848,
 69930,
 -1,
 214512456,
 69931,
 214699213,
 214508312,
 69934,
 -1,
 214636349,
 69936,
 214830287,
 214636349,
 69928,
 -1,
 214767421,
 69929,
 -1,
 214765377,
 69932,
 -1,
 214243759,
 69939,
 215092439,
 214183058,
 -1,
 215157974,
 215029849,
 -1,
 -62252,
 215103084,
 69890,
 -62251,
 215157038,
 69888,
 -1,
 215221697,
 69889,
 -1,
 215093150,
 69952,
 -62248,
 215034111,
 69955,
 -62247,
 215425828,
 69937,
 -62246,
 215490438,
 69940,
 -1,
 215549619,
 69938,
 215810047,
 209791272,
 -1,
 215813344,
 215691398,
 -1,
 215878879,
 215758090,
 128200,
 -1,
 215810072,
 128185,
 -1,
 215813856,
 128201,
 216137727,
 215745499,
 983058,
 216203263,
 216006656,
 -1,
 -62237,
 216086473,
 983139,
 -1,
 216149360,
 983136,
 216337643,
 209719105,
 -1,
 216403176,
 216280115,
 -1,
 -62233,
 216348960,
 127800,
 -1,
 216406063,
 127826,
 -62231,
 216346509,
 127792,
 -62230,
 216541427,
 127937,
 -1,
 216600867,
 128227,
 216796398,
 216274749,
 -1,
 -62227,
 216735006,
 128696,
 -1,
 216795909,
 128020,
 -62225,
 216738755,
 127876,
 -1,
 216933214,
 127851,
 217124142,
 209656917,
 -1,
 217189672,
 217064216,
 -1,
 217255201,
 217123559,
 -1,
 217320733,
 217186437,
 -1,
 217386242,
 217264163,
 -1,
 217451772,
 217331413,
 -1,
 217517305,
 217391896,
 -1,
 -62216,
 217449235,
 128349,
 -1,
 217514261,
 128337,
 217776127,
 217452603,
 -1,
 -62213,
 217645843,
 128359,
 -1,
 217710869,
 128347,
 217910527,
 217388814,
 -1,
 -62210,
 217842451,
 128350,
 -1,
 217907477,
 128338,
 218169343,
 217845833,
 -1,
 -62207,
 218039059,
 128357,
 -1,
 218104085,
 128345,
 218303753,
 217328786,
 -1,
 218369286,
 218241610,
 -1,
 -62203,
 218301203,
 128353,
 -1,
 218366229,
 128341,
 218628095,
 218305079,
 -1,
 -62200,
 218497811,
 128354,
 -1,
 218562837,
 128342,
 218762512,
 218239632,
 -1,
 218828045,
 218703418,
 -1,
 -62196,
 218759955,
 128351,
 -1,
 218824981,
 128339,
 219086847,
 218765861,
 -1,
 -62193,
 218956563,
 128352,
 -1,
 219021589,
 128340,
 219221271,
 218697537,
 -1,
 219286804,
 219160050,
 -1,
 -62189,
 219218707,
 128358,
 -1,
 219283733,
 128346,
 219545599,
 219224115,
 -1,
 -62186,
 219415315,
 128355,
 -1,
 219480341,
 128343,
 219680026,
 219161733,
 -1,
 -62183,
 219611923,
 128348,
 -1,
 219676949,
 128336,
 219938815,
 219619834,
 -1,
 -62180,
 219808531,
 128356,
 -1,
 219873557,
 128344,
 220135423,
 217266072,
 -1,
 220138784,
 220015467,
 128257,
 -1,
 220070340,
 128258,
 -1,
 220073655,
 128259,
 220397567,
 217197871,
 -1,
 220400933,
 220274596,
 -1,
 -62172,
 220342690,
 128235,
 -1,
 220405526,
 128234,
 -62170,
 220345400,
 127746,
 -62169,
 220536521,
 128272,
 -1,
 220596294,
 128213,
 220794155,
 217126717,
 -1,
 -62166,
 220735216,
 128203,
 -1,
 220799511,
 127867,
 221052927,
 220726746,
 -1,
 -62163,
 220928270,
 128079,
 -1,
 220991697,
 127916,
 221187411,
 217064216,
 -1,
 221252924,
 221126669,
 -1,
 221318459,
 221187270,
 -1,
 221383988,
 221264147,
 -1,
 -62157,
 221321021,
 42614,
 -1,
 221385021,
 42617,
 221580598,
 221328200,
 42615,
 -1,
 221518896,
 42612,
 221711672,
 221517629,
 42613,
 -1,
 221652423,
 42655,
 -62151,
 221654735,
 42618,
 -62150,
 221783076,
 42619,
 -1,
 221845023,
 42616,
 -1,
 221253185,
 7676,
 222104902,
 221192519,
 -1,
 222170433,
 222040720,
 -1,
 -62145,
 222115168,
 128533,
 -62144,
 222176814,
 128534,
 -1,
 222237099,
 127882,
 222432580,
 222113702,
 -1,
 -62141,
 222378165,
 128119,
 -1,
 222440927,
 128679,
 -62139,
 222377469,
 127978,
 -1,
 222573273,
 983186,
 222760267,
 222045135,
 -1,
 222825802,
 222697277,
 -1,
 -62135,
 222765541,
 127859,
 -1,
 222826305,
 127850,
 -1,
 222760892,
 127834,
 223087949,
 222705365,
 128004,
 -1,
 223019135,
 128046,
 223219024,
 223029342,
 -1,
 -62129,
 223161946,
 11507,
 -1,
 223218024,
 11506,
 -62127,
 223163642,
 128145,
 -62126,
 223354527,
 128165,
 -1,
 223415055,
 127864,
 223612261,
 221119302,
 -1,
 223677785,
 223555619,
 128008,
 223805439,
 223608959,
 128049,
 223870975,
 223674752,
 -1,
 -62120,
 223754428,
 128572,
 -1,
 223817992,
 128569,
 224005470,
 223619368,
 -1,
 -62117,
 223947498,
 983073,
 -62116,
 224011930,
 127887,
 -62115,
 224077382,
 127904,
 -1,
 224136428,
 128199,
 224333154,
 223945031,
 983098,
 224398689,
 224266769,
 983097,
 -1,
 224329810,
 983170,
 -1,
 224333615,
 127852,
 -62109,
 224272571,
 128247,
 -62108,
 224533917,
 128197,
 -1,
 224595071,
 127797,
 224791927,
 223553832,
 983074,
 224857455,
 224731928,
 -1,
 224922989,
 224800557,
 -1,
 224988524,
 224854016,
 -1,
 225054059,
 224929747,
 128322,
 -1,
 224985661,
 128321,
 -1,
 224993246,
 10060,
 -1,
 224923571,
 127884,
 -62098,
 224868415,
 128081,
 -1,
 225250129,
 128010,
 225447284,
 224803091,
 -1,
 225512819,
 225384704,
 -1,
 -62094,
 225448600,
 128546,
 -1,
 225511849,
 128575,
 -1,
 225455985,
 128302,
 225837055,
 225382209,
 -1,
 -62090,
 225717521,
 127769,
 -1,
 225775073,
 128179,
 225971585,
 224728893,
 -1,
 226037119,
 225913358,
 -1,
 226102654,
 225975624,
 -1,
 226168189,
 226039788,
 -1,
 -62084,
 226103078,
 127568,
 -1,
 226167286,
 127569,
 -1,
 226102361,
 128320,
 -1,
 226047320,
 127914,
 -62080,
 225981240,
 127750,
 -1,
 226435548,
 127910,
 226626954,
 225917203,
 -1,
 226692489,
 226569115,
 -1,
 226758022,
 226635340,
 -1,
 -62075,
 226700716,
 1319,
 -1,
 226765495,
 42593,
 227016703,
 226691416,
 -1,
 -62072,
 226897324,
 1318,
 -1,
 226962103,
 42592,
 -1,
 226626346,
 127744,
 227216787,
 226571080,
 -1,
 227282320,
 227158312,
 -1,
 227347855,
 227223848,
 -1,
 -62066,
 227293461,
 127835,
 -1,
 227348592,
 128177,
 -1,
 227286873,
 10160,
 227672063,
 227225426,
 -1,
 -62062,
 227550256,
 128707,
 -1,
 227608081,
 127854,
 227806614,
 227154634,
 -1,
 -62059,
 227742352,
 64047,
 -1,
 227807041,
 64046,
 -62057,
 227749326,
 983187,
 -62056,
 227939628,
 983200,
 -1,
 228002344,
 983171,
 228200014,
 209593997,
 -1,
 228265452,
 228138069,
 -1,
 228330986,
 228198134,
 -1,
 228396460,
 228274211,
 -1,
 228461986,
 228341878,
 -1,
 -62049,
 228404981,
 127138,
 -62048,
 228464208,
 127154,
 -62047,
 228527525,
 127170,
 -1,
 228592459,
 127186,
 228789671,
 228398878,
 -1,
 -62044,
 228732661,
 127139,
 -62043,
 228791888,
 127155,
 -62042,
 228855205,
 127171,
 -1,
 228920139,
 127187,
 229179391,
 228724825,
 -1,
 -62039,
 229060341,
 127146,
 -62038,
 229119568,
 127162,
 -62037,
 229182885,
 127178,
 -1,
 229247819,
 127194,
 229445047,
 228338834,
 -1,
 229510578,
 229382733,
 -1,
 -62033,
 229453557,
 127142,
 -62032,
 229512784,
 127158,
 -62031,
 229576101,
 127174,
 -1,
 229641035,
 127190,
 229900287,
 229446204,
 -1,
 -62028,
 229781237,
 127143,
 -62027,
 229840464,
 127159,
 -62026,
 229903781,
 127175,
 -1,
 229968715,
 127191,
 230165954,
 229382917,
 -1,
 230231485,
 230105584,
 -1,
 -62022,
 230174453,
 127148,
 -62021,
 230233680,
 127164,
 -62020,
 230296997,
 127180,
 -1,
 230361931,
 127196,
 230621183,
 230168871,
 -1,
 -62017,
 230502133,
 127150,
 -62016,
 230561360,
 127166,
 -62015,
 230624677,
 127182,
 -1,
 230689611,
 127198,
 230886861,
 230101648,
 -1,
 230952392,
 230827582,
 -1,
 -62011,
 230895349,
 127140,
 -62010,
 230954576,
 127156,
 -62009,
 231017893,
 127172,
 -1,
 231082827,
 127188,
 231342079,
 230890025,
 -1,
 -62006,
 231223029,
 127141,
 -62005,
 231282256,
 127157,
 -62004,
 231345573,
 127173,
 -1,
 231410507,
 127189,
 231607762,
 230828265,
 -1,
 -62001,
 231550709,
 127149,
 -62000,
 231609936,
 127165,
 -61999,
 231673253,
 127181,
 -1,
 231738187,
 127197,
 231935447,
 231547391,
 -1,
 -61996,
 231878389,
 127145,
 -61995,
 231937616,
 127161,
 -61994,
 232000933,
 127177,
 -1,
 232065867,
 127193,
 232263132,
 231873142,
 -1,
 -61991,
 232206069,
 127147,
 -61990,
 232265296,
 127163,
 -61989,
 232328613,
 127179,
 -1,
 232393547,
 127195,
 232590817,
 232198155,
 -1,
 -61986,
 232533749,
 127144,
 -61985,
 232592976,
 127160,
 -61984,
 232656293,
 127176,
 -1,
 232721227,
 127192,
 232918502,
 232522686,
 -1,
 -61981,
 232861429,
 127137,
 -61980,
 232920656,
 127153,
 -61979,
 232983973,
 127169,
 -1,
 233048907,
 127185,
 233246185,
 232851202,
 -1,
 -61976,
 233184393,
 127183,
 -1,
 233243590,
 127136,
 -1,
 233191268,
 127199,
 -61973,
 228275016,
 983150,
 -1,
 233442519,
 983147,
 233639425,
 228197190,
 -1,
 233704948,
 233581664,
 -1,
 233770483,
 233641840,
 -1,
 -61968,
 233714822,
 983149,
 -61967,
 233771949,
 983145,
 -61966,
 233836141,
 983146,
 -1,
 233899797,
 983148,
 -1,
 233716017,
 127881,
 234163705,
 233641047,
 -1,
 234229240,
 234094592,
 -1,
 -61961,
 234174377,
 128195,
 -1,
 234230440,
 128196,
 -1,
 234170664,
 128223,
 234491387,
 234097879,
 983121,
 -1,
 234425801,
 983120,
 -61956,
 234436331,
 128062,
 -61955,
 234565443,
 128706,
 -61954,
 234628893,
 128206,
 -61953,
 234693014,
 128060,
 -61952,
 234757817,
 127796,
 -1,
 234818303,
 128230,
 235015704,
 233574209,
 -1,
 235081232,
 234957096,
 -1,
 235146767,
 235023506,
 -1,
 235212302,
 235086900,
 -1,
 235277837,
 235143168,
 -1,
 235343370,
 235222947,
 -1,
 -61944,
 235284484,
 128590,
 -61943,
 235344758,
 128591,
 -1,
 235407400,
 128113,
 -61941,
 235284910,
 128588,
 -61940,
 235541450,
 128589,
 -1,
 235604056,
 128583,
 -1,
 235209918,
 128187,
 -1,
 235147845,
 128547,
 -1,
 235082649,
 127917,
 235998740,
 235020615,
 -1,
 -61934,
 235942059,
 9956,
 -61933,
 236006939,
 128532,
 -1,
 236066182,
 128039,
 236260887,
 235930438,
 -1,
 -61930,
 236202280,
 127824,
 -1,
 236259880,
 127825,
 -1,
 236195209,
 128694,
 236523050,
 234955544,
 -1,
 236588575,
 236467016,
 -1,
 236654109,
 236532223,
 -1,
 -61924,
 236589720,
 128545,
 -1,
 236652969,
 128574,
 -61922,
 236592958,
 127831,
 -1,
 236784168,
 128093,
 236981795,
 236527146,
 -1,
 237047330,
 236915093,
 128659,
 -1,
 236989607,
 128680,
 -1,
 236987289,
 128110,
 237243942,
 236924963,
 -1,
 -61915,
 237175708,
 128688,
 -1,
 237240623,
 127858,
 237440553,
 237186898,
 -1,
 -61912,
 237373542,
 128238,
 -1,
 237438154,
 128239,
 -1,
 237380489,
 128041,
 237702710,
 236459837,
 -1,
 237768239,
 237638653,
 128022,
 237895679,
 237699072,
 -1,
 -61906,
 237773438,
 128061,
 -1,
 237834904,
 128055,
 238030386,
 237707726,
 -1,
 -61903,
 237962732,
 127821,
 -1,
 238026852,
 127885,
 238226997,
 237968469,
 -1,
 -61900,
 238165077,
 128138,
 -1,
 238227284,
 128169,
 -1,
 238170003,
 128299,
 238489151,
 237646664,
 -1,
 238554682,
 238430504,
 -1,
 -61895,
 238497064,
 128091,
 -1,
 238561113,
 128156,
 -61893,
 238497851,
 128686,
 -61892,
 238693832,
 128204,
 -61891,
 238749704,
 128226,
 -61890,
 238813983,
 983167,
 -1,
 238879517,
 983164,
 239078988,
 238430504,
 -1,
 239144523,
 239015741,
 -1,
 239210058,
 239089070,
 -1,
 239275593,
 239153409,
 -1,
 239341126,
 239207107,
 -1,
 -61883,
 239272735,
 983166,
 -1,
 239338269,
 983163,
 239599615,
 239271936,
 -1,
 -61880,
 239481639,
 983165,
 -1,
 239543429,
 983162,
 -1,
 239209654,
 983192,
 -1,
 239149456,
 128120,
 -1,
 239079748,
 983228,
 -61875,
 239017825,
 983193,
 -1,
 239865234,
 983218,
 240062127,
 228139335,
 -1,
 240127633,
 239996737,
 -1,
 240193158,
 240063529,
 -1,
 240258668,
 240135972,
 -1,
 240324201,
 240196824,
 -1,
 -61868,
 240269753,
 127369,
 -61867,
 240335123,
 127368,
 -61866,
 240400588,
 127367,
 -61865,
 240465621,
 127366,
 -61864,
 240530860,
 127365,
 -61863,
 240595784,
 127364,
 -61862,
 240660515,
 127363,
 -61861,
 240725138,
 127362,
 -61860,
 240789800,
 127361,
 -61859,
 240855216,
 127360,
 -61858,
 240919320,
 127358,
 -61857,
 240984391,
 127357,
 -61856,
 241048325,
 127354,
 -61855,
 241112893,
 127352,
 -61854,
 241178001,
 127351,
 -61853,
 241243133,
 127350,
 -61852,
 241308304,
 127349,
 -61851,
 241372993,
 127348,
 -61850,
 241437911,
 127347,
 -61849,
 241502420,
 127346,
 -61848,
 241567490,
 127345,
 -1,
 241632070,
 127344,
 -61846,
 240269120,
 127375,
 -61845,
 241765454,
 10062,
 -1,
 241828726,
 127374,
 242028165,
 240192201,
 -1,
 -61842,
 241973689,
 127337,
 -61841,
 242039059,
 127336,
 -61840,
 242104524,
 127335,
 -61839,
 242169557,
 127334,
 -61838,
 242234796,
 127333,
 -61837,
 242299720,
 127332,
 -61836,
 242364451,
 127331,
 -61835,
 242429074,
 127330,
 -61834,
 242493736,
 127329,
 -61833,
 242559152,
 127328,
 -61832,
 242623256,
 127326,
 -61831,
 242688327,
 127325,
 -61830,
 242753377,
 127324,
 -61829,
 242818133,
 127323,
 -61828,
 242883333,
 127322,
 -61827,
 242948721,
 127321,
 -61826,
 243013437,
 127320,
 -61825,
 243078141,
 127318,
 -61824,
 243143312,
 127317,
 -61823,
 243208001,
 127316,
 -61822,
 243272919,
 127315,
 -61821,
 243337428,
 127314,
 -61820,
 243402498,
 127313,
 -1,
 243467078,
 127312,
 -1,
 241959887,
 983091,
 243732109,
 240137941,
 -1,
 243797644,
 243662848,
 -1,
 243863179,
 243736852,
 -1,
 -61814,
 243808179,
 127770,
 -1,
 243871732,
 127761,
 -1,
 243801680,
 983063,
 -1,
 243740412,
 128240,
 -61810,
 243677451,
 983130,
 -61809,
 244135318,
 128528,
 -61808,
 244194389,
 983131,
 -1,
 244255516,
 128084,
 244453025,
 240067352,
 -1,
 244518555,
 244383744,
 -1,
 244584086,
 244451074,
 -1,
 -61803,
 244525612,
 983126,
 -1,
 244586461,
 128691,
 -61801,
 244526784,
 128685,
 -61800,
 244721399,
 128695,
 -61799,
 244786342,
 128286,
 -61798,
 244850941,
 128245,
 -1,
 244912294,
 128683,
 245108383,
 244461603,
 -1,
 245173918,
 245043096,
 128211,
 -1,
 245105118,
 128212,
 -1,
 245107279,
 128323,
 -61792,
 245050664,
 128067,
 -1,
 245309791,
 128689,
 245501605,
 244396872,
 -1,
 245567140,
 245439573,
 983041,
 -1,
 245505109,
 983040,
 -1,
 245510184,
 128297,
 245763753,
 245433158,
 -1,
 -61785,
 245702687,
 128219,
 -61784,
 245766917,
 983092,
 -1,
 245831830,
 128133,
 246025900,
 245696258,
 -1,
 -61781,
 245968620,
 983196,
 -1,
 246027665,
 983127,
 -61779,
 245965195,
 983221,
 -61778,
 246160469,
 983066,
 -1,
 246224963,
 127747,
 246419227,
 240000085,
 -1,
 246484727,
 246350662,
 -1,
 246550244,
 246428154,
 -1,
 246615766,
 246492306,
 -1,
 246681293,
 246554573,
 -1,
 246746809,
 246623378,
 -1,
 246812344,
 246680234,
 -1,
 -61769,
 246748520,
 983617,
 -1,
 246809580,
 983618,
 -1,
 246743679,
 42921,
 247074492,
 246690584,
 -1,
 -61765,
 247010664,
 983615,
 -1,
 247071724,
 983616,
 247271103,
 247014683,
 -1,
 -61762,
 247207272,
 983613,
 -1,
 247268332,
 983614,
 247467714,
 247210327,
 -1,
 -61759,
 247407422,
 42917,
 -1,
 247467379,
 42897,
 247664325,
 247404267,
 -1,
 -61756,
 247600488,
 983619,
 -1,
 247661548,
 983620,
 247860936,
 247600125,
 -1,
 -61753,
 247797151,
 983199,
 -1,
 247857791,
 42913,
 -61751,
 247802161,
 42919,
 -61750,
 247995479,
 42894,
 -61749,
 248060739,
 42915,
 -61748,
 248121568,
 42899,
 -1,
 248185848,
 983612,
 248446975,
 246625208,
 -1,
 -61745,
 248328227,
 8348,
 -61744,
 248392850,
 8347,
 -61743,
 248456845,
 8346,
 -61742,
 248521031,
 8345,
 -61741,
 248586081,
 8344,
 -61740,
 248650837,
 8343,
 -61739,
 248716037,
 8342,
 -1,
 248780177,
 8341,
 248975075,
 246548824,
 -1,
 249040602,
 248914263,
 -1,
 -61735,
 248980286,
 42916,
 -1,
 249040243,
 42896,
 249237213,
 248976381,
 -1,
 -61732,
 249173407,
 983198,
 -1,
 249234047,
 42912,
 -61730,
 249180943,
 42893,
 -61729,
 249375936,
 42920,
 -61728,
 249440561,
 42918,
 -61727,
 249502531,
 42914,
 -61726,
 249566611,
 42922,
 -1,
 249628896,
 42898,
 -1,
 248913331,
 43002,
 249892589,
 246489882,
 -1,
 249958120,
 249830389,
 -1,
 -61721,
 249897742,
 3807,
 -1,
 249959739,
 3806,
 250154731,
 249893745,
 -1,
 -61718,
 250094644,
 983202,
 -1,
 250152682,
 983203,
 -61716,
 250096611,
 983204,
 -1,
 250289857,
 983205,
 250482419,
 249834185,
 -1,
 250547953,
 250415155,
 -1,
 -61712,
 250482077,
 128311,
 -1,
 250546882,
 128309,
 -61710,
 250489436,
 128308,
 -1,
 250684772,
 128310,
 250875638,
 250425184,
 -1,
 -61707,
 250820531,
 127772,
 -1,
 250884084,
 127767,
 -1,
 250810162,
 128030,
 251137795,
 246424344,
 -1,
 251203325,
 251071207,
 128274,
 251268860,
 251140452,
 -1,
 -61701,
 251214340,
 983079,
 -1,
 251274373,
 983076,
 -1,
 251200085,
 128271,
 251531008,
 251147723,
 -1,
 -61697,
 251469220,
 128140,
 -1,
 251533064,
 127977,
 -61695,
 251475671,
 128261,
 -61694,
 251671510,
 128557,
 -1,
 251731608,
 127853,
 251924237,
 251072321,
 -1,
 251989769,
 251859923,
 -1,
 252055304,
 251921091,
 -1,
 -61689,
 251996078,
 128269,
 -1,
 252057064,
 9958,
 -1,
 251986129,
 128709,
 -61686,
 251929860,
 128006,
 -61685,
 252256523,
 127819,
 -61684,
 252317077,
 128210,
 -1,
 252380245,
 127811,
 252579606,
 251860797,
 -1,
 252645140,
 252518727,
 -1,
 252710675,
 252579651,
 -1,
 252776210,
 252653728,
 983068,
 -1,
 252707166,
 983142,
 -1,
 252711657,
 983062,
 -1,
 252648250,
 128279,
 -61675,
 252586071,
 128132,
 -1,
 252974314,
 128648,
 253169434,
 252520744,
 -1,
 -61672,
 253109016,
 983219,
 -61671,
 253173601,
 983214,
 -1,
 253235009,
 983216,
 -1,
 253104784,
 983065,
 253497213,
 246353729,
 -1,
 253562698,
 253440035,
 -1,
 253628232,
 253499093,
 -1,
 253693765,
 253571025,
 -1,
 253759278,
 253627607,
 -1,
 253824807,
 253704633,
 -1,
 253890339,
 253759297,
 43797,
 -1,
 253824833,
 43796,
 -61660,
 253834056,
 43793,
 -61659,
 253960984,
 43798,
 -61658,
 254023485,
 43794,
 -1,
 254083932,
 43795,
 254345215,
 253758874,
 -1,
 254349098,
 254218049,
 43789,
 -1,
 254283585,
 43788,
 -61653,
 254292808,
 43785,
 -61652,
 254419736,
 43790,
 -61651,
 254482237,
 43786,
 -1,
 254542684,
 43787,
 254742326,
 253692412,
 -1,
 254807857,
 254676801,
 43813,
 -1,
 254742337,
 43812,
 254938931,
 254739270,
 43808,
 -1,
 254870342,
 43811,
 -61644,
 254882632,
 43809,
 -61643,
 255009560,
 43814,
 -1,
 255072061,
 43810,
 255266622,
 254674736,
 -1,
 255332153,
 255201089,
 43821,
 -1,
 255266625,
 43820,
 255463227,
 255263558,
 43816,
 -1,
 255394630,
 43819,
 -61636,
 255406920,
 43817,
 -61635,
 255533848,
 43822,
 -1,
 255596349,
 43818,
 255852543,
 255210235,
 -1,
 255856449,
 255725377,
 43781,
 -1,
 255790913,
 43780,
 -61630,
 255800136,
 43777,
 -61629,
 255927064,
 43782,
 -61628,
 255989565,
 43778,
 -1,
 256050012,
 43779,
 256311295,
 253627244,
 -1,
 -61625,
 256194219,
 4958,
 -1,
 256250982,
 4957,
 -61623,
 253573324,
 983047,
 -1,
 256378626,
 983096,
 256577370,
 253501767,
 -1,
 256642903,
 256511193,
 -1,
 256708438,
 256582545,
 -1,
 256773969,
 256651299,
 -1,
 256839504,
 256715221,
 983048,
 -1,
 256770086,
 983095,
 -1,
 256774782,
 983046,
 -61614,
 256716084,
 983134,
 -61613,
 256976968,
 983178,
 -61612,
 257040450,
 983099,
 -61611,
 257105488,
 983064,
 -1,
 257168761,
 983177,
 -1,
 256653276,
 128282,
 257429337,
 256583856,
 983051,
 -1,
 257373197,
 983050,
 -1,
 257373659,
 128233,
 257625955,
 256509429,
 128066,
 257691488,
 257569112,
 -1,
 257757023,
 257622854,
 -1,
 -61602,
 257699281,
 127759,
 -1,
 257761472,
 127758,
 -1,
 257692193,
 127757,
 258080767,
 257622301,
 -1,
 -61598,
 257960702,
 127806,
 -1,
 258023346,
 127805,
 258215785,
 257563949,
 -1,
 258281320,
 258149490,
 -1,
 -61594,
 258224712,
 128294,
 -61593,
 258287499,
 128268,
 -1,
 258350661,
 128161,
 -1,
 258221873,
 128024,
 258609005,
 258157714,
 -1,
 258674540,
 258541780,
 983104,
 -1,
 258606550,
 983103,
 -1,
 258605894,
 983135,
 258871153,
 258548504,
 -1,
 -61585,
 258813987,
 983049,
 -61584,
 258875233,
 983100,
 -1,
 258939989,
 983067,
 259133300,
 258816337,
 -1,
 -61581,
 259075218,
 128064,
 -1,
 259134767,
 128083,
 259329911,
 259078348,
 -1,
 -61578,
 259273325,
 128125,
 -1,
 259336246,
 128529,
 259526522,
 259274063,
 -1,
 -61575,
 259467245,
 127972,
 -1,
 259525026,
 127984,
 -61573,
 259470860,
 127794,
 -61572,
 259663537,
 983179,
 -1,
 259719911,
 128231,
 259919826,
 253438248,
 -1,
 259985317,
 259854145,
 -1,
 260050842,
 259921164,
 -1,
 -61567,
 259996089,
 127487,
 -61566,
 260061459,
 127486,
 -61565,
 260126924,
 127485,
 -61564,
 260191957,
 127484,
 -61563,
 260257196,
 127483,
 -61562,
 260322120,
 127482,
 -61561,
 260386851,
 127481,
 -61560,
 260451474,
 127480,
 -61559,
 260516136,
 127479,
 -61558,
 260581552,
 127478,
 -61557,
 260646541,
 127477,
 -61556,
 260711192,
 127476,
 -61555,
 260776263,
 127475,
 -61554,
 260841313,
 127474,
 -61553,
 260906069,
 127473,
 -61552,
 260971269,
 127472,
 -61551,
 261036657,
 127471,
 -61550,
 261101373,
 127470,
 -61549,
 261166481,
 127469,
 -61548,
 261231613,
 127468,
 -61547,
 261296784,
 127467,
 -61546,
 261361473,
 127466,
 -61545,
 261426391,
 127465,
 -61544,
 261490900,
 127464,
 -61543,
 261555970,
 127463,
 -1,
 261620550,
 127462,
 261820319,
 259995052,
 -1,
 261885854,
 261755187,
 -1,
 -61539,
 261824085,
 983151,
 -1,
 261888241,
 983152,
 -1,
 261825541,
 128158,
 262148002,
 261753044,
 -1,
 -61535,
 262089270,
 128665,
 -1,
 262153592,
 983112,
 -61533,
 262090655,
 128699,
 -61532,
 262282809,
 128524,
 -1,
 262343900,
 127822,
 262541239,
 259916614,
 -1,
 262606769,
 262477629,
 -1,
 262672303,
 262548783,
 -1,
 262737835,
 262610785,
 -1,
 -61526,
 262671604,
 127339,
 -1,
 262736089,
 127338,
 -61524,
 262673891,
 9995,
 -61523,
 262869848,
 9994,
 -61522,
 262934021,
 11827,
 -1,
 262998927,
 11828,
 -61520,
 262611334,
 127752,
 -1,
 263135053,
 128643,
 263327667,
 262540760,
 128251,
 -1,
 263258157,
 128280,
 263458741,
 263259955,
 128007,
 -1,
 263389311,
 128048,
 -61514,
 263401507,
 128000,
 -1,
 263528289,
 128015,
 263720895,
 262480664,
 -1,
 -61511,
 263665466,
 128675,
 -61510,
 263730264,
 128205,
 -61509,
 263793960,
 127801,
 -61508,
 263857570,
 128019,
 -61507,
 263921275,
 127906,
 -61506,
 263981834,
 128640,
 -1,
 264046177,
 127840,
 264245192,
 263657277,
 983153,
 264310723,
 264180979,
 -1,
 -61502,
 264251310,
 128270,
 -1,
 264312296,
 9957,
 264507334,
 264243716,
 -1,
 -61499,
 264440851,
 127832,
 -1,
 264505126,
 127833,
 -61497,
 264446437,
 128141,
 -1,
 264636216,
 127872,
 264835021,
 264188744,
 -1,
 264900556,
 264774190,
 -1,
 -61493,
 264837441,
 127933,
 -1,
 264900814,
 127939,
 -1,
 264836167,
 127945,
 265162705,
 264772693,
 -1,
 -61489,
 265102104,
 983220,
 -61488,
 265166689,
 983215,
 -1,
 265228097,
 983217,
 -1,
 265104530,
 983113,
 265490476,
 259857157,
 -1,
 265555982,
 265426661,
 -1,
 265621508,
 265489345,
 -1,
 265687006,
 265564195,
 -1,
 265752537,
 265630037,
 -1,
 -61480,
 265691928,
 983929,
 -1,
 265749318,
 983927,
 265949148,
 265688465,
 -1,
 -61477,
 265888536,
 983934,
 -1,
 265945926,
 983932,
 -61475,
 265888536,
 983933,
 -1,
 266076998,
 983931,
 266276835,
 265625927,
 -1,
 -61472,
 266222006,
 983925,
 -61471,
 266281752,
 983935,
 -61470,
 266343739,
 983920,
 -1,
 266404678,
 983930,
 266604521,
 266214149,
 -1,
 266670055,
 266540433,
 -1,
 -61466,
 266609432,
 983919,
 -1,
 266666822,
 983917,
 -61464,
 266609432,
 983918,
 -1,
 266797894,
 983916,
 266997743,
 266537172,
 -1,
 267063277,
 266933649,
 -1,
 -61460,
 267002648,
 983924,
 -1,
 267060038,
 983922,
 -61458,
 267002648,
 983923,
 -1,
 267191110,
 983921,
 267390963,
 266939538,
 -1,
 -61455,
 267332822,
 983946,
 -61454,
 267392415,
 983945,
 -1,
 267453254,
 983947,
 267653112,
 267331213,
 -1,
 267718647,
 267589009,
 -1,
 -61450,
 267658008,
 983939,
 -1,
 267715398,
 983937,
 -1,
 267658008,
 983938,
 267980795,
 267590741,
 -1,
 -61446,
 267920152,
 983943,
 -1,
 267977542,
 983949,
 268177406,
 267914455,
 -1,
 -61443,
 268116760,
 983928,
 -1,
 268174150,
 983926,
 -61441,
 268122550,
 983941,
 -61440,
 268318337,
 983944,
 -61439,
 268381155,
 983942,
 -61438,
 268443898,
 983940,
 -61437,
 268506527,
 983948,
 -1,
 268568327,
 983936,
 268767242,
 265558227,
 -1,
 268832775,
 268708999,
 983952,
 -1,
 268777747,
 983953,
 269025279,
 268773552,
 -1,
 -61431,
 268907336,
 983951,
 -1,
 268963649,
 983954,
 269221887,
 268711613,
 -1,
 -61428,
 269100051,
 983955,
 -61427,
 269159256,
 983950,
 -1,
 269222751,
 983956,
 269422623,
 265487174,
 -1,
 269488158,
 269365454,
 -1,
 269553686,
 269420475,
 -1,
 -61422,
 269497160,
 983964,
 -61421,
 269558552,
 983966,
 -61420,
 269621053,
 983963,
 -61419,
 269684545,
 983965,
 -1,
 269747014,
 983962,
 270008319,
 269484870,
 -1,
 270012445,
 269883776,
 -1,
 270077979,
 269955107,
 -1,
 -61414,
 270021448,
 983968,
 -1,
 270082840,
 983969,
 -61412,
 270018189,
 983970,
 -1,
 270207489,
 983967,
 -1,
 269953561,
 110592,
 -1,
 269427253,
 983201,
 270536745,
 269358909,
 -1,
 270602280,
 270479149,
 128143,
 270667815,
 270539008,
 -1,
 270733350,
 270602904,
 128535,
 270860287,
 270664064,
 -1,
 -61403,
 270741171,
 128537,
 -1,
 270797616,
 128538,
 -1,
 270666177,
 128573,
 -1,
 270598378,
 128139,
 -1,
 270541071,
 128088,
 271192107,
 270471817,
 128273,
 -1,
 271124794,
 128287,
 -1,
 271131435,
 128040,
 271388796,
 265425552,
 -1,
 271454282,
 271319878,
 -1,
 271519814,
 271386836,
 -1,
 271585349,
 271454019,
 -1,
 271650880,
 271529886,
 -1,
 271716415,
 271581184,
 -1,
 271781942,
 271658929,
 128539,
 271908863,
 271712258,
 -1,
 -61387,
 271792012,
 128540,
 -1,
 271856097,
 128541,
 272044090,
 271721240,
 -1,
 272109625,
 271984387,
 128558,
 -1,
 272039944,
 128560,
 -1,
 272046867,
 128582,
 -61381,
 271986952,
 128514,
 -61380,
 272245353,
 128581,
 -61379,
 272310325,
 128567,
 -61378,
 272375515,
 128548,
 -1,
 272436065,
 128531,
 -1,
 271656534,
 128566,
 272699459,
 271592594,
 -1,
 -61374,
 272632859,
 128561,
 -1,
 272697039,
 128523,
 -61372,
 272642487,
 128536,
 -1,
 272834542,
 128134,
 -1,
 271528531,
 127981,
 -61369,
 271464654,
 128224,
 -61368,
 273035641,
 127877,
 -61367,
 273096938,
 128106,
 -1,
 273161841,
 127810,
 273354844,
 271390525,
 -1,
 273420372,
 273295656,
 -1,
 273485905,
 273354561,
 128293,
 273551440,
 273430704,
 -1,
 -61361,
 273493138,
 127878,
 -1,
 273547626,
 127879,
 -1,
 273481840,
 128658,
 273874943,
 273428320,
 -1,
 -61357,
 273758131,
 127771,
 -1,
 273821684,
 127763,
 274010201,
 273362066,
 -1,
 274075736,
 273946001,
 128031,
 -61353,
 274012463,
 127907,
 -1,
 274071605,
 127845,
 -1,
 274018581,
 128074,
 274399231,
 273947952,
 -1,
 -61349,
 274279756,
 983106,
 -1,
 274338691,
 128193,
 274534499,
 273295656,
 -1,
 274600033,
 274473752,
 -1,
 -61345,
 274544719,
 128550,
 -61344,
 274604732,
 128037,
 -1,
 274666495,
 128056,
 -61342,
 274536440,
 127844,
 -1,
 274796645,
 127839,
 274993258,
 274473752,
 -1,
 275058791,
 274934056,
 -1,
 -61338,
 274997091,
 983071,
 -1,
 275061511,
 127860,
 -61336,
 275002664,
 127808,
 -61335,
 275195364,
 128099,
 -1,
 275256509,
 127745,
 275452016,
 274930773,
 -1,
 275517550,
 275391256,
 -1,
 -61331,
 275461964,
 127924,
 -1,
 275523601,
 128190,
 -61329,
 275461482,
 128563,
 -1,
 275649138,
 128170,
 275845236,
 275396297,
 -1,
 -61326,
 275776293,
 983209,
 -61325,
 275841823,
 983208,
 -1,
 275907357,
 983207,
 276107383,
 275788843,
 -1,
 -61322,
 276051891,
 127773,
 -1,
 276115444,
 127765,
 276303994,
 276041537,
 -1,
 -61319,
 276245573,
 127905,
 -1,
 276301341,
 128552,
 -61317,
 276245650,
 983107,
 -1,
 276435600,
 983072,
 276631755,
 271324561,
 -1,
 276697237,
 276570904,
 -1,
 276762761,
 276637992,
 -1,
 276828293,
 276699751,
 -1,
 276893828,
 276759476,
 983059,
 277020671,
 276824064,
 -1,
 -61309,
 276903881,
 983140,
 -1,
 276966768,
 983137,
 -1,
 276834682,
 128677,
 277282815,
 276770088,
 128014,
 277348351,
 277151744,
 -1,
 -61304,
 277227881,
 127943,
 -1,
 277287576,
 128052,
 277483662,
 276706120,
 -1,
 277549197,
 277425451,
 -1,
 -61300,
 277493693,
 127969,
 -1,
 277547166,
 127968,
 -1,
 277490382,
 9203,
 277811345,
 277422561,
 -1,
 -61296,
 277743442,
 128029,
 -1,
 277807440,
 127855,
 -61294,
 277754151,
 127976,
 -61293,
 277950223,
 127973,
 -61292,
 278013581,
 983123,
 -1,
 278071960,
 128298,
 278270122,
 276631361,
 -1,
 278335656,
 278201158,
 -1,
 278401184,
 278279889,
 -1,
 278466715,
 278339313,
 -1,
 -61286,
 278408694,
 10079,
 -1,
 278466076,
 10080,
 278663326,
 278400215,
 -1,
 -61283,
 278602746,
 128178,
 -1,
 278665789,
 10135,
 -61281,
 278603664,
 10133,
 -1,
 278798575,
 10134,
 278991015,
 278341928,
 -1,
 279056550,
 278933541,
 -1,
 279122085,
 279000995,
 -1,
 -61276,
 279063287,
 128157,
 -1,
 279119424,
 128152,
 -1,
 279055700,
 128159,
 -1,
 278987508,
 128585,
 -1,
 278925040,
 127911,
 -61271,
 278276619,
 127807,
 -1,
 279453232,
 128641,
 279646396,
 278206269,
 -1,
 279711923,
 279587207,
 -1,
 279777458,
 279644091,
 -1,
 -61266,
 279720776,
 983959,
 -61265,
 279782168,
 983961,
 -61264,
 279844669,
 983958,
 -61263,
 279908161,
 983960,
 -1,
 279970630,
 983957,
 -1,
 279709190,
 110593,
 280236219,
 279647425,
 -1,
 280301752,
 280167107,
 -1,
 280367287,
 280243971,
 128644,
 -1,
 280297863,
 128645,
 -1,
 280303208,
 128096,
 280625151,
 280231936,
 -1,
 -61254,
 280503146,
 983122,
 -1,
 280561792,
 128262,
 -1,
 280168411,
 127802,
 280826053,
 279577414,
 -1,
 280891585,
 280764257,
 -1,
 -61249,
 280833915,
 128057,
 -61248,
 280895661,
 128296,
 -1,
 280955060,
 127828,
 -61246,
 280834278,
 128035,
 -61245,
 281094170,
 128587,
 -61244,
 281158068,
 128092,
 -1,
 281221557,
 128135,
 281415880,
 280768547,
 983060,
 -61241,
 281357458,
 983138,
 -1,
 281418353,
 983141,
 281673727,
 281359176,
 -1,
 -61238,
 281554333,
 128559,
 -1,
 281616826,
 128175,
 281809176,
 276565207,
 -1,
 281874667,
 281743169,
 -1,
 281940198,
 281818540,
 -1,
 282005727,
 281871682,
 -1,
 282071255,
 281949885,
 -1,
 282136787,
 282014536,
 -1,
 -61230,
 282080231,
 2391,
 -1,
 282136385,
 2390,
 282333398,
 282075928,
 -1,
 -61227,
 282272654,
 2363,
 -1,
 282332993,
 2362,
 -1,
 282265319,
 2383,
 282656767,
 282009003,
 -1,
 282661083,
 282538824,
 -1,
 -61222,
 282604519,
 2423,
 -1,
 282660673,
 2422,
 282857694,
 282600216,
 -1,
 -61219,
 282796942,
 2420,
 -1,
 282857281,
 2419,
 -1,
 282789607,
 2421,
 283181055,
 281941903,
 -1,
 283185379,
 283062307,
 -1,
 -61214,
 283129962,
 983085,
 -1,
 283186958,
 983087,
 -61212,
 283127704,
 983160,
 -61211,
 283321477,
 983083,
 -1,
 283382709,
 983089,
 283578601,
 281877589,
 983119,
 -61208,
 283515441,
 128666,
 -1,
 283578772,
 983118,
 -61206,
 283518689,
 127980,
 -1,
 283708085,
 127795,
 283906295,
 281813784,
 -1,
 283971823,
 283850818,
 -1,
 -61202,
 283913877,
 128317,
 -1,
 283978352,
 128315,
 284168434,
 283915080,
 -1,
 -61199,
 284103904,
 127849,
 -1,
 284166137,
 10175,
 284365044,
 284103677,
 128021,
 -1,
 284295295,
 128054,
 -61195,
 284304731,
 128682,
 -61194,
 284434211,
 128044,
 -1,
 284492034,
 128687,
 284692736,
 283842365,
 -1,
 284758267,
 284637715,
 -1,
 -61190,
 284700660,
 128171,
 -1,
 284758680,
 128565,
 284954878,
 284699900,
 -1,
 -61187,
 284889752,
 128542,
 -1,
 284952767,
 128549,
 -61185,
 284895827,
 127919,
 -1,
 285082892,
 128160,
 285282569,
 284623686,
 -1,
 285348100,
 285221191,
 -1,
 -61181,
 285283643,
 127841,
 -1,
 285346340,
 128131,
 285544711,
 285283506,
 -1,
 -61178,
 285485873,
 11831,
 -1,
 285547863,
 11830,
 -61176,
 285487249,
 983081,
 -1,
 285683082,
 128168,
 285872400,
 285223208,
 -1,
 285937933,
 285811480,
 -1,
 -61172,
 285878124,
 128167,
 -1,
 285941800,
 128042,
 286134543,
 285869193,
 128009,
 -1,
 286064767,
 128050,
 -1,
 286069120,
 128087,
 286331158,
 285804756,
 -1,
 -61166,
 286272658,
 983161,
 -61165,
 286327591,
 983090,
 -61164,
 286393125,
 983088,
 -61163,
 286458655,
 983086,
 -1,
 286524189,
 983084,
 -61161,
 286275013,
 128192,
 -1,
 286661933,
 983082,
 286855501,
 281753301,
 -1,
 286920997,
 286791057,
 -1,
 286986532,
 286857760,
 -1,
 -61156,
 286930057,
 128070,
 -61155,
 286994198,
 128307,
 -61154,
 287058749,
 128073,
 -61153,
 287123725,
 10068,
 -61152,
 287186274,
 128072,
 -61151,
 287250007,
 9989,
 -61150,
 287314794,
 128174,
 -61149,
 287380056,
 10069,
 -1,
 287444594,
 128071,
 -1,
 286917842,
 128011,
 287707441,
 286860056,
 -1,
 287772975,
 287645537,
 -1,
 287838510,
 287704374,
 128105,
 287904045,
 287779988,
 -1,
 -61142,
 287845621,
 128097,
 -61141,
 287905321,
 128082,
 -61140,
 287968067,
 128090,
 -1,
 288032843,
 128098,
 -1,
 287834521,
 128111,
 -1,
 287772819,
 128698,
 -61136,
 287714362,
 128543,
 -1,
 288300536,
 128058,
 288493887,
 287638342,
 -1,
 288559416,
 288436539,
 -1,
 288624951,
 288489472,
 -1,
 -61131,
 288569093,
 127754,
 -61130,
 288623420,
 128702,
 -1,
 288688278,
 128003,
 -1,
 288563332,
 127817,
 288952635,
 288504061,
 -1,
 -61126,
 288888056,
 127764,
 -1,
 288951353,
 127762,
 289149246,
 288891400,
 -1,
 -61123,
 289084664,
 127766,
 -1,
 289147961,
 127768,
 -1,
 289093213,
 128075,
 289411397,
 288427841,
 -1,
 289476931,
 289343057,
 -1,
 -61118,
 289411736,
 128553,
 -1,
 289474985,
 128576,
 -61116,
 289413139,
 983224,
 -1,
 289606990,
 128146,
 289804617,
 289347782,
 -1,
 -61113,
 289741830,
 128521,
 -61112,
 289804102,
 127863,
 -1,
 289869028,
 127888,
 290066764,
 289745192,
 -1,
 -61109,
 290000992,
 128295,
 -1,
 290063838,
 127873,
 -1,
 290003569,
 983223,
 290328951,
 286794520,
 -1,
 290394459,
 290268813,
 -1,
 290459993,
 290328385,
 -1,
 290525528,
 290398537,
 -1,
 290591060,
 290463652,
 -1,
 -61101,
 290531746,
 128236,
 -1,
 290594582,
 128237,
 -61099,
 290528964,
 128275,
 -61098,
 290723332,
 128080,
 -61097,
 290788142,
 128194,
 -1,
 290850886,
 128214,
 -1,
 290466273,
 983190,
 -61094,
 290402762,
 128191,
 -1,
 291051229,
 9934,
 291246438,
 290335016,
 -1,
 291311973,
 291183188,
 -1,
 291377506,
 291251337,
 -1,
 -61089,
 291319333,
 2933,
 -61088,
 291383512,
 2930,
 -61087,
 291444172,
 2931,
 -1,
 291508245,
 2934,
 291766271,
 291320222,
 -1,
 -61084,
 291647023,
 2935,
 -1,
 291711200,
 2932,
 -1,
 291243372,
 128217,
 291967341,
 291184967,
 -1,
 292032876,
 291900279,
 -1,
 -61079,
 291975393,
 128662,
 -61078,
 292038600,
 128660,
 -61077,
 292096187,
 128653,
 -1,
 292161211,
 128664,
 -1,
 291963391,
 128283,
 292426096,
 291904792,
 -1,
 -61073,
 292370557,
 128117,
 -1,
 292429786,
 128116,
 -61071,
 292370636,
 128002,
 -61070,
 292566405,
 128228,
 -61069,
 292629774,
 983191,
 -61068,
 292690717,
 128076,
 -61067,
 292754207,
 127970,
 -61066,
 292818271,
 127842,
 -1,
 292883558,
 128025,
 293081507,
 290264061,
 -1,
 293147017,
 293021992,
 -1,
 293212543,
 293082941,
 -1,
 293278078,
 293151303,
 -1,
 293343613,
 293212824,
 128512,
 -1,
 293274260,
 128513,
 -1,
 293276123,
 128568,
 -1,
 293216142,
 128556,
 293605763,
 293146584,
 -1,
 -61055,
 293541432,
 128154,
 -61054,
 293603398,
 128215,
 -1,
 293668332,
 127823,
 293867910,
 293544728,
 -1,
 -61051,
 293812087,
 128151,
 -1,
 293876900,
 983109,
 294125567,
 293798726,
 -1,
 -61048,
 294004517,
 127815,
 -1,
 294063882,
 127891,
 294261143,
 293080897,
 -1,
 294326678,
 294200714,
 -1,
 294392208,
 294264235,
 -1,
 -61043,
 294335316,
 983915,
 -61042,
 294395005,
 4351,
 -61041,
 294458911,
 4350,
 -1,
 294519837,
 4349,
 294719891,
 294334028,
 -1,
 -61038,
 294664627,
 11559,
 -1,
 294716445,
 11565,
 294977535,
 294652248,
 -1,
 -61035,
 294861235,
 4295,
 -1,
 294913053,
 4301,
 -1,
 294264695,
 128142,
 295178651,
 294204232,
 -1,
 -61031,
 295115399,
 2800,
 -61030,
 295180827,
 127928,
 -1,
 295241237,
 128130,
 295440798,
 295116481,
 -1,
 -61027,
 295384962,
 127775,
 -1,
 295438144,
 127760,
 -61025,
 295382162,
 983110,
 -61024,
 295576372,
 128016,
 -61023,
 295639483,
 128103,
 -61022,
 295704323,
 128123,
 -1,
 295765234,
 127922,
 295965117,
 293017405,
 -1,
 296030650,
 295903559,
 -1,
 296096172,
 295970976,
 -1,
 296161706,
 296033489,
 -1,
 -61016,
 296103541,
 128289,
 -61015,
 296164826,
 128292,
 -1,
 296225157,
 128288,
 -61013,
 296103963,
 128291,
 -1,
 296362746,
 128290,
 296554932,
 296031118,
 -1,
 296620467,
 296496470,
 -1,
 296686001,
 296562723,
 -1,
 -61008,
 296630378,
 983111,
 -1,
 296687374,
 983108,
 -61006,
 296625285,
 983114,
 -1,
 296817589,
 983105,
 -1,
 296553853,
 128129,
 297079223,
 296488151,
 983129,
 -61002,
 297015162,
 8377,
 -1,
 297079381,
 983128,
 -61000,
 297023002,
 9959,
 -60999,
 297208703,
 128232,
 -1,
 297273450,
 128229,
 -60997,
 295975362,
 127982,
 -60996,
 297410842,
 128127,
 -1,
 297470472,
 127848,
 297669064,
 295901809,
 -1,
 297734599,
 297599814,
 -1,
 297800134,
 297674451,
 -1,
 -60991,
 297742331,
 128304,
 -60990,
 297805805,
 127971,
 -60989,
 297870263,
 128121,
 -60988,
 297932094,
 128122,
 -60987,
 297995775,
 127886,
 -1,
 298060194,
 127983,
 -1,
 297732850,
 127875,
 -1,
 297668476,
 128086,
 298389968,
 297612104,
 -1,
 298455500,
 298329765,
 -1,
 -60981,
 298397333,
 128316,
 -1,
 298461808,
 128314,
 298652111,
 298393927,
 -1,
 -60978,
 298588677,
 983115,
 -1,
 298648874,
 128530,
 -1,
 298593426,
 983116,
 298914262,
 298334729,
 -1,
 298979796,
 298852679,
 -1,
 -60973,
 298916465,
 983212,
 -1,
 298977426,
 983247,
 -60971,
 298921708,
 983211,
 -1,
 299113073,
 983213,
 299368447,
 298858771,
 -1,
 -60968,
 299243350,
 983227,
 -1,
 299307055,
 128155]
_charnames_2112 = [
2459,
2453,
2451,
2452,
2450,
2457,
2442,
2455,
2439,
2441,
2440,
2448,
2447,
2446,
2435,
2456,
2445,
2436,
2444,
2443,
2437,
2438,
2460,
2458,
2449,
2464,
2461,
2463,
-1,
-1,
2462,
]

_charnames_2208 = [
1897,
-1,
1895,
1890,
1896,
1891,
1893,
1892,
1884,
1885,
1888,
1889,
1887,
]

_charnames_2276 = [
1914,
1916,
1912,
1915,
1917,
1913,
1907,
1904,
1910,
1906,
1903,
1909,
1924,
1925,
1923,
1879,
1931,
1932,
1934,
1900,
1919,
1899,
1921,
1927,
1928,
1920,
1929,
]

_charnames_2383 = [
4310,
-1,
-1,
-1,
-1,
-1,
-1,
4306,
4305,
]

_charnames_4295 = [
4500,
-1,
-1,
-1,
-1,
-1,
4501,
]

_charnames_7098 = [
2778,
2771,
2772,
2773,
2770,
2769,
865,
834,
860,
832,
848,
864,
857,
850,
829,
842,
847,
853,
826,
851,
861,
833,
858,
862,
855,
828,
844,
830,
835,
839,
836,
827,
846,
852,
825,
840,
856,
831,
838,
863,
841,
849,
859,
854,
884,
872,
874,
873,
876,
871,
875,
870,
867,
868,
889,
890,
887,
886,
]

_charnames_7360 = [
2761,
2760,
2759,
2765,
2762,
2763,
2764,
2766,
]

_charnames_8341 = [
3797,
3796,
3795,
3794,
3793,
3792,
3791,
3790,
]

_charnames_9193 = [
1080,
1083,
1085,
1088,
1081,
1084,
1082,
2105,
2813,
1599,
4237,
]

_charnames_9989 = [
4384,
-1,
-1,
-1,
-1,
4012,
4011,
]

_charnames_10060 = [
3435,
-1,
3690,
-1,
-1,
-1,
-1,
1087,
4382,
4386,
]

_charnames_11559 = [
4497,
-1,
-1,
-1,
-1,
-1,
4498,
]

_charnames_11826 = [
1652,
4013,
4014,
1650,
4358,
4357,
1651,
1624,
1645,
1659,
]

_charnames_42612 = [
3381,
3382,
3378,
3380,
3386,
3379,
3384,
3385,
]

_charnames_42893 = [
3805,
3785,
-1,
3801,
3777,
3810,
3787,
]

_charnames_42912 = [
3804,
3783,
3808,
3786,
3800,
3776,
3807,
3784,
3806,
3768,
3809,
]

_charnames_43744 = [
2405,
2404,
2406,
2399,
2394,
2393,
2403,
2402,
2400,
2397,
2396,
2416,
2415,
2412,
2413,
2411,
2423,
2420,
2419,
2422,
2421,
2414,
2417,
]

_charnames_43777 = [
3905,
3907,
3908,
3904,
3903,
3906,
-1,
-1,
3882,
3884,
3885,
3881,
3880,
3883,
-1,
-1,
3875,
3877,
3878,
3874,
3873,
3876,
]

_charnames_43808 = [
3889,
3891,
3893,
3890,
3888,
3887,
3892,
-1,
3897,
3899,
3901,
3898,
3896,
3895,
3900,
]

_charnames_64434 = [
1870,
1869,
1860,
1859,
1866,
1865,
1864,
1863,
1877,
1876,
1871,
1858,
1857,
1878,
1874,
1873,
]

_charnames_67968 = [
2354,
2352,
2350,
2347,
2343,
2344,
2341,
2342,
2346,
2348,
2330,
2331,
2328,
2329,
2336,
2337,
2349,
2339,
2351,
2333,
2334,
2335,
2340,
2345,
2324,
2325,
2322,
2323,
2326,
2353,
2355,
2356,
2372,
2384,
2382,
2379,
2374,
2375,
2386,
2378,
2380,
2368,
2367,
2376,
2381,
2370,
2383,
2365,
2373,
2364,
2371,
2377,
2362,
2361,
2360,
2385,
-1,
-1,
-1,
-1,
-1,
-1,
2388,
2389,
]

_charnames_69632 = [
1058,
1059,
1055,
1057,
1056,
951,
954,
973,
974,
959,
960,
924,
925,
926,
927,
988,
953,
935,
952,
969,
968,
977,
976,
943,
980,
979,
972,
971,
941,
932,
931,
948,
947,
942,
934,
933,
950,
949,
944,
963,
962,
983,
982,
986,
984,
985,
966,
928,
957,
956,
958,
987,
965,
939,
937,
938,
1028,
1035,
1031,
1032,
1029,
1030,
1021,
1022,
1023,
1024,
1034,
1027,
1033,
1026,
1036,
1053,
1052,
1066,
1065,
1063,
1067,
1062,
-1,
-1,
-1,
-1,
1010,
992,
995,
1005,
1008,
999,
1001,
1016,
1014,
997,
993,
996,
1006,
1009,
1000,
1002,
1017,
1015,
1013,
1012,
1048,
1049,
1040,
1041,
1046,
1047,
1043,
1044,
1051,
1050,
]

_charnames_69840 = [
2722,
2721,
2734,
2733,
2732,
2731,
2713,
2710,
2726,
2711,
2719,
2724,
2718,
2723,
2730,
2727,
2728,
2709,
2735,
2717,
2729,
2720,
2725,
2716,
2714,
]

_charnames_69872 = [
2746,
2747,
2738,
2739,
2744,
2745,
2741,
2742,
2749,
2748,
-1,
-1,
-1,
-1,
-1,
-1,
3284,
3285,
3283,
3250,
3247,
3242,
3249,
3228,
3227,
3234,
3233,
3212,
3237,
3236,
3231,
3230,
3210,
3206,
3205,
3217,
3216,
3211,
3208,
3207,
3219,
3218,
3213,
3225,
3224,
3240,
3239,
3245,
3221,
3222,
3244,
3246,
3241,
3243,
3248,
3270,
3277,
3278,
3273,
3274,
3279,
3272,
3275,
3271,
3276,
3288,
3290,
3280,
3289,
-1,
3262,
3263,
3254,
3255,
3260,
3261,
3257,
3258,
3265,
3264,
3286,
3267,
3266,
3287,
]

_charnames_70016 = [
2632,
2629,
2625,
2550,
2553,
2572,
2573,
2558,
2559,
2528,
2529,
2530,
2531,
2588,
2552,
2585,
2551,
2568,
2567,
2576,
2575,
2542,
2579,
2578,
2571,
2570,
2540,
2536,
2535,
2547,
2546,
2541,
2538,
2537,
2549,
2548,
2543,
2562,
2561,
2582,
2581,
2586,
2583,
2584,
2565,
2564,
2532,
2556,
2555,
2557,
2587,
2598,
2601,
2602,
2599,
2600,
2591,
2592,
2593,
2594,
2604,
2597,
2603,
2596,
2626,
2628,
2631,
2630,
2634,
2621,
2620,
2635,
2633,
]

_charnames_70096 = [
2616,
2617,
2608,
2609,
2614,
2615,
2611,
2612,
2619,
2618,
]

_charnames_71296 = [
1503,
1506,
1524,
1525,
1507,
1508,
1541,
1505,
1537,
1504,
1520,
1519,
1528,
1527,
1495,
1531,
1530,
1523,
1522,
1493,
1489,
1488,
1500,
1499,
1494,
1491,
1490,
1502,
1501,
1496,
1517,
1516,
1534,
1533,
1538,
1535,
1514,
1539,
1536,
1510,
1511,
1540,
1513,
1572,
1569,
1560,
1563,
1564,
1561,
1562,
1566,
1559,
1565,
1558,
1570,
1571,
]

_charnames_71360 = [
1552,
1553,
1544,
1545,
1550,
1551,
1547,
1548,
1555,
1554,
]

_charnames_92160 = [
551,
659,
628,
629,
572,
603,
648,
560,
606,
625,
626,
582,
644,
553,
580,
587,
596,
614,
547,
634,
565,
612,
550,
654,
653,
546,
585,
620,
657,
621,
592,
559,
662,
658,
545,
613,
597,
598,
590,
638,
622,
569,
631,
581,
574,
630,
643,
651,
611,
646,
584,
635,
568,
639,
591,
602,
652,
665,
664,
640,
610,
586,
605,
543,
607,
556,
618,
566,
661,
552,
583,
573,
595,
557,
647,
609,
619,
562,
579,
555,
637,
563,
663,
650,
575,
571,
594,
699,
734,
708,
709,
729,
671,
718,
737,
670,
719,
723,
738,
727,
701,
702,
740,
722,
733,
706,
705,
680,
673,
696,
714,
741,
713,
728,
724,
746,
694,
691,
745,
710,
735,
684,
689,
690,
681,
707,
674,
685,
697,
721,
683,
743,
672,
744,
715,
678,
677,
730,
692,
700,
675,
717,
693,
404,
441,
495,
533,
402,
419,
405,
528,
453,
530,
445,
437,
451,
523,
423,
460,
479,
529,
482,
496,
440,
463,
414,
455,
497,
490,
491,
512,
424,
506,
432,
502,
514,
401,
535,
444,
471,
438,
398,
517,
456,
474,
435,
504,
399,
538,
418,
415,
413,
539,
536,
452,
537,
431,
518,
501,
410,
428,
486,
397,
467,
464,
519,
488,
430,
406,
532,
400,
412,
436,
489,
411,
422,
470,
498,
421,
509,
513,
454,
468,
461,
480,
450,
481,
459,
494,
427,
473,
472,
510,
484,
485,
407,
443,
520,
524,
525,
505,
299,
386,
246,
282,
247,
360,
249,
259,
240,
265,
385,
234,
312,
236,
331,
342,
311,
252,
318,
332,
377,
335,
322,
284,
268,
301,
293,
324,
376,
250,
329,
231,
346,
389,
233,
391,
269,
288,
355,
270,
305,
290,
363,
289,
281,
358,
256,
297,
338,
264,
344,
323,
375,
330,
383,
345,
232,
285,
255,
328,
368,
366,
262,
356,
239,
286,
242,
374,
369,
373,
271,
274,
319,
336,
244,
235,
347,
294,
334,
260,
343,
302,
241,
354,
243,
258,
251,
388,
333,
380,
350,
348,
263,
382,
357,
295,
279,
317,
304,
315,
310,
337,
277,
313,
275,
367,
278,
314,
364,
303,
359,
381,
349,
276,
298,
321,
392,
36,
120,
100,
165,
222,
160,
72,
154,
209,
49,
40,
68,
112,
13,
179,
215,
152,
22,
73,
119,
172,
162,
51,
28,
91,
11,
27,
50,
211,
45,
85,
155,
17,
98,
198,
12,
46,
93,
159,
23,
38,
113,
151,
69,
34,
19,
142,
199,
117,
133,
86,
116,
177,
153,
124,
220,
217,
166,
65,
110,
203,
29,
149,
97,
101,
54,
63,
206,
115,
173,
143,
56,
141,
105,
39,
80,
130,
168,
188,
205,
8,
178,
90,
14,
201,
190,
59,
84,
136,
21,
57,
53,
87,
95,
189,
62,
103,
200,
186,
102,
67,
9,
171,
79,
60,
134,
18,
76,
187,
192,
43,
225,
121,
223,
224,
164,
75,
109,
111,
35,
148,
135,
24,
131,
138,
139,
128,
129,
176,
83,
44,
70,
216,
193,
221,
167,
94,
212,
210,
25,
30,
146,
147,
185,
61,
77,
161,
180,
106,
89,
92,
123,
181,
104,
125,
191,
202,
779,
817,
776,
819,
784,
798,
757,
809,
786,
787,
794,
799,
761,
753,
789,
767,
766,
768,
769,
775,
773,
750,
749,
752,
811,
764,
812,
759,
803,
758,
814,
804,
788,
760,
782,
774,
755,
756,
765,
805,
818,
815,
808,
807,
778,
791,
783,
795,
793,
792,
800,
777,
770,
816,
]

_charnames_93952 = [
2240,
2251,
2186,
2239,
2243,
2242,
2215,
2250,
2234,
2233,
2153,
2208,
2184,
2185,
2152,
2207,
2164,
2166,
2187,
2213,
2160,
2159,
2222,
2221,
2220,
2219,
2151,
2206,
2150,
2205,
2249,
2231,
2188,
2237,
2236,
2163,
2162,
2212,
2246,
2247,
2230,
2229,
2146,
2201,
2157,
2156,
2147,
2202,
2182,
2189,
2198,
2225,
2224,
2177,
2175,
2148,
2203,
2183,
2226,
2178,
2176,
2173,
2171,
2214,
2172,
2170,
2248,
2216,
2245,
]

_charnames_94032 = [
2165,
2305,
2303,
2304,
2262,
2270,
2269,
2263,
2264,
2284,
2286,
2291,
2290,
2278,
2281,
2282,
2287,
2253,
2254,
2255,
2256,
2258,
2261,
2260,
2257,
2259,
2271,
2272,
2273,
2274,
2275,
2277,
2276,
2288,
2289,
2265,
2266,
2280,
2293,
2279,
2292,
2268,
2283,
2267,
2285,
2294,
2295,
]

_charnames_94095 = [
2298,
2297,
2300,
2299,
2144,
2143,
2142,
2141,
2140,
2139,
2138,
2197,
2196,
2195,
2194,
2193,
2192,
]

_charnames_126464 = [
1839,
1851,
1847,
1705,
-1,
1842,
1830,
1848,
1824,
1841,
1837,
1743,
1846,
1845,
1776,
1840,
1850,
1777,
1844,
1843,
1775,
1828,
1826,
1836,
1827,
1706,
1831,
1849,
1703,
1701,
1702,
1700,
-1,
1801,
1797,
-1,
1790,
-1,
-1,
1791,
-1,
1792,
1788,
1796,
1795,
1794,
1781,
1802,
1799,
1782,
1793,
-1,
1780,
1785,
1784,
1787,
-1,
1800,
-1,
1798,
-1,
-1,
-1,
-1,
-1,
-1,
1820,
-1,
-1,
-1,
-1,
1821,
-1,
1815,
-1,
1818,
-1,
1817,
1808,
1823,
-1,
1809,
1816,
-1,
1807,
-1,
-1,
1819,
-1,
1814,
-1,
1822,
-1,
1813,
-1,
1812,
-1,
1773,
1770,
-1,
1763,
-1,
-1,
1764,
1749,
1766,
1761,
-1,
1769,
1768,
1752,
1774,
1772,
1753,
1767,
-1,
1751,
1748,
1747,
1760,
-1,
1758,
1765,
1771,
1757,
-1,
1756,
-1,
1729,
1742,
1739,
1726,
1723,
1732,
1720,
1724,
1714,
1731,
-1,
1737,
1736,
1735,
1717,
1730,
1741,
1718,
1734,
1733,
1716,
1713,
1711,
1738,
1712,
1727,
1721,
1740,
-1,
-1,
-1,
-1,
-1,
1697,
1693,
1683,
-1,
1686,
1680,
1694,
1674,
1685,
-1,
1691,
1690,
1689,
1677,
1698,
1696,
1678,
1688,
1687,
1676,
1673,
1671,
1692,
1672,
1684,
1681,
1695,
]

_charnames_127136 = [
3560,
3554,
3486,
3491,
3524,
3529,
3502,
3507,
3549,
3539,
3496,
3544,
3513,
3534,
3518,
-1,
-1,
3555,
3487,
3492,
3525,
3530,
3503,
3508,
3550,
3540,
3497,
3545,
3514,
3535,
3519,
-1,
-1,
3556,
3488,
3493,
3526,
3531,
3504,
3509,
3551,
3541,
3498,
3546,
3515,
3536,
3520,
3559,
-1,
3557,
3489,
3494,
3527,
3532,
3505,
3510,
3552,
3542,
3499,
3547,
3516,
3537,
3521,
3561,
]

_charnames_127280 = [
2671,
-1,
2670,
2669,
2668,
2667,
2666,
2665,
2664,
2663,
2662,
2661,
2660,
-1,
2659,
-1,
2658,
2657,
-1,
2656,
2655,
2654,
-1,
2653,
2652,
2651,
-1,
-1,
-1,
-1,
-1,
2698,
3716,
3715,
3714,
3713,
3712,
3711,
3710,
-1,
3709,
3708,
3707,
3706,
3705,
3704,
3703,
-1,
3702,
3701,
3700,
3699,
3698,
3697,
3696,
3695,
3694,
3693,
4010,
4009,
-1,
-1,
-1,
-1,
3688,
3687,
3686,
3685,
3684,
3683,
3682,
3681,
3680,
-1,
3679,
-1,
-1,
3678,
3677,
-1,
3676,
3675,
3674,
3673,
3672,
3671,
3670,
3669,
3668,
3667,
-1,
-1,
-1,
-1,
3691,
3689,
-1,
2691,
2690,
2704,
2703,
2694,
2693,
2702,
2701,
2700,
2699,
]

_charnames_127462 = [
3993,
3992,
3991,
3990,
3989,
3988,
3987,
3986,
3985,
3984,
3983,
3982,
3981,
3980,
3979,
3978,
3977,
3976,
3975,
3974,
3973,
3972,
3971,
3970,
3969,
3968,
-1,
2697,
2696,
]

_charnames_127538 = [
2679,
2678,
2688,
2685,
2683,
2684,
2680,
2689,
2687,
]

_charnames_127744 = [
3465,
4201,
3365,
3758,
2780,
2779,
3455,
2781,
4015,
1070,
4404,
3197,
2316,
3935,
3934,
3933,
4509,
3722,
4410,
4179,
4409,
4214,
4412,
3829,
4413,
3445,
3721,
4178,
3828,
4213,
2783,
4508,
2640,
]

_charnames_127792 = [
3304,
2887,
3962,
4330,
3583,
3428,
-1,
1654,
3302,
4026,
4283,
2782,
1094,
3938,
3937,
4264,
4199,
2478,
4169,
3852,
2516,
1627,
2118,
4487,
2428,
4407,
1574,
3850,
901,
3632,
4004,
4482,
3605,
3606,
3303,
2805,
4288,
2884,
2429,
3613,
4036,
4037,
3402,
3469,
2809,
2830,
1075,
4194,
4030,
4354,
4469,
2786,
4193,
4183,
2753,
2636,
4540,
4336,
3401,
3311,
3425,
3842,
3474,
4240,
2639,
1115,
3621,
3400,
4198,
1637,
2912,
4423,
3410,
1606,
1120,
3370,
906,
-1,
-1,
-1,
4039,
4427,
1123,
4550,
3310,
4167,
4174,
4175,
917,
3571,
3392,
1575,
3436,
3633,
4548,
3419,
4424,
2509,
2893,
4488,
]

_charnames_127904 = [
3420,
4216,
4028,
4182,
2309,
2508,
3456,
4263,
1936,
1623,
3454,
1600,
3373,
3599,
3190,
4350,
2883,
1128,
4514,
1107,
4204,
2514,
2517,
2910,
4505,
2515,
1619,
3193,
2513,
4042,
1638,
2915,
916,
3305,
2908,
4043,
2789,
-1,
1607,
4231,
2126,
4044,
2916,
]

_charnames_127968 = [
4236,
4235,
4468,
4545,
3960,
4242,
895,
2117,
4241,
3839,
3396,
2892,
4329,
4165,
4538,
4549,
3961,
]

_charnames_128000 = [
4021,
2487,
4464,
4406,
3403,
1596,
3849,
4019,
3412,
4365,
3438,
4388,
2907,
2906,
4229,
4022,
4511,
2647,
2491,
4027,
3309,
4338,
3627,
1109,
3944,
4470,
2833,
1136,
2107,
4239,
3830,
4181,
1605,
1093,
1653,
4289,
905,
4191,
1124,
3603,
4139,
3625,
4364,
912,
4341,
2488,
3404,
1597,
4020,
3413,
4366,
2831,
4232,
2492,
4339,
3630,
4192,
4286,
4400,
1119,
3582,
3629,
3579,
-1,
3954,
-1,
3930,
3743,
2489,
1626,
4379,
4387,
4383,
4381,
4184,
4414,
4467,
1657,
1658,
3372,
4437,
3437,
4394,
3955,
3728,
1661,
4551,
4367,
4136,
1129,
4395,
3640,
4291,
3614,
2470,
2130,
4279,
4393,
4396,
4200,
1134,
1133,
1106,
4512,
2431,
4391,
4168,
2469,
1643,
1642,
3618,
4397,
1071,
3593,
2468,
2467,
4463,
4462,
902,
3394,
3658,
4546,
4547,
4513,
907,
3957,
2103,
4539,
2914,
4531,
4506,
4355,
3860,
3752,
4164,
4292,
914,
2899,
3635,
4135,
3838,
4038,
4502,
4128,
1108,
3408,
4420,
1118,
1076,
1644,
2828,
4484,
4260,
1090,
4480,
4568,
3641,
4259,
3998,
4261,
4351,
3943,
2113,
1105,
2880,
3409,
2832,
4363,
4360,
3636,
4207,
4345,
2825,
1660,
4385,
4298,
2495,
3470,
4252,
3446,
897,
900,
899,
898,
2494,
3294,
2890,
3597,
1072,
2314,
4205,
4441,
4374,
4187,
4438,
3574,
3575,
3427,
1636,
3421,
3293,
3295,
915,
3369,
3643,
4025,
3581,
2806,
1616,
1102,
3851,
3740,
3741,
3367,
4439,
4481,
1091,
4453,
1103,
3750,
2894,
2427,
1634,
3576,
4166,
2911,
3644,
3306,
4465,
4537,
3584,
3964,
4536,
3929,
3364,
3363,
4434,
4435,
3623,
3624,
3724,
2503,
2505,
3194,
2506,
3737,
2109,
3426,
-1,
3191,
1632,
4017,
3192,
-1,
-1,
-1,
1646,
3358,
3359,
3360,
2108,
3840,
4282,
2821,
2817,
2820,
2819,
893,
3942,
3846,
4033,
3836,
3366,
4137,
3832,
4436,
1112,
1113,
1101,
3859,
4018,
911,
3926,
4460,
2751,
1625,
3736,
4138,
4521,
4519,
4523,
4522,
4520,
4172,
3941,
4426,
4287,
3748,
4244,
3637,
2308,
1633,
3443,
2875,
4544,
1618,
1086,
4380,
3825,
3824,
3826,
3823,
2855,
2856,
4555,
4334,
4554,
4333,
-1,
-1,
3453,
3434,
3433,
3742,
]

_charnames_128336 = [
3353,
3320,
3326,
3340,
3343,
3333,
3336,
3350,
3356,
3329,
3347,
3323,
3352,
3319,
3325,
3339,
3342,
3332,
3335,
3349,
3355,
3328,
3346,
3322,
]

_charnames_128507 = [
2486,
1628,
2801,
2876,
2507,
4475,
4476,
4154,
2838,
2841,
2842,
2840,
2846,
2844,
4422,
2849,
4162,
4003,
2845,
2848,
2853,
3726,
3958,
4558,
4158,
3602,
3390,
3391,
4130,
4163,
4132,
4133,
4146,
4148,
4149,
4348,
4399,
2112,
3611,
3441,
3598,
4157,
4349,
4190,
2111,
4217,
4417,
2882,
1598,
4478,
3841,
4151,
4297,
4152,
4161,
2121,
4206,
2881,
4346,
4159,
4156,
4477,
3416,
2851,
2852,
3415,
4134,
3612,
3442,
4418,
-1,
-1,
-1,
-1,
4155,
4153,
3596,
2888,
4262,
2822,
4290,
3594,
3595,
3591,
3592,
]

_charnames_128640 = [
4029,
4265,
2810,
4016,
4277,
4278,
1612,
2424,
3861,
2802,
1610,
1611,
1131,
4458,
1608,
1135,
2315,
2127,
4176,
3616,
4457,
1576,
4456,
2116,
4459,
4000,
4327,
1937,
1613,
2496,
2483,
2785,
2484,
2131,
2645,
4024,
2824,
4228,
3186,
3395,
3617,
1617,
4340,
3738,
2857,
3734,
3642,
4342,
3620,
3744,
1127,
3733,
1126,
2485,
3607,
3735,
3308,
2426,
4398,
4002,
904,
1629,
4405,
2638,
891,
892,
3580,
3473,
918,
3848,
]

_charnames_128768 = [
2088,
1984,
2101,
2102,
2086,
1973,
1971,
1972,
1969,
1970,
2034,
2037,
2036,
1951,
2051,
2030,
2061,
2064,
2063,
2004,
1953,
2091,
2039,
2040,
2019,
2020,
2098,
1964,
2081,
2082,
1996,
2015,
2002,
2083,
1948,
1994,
1995,
2003,
1955,
1946,
2041,
2055,
2095,
1982,
1949,
1956,
1947,
2038,
2013,
2014,
2007,
2011,
2010,
2009,
1975,
1976,
2066,
1957,
1981,
2016,
2017,
1979,
2031,
2056,
2057,
2089,
2022,
2025,
2024,
1977,
2100,
1962,
2054,
2097,
2085,
2044,
1999,
2058,
1998,
1965,
2000,
2059,
1961,
2094,
1963,
2099,
2070,
1980,
2046,
2029,
2045,
1983,
1959,
1960,
1950,
2050,
2078,
2076,
2077,
2049,
2048,
1987,
1992,
1991,
1990,
1989,
1978,
2028,
2027,
2018,
2069,
2092,
2079,
2065,
2073,
2072,
]

_charnames_983040 = [
3747,
3746,
2798,
2752,
2796,
2811,
3920,
3912,
3918,
3950,
3928,
3927,
2129,
2128,
2104,
1111,
910,
1140,
3296,
4224,
4293,
1577,
3858,
3723,
3924,
3866,
3757,
3952,
3856,
3184,
3195,
4197,
4219,
3418,
3429,
2643,
3835,
2705,
2644,
3834,
2858,
4359,
4375,
4324,
4373,
4321,
4372,
4322,
4371,
4325,
4370,
3717,
3751,
2898,
2897,
3919,
3913,
3423,
3422,
3923,
3951,
2788,
2787,
3947,
3946,
4530,
4186,
4218,
4528,
4485,
4510,
4527,
4001,
4049,
4529,
4557,
4559,
2814,
4328,
4326,
3578,
3577,
4281,
4243,
1074,
1141,
3732,
3755,
4534,
4532,
3725,
3727,
2795,
2901,
3921,
3948,
3299,
4227,
4294,
3298,
4226,
4295,
3857,
3185,
3196,
3568,
3569,
3563,
3570,
3567,
3562,
3996,
3997,
4031,
2863,
2869,
2903,
2864,
2868,
2902,
4323,
4369,
3656,
3653,
3646,
3655,
3652,
3645,
2889,
2812,
3424,
3480,
2425,
2518,
2799,
2797,
2826,
3925,
3922,
3963,
2794,
2750,
2865,
2917,
2866,
2895,
3397,
3478,
2807,
2790,
4440,
4466,
3657,
3660,
2123,
2124,
3754,
2646,
3803,
3782,
3479,
4126,
3817,
3818,
3819,
3820,
1589,
4211,
4210,
4209,
2519,
4564,
4562,
4565,
3864,
4047,
3865,
4048,
3661,
3863,
4046,
3756,
2520,
4428,
4419,
2311,
2312,
4567,
3659,
2920,
3031,
3165,
3154,
3143,
3132,
3121,
3110,
3099,
3020,
3009,
2998,
2987,
2976,
2965,
2954,
1139,
1104,
4563,
1138,
2943,
2932,
2921,
3076,
3065,
3054,
3043,
3032,
3087,
3098,
3097,
3096,
3095,
3175,
3174,
3173,
3172,
3171,
3170,
3169,
3168,
3167,
3166,
3164,
3163,
3162,
3161,
3160,
3159,
3158,
3157,
3156,
3155,
3153,
3152,
3151,
3150,
3149,
3148,
3147,
3146,
3145,
3144,
3142,
3141,
3140,
3139,
3138,
3137,
3136,
3135,
3134,
3133,
3131,
3130,
3129,
3128,
3127,
3126,
3125,
3124,
3123,
3122,
3120,
3119,
3118,
3117,
3116,
3115,
3114,
3113,
3112,
3111,
3109,
3108,
3107,
3106,
3105,
3104,
3103,
3102,
3101,
3100,
3030,
3029,
3028,
3027,
3026,
3025,
3024,
3023,
3022,
3021,
3019,
3018,
3017,
3016,
3015,
3014,
3013,
3012,
3011,
3010,
3008,
3007,
3006,
3005,
3004,
3003,
3002,
3001,
3000,
2999,
2997,
2996,
2995,
2994,
2993,
2992,
2991,
2990,
2989,
2988,
2986,
2985,
2984,
2983,
2982,
2981,
2980,
2979,
2978,
2977,
2975,
2974,
2973,
2972,
2971,
2970,
2969,
2968,
2967,
2966,
2964,
2963,
2962,
2961,
2960,
2959,
2958,
2957,
2956,
2955,
2953,
2952,
2951,
2950,
2949,
2948,
2947,
2946,
2945,
2944,
2942,
2941,
2940,
2939,
2938,
2937,
2936,
2935,
2934,
2933,
2931,
2930,
2929,
2928,
2927,
2926,
2925,
2924,
2923,
2922,
3086,
3085,
3084,
3083,
3082,
3081,
3080,
3079,
3078,
3077,
3075,
3074,
3073,
3072,
3071,
3070,
3069,
3068,
3067,
3066,
3064,
3063,
3062,
3061,
3060,
3059,
3058,
3057,
3056,
3055,
3053,
3052,
3051,
3050,
3049,
3048,
3047,
3046,
3045,
3044,
3042,
3041,
3040,
3039,
3038,
3037,
3036,
3035,
3034,
3033,
3094,
3093,
3092,
3091,
3090,
3089,
3088,
]

_charnames_983612 = [
3788,
3773,
3774,
3770,
3771,
3766,
3767,
3779,
3780,
1116,
1475,
1464,
1483,
1463,
1472,
1461,
1471,
1460,
1479,
1480,
1477,
1473,
1468,
1478,
1470,
1469,
1474,
1462,
1481,
1467,
1466,
1465,
1482,
1476,
1307,
1312,
1313,
1308,
1309,
1314,
1315,
1306,
1310,
1311,
1305,
1190,
1195,
1196,
1191,
1192,
1197,
1198,
1189,
1193,
1194,
1188,
1450,
1455,
1456,
1451,
1452,
1457,
1458,
1449,
1453,
1454,
1448,
1177,
1182,
1183,
1178,
1179,
1184,
1185,
1176,
1180,
1181,
1175,
1321,
1326,
1327,
1322,
1323,
1328,
1329,
1320,
1324,
1325,
1319,
1164,
1169,
1170,
1165,
1166,
1171,
1172,
1163,
1167,
1168,
1162,
1333,
1338,
1339,
1334,
1335,
1340,
1341,
1332,
1336,
1337,
1331,
1202,
1207,
1208,
1203,
1204,
1209,
1210,
1201,
1205,
1206,
1200,
1398,
1403,
1404,
1399,
1400,
1405,
1406,
1397,
1401,
1402,
1396,
1411,
1416,
1417,
1412,
1413,
1418,
1419,
1410,
1414,
1415,
1409,
1372,
1377,
1378,
1373,
1374,
1379,
1380,
1371,
1375,
1376,
1370,
1359,
1364,
1365,
1360,
1361,
1366,
1367,
1358,
1362,
1363,
1357,
1281,
1286,
1287,
1282,
1283,
1288,
1289,
1280,
1284,
1285,
1279,
1385,
1390,
1391,
1386,
1387,
1392,
1393,
1384,
1388,
1389,
1383,
1257,
1262,
1263,
1258,
1259,
1264,
1265,
1256,
1260,
1261,
1255,
1269,
1274,
1275,
1270,
1271,
1276,
1277,
1268,
1272,
1273,
1267,
1347,
1352,
1353,
1348,
1349,
1354,
1355,
1346,
1350,
1351,
1345,
1152,
1157,
1158,
1153,
1154,
1159,
1160,
1151,
1155,
1156,
1150,
1424,
1429,
1430,
1425,
1426,
1431,
1432,
1423,
1427,
1428,
1422,
1216,
1221,
1222,
1217,
1218,
1223,
1224,
1215,
1219,
1220,
1214,
1230,
1235,
1236,
1231,
1232,
1237,
1238,
1229,
1233,
1234,
1228,
1242,
1247,
1248,
1243,
1244,
1249,
1250,
1241,
1245,
1246,
1240,
1437,
1442,
1443,
1438,
1439,
1444,
1445,
1436,
1440,
1441,
1435,
1292,
1295,
1300,
1301,
1296,
1297,
1302,
1303,
1294,
1298,
1299,
1293,
1225,
2874,
2873,
2872,
4492,
4072,
4070,
4071,
4069,
4065,
4078,
4076,
4077,
4075,
4063,
4093,
4056,
4092,
4055,
4066,
4061,
4059,
4060,
4058,
4064,
4099,
4086,
4087,
4085,
4097,
4094,
4096,
4089,
4095,
4081,
4080,
4082,
4098,
4090,
4108,
4104,
4101,
4102,
4105,
4107,
4109,
4273,
4271,
4269,
4272,
4270,
4117,
4115,
4113,
4116,
4114,
4124,
4121,
4122,
4123,
2500,
2499,
]

def lookup_charcode(code):
    res = -1
    if code == 1318: res = 3463
    elif code == 1319: res = 3460
    elif code == 1423: res = 1938
    elif code == 1540: res = 1880
    elif code == 1568: res = 1894
    elif code == 1631: res = 1933
    elif 2112 <= code <= 2142: res = _charnames_2112[code-2112]
    elif 2208 <= code <= 2220: res = _charnames_2208[code-2208]
    elif 2276 <= code <= 2302: res = _charnames_2276[code-2276]
    elif code == 2362: res = 4309
    elif code == 2363: res = 4308
    elif 2383 <= code <= 2391: res = _charnames_2383[code-2383]
    elif code == 2419: res = 4317
    elif code == 2420: res = 4316
    elif code == 2421: res = 4318
    elif code == 2422: res = 4314
    elif code == 2423: res = 4313
    elif code == 2800: res = 4504
    elif code == 2930: res = 4447
    elif code == 2931: res = 4448
    elif code == 2932: res = 4452
    elif code == 2933: res = 4446
    elif code == 2934: res = 4449
    elif code == 2935: res = 4451
    elif code == 3369: res = 2473
    elif code == 3386: res = 2472
    elif code == 3406: res = 2474
    elif code == 3806: res = 3815
    elif code == 3807: res = 3814
    elif code == 3980: res = 1585
    elif code == 3981: res = 1583
    elif code == 3982: res = 1582
    elif code == 3983: res = 1584
    elif code == 4057: res = 1588
    elif code == 4058: res = 1587
    elif 4295 <= code <= 4301: res = _charnames_4295[code-4295]
    elif code == 4349: res = 4495
    elif code == 4350: res = 4494
    elif code == 4351: res = 4493
    elif code == 4957: res = 3911
    elif code == 4958: res = 3910
    elif code == 7083: res = 2777
    elif code == 7084: res = 2776
    elif code == 7085: res = 2775
    elif 7098 <= code <= 7155: res = _charnames_7098[code-7098]
    elif code == 7164: res = 882
    elif code == 7165: res = 880
    elif code == 7166: res = 883
    elif code == 7167: res = 881
    elif 7360 <= code <= 7367: res = _charnames_7360[code-7360]
    elif code == 7411: res = 3180
    elif code == 7412: res = 3182
    elif code == 7413: res = 3181
    elif code == 7414: res = 3179
    elif code == 7676: res = 3387
    elif 8341 <= code <= 8348: res = _charnames_8341[code-8341]
    elif code == 8377: res = 4533
    elif 9193 <= code <= 9203: res = _charnames_9193[code-9193]
    elif code == 9934: res = 4442
    elif code == 9954: res = 2120
    elif code == 9956: res = 3601
    elif code == 9957: res = 4034
    elif code == 9958: res = 3847
    elif code == 9959: res = 4535
    elif 9989 <= code <= 9995: res = _charnames_9989[code-9989]
    elif code == 10024: res = 2829
    elif 10060 <= code <= 10069: res = _charnames_10060[code-10060]
    elif code == 10079: res = 4249
    elif code == 10080: res = 4250
    elif code == 10133: res = 4254
    elif code == 10134: res = 4255
    elif code == 10135: res = 4253
    elif code == 10160: res = 3471
    elif code == 10175: res = 4337
    elif code == 10187: res = 2476
    elif code == 10189: res = 2477
    elif code == 10190: res = 2674
    elif code == 10191: res = 2673
    elif code == 11506: res = 3407
    elif code == 11507: res = 3406
    elif 11559 <= code <= 11565: res = _charnames_11559[code-11559]
    elif code == 11622: res = 1593
    elif code == 11623: res = 1592
    elif code == 11632: res = 1594
    elif code == 11647: res = 1595
    elif 11826 <= code <= 11835: res = _charnames_11826[code-11826]
    elif code == 12728: res = 1099
    elif code == 12729: res = 1098
    elif code == 12730: res = 1097
    elif code == 42592: res = 3464
    elif code == 42593: res = 3461
    elif 42612 <= code <= 42619: res = _charnames_42612[code-42612]
    elif code == 42655: res = 3383
    elif 42893 <= code <= 42899: res = _charnames_42893[code-42893]
    elif 42912 <= code <= 42922: res = _charnames_42912[code-42912]
    elif code == 43000: res = 2502
    elif code == 43001: res = 2501
    elif code == 43002: res = 3811
    elif 43744 <= code <= 43766: res = _charnames_43744[code-43744]
    elif 43777 <= code <= 43798: res = _charnames_43777[code-43777]
    elif 43808 <= code <= 43822: res = _charnames_43808[code-43808]
    elif code == 64046: res = 3477
    elif code == 64047: res = 3476
    elif 64434 <= code <= 64449: res = _charnames_64434[code-64434]
    elif 67968 <= code <= 68031: res = _charnames_67968[code-67968]
    elif 69632 <= code <= 69743: res = _charnames_69632[code-69632]
    elif 69840 <= code <= 69864: res = _charnames_69840[code-69840]
    elif 69872 <= code <= 69955: res = _charnames_69872[code-69872]
    elif 70016 <= code <= 70088: res = _charnames_70016[code-70016]
    elif 70096 <= code <= 70105: res = _charnames_70096[code-70096]
    elif 71296 <= code <= 71351: res = _charnames_71296[code-71296]
    elif 71360 <= code <= 71369: res = _charnames_71360[code-71360]
    elif 92160 <= code <= 92728: res = _charnames_92160[code-92160]
    elif 93952 <= code <= 94020: res = _charnames_93952[code-93952]
    elif 94032 <= code <= 94078: res = _charnames_94032[code-94032]
    elif 94095 <= code <= 94111: res = _charnames_94095[code-94095]
    elif code == 110592: res = 4125
    elif code == 110593: res = 4274
    elif 126464 <= code <= 126651: res = _charnames_126464[code-126464]
    elif code == 126704: res = 1833
    elif code == 126705: res = 1834
    elif 127136 <= code <= 127199: res = _charnames_127136[code-127136]
    elif 127280 <= code <= 127386: res = _charnames_127280[code-127280]
    elif 127462 <= code <= 127490: res = _charnames_127462[code-127462]
    elif 127538 <= code <= 127546: res = _charnames_127538[code-127538]
    elif code == 127568: res = 3451
    elif code == 127569: res = 3452
    elif 127744 <= code <= 127776: res = _charnames_127744[code-127744]
    elif 127792 <= code <= 127891: res = _charnames_127792[code-127792]
    elif 127904 <= code <= 127946: res = _charnames_127904[code-127904]
    elif 127968 <= code <= 127984: res = _charnames_127968[code-127968]
    elif 128000 <= code <= 128323: res = _charnames_128000[code-128000]
    elif 128336 <= code <= 128359: res = _charnames_128336[code-128336]
    elif 128507 <= code <= 128591: res = _charnames_128507[code-128507]
    elif 128640 <= code <= 128709: res = _charnames_128640[code-128640]
    elif 128768 <= code <= 128883: res = _charnames_128768[code-128768]
    elif 983040 <= code <= 983488: res = _charnames_983040[code-983040]
    elif 983612 <= code <= 983972: res = _charnames_983612[code-983612]
    if res == -1: raise KeyError(code)
    return name_of_node(res)

# end output from build_compression_tree
#____________________________________________________________
_names_corrected = {
}
_code_by_name_corrected = {
}

_cjk_prefix = "CJK UNIFIED IDEOGRAPH-"
_hangul_prefix = 'HANGUL SYLLABLE '

_hangul_L = ['G', 'GG', 'N', 'D', 'DD', 'R', 'M', 'B', 'BB',
            'S', 'SS', '', 'J', 'JJ', 'C', 'K', 'T', 'P', 'H']
_hangul_V = ['A', 'AE', 'YA', 'YAE', 'EO', 'E', 'YEO', 'YE', 'O', 'WA', 'WAE',
            'OE', 'YO', 'U', 'WEO', 'WE', 'WI', 'YU', 'EU', 'YI', 'I']
_hangul_T = ['', 'G', 'GG', 'GS', 'N', 'NJ', 'NH', 'D', 'L', 'LG', 'LM',
            'LB', 'LS', 'LT', 'LP', 'LH', 'M', 'B', 'BS', 'S', 'SS',
            'NG', 'J', 'C', 'K', 'T', 'P', 'H']

def _lookup_hangul(syllables):
    l_code = v_code = t_code = -1
    for i in range(len(_hangul_L)):
        jamo = _hangul_L[i]
        if (syllables[:len(jamo)] == jamo and
            (l_code < 0 or len(jamo) > len(_hangul_L[l_code]))):
            l_code = i
    if l_code < 0:
        raise KeyError
    start = len(_hangul_L[l_code])

    for i in range(len(_hangul_V)):
        jamo = _hangul_V[i]
        if (syllables[start:start + len(jamo)] == jamo and
            (v_code < 0 or len(jamo) > len(_hangul_V[v_code]))):
            v_code = i
    if v_code < 0:
        raise KeyError
    start += len(_hangul_V[v_code])

    for i in range(len(_hangul_T)):
        jamo = _hangul_T[i]
        if (syllables[start:start + len(jamo)] == jamo and
            (t_code < 0 or len(jamo) > len(_hangul_T[t_code]))):
            t_code = i
    if t_code < 0:
        raise KeyError
    start += len(_hangul_T[t_code])

    if len(syllables[start:]):
        raise KeyError
    return 0xAC00 + (l_code * 21 + v_code) * 28 + t_code

def _lookup_cjk(cjk_code):
    if len(cjk_code) != 4 and len(cjk_code) != 5:
        raise KeyError
    for c in cjk_code:
        if not ('0' <= c <= '9' or 'A' <= c <= 'F'):
            raise KeyError
    code = int(cjk_code, 16)
    if (0x3400 <= code <= 0x4DB5 or 0x4E00 <= code <= 0x9FCC or 0x20000 <= code <= 0x2A6D6 or 0x2A700 <= code <= 0x2B734 or 0x2B740 <= code <= 0x2B81D):
        return code
    raise KeyError

def lookup(name, with_named_sequence=False):
    if name[:len(_cjk_prefix)] == _cjk_prefix:
        return _lookup_cjk(name[len(_cjk_prefix):])
    if name[:len(_hangul_prefix)] == _hangul_prefix:
        return _lookup_hangul(name[len(_hangul_prefix):])

    if not base_mod:
        code = trie_lookup(name)
    else:
        try:
            code = trie_lookup(name)
        except KeyError:
            if name not in _code_by_name_corrected:
                code = base_mod.trie_lookup(name)
            else:
                raise
    if not with_named_sequence and 0xF0200 <= code < 0xF0400:
        raise KeyError
    return code

def name(code):
    if (0x3400 <= code <= 0x4DB5 or 0x4E00 <= code <= 0x9FCC or 0x20000 <= code <= 0x2A6D6 or 0x2A700 <= code <= 0x2B734 or 0x2B740 <= code <= 0x2B81D):
        return "CJK UNIFIED IDEOGRAPH-" + hex(code)[2:].upper()
    if 0xAC00 <= code <= 0xD7A3:
        # vl_code, t_code = divmod(code - 0xAC00, len(_hangul_T))
        vl_code = (code - 0xAC00) // len(_hangul_T)
        t_code = (code - 0xAC00) % len(_hangul_T)
        # l_code, v_code = divmod(vl_code,  len(_hangul_V))
        l_code = vl_code // len(_hangul_V)
        v_code = vl_code % len(_hangul_V)
        return ("HANGUL SYLLABLE " + _hangul_L[l_code] +
                _hangul_V[v_code] + _hangul_T[t_code])
    if 0xF0000 <= code < 0xF0400:
        raise KeyError

    if not base_mod:
        return lookup_charcode(code)
    else:
        try:
            return lookup_charcode(code)
        except KeyError:
            if code not in _names_corrected:
                return base_mod.lookup_charcode(code)
            else:
                raise

_db_records = [
('Cc', 'B', 'N', 5),
('Cc', 'BN', 'N', 0),
('Cc', 'S', 'N', 1),
('Cc', 'S', 'N', 5),
('Cc', 'WS', 'N', 5),
('Cf', 'AL', 'N', 8192),
('Cf', 'AN', 'N', 8192),
('Cf', 'BN', 'A', 8192),
('Cf', 'BN', 'N', 8192),
('Cf', 'L', 'N', 8192),
('Cf', 'LRE', 'N', 8192),
('Cf', 'LRO', 'N', 8192),
('Cf', 'ON', 'N', 8192),
('Cf', 'PDF', 'N', 8192),
('Cf', 'R', 'N', 8192),
('Cf', 'RLE', 'N', 8192),
('Cf', 'RLO', 'N', 8192),
('Cn', '', 'N', 0),
('Cn', '', 'W', 0),
('Co', 'L', 'A', 0),
('Cs', 'L', 'N', 0),
('Ll', 'L', 'A', 7202),
('Ll', 'L', 'F', 7202),
('Ll', 'L', 'N', 7202),
('Ll', 'L', 'Na', 7202),
('Lm', 'AL', 'N', 15362),
('Lm', 'L', 'A', 15362),
('Lm', 'L', 'A', 15394),
('Lm', 'L', 'H', 14338),
('Lm', 'L', 'H', 15362),
('Lm', 'L', 'N', 12322),
('Lm', 'L', 'N', 15362),
('Lm', 'L', 'N', 15394),
('Lm', 'L', 'W', 15362),
('Lm', 'ON', 'A', 15362),
('Lm', 'ON', 'N', 12290),
('Lm', 'ON', 'N', 15362),
('Lm', 'R', 'N', 15362),
('Lo', 'AL', 'N', 4098),
('Lo', 'AL', 'N', 7170),
('Lo', 'L', 'A', 7202),
('Lo', 'L', 'H', 7170),
('Lo', 'L', 'N', 6146),
('Lo', 'L', 'N', 7170),
('Lo', 'L', 'W', 7170),
('Lo', 'L', 'W', 7234),
('Lo', 'R', 'N', 7170),
('Lt', 'L', 'N', 7186),
('Lu', 'L', 'A', 7178),
('Lu', 'L', 'F', 7178),
('Lu', 'L', 'N', 7178),
('Lu', 'L', 'Na', 7178),
('Mc', 'L', 'N', 6144),
('Mc', 'L', 'W', 6144),
('Me', 'NSM', 'N', 12288),
('Mn', 'L', 'N', 14336),
('Mn', 'NSM', 'A', 14336),
('Mn', 'NSM', 'A', 14368),
('Mn', 'NSM', 'N', 14336),
('Mn', 'NSM', 'W', 14336),
('Nd', 'AN', 'N', 6592),
('Nd', 'EN', 'F', 6592),
('Nd', 'EN', 'N', 6592),
('Nd', 'EN', 'Na', 6592),
('Nd', 'L', 'N', 6592),
('Nd', 'R', 'N', 6592),
('Nl', 'L', 'A', 7240),
('Nl', 'L', 'A', 7264),
('Nl', 'L', 'N', 7168),
('Nl', 'L', 'N', 7232),
('Nl', 'L', 'N', 7240),
('Nl', 'L', 'N', 7264),
('Nl', 'L', 'W', 7232),
('Nl', 'ON', 'N', 7232),
('No', 'AN', 'N', 4160),
('No', 'AN', 'N', 4288),
('No', 'EN', 'A', 4160),
('No', 'EN', 'A', 4288),
('No', 'EN', 'N', 4288),
('No', 'L', 'A', 4160),
('No', 'L', 'N', 4160),
('No', 'L', 'N', 6336),
('No', 'L', 'W', 4160),
('No', 'ON', 'A', 4160),
('No', 'ON', 'A', 4288),
('No', 'ON', 'N', 4160),
('No', 'ON', 'N', 4288),
('No', 'ON', 'W', 4160),
('No', 'R', 'N', 4160),
('No', 'R', 'N', 4288),
('Pc', 'ON', 'F', 6144),
('Pc', 'ON', 'N', 6144),
('Pc', 'ON', 'Na', 6144),
('Pc', 'ON', 'W', 6144),
('Pd', 'ES', 'F', 4096),
('Pd', 'ES', 'Na', 4096),
('Pd', 'ES', 'W', 4096),
('Pd', 'ON', 'A', 4096),
('Pd', 'ON', 'N', 4096),
('Pd', 'ON', 'W', 4096),
('Pd', 'R', 'N', 4096),
('Pe', 'ON', 'F', 4608),
('Pe', 'ON', 'H', 4608),
('Pe', 'ON', 'N', 4096),
('Pe', 'ON', 'N', 4608),
('Pe', 'ON', 'Na', 4608),
('Pe', 'ON', 'W', 4096),
('Pe', 'ON', 'W', 4608),
('Pf', 'ON', 'A', 4096),
('Pf', 'ON', 'A', 12288),
('Pf', 'ON', 'N', 4608),
('Pi', 'ON', 'A', 4096),
('Pi', 'ON', 'A', 12288),
('Pi', 'ON', 'N', 4096),
('Pi', 'ON', 'N', 4608),
('Po', 'AL', 'N', 4096),
('Po', 'AN', 'N', 4096),
('Po', 'CS', 'F', 4096),
('Po', 'CS', 'F', 12288),
('Po', 'CS', 'N', 4096),
('Po', 'CS', 'Na', 4096),
('Po', 'CS', 'Na', 12288),
('Po', 'CS', 'W', 4096),
('Po', 'CS', 'W', 12288),
('Po', 'ET', 'A', 4096),
('Po', 'ET', 'F', 4096),
('Po', 'ET', 'N', 4096),
('Po', 'ET', 'Na', 4096),
('Po', 'ET', 'W', 4096),
('Po', 'L', 'N', 4096),
('Po', 'ON', 'A', 4096),
('Po', 'ON', 'A', 12288),
('Po', 'ON', 'A', 14336),
('Po', 'ON', 'F', 4096),
('Po', 'ON', 'F', 12288),
('Po', 'ON', 'H', 4096),
('Po', 'ON', 'N', 4096),
('Po', 'ON', 'N', 14336),
('Po', 'ON', 'Na', 4096),
('Po', 'ON', 'Na', 12288),
('Po', 'ON', 'W', 4096),
('Po', 'ON', 'W', 12288),
('Po', 'R', 'N', 4096),
('Po', 'R', 'N', 12288),
('Ps', 'ON', 'F', 4608),
('Ps', 'ON', 'H', 4608),
('Ps', 'ON', 'N', 4096),
('Ps', 'ON', 'N', 4608),
('Ps', 'ON', 'Na', 4608),
('Ps', 'ON', 'W', 4096),
('Ps', 'ON', 'W', 4608),
('Sc', 'AL', 'N', 4096),
('Sc', 'ET', 'A', 4096),
('Sc', 'ET', 'F', 4096),
('Sc', 'ET', 'H', 4096),
('Sc', 'ET', 'N', 4096),
('Sc', 'ET', 'Na', 4096),
('Sc', 'ET', 'W', 4096),
('Sk', 'AL', 'N', 12288),
('Sk', 'L', 'N', 12288),
('Sk', 'ON', 'A', 12288),
('Sk', 'ON', 'F', 12288),
('Sk', 'ON', 'N', 12288),
('Sk', 'ON', 'Na', 12288),
('Sk', 'ON', 'W', 12288),
('Sm', 'AL', 'N', 4096),
('Sm', 'CS', 'N', 4096),
('Sm', 'ES', 'F', 4096),
('Sm', 'ES', 'N', 4096),
('Sm', 'ES', 'Na', 4096),
('Sm', 'ES', 'W', 4096),
('Sm', 'ET', 'A', 4096),
('Sm', 'ET', 'N', 4096),
('Sm', 'L', 'N', 4096),
('Sm', 'ON', 'A', 4096),
('Sm', 'ON', 'A', 4608),
('Sm', 'ON', 'F', 4096),
('Sm', 'ON', 'F', 4608),
('Sm', 'ON', 'H', 4096),
('Sm', 'ON', 'N', 4096),
('Sm', 'ON', 'N', 4608),
('Sm', 'ON', 'N', 7168),
('Sm', 'ON', 'Na', 4096),
('Sm', 'ON', 'Na', 4608),
('Sm', 'ON', 'W', 4096),
('Sm', 'ON', 'W', 4608),
('So', 'AL', 'N', 4096),
('So', 'ET', 'A', 4096),
('So', 'ET', 'N', 4096),
('So', 'ET', 'N', 7168),
('So', 'L', 'A', 4096),
('So', 'L', 'A', 4104),
('So', 'L', 'A', 4128),
('So', 'L', 'N', 4096),
('So', 'L', 'W', 4096),
('So', 'ON', 'A', 4096),
('So', 'ON', 'F', 4096),
('So', 'ON', 'H', 4096),
('So', 'ON', 'N', 4096),
('So', 'ON', 'Na', 4096),
('So', 'ON', 'W', 4096),
('Zl', 'WS', 'N', 5),
('Zp', 'B', 'N', 5),
('Zs', 'CS', 'N', 1),
('Zs', 'WS', 'F', 1),
('Zs', 'WS', 'N', 1),
('Zs', 'WS', 'Na', 4097),
]
_db_pgtbl = (
'\x00\x01\x02\x03\x04\x05\x06\x07\x08\t\n\x0b\x0c\r\x0e\x0f\x10\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f !"#$%&\'()*+,-./0123455565575555'
'555555555555589:5;5<55=5>55555?@55AB555C5555555D555E55F555555555'
'G555H5555555IJ55555555K55555555LM555N\x15OPQRST55555555555555555555'
'55555555555555555555555UVVVVVVVVWWWWWWWWWWWWWWWWWWWWWWWWWXYZ[\\]^'
'_`abcdddefghidjdklddddmddddddddd\x15\x15\x15noddddddddddd\x15\x15\x15\x15pddddddddddd'
'dddddddddddddddddddddddddddddddddddddddd\x15\x15qddddrdddddddddddddddd'
'ddddddddddddddddddddddddddddddddddddddddddddddddsddddddddddddddd'
'ddddddddddddddddtuvwxyz{dddddddddddddddddddddd|d}~\x7f\x80\x81\x82\x83\x84dddddddd'
'\x85\x865555555\x87\x88\x8955555555555555555555555\x8a55555\x8b55555555555555555\x8c5555'
'5555555555555555555555555555555555\x8d55555555555555555555555555555'
'55555555555555555555555555555555555555\x8e5555555555555555\x8f\x90\x91\x91\x91\x91\x91\x91\x91'
'\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x8a5\x90\x91\x91\x91\x91\x92'
'\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91'
'\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91'
'\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91'
'\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x92'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'\x93\x94dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW'
'WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW'
'WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW'
'WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW\x95'
'WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW'
'WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW'
'WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW'
'WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW\x95'
)
_db_pages = ( 
'\x01\x01\x01\x01\x01\x01\x01\x01\x01\x02\x00\x03\x04\x00\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x00\x00\x00\x02\xce\x8a\x8a\x7f\x9c\x7f\x8a\x8b\x94i\x8a\xa9x_yx??????????y\x8a\xb7\xb6\xb7\x8a'
'\x8a33333333333333333333333333\x94\x8ai\xa3\\\xa3\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x94\xb6i\xb6\x01'
'\x01\x01\x01\x01\x01\x00\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\xcb\x82\x9c\x9c\x98\x9c\xc7\x82\xa0\xc6(r\xb6\x07\xc3\xa3\xbb\xabMM\xa0\x17\x82\x84\xa0M(nSSS\x82'
'22222202222222220222222\xae0222220\x15\x15\x15\x17\x17\x17\x17\x15\x17\x15\x15\x15\x17\x15\x15\x17\x17\x15\x17\x15\x15\x17\x17\x17\xae\x15\x15\x15\x17\x15\x17\x15\x17'
'2\x152\x172\x172\x172\x172\x172\x172\x172\x152\x152\x172\x172\x172\x152\x172\x172\x172\x172\x170\x152\x172\x152\x172\x172\x150\x152\x172\x17\x152\x172\x172\x170'
'\x150\x152\x152\x172\x15\x150\x152\x152\x172\x170\x152\x172\x172\x172\x172\x172\x172\x172\x172\x170\x152\x172\x152\x172\x172\x172\x172\x172\x1722\x172\x172\x17\x17'
'\x1722\x172\x1722\x17222\x17\x172222\x1722\x17222\x17\x17\x1722\x1722\x172\x172\x1722\x172\x17\x172\x1722\x17222\x172\x1722\x17\x17+2\x17\x17\x17'
'++++2/\x172/\x172/\x172\x152\x152\x152\x152\x152\x152\x152\x15\x172\x172\x172\x172\x172\x172\x172\x172\x172\x17\x172/\x172\x17222\x172\x172\x172\x17'
'2\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x17\x17\x17\x17\x17\x17\x1722\x1722\x17'
'\x172\x172222\x172\x172\x172\x172\x17\x17\x15\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x15\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17'
'\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17+\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17         $$\x1f\x1f\x1f\x1f\x1f'
'  \xa2\xa2\xa0\xa2$"$"""$"$$\x1a\x1f\xa2\xa2\xa2\xa2\xa2\xa2\xa0\xa0\xa0\xa0\xa2\xa0\xa2\xa0     \xa2\xa2\xa2\xa2\xa2\xa2\xa2$\xa2\x1f\xa2\xa2\xa2\xa2\xa2\xa2\xa2\xa2\xa2\xa2\xa2\xa2\xa2\xa2\xa2\xa2\xa2'
'8888888888888888888888888888888888888888888888888888888888888888'
'8888898888888888888888888888888888888888888888882\x172\x17$\xa22\x17\x11\x11\x1e\x17\x17\x17\x88\x11'
'\x11\x11\x11\x11\xa2\xa22\x89222\x112\x1122\x1700000000000000000\x11000000022\x17\x17\x17\x17\x17\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x17\x15\x15\x15\x15\x15\x15\x15\x17\x17\x17\x17\x172\x17\x17222\x17\x17\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x17\x17\x17\x17\x172\x17\xb32\x1722\x17\x17222'
'202222222222222200000000000000000000000000000000\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x17\x15\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x17'
'2\x17\xc1:::::662\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x17'
'22\x172\x172\x172\x172\x172\x172\x17\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x17'
'2\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x17\x11\x11\x11\x11\x11\x11\x11\x11\x11222222222222222'
'22222222222222222222222\x11\x11\x1f\x81\x81\x81\x81\x81\x81\x11\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17'
'\x17\x17\x17\x17\x17\x17\x17\x17\x11\x81b\x11\x11\x11\x11\x9b\x11:::::::::::::::::::::::::::::::::::::::::::::d:'
'\x8e::\x8e::\x8e:\x11\x11\x11\x11\x11\x11\x11\x11...........................\x11\x11\x11\x11\x11...\x8e\x8f\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
"\x06\x06\x06\x06\x06\x11\xb3\xb3\xa5~~\x97ws\xc6\xc6:::::::::::s\x11\x11ss''''''''''''''''''''''''''''''''"
"\x19'''''''''':::::::::::::::::::::<<<<<<<<<<~tts'':'''''''''''''''"
"''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''"
"''''''''''''''''''''s':::::::\x06\xc6::::::\x19\x19::\xc6::::''>>>>>>>>>>'''\xba\xba'"
"ssssssssssssss\x11\x05':''''''''''''''''''''''''''''''::::::::::::::::"
":::::::::::\x11\x11'''''''''''''''''''''''''''''''''''''''''''''''''''"
"'''''''''''''''''''''''''''''''''''''':::::::::::'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11"
'AAAAAAAAAA.................................:::::::::%%\xc6\x88\x88\x88%\x11\x11\x11\x11\x11'
'......................::::%:::::::::%:::%:::::\x11\x11\x8e\x8e\x8e\x8e\x8e\x8e\x8e\x8e\x8e\x8e\x8e\x8e\x8e\x8e\x8e\x11'
'.........................:::\x11\x11\x8e\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
"\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'\x11'''''''''''\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11"
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11:::::::::::::::::::::::::::\x11'
':::4++++++++++++++++++++++++++++++++++++++++++++++++++++++:4:+44'
'4::::::::4444:44+:::::::++++++++++::\x81\x81@@@@@@@@@@\x81\x1f++++++\x11+++++++'
'\x11:44\x11++++++++\x11\x11++\x11\x11++++++++++++++++++++++\x11+++++++\x11+\x11\x11\x11++++\x11\x11:+44'
'4::::\x11\x1144\x11\x1144:+\x11\x11\x11\x11\x11\x11\x11\x114\x11\x11\x11\x11++\x11+++::\x11\x11@@@@@@@@@@++\x9b\x9bPPPPPP\xc1\x9b\x11\x11\x11\x11'
'\x11::4\x11++++++\x11\x11\x11\x11++\x11\x11++++++++++++++++++++++\x11+++++++\x11++\x11++\x11++\x11\x11:\x1144'
'4::\x11\x11\x11\x11::\x11\x11:::\x11\x11\x11:\x11\x11\x11\x11\x11\x11\x11++++\x11+\x11\x11\x11\x11\x11\x11\x11@@@@@@@@@@::+++:\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11::4\x11+++++++++\x11+++\x11++++++++++++++++++++++\x11+++++++\x11++\x11+++++\x11\x11:+44'
'4:::::\x11::4\x1144:\x11\x11+\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11++::\x11\x11@@@@@@@@@@\x81\x9b\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11:44\x11++++++++\x11\x11++\x11\x11++++++++++++++++++++++\x11+++++++\x11++\x11+++++\x11\x11:+4:'
'4::::\x11\x1144\x11\x1144:\x11\x11\x11\x11\x11\x11\x11\x11:4\x11\x11\x11\x11++\x11+++::\x11\x11@@@@@@@@@@\xc1+PPPPPP\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11:+\x11++++++\x11\x11\x11+++\x11++++\x11\x11\x11++\x11+\x11++\x11\x11\x11++\x11\x11\x11+++\x11\x11\x11++++++++++++\x11\x11\x11\x1144'
':44\x11\x11\x11444\x11444:\x11\x11+\x11\x11\x11\x11\x11\x114\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11@@@@@@@@@@PPP\xc6\xc6\xc6\xc6\xc6\xc6\x9b\xc6\x11\x11\x11\x11\x11'
'\x11444\x11++++++++\x11+++\x11+++++++++++++++++++++++\x11++++++++++\x11+++++\x11\x11\x11+::'
':4444\x11:::\x11::::\x11\x11\x11\x11\x11\x11\x11::\x11++\x11\x11\x11\x11\x11\x11++::\x11\x11@@@@@@@@@@\x11\x11\x11\x11\x11\x11\x11\x11UUUUUUU\xc1'
'\x11\x1144\x11++++++++\x11+++\x11+++++++++++++++++++++++\x11++++++++++\x11+++++\x11\x11:+47'
'44444\x11744\x1144::\x11\x11\x11\x11\x11\x11\x1144\x11\x11\x11\x11\x11\x11\x11+\x11++::\x11\x11@@@@@@@@@@\x11++\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x1144\x11++++++++\x11+++\x11+++++++++++++++++++++++++++++++++++++++++\x11\x11+44'
'4::::\x11444\x11444:+\x11\x11\x11\x11\x11\x11\x11\x114\x11\x11\x11\x11\x11\x11\x11\x11++::\x11\x11@@@@@@@@@@PPPPPP\x11\x11\x11\xc1++++++'
'\x11\x1144\x11++++++++++++++++++\x11\x11\x11++++++++++++++++++++++++\x11+++++++++\x11+\x11\x11'
'+++++++\x11\x11\x11:\x11\x11\x11\x11444:::\x11:\x1144444444\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x1144\x81\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11++++++++++++++++++++++++++++++++++++++++++++++++:+*:::::::\x11\x11\x11\x11\x9b'
'++++++\x1f::::::::\x81@@@@@@@@@@\x81\x81\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11++\x11+\x11\x11++\x11+\x11\x11+\x11\x11\x11\x11\x11\x11++++\x11+++++++\x11+++\x11+\x11+\x11\x11++\x11++++:+*::::::\x11::+\x11\x11'
'+++++\x11\x1f\x11::::::\x11\x11@@@@@@@@@@\x11\x11++++\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'+\xc1\xc1\xc1\x81\x81\x81\x81\x81\x81\x81\x81\x81\x81\x81\x81\x81\x81\x81\xc1\x81\xc1\xc1\xc1::\xc1\xc1\xc1\xc1\xc1\xc1@@@@@@@@@@PPPPPPPPPP\xc1:\xc1:\xc1:\x93h\x93h44'
'++++++++\x11++++++++++++++++++++++++++++++++++++\x11\x11\x11\x11::::::::::::::4'
':::::\x81::+++++:::::::::::\x11::::::::::::::::::::::::::::::::::::\x11\xc1\xc1'
'\xc1\xc1\xc1\xc1\xc1\xc1:\xc1\xc1\xc1\xc1\xc1\xc1\x11\xc1\xc1\x81\x81\x81\x81\x81\xc1\xc1\xc1\xc1\x81\x81\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'+++++++++++++++++++++++++++++++++++++++++++44::::4::::::4::44::+'
'@@@@@@@@@@\x81\x81\x81\x81\x81\x81++++++44::++++:::+444++4444444+++::::+++++++++++'
'++:44::444444:+4@@@@@@@@@@444:\xc1\xc122222222222222222222222222222222'
'222222\x112\x11\x11\x11\x11\x112\x11\x11+++++++++++++++++++++++++++++++++++++++++++\x81\x1f+++'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,++++++++++++++++++++++++++++++++'
'+++++++++++++++++++++++++++++++++++,,,,,++++++++++++++++++++++++'
'++++++++++++++++++++++++++++++++++++++++++++++++++++++++++,,,,,,'
'++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++'
'+++++++++\x11++++\x11\x11+++++++\x11+\x11++++\x11\x11++++++++++++++++++++++++++++++++'
'+++++++++\x11++++\x11\x11+++++++++++++++++++++++++++++++++\x11++++\x11\x11+++++++\x11'
'+\x11++++\x11\x11+++++++++++++++\x11++++++++++++++++++++++++++++++++++++++++'
'+++++++++++++++++\x11++++\x11\x11++++++++++++++++++++++++++++++++++++++++'
'+++++++++++++++++++++++++++\x11\x11:::\x81\x81\x81\x81\x81\x81\x81\x81\x81QQQQQQQQQPPPPPPPPPPP\x11\x11\x11'
'++++++++++++++++\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\x11\x11\x11\x11\x11\x11++++++++++++++++++++++++++++++++'
'+++++++++++++++++++++++++++++++++++++++++++++++++++++\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'b+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++'
'++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++'
'++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++'
'++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++'
'++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++'
'++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++'
'++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++'
'++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++'
'++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++'
'+++++++++++++++++++++++++++++++++++++++++++++\x81\x81+++++++++++++++++'
'\xcd++++++++++++++++++++++++++\x93h\x11\x11\x11++++++++++++++++++++++++++++++++'
'+++++++++++++++++++++++++++++++++++++++++++\x81\x81\x81EEE\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'+++++++++++++\x11++++:::\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11++++++++++++++++++:::\x81\x81\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'++++++++++++++++++::\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11+++++++++++++\x11+++\x11::\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'++++++++++++++++++++++++++++++++++++++++++++++++++++::4:::::::44'
'444444:44:::::::::::\x81\x81\x81\x1f\x81\x81\x81\x9b+:\x11\x11@@@@@@@@@@\x11\x11\x11\x11\x11\x11UUUUUUUUUU\x11\x11\x11\x11\x11\x11'
'\x88\x88\x88\x88\x88\x88b\x88\x88\x88\x88:::\xcd\x11@@@@@@@@@@\x11\x11\x11\x11\x11\x11++++++++++++++++++++++++++++++++'
'+++\x1f++++++++++++++++++++++++++++++++++++++++++++++++++++\x11\x11\x11\x11\x11\x11\x11\x11'
'+++++++++++++++++++++++++++++++++++++++++:+\x11\x11\x11\x11\x11++++++++++++++++'
'++++++++++++++++++++++++++++++++++++++++++++++++++++++\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'+++++++++++++++++++++++++++++\x11\x11\x11:::4444::444\x11\x11\x11\x1144:444444:::\x11\x11\x11\x11'
'\xc6\x11\x11\x11\x88\x88@@@@@@@@@@++++++++++++++++++++++++++++++\x11\x11+++++\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'++++++++++++++++++++++++++++++++++++++++++++\x11\x11\x11\x114444444444444444'
'4+++++++44\x11\x11\x11\x11\x11\x11@@@@@@@@@@Q\x11\x11\x11\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6'
'+++++++++++++++++++++++::444\x11\x11\x81\x81++++++++++++++++++++++++++++++++'
'+++++++++++++++++++++4:4:::::::\x11:4:44::::::::444444::::::::::\x11\x11:'
'@@@@@@@@@@\x11\x11\x11\x11\x11\x11@@@@@@@@@@\x11\x11\x11\x11\x11\x11\x81\x81\x81\x81\x81\x81\x81\x1f\x81\x81\x81\x81\x81\x81\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'::::4+++++++++++++++++++++++++++++++++++++++++++++++:4:::::4:444'
'44:44+++++++\x11\x11\x11\x11@@@@@@@@@@\x81\x81\x81\x81\x81\x81\x81\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1:::::::::\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\x11\x11\x11'
'::4++++++++++++++++++++++++++++++4::::44::4:44++@@@@@@@@@@++++++'
'++++++++++++++++++++++++++++++++++++++:4::444:4:::44\x11\x11\x11\x11\x11\x11\x11\x11\x81\x81\x81\x81'
'++++++++++++++++++++++++++++++++++++44444444::::::::44::\x11\x11\x11\x81\x81\x81\x81\x81'
'@@@@@@@@@@\x11\x11\x11+++@@@@@@@@@@++++++++++++++++++++++++++++++\x1f\x1f\x1f\x1f\x1f\x1f\x81\x81'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x81\x81\x81\x81\x81\x81\x81\x81\x11\x11\x11\x11\x11\x11\x11\x11:::\x81:::::::::::::4:::::::++++:++++44:++\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17                    '
'                                           \x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17 \x17\x17\x17\x17\x17\x17\x17'
'\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17                                     '
':::::::::::::::::::::::::::::::::::::::\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11::::'
'2\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x17'
'2\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x17'
'2\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x17\x17\x17\x17\x17\x17\x17\x17\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x17'
'2\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x17'
'\x17\x17\x17\x17\x17\x17\x17\x1722222222\x17\x17\x17\x17\x17\x17\x11\x11222222\x11\x11\x17\x17\x17\x17\x17\x17\x17\x1722222222\x17\x17\x17\x17\x17\x17\x17\x1722222222'
'\x17\x17\x17\x17\x17\x17\x11\x11222222\x11\x11\x17\x17\x17\x17\x17\x17\x17\x17\x112\x112\x112\x112\x17\x17\x17\x17\x17\x17\x17\x1722222222\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x11\x11'
'\x17\x17\x17\x17\x17\x17\x17\x17////////\x17\x17\x17\x17\x17\x17\x17\x17////////\x17\x17\x17\x17\x17\x17\x17\x17////////\x17\x17\x17\x17\x17\x11\x17\x172222/\xa2\x17\xa2'
'\xa2\xa2\x17\x17\x17\x11\x17\x172222/\xa2\xa2\xa2\x17\x17\x17\x17\x11\x11\x17\x172222\x11\xa2\xa2\xa2\x17\x17\x17\x17\x17\x17\x17\x1722222\xa2\xa2\xa2\x11\x11\x17\x17\x17\x11\x17\x172222/\xa2\xa2\x11'
'\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\x08\x08\x08\t\x0eabbaaa\x82\x88pm\x92qol\x92q\x82\x82\x82\x88\x83\x82\x82\x83\xc9\xca\n\x0f\r\x0b\x10\xcb|~||~\x82\x88\x88\x88rn\x82\x88\x88\x82['
'[\x88\x88\x88\xa6\x93h\x88\x88\x88\x88\x88\x88\x88\x88\x88\x88\x88\xb3\x88[\x88\x88\x88\x88\x88\x88\x88\x88\x88\x88\xcd\x08\x08\x08\x08\x08\x11\x11\x11\x11\x11\x08\x08\x08\x08\x08\x08N \x11\x11MNNNNN\xa8\xa8\xb3\x93h\x1b'
'NMMMMNNNNN\xa8\xa8\xb3\x93h\x11             \x11\x11\x11\x9b\x9b\x9b\x9b\x9b\x9b\x9b\x9b\x9b\x9a\x9b\x9b\x98\x9b\x9b\x9b\x9b\x9b\x9b\x9b\x9b\x9b\x9b\x9b\x9b\x9b\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11:::::::::::::6666:666::::::::::::\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\xc6\xc62\xc3\xc6\xc3\xc62\xc6\xc3\x17222\x17\x17222\x15\xc62\xc3\xc6\xb522222\xc6\xc6\xc6\xc3\xc3\xc62\xc60\xc62\xc62022\xbd\x172222\x17++++\x17\xc6\xc6\x17\x1722'
'\xb4\xb3\xb3\xb3\xb32\x17\x17\x17\x17\xc6\xb3\xc6\xc6\x17\xc1UUUSSUUUUUUSSSSUBBBBBBBBBBBBFFFFCCCCCCCCCCGGGGGG'
'EEE2\x17EEEES\x11\x11\x11\x11\x11\x11\xae\xae\xae\xae\xae\xc3\xc3\xc3\xc3\xc3\xb3\xb3\xc6\xc6\xc6\xc6\xb3\xc6\xc6\xb3\xc6\xc6\xb3\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xb3\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc3\xc3\xc6\xc6\xc6\xc6\xc6\xc6'
'\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xb3\xb3\xc6\xc6\xae\xc6\xae\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc3\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3'
'\xae\xb4\xaf\xaf\xb4\xb3\xb3\xae\xaf\xb4\xb4\xaf\xb4\xb4\xb3\xae\xb3\xaf\xa8\xac\xb3\xaf\xb4\xb3\xb3\xb3\xaf\xb4\xb4\xaf\xae\xaf\xaf\xb4\xb4\xae\xb4\xae\xb4\xae\xae\xae\xae\xaf\xaf\xb4\xaf\xb4\xb4\xb4\xb4\xb4\xae\xae\xae\xae\xb3\xb4\xb3\xb4\xaf\xaf\xb4\xb4'
'\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xaf\xb4\xb4\xb4\xaf\xb3\xb3\xb3\xb3\xb3\xaf\xb4\xb4\xb4\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb4\xaf\xae\xb4\xb3\xaf\xaf\xaf\xaf\xb4\xb4\xaf\xaf\xb3\xb3\xaf\xaf\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4'
'\xb4\xb4\xaf\xaf\xb4\xb4\xaf\xaf\xb4\xb4\xb4\xb4\xb4\xb3\xb3\xb4\xb4\xb4\xb4\xb3\xb3\xae\xb3\xb3\xb4\xae\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb4\xb4\xb3\xae\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb3\xb3\xb3\xb3\xb3\xb4\xaf'
'\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb4\xb4\xb4\xb4\xb4\xb3\xb3\xb4\xb4\xb3\xb3\xb3\xb3\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb3\xb3\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4'
'\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xb4\xb4\xb4\xb4\xc6\xc6\xc6\xc6\xc6\xc6\xc3\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xb4\xb4\xc6\xc6\xc6\xc6\xc6\xc6\xc6\x96k\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1'
'\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc6\xb3\xc6\xc6\xc6'
'\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc1\xc6\xc6\xc6\xc6\xc6\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6'
'\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xb3\xb3\xb3\xb3\xb3\xb3\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11TTTTTTTTTSSSSSSSSSSSTTTTTTTTTSSS'
'SSSSSSSSMMMMMMMMMLLLLLLLLLLL\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbf\xbf\xbf\xbf\xbf\xbf\xbf\xbf\xbf\xbf'
'\xbf\xbf\xbf\xbf\xbf\xbf\xbf\xbf\xbf\xbf\xbf\xbf\xbf\xbf\xbf\xbf\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0VSSSSSSSSSSTTTTTTTTTST'
'\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3'
'\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc6\xc6\xc6\xc6\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6'
'\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc6\xc6\xc3\xc3\xc3\xc3\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc3\xc3\xc6\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc3\xc3\xc6\xc6\xc3\xae\xc6\xc6\xc6\xc6\xc3\xc3\xc6\xc6'
'\xc3\xae\xc6\xc6\xc6\xc6\xc3\xc3\xc3\xc6\xc6\xc3\xc6\xc6\xc3\xc3\xc3\xc3\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc3\xc3\xc3\xc3\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc3\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3'
'\xc6\xc6\xc6\xc6\xc6\xc3\xc3\xc6\xc6\xc3\xc6\xc6\xc6\xc6\xc3\xc3\xc6\xc6\xc6\xc6\xc3\xc3\xc6\xc6\xc6\xc6\xc6\xc6\xc3\xc6\xc3\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6'
'\xc3\xc6\xc3\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc3\xc3\xc6\xc3\xc3\xc3\xc6\xc3\xc3\xc3\xc3\xc6\xc3\xc3\xc6\xae\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6'
'\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc3\xc3\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc1\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc3\xc3'
'\xc6\xc6\xc6\xc6\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc6\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc6\xc3\xc6\xc6\xc6\xc6\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3\xc3'
'\x11\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc3\xc6\xc6'
'\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc3\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\x93h\x93h\x93h\x93h\x93h\x93h\x93hTTTTTTTTTS'
'VVVVVVVVVUVVVVVVVVVU\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6'
'\xb4\xb3\xb3\xb4\xb4\x93h\xb3\xb4\xb4\xb3\xb4\xb4\xb4\xb3\xb3\xb3\xb3\xb3\xb4\xb4\xb4\xb4\xb3\xb3\xb3\xb3\xb3\xb4\xb4\xb4\xb3\xb3\xb3\xb4\xb4\xb4\xb4\x94i\x94i\x94i\x94i\x93h\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3'
'\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1'
'\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1'
'\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1'
'\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1'
'\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3'
'\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3'
'\xb3\xb3\xb3\x93h\x94i\x93h\x93h\x93h\x93h\x93h\x93h\x93h\x93h\x93h\xb3\xb3\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb4\xb3\xb3\xb3\xb3\xb3\xb3\xb3'
'\xb4\xb4\xb4\xb4\xb4\xb4\xb3\xb3\xb3\xb4\xb3\xb3\xb3\xb3\xb4\xb4\xb4\xb4\xb4\xb3\xb4\xb4\xb3\xb3\x93h\x93h\xb4\xb3\xb3\xb3\xb3\xb4\xb3\xb4\xb4\xb4\xb3\xb3\xb4\xb4\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb4\xb4\xb4\xb4\xb4\xb4\xb3\xb3\x93h\xb3\xb3'
'\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb3\xb4\xb4\xb4\xb4\xb3\xb3\xb4\xb3\xb4\xb3\xb3\xb4\xb3\xb4\xb4\xb4\xb4\xb3\xb3\xb3\xb3\xb3\xb4\xb4\xb3\xb3\xb3\xb3\xb3\xb3\xb4\xb4\xb4\xb3'
'\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb4\xb4\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb4\xb4\xb3\xb3\xb3\xb3\xb4\xb4\xb4\xb4\xb3\xb4\xb4\xb3\xb3\xb4\xb4\xb3\xb3\xb3\xb3\xb4\xb4\xb4\xb4\xb4\xb4\xb4'
'\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb3\xb3\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb3\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4'
'\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb4\xb3\xb3\xb3\xb3\xb3\xb4\xb3\xb4\xb3\xb3\xb3\xb4\xb4\xb4\xb4\xb4\xb3\xb3\xb3\xb3\xb3\xb4\xb4\xb4\xb3\xb3\xb3\xb3\xb4\xb3\xb3\xb3\xb4\xb4\xb4\xb4\xb4\xb3\xb4\xb3\xb3'
'\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3'
'\xb3\xb3\xb3\xb3\xb3\xc6\xc6\xb3\xb3\xb3\xb3\xb3\xb3\x11\x11\x11\xc6\xc6\xc6\xc6\xc6\xc3\xc3\xc3\xc3\xc3\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'22222222222222222222222222222222222222222222222\x11\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17'
'\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x112\x17222\x17\x172\x172\x172\x172222\x172\x17\x172\x17\x17\x17\x17\x17\x17  22'
'2\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x17'
'2\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x17\x17\xc6\xc6\xc6\xc6\xc6\xc62\x172\x17:::2\x17\x11\x11\x11\x11\x11\x88\x88\x88\x88U\x88\x88'
'\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x11\x17\x11\x11\x11\x11\x11\x17\x11\x11++++++++++++++++'
'++++++++++++++++++++++++++++++++++++++++\x11\x11\x11\x11\x11\x11\x11\x1f\x81\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11:'
'+++++++++++++++++++++++\x11\x11\x11\x11\x11\x11\x11\x11\x11+++++++\x11+++++++\x11+++++++\x11+++++++\x11'
'+++++++\x11+++++++\x11+++++++\x11+++++++\x11::::::::::::::::::::::::::::::::'
'\x88\x88rnrn\x88\x88\x88rn\x88rn\x88\x88\x88\x88\x88\x88\x88\x88\x88b\x88\x88b\x88rn\x88\x88rn\x93h\x93h\x93h\x93h\x88\x88\x88\x88\x88#\x88\x88\x88\x88\x88\x88\x88\x88\x88\x88bb\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\x11\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8'
'\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8'
'\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8'
'\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8'
'\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\x11\x11\x11\x11'
'\xcc\x8c\x8c\x8c\xc8!,H\x96k\x96k\x96k\x96k\x96k\xc8\xc8\x96k\x96k\x96k\x96kc\x95jj\xc8HHHHHHHHH;;;;55c!!!!!\xc8\xc8HHH!,\x8c\xc8\xc6'
'\x11,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,\x11\x11;;\xa4\xa4!!,c,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,\x8c!!!,'
'\x11\x11\x11\x11\x11,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,\x11\x11\x11,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,\x11\xc2\xc2RRRR\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2,,,,,,,,,,,,,,,,,,,,,,,,,,,\x11\x11\x11\x11\x11'
'\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11,,,,,,,,,,,,,,,,'
'\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc8\xc8\x11RRRRRRRRRR\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2'
'\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2OOOOOOOO\xc8WWWWWWWWWWWWWWW\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc8\xc8\xc8\xc2'
'RRRRRRRRRR\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2WWWWWWWWWWWWWWW'
'\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc8\xc8\xc8\xc8\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\x11'
'\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2'
'\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc8\xc8\xc8\xc8\xc2\xc2\xc2\xc2\xc2'
'\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2'
'\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc8\xc8\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc8'
',,,,,-,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,-,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,-,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,-,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12'
'\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6'
'-,,-,,,-,-,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,-,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,-,,,,,,,-,-,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,-'
'-,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,-,,,,,,,,-,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,-,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,-,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,-,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,-,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,-,-,-,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',-,---,,,,,,-,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',----,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,-,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,-,,,,,,,-,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,-,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,--'
',,,,,,,,,,,,---,-,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,-,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,-,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,-,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,-,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,-,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,-,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,-,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,-,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,-,,,,-,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,-,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,-,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,-,,,,,-,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,-,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,-,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12'
',,,,,,,,,,,,,,,,,,,,,!,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,\x11\x11\x11\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8'
'\xc8\xc8\xc8\xc8\xc8\xc8\xc8\x11\x11\x11\x11\x11\x11\x11\x11\x11++++++++++++++++++++++++++++++++++++++++\x1f\x1f\x1f\x1f\x1f\x1f\x81\x81'
'++++++++++++\x1f\x88\x88\x88++++++++++++++++@@@@@@@@@@++\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'2\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x17+:666\x88::::::::::\x88$'
'2\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x17\x11\x11\x11\x11\x11\x11\x11:++++++++++++++++++++++++++++++++'
'++++++++++++++++++++++++++++++++++++++EEEEEEEEEE::\x81\x81\x81\x81\x81\x81\x11\x11\x11\x11\x11\x11\x11\x11'
'\xa2\xa2\xa2\xa2\xa2\xa2\xa2\xa2\xa2\xa2\xa2\xa2\xa2\xa2\xa2\xa2\xa2\xa2\xa2\xa2\xa2\xa2\xa2$$$$$$$$$\xa2\xa22\x172\x172\x172\x172\x172\x172\x17\x17\x172\x172\x172\x172\x172\x172\x172\x17'
'2\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x17 \x17\x17\x17\x17\x17\x17\x17\x172\x172\x1722\x17'
'2\x172\x172\x172\x17$\x9f\x9f2\x172\x17\x112\x172\x17\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x112\x172\x172\x172\x172\x172\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11  \x17+++++'
'++:+++:++++:+++++++++++++++++++++++44::4\xc6\xc6\xc6\xc6\x11\x11\x11\x11PPPPPP\xc1\xc1\x9b\xbc\x11\x11\x11\x11\x11\x11'
'++++++++++++++++++++++++++++++++++++++++++++++++++++\x88\x88\x88\x88\x11\x11\x11\x11\x11\x11\x11\x11'
'44++++++++++++++++++++++++++++++++++++++++++++++++++444444444444'
'4444:\x11\x11\x11\x11\x11\x11\x11\x11\x11\x81\x81@@@@@@@@@@\x11\x11\x11\x11\x11\x11::::::::::::::::::++++++\x81\x81\x81+\x11\x11\x11\x11'
'@@@@@@@@@@++++++++++++++++++++++++++++::::::::\x81\x81++++++++++++++++'
'+++++++:::::::::::44\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x81,,,,,,,,,,,,,,,,,,,,,,,,,,,,,\x11\x11\x11'
':::4+++++++++++++++++++++++++++++++++++++++++++++++:44::::44:444'
'4\x81\x81\x81\x81\x81\x81\x81\x81\x81\x81\x81\x81\x81\x11\x1f@@@@@@@@@@\x11\x11\x11\x11\x81\x81\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'+++++++++++++++++++++++++++++++++++++++++::::::44::44::\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'+++:++++++++:4\x11\x11@@@@@@@@@@\x11\x11\x81\x81\x81\x81++++++++++++++++\x1f++++++\xc1\xc1\xc1+4\x11\x11\x11\x11'
'++++++++++++++++++++++++++++++++++++++++++++++++:+:::++::+++++::'
'+:+\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11++\x1f\x81\x81+++++++++++4::44\x81\x81+\x1f\x1f4:\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11++++++\x11\x11++++++\x11\x11++++++\x11\x11\x11\x11\x11\x11\x11\x11\x11+++++++\x11+++++++\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'+++++++++++++++++++++++++++++++++++44:44:44\x814:\x11\x11@@@@@@@@@@\x11\x11\x11\x11\x11\x11'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11,,,,,,,,,,,,,,,,'
',,,,,,,\x11\x11\x11\x11,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,\x11\x11\x11\x11'
'\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14'
'\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14'
'\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14'
'\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14'
'\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13'
'\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13'
'\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13'
'\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,-,,,,,,,-,,,,-,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,-,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,-,-,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,-,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,\x12\x12,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12'
'\x17\x17\x17\x17\x17\x17\x17\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x17\x17\x17\x17\x17\x11\x11\x11\x11\x11.:..........\xa8.............\x11.....\x11.\x11'
"..\x11..\x11..........''''''''''''''''''''''''''''''''''''''''''''''''"
"''''''''''''''''''''''''''''''''''''''''''''''''''\x9e\x9e\x9e\x9e\x9e\x9e\x9e\x9e\x9e\x9e\x9e\x9e\x9e\x9e"
"\x9e\x9e\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'''''''''''''''''''''''''''''''''''''''''''''"
"''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''"
"''''''''''''''''''''''''''''''&&&&&&''''''''''''''''''''''''''''"
"''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''"
"''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''"
"''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''\x92g"
"\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11''''''''''''''''''''''''''''''''''''''''''''''''"
"''''''''''''''''\x11\x11''''''''''''''''''''''''''''''''''''''''''''''"
"''''''''\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11''''''''''&&\x97\xc6\x11\x11"
'8888888888888888\x8c\x8c\x8c\x8d\x8c\x8c\x8c\x95j\x8c\x11\x11\x11\x11\x11\x11:::::::\x11\x11\x11\x11\x11\x11\x11\x11\x11\x8ccc]]\x95j\x95j\x95j\x95j\x95j\x95'
"j\x95j\x95j\x8c\x8c\x95j\x8c\x8c\x8c\x8c]]]z\x8c{\x11\x8c{\x8c\x8cc\x96k\x96k\x96k\x80\x8c\x8c\xaa`\xb9\xb9\xb8\x11\x8c\x9d\x80\x8c\x11\x11\x11\x11&'&'&\x11&'&'&'&'&'"
"''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''"
"'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''\x11\x11\x08"
'\x11\x85\x85}\x99}\x85\x86\x90e\x85\xa7u^vu==========v\x85\xb1\xb0\xb1\x85\x8511111111111111111111111111\x90\x85e\xa1Z'
'\xa1\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x90\xb0e\xb0\x90e\x87\x91f\x87\x87))))))))))\x1d)))))))))))))))'
'))))))))))))))))))))))))))))))\x1c\x1c)))))))))))))))))))))))))))))))\x11'
'\x11\x11))))))\x11\x11))))))\x11\x11))))))\x11\x11)))\x11\x11\x11\x99\x99\xb0\xa1\xc4\x99\x99\x11\xc5\xb2\xb2\xb2\xb2\xc5\xc5\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x0c\x0c\x0c\xc6\xc3\x11\x11'
'++++++++++++\x11++++++++++++++++++++++++++\x11+++++++++++++++++++\x11++\x11+'
'++++++++++++++\x11\x11++++++++++++++\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++'
'+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++\x11\x11\x11\x11\x11'
'\x81\x88\x81\x11\x11\x11\x11PPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPP\x11\x11\x11\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1'
'IIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIUUUU\xc6\xc6\xc6\xc6\xc6\xc6\xc6'
'\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6U\x11\x11\x11\x11\x11\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1:\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'+++++++++++++++++++++++++++++\x11\x11\x11++++++++++++++++++++++++++++++++'
'+++++++++++++++++\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'+++++++++++++++++++++++++++++++\x11PPPP\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11++++++++++++++++'
'+E++++++++E\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'++++++++++++++++++++++++++++++\x11\x81++++++++++++++++++++++++++++++++'
'++++\x11\x11\x11\x11++++++++\x81EEEEE\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'2222222222222222222222222222222222222222\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17'
'\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17++++++++++++++++++++++++++++++++++++++++++++++++'
'++++++++++++++++++++++++++++++\x11\x11@@@@@@@@@@\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'......\x11\x11.\x11............................................\x11..\x11\x11\x11.\x11\x11.'
'......................\x11\x8eXXXXXXXX\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'......................XXXXXX\x11\x11\x11\x88..........................\x11\x11\x11\x11\x11\x8e'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'........................................................\x11\x11\x11\x11\x11\x11..'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'.:::\x11::\x11\x11\x11\x11\x11::::....\x11...\x11...........................\x11\x11\x11\x11:::\x11\x11\x11\x11:'
'YYYYXXXX\x11\x11\x11\x11\x11\x11\x11\x11\x8e\x8e\x8e\x8e\x8e\x8e\x8e\x8e\x8e\x11\x11\x11\x11\x11\x11\x11.............................XX\x8e'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'......................................................\x11\x11\x11\x88\x88\x88\x88\x88\x88\x88'
'......................\x11\x11XXXXXXXX...................\x11\x11\x11\x11\x11XXXXXXXX'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'................................................................'
'.........\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11KKKKKKKKKJJJJJJJJJJJJJJJJJJJJJJ\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'4:4+++++++++++++++++++++++++++++++++++++++++++++++++++++::::::::'
':::::::\x81\x81\x81\x81\x81\x81\x81\x11\x11\x11\x11VVVVVVVVVUUUUUUUUUUU@@@@@@@@@@\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'::4+++++++++++++++++++++++++++++++++++++++++++++444::::44::\x81\x81\t\x81\x81'
'\x81\x81\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11+++++++++++++++++++++++++\x11\x11\x11\x11\x11\x11\x11@@@@@@@@@@\x11\x11\x11\x11\x11\x11'
':::++++++++++++++++++++++++++++++++++++:::::4::::::::\x11@@@@@@@@@@'
'\x81\x81\x81\x81\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'::4++++++++++++++++++++++++++++++++++++++++++++++++444:::::::::4'
'4++++\x81\x81\x81\x81\x11\x11\x11\x11\x11\x11\x11@@@@@@@@@@\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'+++++++++++++++++++++++++++++++++++++++++++:4:44::::::4:\x11\x11\x11\x11\x11\x11\x11\x11'
'@@@@@@@@@@\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++'
'+++++++++++++++++++++++++++++++++++++++++++++++\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'EEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEDDEEEEEEEEEEEE'
'EEEEEEEEEEEEEEEEEEEEEEDDEEEEEEEEEEE\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x81\x81\x81\x81\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'+++++++++++++++++++++++++++++++++++++++++++++++\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'+++++++++++++++++++++++++++++++++++++++++++++++++++++++++\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++'
'+++++\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11+4444444444444444444444444444444444444444444444\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11::::\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
',,\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1'
'\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1'
'\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1'
'\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\x11\x11\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1'
'\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc144:::\xc1\xc1\xc1444444\x08\x08\x08\x08\x08\x08\x08\x08:::::'
':::\xc1\xc1:::::::\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1::::\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1'
'\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6'
'\xc6\xc6:::\xc6\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6'
'\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\x11\x11\x11\x11\x11\x11\x11\x11\x11PPPPPPPPPPPPPPPPPP\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'22222222222222222222222222\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17222222222222'
'22222222222222\x17\x17\x17\x17\x17\x17\x17\x11\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17222222222222222222222222'
'22\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x172\x1122\x11\x112\x11\x1122\x11\x112222\x1122222222\x17\x17\x17\x17\x11\x17\x11\x17\x17\x17'
'\x17\x17\x17\x17\x11\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x1722222222222222222222222222\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17'
'\x17\x17\x17\x1722\x112222\x11\x1122222222\x112222222\x11\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x1722\x112222\x11'
'22222\x112\x11\x11\x112222222\x11\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x1722222222222222222222'
'222222\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x1722222222222222222222222222\x17\x17\x17\x17\x17\x17'
'\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x1722222222222222222222222222\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17'
'\x17\x17\x17\x17\x17\x17\x17\x1722222222222222222222222222\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x172222'
'2222222222222222222222\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x172222222222222222'
'2222222222\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x11\x11222222222222222222222222'
'2\xad\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\xb4\x17\x17\x17\x17\x17\x172222222222222222222222222\xad\x17\x17\x17\x17'
'\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\xb4\x17\x17\x17\x17\x17\x172222222222222222222222222\xad\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17'
'\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\xb4\x17\x17\x17\x17\x17\x172222222222222222222222222\xad\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17'
'\x17\x17\x17\x17\x17\x17\x17\x17\x17\xb4\x17\x17\x17\x17\x17\x172222222222222222222222222\xad\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17'
'\x17\x17\x17\xb4\x17\x17\x17\x17\x17\x172\x17\x11\x11>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>'
"''''\x11'''''''''''''''''''''''''''\x11''\x11'\x11\x11'\x11''''''''''\x11''''\x11'\x11'\x11\x11\x11\x11"
"\x11\x11'\x11\x11\x11\x11'\x11'\x11'\x11'''\x11''\x11'\x11\x11'\x11'\x11'\x11'\x11'\x11''\x11'\x11\x11''''\x11'''''''\x11''''\x11''''\x11'\x11"
"''''''''''\x11'''''''''''''''''\x11\x11\x11\x11\x11'''\x11'''''\x11'''''''''''''''''\x11\x11\x11\x11"
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\xb3\xb3\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\x11\x11\x11\x11\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6'
'\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6'
'\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\x11\x11\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\x11'
'\x11\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\x11\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'MMMMMMMMMMM\x11\x11\x11\x11\x11\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xc1\x11\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe'
'\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xc6\xc6\x11\x11\x11\x11\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe'
'\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1'
'\xc2\xc2\xc2\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\x11\x11\x11\x11\x11'
'\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\x11\x11\x11\x11\x11\x11\x11\xc2\xc2\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\xc6\xc6\xc6\xc6\xc6\xc6\x11\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6'
'\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\x11\x11\x11'
'\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6'
'\xc6\xc6\xc6\xc6\xc6\x11\xc6\xc6\xc6\xc6\xc6\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\x11'
'\xc6\x11\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6'
'\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6'
'\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\x11\xc6\xc6\xc6\xc6\x11\x11\x11'
'\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\x11\x11'
'\xc6\xc6\xc6\xc6\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\xc6\xc6\xc6\xc6\xc6'
'\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6'
'\xc6\x11\x11\x11\x11\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6'
'\xc6\xc6\xc6\xc6\xc6\xc6\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6'
'\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
',-,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,-,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,-,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,-,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,-,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,-,,,,,,,,-,,,,,,,,,,,,,,,-,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,-,,,,,,,,,,,,,,,,,,-,,'
',,,,,,,,,,,,,,,,,,,,,,,,,-,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,-,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,-,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,-,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,-,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12'
'\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12'
'\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12'
'\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12'
'\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12'
'\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12'
'\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12'
'\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12'
'\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12'
'\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12'
'\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12'
'\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x11\x11'
'\x11\x08\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08'
'\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'8888888888888888888888888888888888888888888888888888888888888888'
'8888888888888888888888888888888888888888888888888888888888888888'
'8888888888888888888888888888888888888888888888888888888888888888'
'888888888888888888888888888888888888888888888888\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13'
'\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13'
'\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13'
'\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x11\x11'
)

def _get_record(code):
    return _db_records[ord(_db_pages[(ord(_db_pgtbl[code >> 8]) << 8) + (code & 255)])]

def category(code): return _get_record(code)[0]
def bidirectional(code): return _get_record(code)[1]
def east_asian_width(code): return _get_record(code)[2]
def isspace(code): return _get_record(code)[3] & 1 != 0
def isalpha(code): return _get_record(code)[3] & 2 != 0
def islinebreak(code): return _get_record(code)[3] & 4 != 0
def isnumeric(code): return _get_record(code)[3] & 64 != 0
def isdigit(code): return _get_record(code)[3] & 128 != 0
def isdecimal(code): return _get_record(code)[3] & 256 != 0
def isalnum(code): return _get_record(code)[3] & 66 != 0
def isupper(code): return _get_record(code)[3] & 8 != 0
def istitle(code): return _get_record(code)[3] & 16 != 0
def islower(code): return _get_record(code)[3] & 32 != 0
def iscased(code): return _get_record(code)[3] & 56 != 0
def isxidstart(code): return _get_record(code)[3] & 1024 != 0
def isxidcontinue(code): return _get_record(code)[3] & 2048 != 0
def isprintable(code): return _get_record(code)[3] & 4096 != 0
def mirrored(code): return _get_record(code)[3] & 512 != 0
def iscaseignorable(code): return _get_record(code)[3] & 8192 != 0
_decimal = {
69734: 0,
69735: 1,
69736: 2,
69737: 3,
69738: 4,
69739: 5,
69740: 6,
69741: 7,
69742: 8,
69743: 9,
69872: 0,
69873: 1,
69874: 2,
69875: 3,
69876: 4,
69877: 5,
69878: 6,
69879: 7,
69880: 8,
69881: 9,
69942: 0,
69943: 1,
69944: 2,
69945: 3,
69946: 4,
69947: 5,
69948: 6,
69949: 7,
69950: 8,
69951: 9,
70096: 0,
70097: 1,
70098: 2,
70099: 3,
70100: 4,
70101: 5,
70102: 6,
70103: 7,
70104: 8,
70105: 9,
71360: 0,
71361: 1,
71362: 2,
71363: 3,
71364: 4,
71365: 5,
71366: 6,
71367: 7,
71368: 8,
71369: 9,
}

_decimal_corrected = {
6618: None,
}
_digit = {
69714: 1,
69715: 2,
69716: 3,
69717: 4,
69718: 5,
69719: 6,
69720: 7,
69721: 8,
69722: 9,
69734: 0,
69735: 1,
69736: 2,
69737: 3,
69738: 4,
69739: 5,
69740: 6,
69741: 7,
69742: 8,
69743: 9,
69872: 0,
69873: 1,
69874: 2,
69875: 3,
69876: 4,
69877: 5,
69878: 6,
69879: 7,
69880: 8,
69881: 9,
69942: 0,
69943: 1,
69944: 2,
69945: 3,
69946: 4,
69947: 5,
69948: 6,
69949: 7,
69950: 8,
69951: 9,
70096: 0,
70097: 1,
70098: 2,
70099: 3,
70100: 4,
70101: 5,
70102: 6,
70103: 7,
70104: 8,
70105: 9,
71360: 0,
71361: 1,
71362: 2,
71363: 3,
71364: 4,
71365: 5,
71366: 6,
71367: 7,
71368: 8,
71369: 9,
}

_digit_corrected = {
}
_numeric = {
188: 1.0 / 4.0,
189: 1.0 / 2.0,
190: 3.0 / 4.0,
2548: 1.0 / 16.0,
2549: 1.0 / 8.0,
2550: 3.0 / 16.0,
2551: 1.0 / 4.0,
2552: 3.0 / 4.0,
2930: 1.0 / 4.0,
2931: 1.0 / 2.0,
2932: 3.0 / 4.0,
2933: 1.0 / 16.0,
2934: 1.0 / 8.0,
2935: 3.0 / 16.0,
3443: 1.0 / 4.0,
3444: 1.0 / 2.0,
3445: 3.0 / 4.0,
3882: 1.0 / 2.0,
3883: 3.0 / 2.0,
3884: 5.0 / 2.0,
3885: 7.0 / 2.0,
3886: 9.0 / 2.0,
3887: 11.0 / 2.0,
3888: 13.0 / 2.0,
3889: 15.0 / 2.0,
3890: 17.0 / 2.0,
3891: -1.0 / 2.0,
8528: 1.0 / 7.0,
8529: 1.0 / 9.0,
8530: 1.0 / 10.0,
8531: 1.0 / 3.0,
8532: 2.0 / 3.0,
8533: 1.0 / 5.0,
8534: 2.0 / 5.0,
8535: 3.0 / 5.0,
8536: 4.0 / 5.0,
8537: 1.0 / 6.0,
8538: 5.0 / 6.0,
8539: 1.0 / 8.0,
8540: 3.0 / 8.0,
8541: 5.0 / 8.0,
8542: 7.0 / 8.0,
11517: 1.0 / 2.0,
12872: 10.0,
12873: 20.0,
12874: 30.0,
12875: 40.0,
12876: 50.0,
12877: 60.0,
12878: 70.0,
12879: 80.0,
43056: 1.0 / 4.0,
43057: 1.0 / 2.0,
43058: 3.0 / 4.0,
43059: 1.0 / 16.0,
43060: 1.0 / 8.0,
43061: 3.0 / 16.0,
65856: 1.0 / 4.0,
65857: 1.0 / 2.0,
65909: 1.0 / 2.0,
65910: 1.0 / 2.0,
65911: 2.0 / 3.0,
65912: 3.0 / 4.0,
69243: 1.0 / 2.0,
69244: 1.0 / 4.0,
69245: 1.0 / 3.0,
69246: 2.0 / 3.0,
69714: 1.0,
69715: 2.0,
69716: 3.0,
69717: 4.0,
69718: 5.0,
69719: 6.0,
69720: 7.0,
69721: 8.0,
69722: 9.0,
69723: 10.0,
69724: 20.0,
69725: 30.0,
69726: 40.0,
69727: 50.0,
69728: 60.0,
69729: 70.0,
69730: 80.0,
69731: 90.0,
69732: 100.0,
69733: 1000.0,
69734: 0.0,
69735: 1.0,
69736: 2.0,
69737: 3.0,
69738: 4.0,
69739: 5.0,
69740: 6.0,
69741: 7.0,
69742: 8.0,
69743: 9.0,
69872: 0.0,
69873: 1.0,
69874: 2.0,
69875: 3.0,
69876: 4.0,
69877: 5.0,
69878: 6.0,
69879: 7.0,
69880: 8.0,
69881: 9.0,
69942: 0.0,
69943: 1.0,
69944: 2.0,
69945: 3.0,
69946: 4.0,
69947: 5.0,
69948: 6.0,
69949: 7.0,
69950: 8.0,
69951: 9.0,
70096: 0.0,
70097: 1.0,
70098: 2.0,
70099: 3.0,
70100: 4.0,
70101: 5.0,
70102: 6.0,
70103: 7.0,
70104: 8.0,
70105: 9.0,
71360: 0.0,
71361: 1.0,
71362: 2.0,
71363: 3.0,
71364: 4.0,
71365: 5.0,
71366: 6.0,
71367: 7.0,
71368: 8.0,
71369: 9.0,
74842: 1.0 / 3.0,
74843: 2.0 / 3.0,
74844: 5.0 / 6.0,
74845: 1.0 / 3.0,
74846: 2.0 / 3.0,
74847: 1.0 / 8.0,
74848: 1.0 / 4.0,
74849: 1.0 / 6.0,
74850: 1.0 / 4.0,
}

_numeric_corrected = {
}

def decimal(code):
    try:
        return _decimal[code]
    except KeyError:
        if base_mod is not None and code not in _decimal_corrected:
            return base_mod._decimal[code]
        else:
            raise

def digit(code):
    try:
        return _digit[code]
    except KeyError:
        if base_mod is not None and code not in _digit_corrected:
            return base_mod._digit[code]
        else:
            raise

def numeric(code):
    try:
        return _numeric[code]
    except KeyError:
        if base_mod is not None and code not in _numeric_corrected:
            return base_mod._numeric[code]
        else:
            raise

_toupper = {
613: 42893,
614: 42922,
1319: 1318,
11507: 11506,
11559: 4295,
11565: 4301,
42593: 42592,
42897: 42896,
42899: 42898,
42913: 42912,
42915: 42914,
42917: 42916,
42919: 42918,
42921: 42920,
}

_toupper_corrected = {
}
_tolower = {
1318: 1319,
4295: 11559,
4301: 11565,
11506: 11507,
42592: 42593,
42893: 613,
42896: 42897,
42898: 42899,
42912: 42913,
42914: 42915,
42916: 42917,
42918: 42919,
42920: 42921,
42922: 614,
}

_tolower_corrected = {
}
_totitle = {
613: 42893,
614: 42922,
1319: 1318,
11507: 11506,
11559: 4295,
11565: 4301,
42593: 42592,
42897: 42896,
42899: 42898,
42913: 42912,
42915: 42914,
42917: 42916,
42919: 42918,
42921: 42920,
}

_totitle_corrected = {
}
_special_casing = {
}

_special_casing_corrected = {
}

def toupper(code):
    if code < 128:
        if ord('a') <= code <= ord('z'):
            return code - 32
        return code
    try:
        return _toupper[code]
    except KeyError:
        if base_mod is not None and code not in _toupper_corrected:
            return base_mod._toupper.get(code, code)
        else:
            return code

def tolower(code):
    if code < 128:
        if ord('A') <= code <= ord('Z'):
            return code + 32
        return code
    try:
        return _tolower[code]
    except KeyError:
        if base_mod is not None and code not in _tolower_corrected:
            return base_mod._tolower.get(code, code)
        else:
            return code

def totitle(code):
    try:
        return _totitle[code]
    except KeyError:
        if base_mod is not None and code not in _totitle_corrected:
            return base_mod._totitle.get(code, code)
        else:
            return code

def toupper_full(code):
    if code < 128:
        if ord('a') <= code <= ord('z'):
            return [code - 32]
        return [code]
    try:
        return _special_casing[code][2]
    except KeyError:
        if base_mod is not None and code not in _special_casing_corrected:
            try:
                return base_mod._special_casing[code][2]
            except KeyError:
                pass
    return [toupper(code)]

def tolower_full(code):
    if code < 128:
        if ord('A') <= code <= ord('Z'):
            return [code + 32]
        return [code]
    try:
        return _special_casing[code][0]
    except KeyError:
        if base_mod is not None and code not in _special_casing_corrected:
            try:
                return base_mod._special_casing[code][0]
            except KeyError:
                pass
    return [tolower(code)]

def totitle_full(code):
    try:
        return _special_casing[code][1]
    except KeyError:
        if base_mod is not None and code not in _special_casing_corrected:
            try:
                return base_mod._special_casing[code][1]
            except KeyError:
                pass
    return [totitle(code)]

_raw_decomposition = {
8341: '<sub> 0068',
8342: '<sub> 006B',
8343: '<sub> 006C',
8344: '<sub> 006D',
8345: '<sub> 006E',
8346: '<sub> 0070',
8347: '<sub> 0073',
8348: '<sub> 0074',
43000: '<super> 0126',
43001: '<super> 0153',
64046: '90DE',
64047: '96B7',
69934: '11131 11127',
69935: '11132 11127',
126464: '<font> 0627',
126465: '<font> 0628',
126466: '<font> 062C',
126467: '<font> 062F',
126469: '<font> 0648',
126470: '<font> 0632',
126471: '<font> 062D',
126472: '<font> 0637',
126473: '<font> 064A',
126474: '<font> 0643',
126475: '<font> 0644',
126476: '<font> 0645',
126477: '<font> 0646',
126478: '<font> 0633',
126479: '<font> 0639',
126480: '<font> 0641',
126481: '<font> 0635',
126482: '<font> 0642',
126483: '<font> 0631',
126484: '<font> 0634',
126485: '<font> 062A',
126486: '<font> 062B',
126487: '<font> 062E',
126488: '<font> 0630',
126489: '<font> 0636',
126490: '<font> 0638',
126491: '<font> 063A',
126492: '<font> 066E',
126493: '<font> 06BA',
126494: '<font> 06A1',
126495: '<font> 066F',
126497: '<font> 0628',
126498: '<font> 062C',
126500: '<font> 0647',
126503: '<font> 062D',
126505: '<font> 064A',
126506: '<font> 0643',
126507: '<font> 0644',
126508: '<font> 0645',
126509: '<font> 0646',
126510: '<font> 0633',
126511: '<font> 0639',
126512: '<font> 0641',
126513: '<font> 0635',
126514: '<font> 0642',
126516: '<font> 0634',
126517: '<font> 062A',
126518: '<font> 062B',
126519: '<font> 062E',
126521: '<font> 0636',
126523: '<font> 063A',
126530: '<font> 062C',
126535: '<font> 062D',
126537: '<font> 064A',
126539: '<font> 0644',
126541: '<font> 0646',
126542: '<font> 0633',
126543: '<font> 0639',
126545: '<font> 0635',
126546: '<font> 0642',
126548: '<font> 0634',
126551: '<font> 062E',
126553: '<font> 0636',
126555: '<font> 063A',
126557: '<font> 06BA',
126559: '<font> 066F',
126561: '<font> 0628',
126562: '<font> 062C',
126564: '<font> 0647',
126567: '<font> 062D',
126568: '<font> 0637',
126569: '<font> 064A',
126570: '<font> 0643',
126572: '<font> 0645',
126573: '<font> 0646',
126574: '<font> 0633',
126575: '<font> 0639',
126576: '<font> 0641',
126577: '<font> 0635',
126578: '<font> 0642',
126580: '<font> 0634',
126581: '<font> 062A',
126582: '<font> 062B',
126583: '<font> 062E',
126585: '<font> 0636',
126586: '<font> 0638',
126587: '<font> 063A',
126588: '<font> 066E',
126590: '<font> 06A1',
126592: '<font> 0627',
126593: '<font> 0628',
126594: '<font> 062C',
126595: '<font> 062F',
126596: '<font> 0647',
126597: '<font> 0648',
126598: '<font> 0632',
126599: '<font> 062D',
126600: '<font> 0637',
126601: '<font> 064A',
126603: '<font> 0644',
126604: '<font> 0645',
126605: '<font> 0646',
126606: '<font> 0633',
126607: '<font> 0639',
126608: '<font> 0641',
126609: '<font> 0635',
126610: '<font> 0642',
126611: '<font> 0631',
126612: '<font> 0634',
126613: '<font> 062A',
126614: '<font> 062B',
126615: '<font> 062E',
126616: '<font> 0630',
126617: '<font> 0636',
126618: '<font> 0638',
126619: '<font> 063A',
126625: '<font> 0628',
126626: '<font> 062C',
126627: '<font> 062F',
126629: '<font> 0648',
126630: '<font> 0632',
126631: '<font> 062D',
126632: '<font> 0637',
126633: '<font> 064A',
126635: '<font> 0644',
126636: '<font> 0645',
126637: '<font> 0646',
126638: '<font> 0633',
126639: '<font> 0639',
126640: '<font> 0641',
126641: '<font> 0635',
126642: '<font> 0642',
126643: '<font> 0631',
126644: '<font> 0634',
126645: '<font> 062A',
126646: '<font> 062B',
126647: '<font> 062E',
126648: '<font> 0630',
126649: '<font> 0636',
126650: '<font> 0638',
126651: '<font> 063A',
127280: '<square> 0041',
127282: '<square> 0043',
127283: '<square> 0044',
127284: '<square> 0045',
127285: '<square> 0046',
127286: '<square> 0047',
127287: '<square> 0048',
127288: '<square> 0049',
127289: '<square> 004A',
127290: '<square> 004B',
127291: '<square> 004C',
127292: '<square> 004D',
127294: '<square> 004F',
127296: '<square> 0051',
127297: '<square> 0052',
127299: '<square> 0054',
127300: '<square> 0055',
127301: '<square> 0056',
127303: '<square> 0058',
127304: '<square> 0059',
127305: '<square> 005A',
127311: '<square> 0057 0043',
127338: '<super> 004D 0043',
127339: '<super> 004D 0044',
127489: '<square> 30B3 30B3',
127490: '<square> 30B5',
127538: '<square> 7981',
127539: '<square> 7A7A',
127540: '<square> 5408',
127541: '<square> 6E80',
127542: '<square> 6709',
127543: '<square> 6708',
127544: '<square> 7533',
127545: '<square> 5272',
127546: '<square> 55B6',
127568: '<circle> 5F97',
127569: '<circle> 53EF',
}

_raw_decomposition_corrected = {
}

def decomposition(code):
    try:
        return _raw_decomposition[code]
    except KeyError:
        if base_mod is not None and code not in _raw_decomposition_corrected:
            return base_mod._raw_decomposition.get(code, '')
        else:
            return ''

_composition = {
r_longlong(   65 << 32 |   768):   192,
r_longlong(   65 << 32 |   769):   193,
r_longlong(   65 << 32 |   770):   194,
r_longlong(   65 << 32 |   771):   195,
r_longlong(   65 << 32 |   776):   196,
r_longlong(   65 << 32 |   778):   197,
r_longlong(   67 << 32 |   807):   199,
r_longlong(   69 << 32 |   768):   200,
r_longlong(   69 << 32 |   769):   201,
r_longlong(   69 << 32 |   770):   202,
r_longlong(   69 << 32 |   776):   203,
r_longlong(   73 << 32 |   768):   204,
r_longlong(   73 << 32 |   769):   205,
r_longlong(   73 << 32 |   770):   206,
r_longlong(   73 << 32 |   776):   207,
r_longlong(   78 << 32 |   771):   209,
r_longlong(   79 << 32 |   768):   210,
r_longlong(   79 << 32 |   769):   211,
r_longlong(   79 << 32 |   770):   212,
r_longlong(   79 << 32 |   771):   213,
r_longlong(   79 << 32 |   776):   214,
r_longlong(   85 << 32 |   768):   217,
r_longlong(   85 << 32 |   769):   218,
r_longlong(   85 << 32 |   770):   219,
r_longlong(   85 << 32 |   776):   220,
r_longlong(   89 << 32 |   769):   221,
r_longlong(   97 << 32 |   768):   224,
r_longlong(   97 << 32 |   769):   225,
r_longlong(   97 << 32 |   770):   226,
r_longlong(   97 << 32 |   771):   227,
r_longlong(   97 << 32 |   776):   228,
r_longlong(   97 << 32 |   778):   229,
r_longlong(   99 << 32 |   807):   231,
r_longlong(  101 << 32 |   768):   232,
r_longlong(  101 << 32 |   769):   233,
r_longlong(  101 << 32 |   770):   234,
r_longlong(  101 << 32 |   776):   235,
r_longlong(  105 << 32 |   768):   236,
r_longlong(  105 << 32 |   769):   237,
r_longlong(  105 << 32 |   770):   238,
r_longlong(  105 << 32 |   776):   239,
r_longlong(  110 << 32 |   771):   241,
r_longlong(  111 << 32 |   768):   242,
r_longlong(  111 << 32 |   769):   243,
r_longlong(  111 << 32 |   770):   244,
r_longlong(  111 << 32 |   771):   245,
r_longlong(  111 << 32 |   776):   246,
r_longlong(  117 << 32 |   768):   249,
r_longlong(  117 << 32 |   769):   250,
r_longlong(  117 << 32 |   770):   251,
r_longlong(  117 << 32 |   776):   252,
r_longlong(  121 << 32 |   769):   253,
r_longlong(  121 << 32 |   776):   255,
r_longlong(   65 << 32 |   772):   256,
r_longlong(   97 << 32 |   772):   257,
r_longlong(   65 << 32 |   774):   258,
r_longlong(   97 << 32 |   774):   259,
r_longlong(   65 << 32 |   808):   260,
r_longlong(   97 << 32 |   808):   261,
r_longlong(   67 << 32 |   769):   262,
r_longlong(   99 << 32 |   769):   263,
r_longlong(   67 << 32 |   770):   264,
r_longlong(   99 << 32 |   770):   265,
r_longlong(   67 << 32 |   775):   266,
r_longlong(   99 << 32 |   775):   267,
r_longlong(   67 << 32 |   780):   268,
r_longlong(   99 << 32 |   780):   269,
r_longlong(   68 << 32 |   780):   270,
r_longlong(  100 << 32 |   780):   271,
r_longlong(   69 << 32 |   772):   274,
r_longlong(  101 << 32 |   772):   275,
r_longlong(   69 << 32 |   774):   276,
r_longlong(  101 << 32 |   774):   277,
r_longlong(   69 << 32 |   775):   278,
r_longlong(  101 << 32 |   775):   279,
r_longlong(   69 << 32 |   808):   280,
r_longlong(  101 << 32 |   808):   281,
r_longlong(   69 << 32 |   780):   282,
r_longlong(  101 << 32 |   780):   283,
r_longlong(   71 << 32 |   770):   284,
r_longlong(  103 << 32 |   770):   285,
r_longlong(   71 << 32 |   774):   286,
r_longlong(  103 << 32 |   774):   287,
r_longlong(   71 << 32 |   775):   288,
r_longlong(  103 << 32 |   775):   289,
r_longlong(   71 << 32 |   807):   290,
r_longlong(  103 << 32 |   807):   291,
r_longlong(   72 << 32 |   770):   292,
r_longlong(  104 << 32 |   770):   293,
r_longlong(   73 << 32 |   771):   296,
r_longlong(  105 << 32 |   771):   297,
r_longlong(   73 << 32 |   772):   298,
r_longlong(  105 << 32 |   772):   299,
r_longlong(   73 << 32 |   774):   300,
r_longlong(  105 << 32 |   774):   301,
r_longlong(   73 << 32 |   808):   302,
r_longlong(  105 << 32 |   808):   303,
r_longlong(   73 << 32 |   775):   304,
r_longlong(   74 << 32 |   770):   308,
r_longlong(  106 << 32 |   770):   309,
r_longlong(   75 << 32 |   807):   310,
r_longlong(  107 << 32 |   807):   311,
r_longlong(   76 << 32 |   769):   313,
r_longlong(  108 << 32 |   769):   314,
r_longlong(   76 << 32 |   807):   315,
r_longlong(  108 << 32 |   807):   316,
r_longlong(   76 << 32 |   780):   317,
r_longlong(  108 << 32 |   780):   318,
r_longlong(   78 << 32 |   769):   323,
r_longlong(  110 << 32 |   769):   324,
r_longlong(   78 << 32 |   807):   325,
r_longlong(  110 << 32 |   807):   326,
r_longlong(   78 << 32 |   780):   327,
r_longlong(  110 << 32 |   780):   328,
r_longlong(   79 << 32 |   772):   332,
r_longlong(  111 << 32 |   772):   333,
r_longlong(   79 << 32 |   774):   334,
r_longlong(  111 << 32 |   774):   335,
r_longlong(   79 << 32 |   779):   336,
r_longlong(  111 << 32 |   779):   337,
r_longlong(   82 << 32 |   769):   340,
r_longlong(  114 << 32 |   769):   341,
r_longlong(   82 << 32 |   807):   342,
r_longlong(  114 << 32 |   807):   343,
r_longlong(   82 << 32 |   780):   344,
r_longlong(  114 << 32 |   780):   345,
r_longlong(   83 << 32 |   769):   346,
r_longlong(  115 << 32 |   769):   347,
r_longlong(   83 << 32 |   770):   348,
r_longlong(  115 << 32 |   770):   349,
r_longlong(   83 << 32 |   807):   350,
r_longlong(  115 << 32 |   807):   351,
r_longlong(   83 << 32 |   780):   352,
r_longlong(  115 << 32 |   780):   353,
r_longlong(   84 << 32 |   807):   354,
r_longlong(  116 << 32 |   807):   355,
r_longlong(   84 << 32 |   780):   356,
r_longlong(  116 << 32 |   780):   357,
r_longlong(   85 << 32 |   771):   360,
r_longlong(  117 << 32 |   771):   361,
r_longlong(   85 << 32 |   772):   362,
r_longlong(  117 << 32 |   772):   363,
r_longlong(   85 << 32 |   774):   364,
r_longlong(  117 << 32 |   774):   365,
r_longlong(   85 << 32 |   778):   366,
r_longlong(  117 << 32 |   778):   367,
r_longlong(   85 << 32 |   779):   368,
r_longlong(  117 << 32 |   779):   369,
r_longlong(   85 << 32 |   808):   370,
r_longlong(  117 << 32 |   808):   371,
r_longlong(   87 << 32 |   770):   372,
r_longlong(  119 << 32 |   770):   373,
r_longlong(   89 << 32 |   770):   374,
r_longlong(  121 << 32 |   770):   375,
r_longlong(   89 << 32 |   776):   376,
r_longlong(   90 << 32 |   769):   377,
r_longlong(  122 << 32 |   769):   378,
r_longlong(   90 << 32 |   775):   379,
r_longlong(  122 << 32 |   775):   380,
r_longlong(   90 << 32 |   780):   381,
r_longlong(  122 << 32 |   780):   382,
r_longlong(   79 << 32 |   795):   416,
r_longlong(  111 << 32 |   795):   417,
r_longlong(   85 << 32 |   795):   431,
r_longlong(  117 << 32 |   795):   432,
r_longlong(   65 << 32 |   780):   461,
r_longlong(   97 << 32 |   780):   462,
r_longlong(   73 << 32 |   780):   463,
r_longlong(  105 << 32 |   780):   464,
r_longlong(   79 << 32 |   780):   465,
r_longlong(  111 << 32 |   780):   466,
r_longlong(   85 << 32 |   780):   467,
r_longlong(  117 << 32 |   780):   468,
r_longlong(  220 << 32 |   772):   469,
r_longlong(  252 << 32 |   772):   470,
r_longlong(  220 << 32 |   769):   471,
r_longlong(  252 << 32 |   769):   472,
r_longlong(  220 << 32 |   780):   473,
r_longlong(  252 << 32 |   780):   474,
r_longlong(  220 << 32 |   768):   475,
r_longlong(  252 << 32 |   768):   476,
r_longlong(  196 << 32 |   772):   478,
r_longlong(  228 << 32 |   772):   479,
r_longlong(  550 << 32 |   772):   480,
r_longlong(  551 << 32 |   772):   481,
r_longlong(  198 << 32 |   772):   482,
r_longlong(  230 << 32 |   772):   483,
r_longlong(   71 << 32 |   780):   486,
r_longlong(  103 << 32 |   780):   487,
r_longlong(   75 << 32 |   780):   488,
r_longlong(  107 << 32 |   780):   489,
r_longlong(   79 << 32 |   808):   490,
r_longlong(  111 << 32 |   808):   491,
r_longlong(  490 << 32 |   772):   492,
r_longlong(  491 << 32 |   772):   493,
r_longlong(  439 << 32 |   780):   494,
r_longlong(  658 << 32 |   780):   495,
r_longlong(  106 << 32 |   780):   496,
r_longlong(   71 << 32 |   769):   500,
r_longlong(  103 << 32 |   769):   501,
r_longlong(   78 << 32 |   768):   504,
r_longlong(  110 << 32 |   768):   505,
r_longlong(  197 << 32 |   769):   506,
r_longlong(  229 << 32 |   769):   507,
r_longlong(  198 << 32 |   769):   508,
r_longlong(  230 << 32 |   769):   509,
r_longlong(  216 << 32 |   769):   510,
r_longlong(  248 << 32 |   769):   511,
r_longlong(   65 << 32 |   783):   512,
r_longlong(   97 << 32 |   783):   513,
r_longlong(   65 << 32 |   785):   514,
r_longlong(   97 << 32 |   785):   515,
r_longlong(   69 << 32 |   783):   516,
r_longlong(  101 << 32 |   783):   517,
r_longlong(   69 << 32 |   785):   518,
r_longlong(  101 << 32 |   785):   519,
r_longlong(   73 << 32 |   783):   520,
r_longlong(  105 << 32 |   783):   521,
r_longlong(   73 << 32 |   785):   522,
r_longlong(  105 << 32 |   785):   523,
r_longlong(   79 << 32 |   783):   524,
r_longlong(  111 << 32 |   783):   525,
r_longlong(   79 << 32 |   785):   526,
r_longlong(  111 << 32 |   785):   527,
r_longlong(   82 << 32 |   783):   528,
r_longlong(  114 << 32 |   783):   529,
r_longlong(   82 << 32 |   785):   530,
r_longlong(  114 << 32 |   785):   531,
r_longlong(   85 << 32 |   783):   532,
r_longlong(  117 << 32 |   783):   533,
r_longlong(   85 << 32 |   785):   534,
r_longlong(  117 << 32 |   785):   535,
r_longlong(   83 << 32 |   806):   536,
r_longlong(  115 << 32 |   806):   537,
r_longlong(   84 << 32 |   806):   538,
r_longlong(  116 << 32 |   806):   539,
r_longlong(   72 << 32 |   780):   542,
r_longlong(  104 << 32 |   780):   543,
r_longlong(   65 << 32 |   775):   550,
r_longlong(   97 << 32 |   775):   551,
r_longlong(   69 << 32 |   807):   552,
r_longlong(  101 << 32 |   807):   553,
r_longlong(  214 << 32 |   772):   554,
r_longlong(  246 << 32 |   772):   555,
r_longlong(  213 << 32 |   772):   556,
r_longlong(  245 << 32 |   772):   557,
r_longlong(   79 << 32 |   775):   558,
r_longlong(  111 << 32 |   775):   559,
r_longlong(  558 << 32 |   772):   560,
r_longlong(  559 << 32 |   772):   561,
r_longlong(   89 << 32 |   772):   562,
r_longlong(  121 << 32 |   772):   563,
r_longlong(  168 << 32 |   769):   901,
r_longlong(  913 << 32 |   769):   902,
r_longlong(  917 << 32 |   769):   904,
r_longlong(  919 << 32 |   769):   905,
r_longlong(  921 << 32 |   769):   906,
r_longlong(  927 << 32 |   769):   908,
r_longlong(  933 << 32 |   769):   910,
r_longlong(  937 << 32 |   769):   911,
r_longlong(  970 << 32 |   769):   912,
r_longlong(  921 << 32 |   776):   938,
r_longlong(  933 << 32 |   776):   939,
r_longlong(  945 << 32 |   769):   940,
r_longlong(  949 << 32 |   769):   941,
r_longlong(  951 << 32 |   769):   942,
r_longlong(  953 << 32 |   769):   943,
r_longlong(  971 << 32 |   769):   944,
r_longlong(  953 << 32 |   776):   970,
r_longlong(  965 << 32 |   776):   971,
r_longlong(  959 << 32 |   769):   972,
r_longlong(  965 << 32 |   769):   973,
r_longlong(  969 << 32 |   769):   974,
r_longlong(  978 << 32 |   769):   979,
r_longlong(  978 << 32 |   776):   980,
r_longlong( 1045 << 32 |   768):  1024,
r_longlong( 1045 << 32 |   776):  1025,
r_longlong( 1043 << 32 |   769):  1027,
r_longlong( 1030 << 32 |   776):  1031,
r_longlong( 1050 << 32 |   769):  1036,
r_longlong( 1048 << 32 |   768):  1037,
r_longlong( 1059 << 32 |   774):  1038,
r_longlong( 1048 << 32 |   774):  1049,
r_longlong( 1080 << 32 |   774):  1081,
r_longlong( 1077 << 32 |   768):  1104,
r_longlong( 1077 << 32 |   776):  1105,
r_longlong( 1075 << 32 |   769):  1107,
r_longlong( 1110 << 32 |   776):  1111,
r_longlong( 1082 << 32 |   769):  1116,
r_longlong( 1080 << 32 |   768):  1117,
r_longlong( 1091 << 32 |   774):  1118,
r_longlong( 1140 << 32 |   783):  1142,
r_longlong( 1141 << 32 |   783):  1143,
r_longlong( 1046 << 32 |   774):  1217,
r_longlong( 1078 << 32 |   774):  1218,
r_longlong( 1040 << 32 |   774):  1232,
r_longlong( 1072 << 32 |   774):  1233,
r_longlong( 1040 << 32 |   776):  1234,
r_longlong( 1072 << 32 |   776):  1235,
r_longlong( 1045 << 32 |   774):  1238,
r_longlong( 1077 << 32 |   774):  1239,
r_longlong( 1240 << 32 |   776):  1242,
r_longlong( 1241 << 32 |   776):  1243,
r_longlong( 1046 << 32 |   776):  1244,
r_longlong( 1078 << 32 |   776):  1245,
r_longlong( 1047 << 32 |   776):  1246,
r_longlong( 1079 << 32 |   776):  1247,
r_longlong( 1048 << 32 |   772):  1250,
r_longlong( 1080 << 32 |   772):  1251,
r_longlong( 1048 << 32 |   776):  1252,
r_longlong( 1080 << 32 |   776):  1253,
r_longlong( 1054 << 32 |   776):  1254,
r_longlong( 1086 << 32 |   776):  1255,
r_longlong( 1256 << 32 |   776):  1258,
r_longlong( 1257 << 32 |   776):  1259,
r_longlong( 1069 << 32 |   776):  1260,
r_longlong( 1101 << 32 |   776):  1261,
r_longlong( 1059 << 32 |   772):  1262,
r_longlong( 1091 << 32 |   772):  1263,
r_longlong( 1059 << 32 |   776):  1264,
r_longlong( 1091 << 32 |   776):  1265,
r_longlong( 1059 << 32 |   779):  1266,
r_longlong( 1091 << 32 |   779):  1267,
r_longlong( 1063 << 32 |   776):  1268,
r_longlong( 1095 << 32 |   776):  1269,
r_longlong( 1067 << 32 |   776):  1272,
r_longlong( 1099 << 32 |   776):  1273,
r_longlong( 1575 << 32 |  1619):  1570,
r_longlong( 1575 << 32 |  1620):  1571,
r_longlong( 1608 << 32 |  1620):  1572,
r_longlong( 1575 << 32 |  1621):  1573,
r_longlong( 1610 << 32 |  1620):  1574,
r_longlong( 1749 << 32 |  1620):  1728,
r_longlong( 1729 << 32 |  1620):  1730,
r_longlong( 1746 << 32 |  1620):  1747,
r_longlong( 2344 << 32 |  2364):  2345,
r_longlong( 2352 << 32 |  2364):  2353,
r_longlong( 2355 << 32 |  2364):  2356,
r_longlong( 2503 << 32 |  2494):  2507,
r_longlong( 2503 << 32 |  2519):  2508,
r_longlong( 2887 << 32 |  2902):  2888,
r_longlong( 2887 << 32 |  2878):  2891,
r_longlong( 2887 << 32 |  2903):  2892,
r_longlong( 2962 << 32 |  3031):  2964,
r_longlong( 3014 << 32 |  3006):  3018,
r_longlong( 3015 << 32 |  3006):  3019,
r_longlong( 3014 << 32 |  3031):  3020,
r_longlong( 3142 << 32 |  3158):  3144,
r_longlong( 3263 << 32 |  3285):  3264,
r_longlong( 3270 << 32 |  3285):  3271,
r_longlong( 3270 << 32 |  3286):  3272,
r_longlong( 3270 << 32 |  3266):  3274,
r_longlong( 3274 << 32 |  3285):  3275,
r_longlong( 3398 << 32 |  3390):  3402,
r_longlong( 3399 << 32 |  3390):  3403,
r_longlong( 3398 << 32 |  3415):  3404,
r_longlong( 3545 << 32 |  3530):  3546,
r_longlong( 3545 << 32 |  3535):  3548,
r_longlong( 3548 << 32 |  3530):  3549,
r_longlong( 3545 << 32 |  3551):  3550,
r_longlong( 4133 << 32 |  4142):  4134,
r_longlong( 6917 << 32 |  6965):  6918,
r_longlong( 6919 << 32 |  6965):  6920,
r_longlong( 6921 << 32 |  6965):  6922,
r_longlong( 6923 << 32 |  6965):  6924,
r_longlong( 6925 << 32 |  6965):  6926,
r_longlong( 6929 << 32 |  6965):  6930,
r_longlong( 6970 << 32 |  6965):  6971,
r_longlong( 6972 << 32 |  6965):  6973,
r_longlong( 6974 << 32 |  6965):  6976,
r_longlong( 6975 << 32 |  6965):  6977,
r_longlong( 6978 << 32 |  6965):  6979,
r_longlong(   65 << 32 |   805):  7680,
r_longlong(   97 << 32 |   805):  7681,
r_longlong(   66 << 32 |   775):  7682,
r_longlong(   98 << 32 |   775):  7683,
r_longlong(   66 << 32 |   803):  7684,
r_longlong(   98 << 32 |   803):  7685,
r_longlong(   66 << 32 |   817):  7686,
r_longlong(   98 << 32 |   817):  7687,
r_longlong(  199 << 32 |   769):  7688,
r_longlong(  231 << 32 |   769):  7689,
r_longlong(   68 << 32 |   775):  7690,
r_longlong(  100 << 32 |   775):  7691,
r_longlong(   68 << 32 |   803):  7692,
r_longlong(  100 << 32 |   803):  7693,
r_longlong(   68 << 32 |   817):  7694,
r_longlong(  100 << 32 |   817):  7695,
r_longlong(   68 << 32 |   807):  7696,
r_longlong(  100 << 32 |   807):  7697,
r_longlong(   68 << 32 |   813):  7698,
r_longlong(  100 << 32 |   813):  7699,
r_longlong(  274 << 32 |   768):  7700,
r_longlong(  275 << 32 |   768):  7701,
r_longlong(  274 << 32 |   769):  7702,
r_longlong(  275 << 32 |   769):  7703,
r_longlong(   69 << 32 |   813):  7704,
r_longlong(  101 << 32 |   813):  7705,
r_longlong(   69 << 32 |   816):  7706,
r_longlong(  101 << 32 |   816):  7707,
r_longlong(  552 << 32 |   774):  7708,
r_longlong(  553 << 32 |   774):  7709,
r_longlong(   70 << 32 |   775):  7710,
r_longlong(  102 << 32 |   775):  7711,
r_longlong(   71 << 32 |   772):  7712,
r_longlong(  103 << 32 |   772):  7713,
r_longlong(   72 << 32 |   775):  7714,
r_longlong(  104 << 32 |   775):  7715,
r_longlong(   72 << 32 |   803):  7716,
r_longlong(  104 << 32 |   803):  7717,
r_longlong(   72 << 32 |   776):  7718,
r_longlong(  104 << 32 |   776):  7719,
r_longlong(   72 << 32 |   807):  7720,
r_longlong(  104 << 32 |   807):  7721,
r_longlong(   72 << 32 |   814):  7722,
r_longlong(  104 << 32 |   814):  7723,
r_longlong(   73 << 32 |   816):  7724,
r_longlong(  105 << 32 |   816):  7725,
r_longlong(  207 << 32 |   769):  7726,
r_longlong(  239 << 32 |   769):  7727,
r_longlong(   75 << 32 |   769):  7728,
r_longlong(  107 << 32 |   769):  7729,
r_longlong(   75 << 32 |   803):  7730,
r_longlong(  107 << 32 |   803):  7731,
r_longlong(   75 << 32 |   817):  7732,
r_longlong(  107 << 32 |   817):  7733,
r_longlong(   76 << 32 |   803):  7734,
r_longlong(  108 << 32 |   803):  7735,
r_longlong( 7734 << 32 |   772):  7736,
r_longlong( 7735 << 32 |   772):  7737,
r_longlong(   76 << 32 |   817):  7738,
r_longlong(  108 << 32 |   817):  7739,
r_longlong(   76 << 32 |   813):  7740,
r_longlong(  108 << 32 |   813):  7741,
r_longlong(   77 << 32 |   769):  7742,
r_longlong(  109 << 32 |   769):  7743,
r_longlong(   77 << 32 |   775):  7744,
r_longlong(  109 << 32 |   775):  7745,
r_longlong(   77 << 32 |   803):  7746,
r_longlong(  109 << 32 |   803):  7747,
r_longlong(   78 << 32 |   775):  7748,
r_longlong(  110 << 32 |   775):  7749,
r_longlong(   78 << 32 |   803):  7750,
r_longlong(  110 << 32 |   803):  7751,
r_longlong(   78 << 32 |   817):  7752,
r_longlong(  110 << 32 |   817):  7753,
r_longlong(   78 << 32 |   813):  7754,
r_longlong(  110 << 32 |   813):  7755,
r_longlong(  213 << 32 |   769):  7756,
r_longlong(  245 << 32 |   769):  7757,
r_longlong(  213 << 32 |   776):  7758,
r_longlong(  245 << 32 |   776):  7759,
r_longlong(  332 << 32 |   768):  7760,
r_longlong(  333 << 32 |   768):  7761,
r_longlong(  332 << 32 |   769):  7762,
r_longlong(  333 << 32 |   769):  7763,
r_longlong(   80 << 32 |   769):  7764,
r_longlong(  112 << 32 |   769):  7765,
r_longlong(   80 << 32 |   775):  7766,
r_longlong(  112 << 32 |   775):  7767,
r_longlong(   82 << 32 |   775):  7768,
r_longlong(  114 << 32 |   775):  7769,
r_longlong(   82 << 32 |   803):  7770,
r_longlong(  114 << 32 |   803):  7771,
r_longlong( 7770 << 32 |   772):  7772,
r_longlong( 7771 << 32 |   772):  7773,
r_longlong(   82 << 32 |   817):  7774,
r_longlong(  114 << 32 |   817):  7775,
r_longlong(   83 << 32 |   775):  7776,
r_longlong(  115 << 32 |   775):  7777,
r_longlong(   83 << 32 |   803):  7778,
r_longlong(  115 << 32 |   803):  7779,
r_longlong(  346 << 32 |   775):  7780,
r_longlong(  347 << 32 |   775):  7781,
r_longlong(  352 << 32 |   775):  7782,
r_longlong(  353 << 32 |   775):  7783,
r_longlong( 7778 << 32 |   775):  7784,
r_longlong( 7779 << 32 |   775):  7785,
r_longlong(   84 << 32 |   775):  7786,
r_longlong(  116 << 32 |   775):  7787,
r_longlong(   84 << 32 |   803):  7788,
r_longlong(  116 << 32 |   803):  7789,
r_longlong(   84 << 32 |   817):  7790,
r_longlong(  116 << 32 |   817):  7791,
r_longlong(   84 << 32 |   813):  7792,
r_longlong(  116 << 32 |   813):  7793,
r_longlong(   85 << 32 |   804):  7794,
r_longlong(  117 << 32 |   804):  7795,
r_longlong(   85 << 32 |   816):  7796,
r_longlong(  117 << 32 |   816):  7797,
r_longlong(   85 << 32 |   813):  7798,
r_longlong(  117 << 32 |   813):  7799,
r_longlong(  360 << 32 |   769):  7800,
r_longlong(  361 << 32 |   769):  7801,
r_longlong(  362 << 32 |   776):  7802,
r_longlong(  363 << 32 |   776):  7803,
r_longlong(   86 << 32 |   771):  7804,
r_longlong(  118 << 32 |   771):  7805,
r_longlong(   86 << 32 |   803):  7806,
r_longlong(  118 << 32 |   803):  7807,
r_longlong(   87 << 32 |   768):  7808,
r_longlong(  119 << 32 |   768):  7809,
r_longlong(   87 << 32 |   769):  7810,
r_longlong(  119 << 32 |   769):  7811,
r_longlong(   87 << 32 |   776):  7812,
r_longlong(  119 << 32 |   776):  7813,
r_longlong(   87 << 32 |   775):  7814,
r_longlong(  119 << 32 |   775):  7815,
r_longlong(   87 << 32 |   803):  7816,
r_longlong(  119 << 32 |   803):  7817,
r_longlong(   88 << 32 |   775):  7818,
r_longlong(  120 << 32 |   775):  7819,
r_longlong(   88 << 32 |   776):  7820,
r_longlong(  120 << 32 |   776):  7821,
r_longlong(   89 << 32 |   775):  7822,
r_longlong(  121 << 32 |   775):  7823,
r_longlong(   90 << 32 |   770):  7824,
r_longlong(  122 << 32 |   770):  7825,
r_longlong(   90 << 32 |   803):  7826,
r_longlong(  122 << 32 |   803):  7827,
r_longlong(   90 << 32 |   817):  7828,
r_longlong(  122 << 32 |   817):  7829,
r_longlong(  104 << 32 |   817):  7830,
r_longlong(  116 << 32 |   776):  7831,
r_longlong(  119 << 32 |   778):  7832,
r_longlong(  121 << 32 |   778):  7833,
r_longlong(  383 << 32 |   775):  7835,
r_longlong(   65 << 32 |   803):  7840,
r_longlong(   97 << 32 |   803):  7841,
r_longlong(   65 << 32 |   777):  7842,
r_longlong(   97 << 32 |   777):  7843,
r_longlong(  194 << 32 |   769):  7844,
r_longlong(  226 << 32 |   769):  7845,
r_longlong(  194 << 32 |   768):  7846,
r_longlong(  226 << 32 |   768):  7847,
r_longlong(  194 << 32 |   777):  7848,
r_longlong(  226 << 32 |   777):  7849,
r_longlong(  194 << 32 |   771):  7850,
r_longlong(  226 << 32 |   771):  7851,
r_longlong( 7840 << 32 |   770):  7852,
r_longlong( 7841 << 32 |   770):  7853,
r_longlong(  258 << 32 |   769):  7854,
r_longlong(  259 << 32 |   769):  7855,
r_longlong(  258 << 32 |   768):  7856,
r_longlong(  259 << 32 |   768):  7857,
r_longlong(  258 << 32 |   777):  7858,
r_longlong(  259 << 32 |   777):  7859,
r_longlong(  258 << 32 |   771):  7860,
r_longlong(  259 << 32 |   771):  7861,
r_longlong( 7840 << 32 |   774):  7862,
r_longlong( 7841 << 32 |   774):  7863,
r_longlong(   69 << 32 |   803):  7864,
r_longlong(  101 << 32 |   803):  7865,
r_longlong(   69 << 32 |   777):  7866,
r_longlong(  101 << 32 |   777):  7867,
r_longlong(   69 << 32 |   771):  7868,
r_longlong(  101 << 32 |   771):  7869,
r_longlong(  202 << 32 |   769):  7870,
r_longlong(  234 << 32 |   769):  7871,
r_longlong(  202 << 32 |   768):  7872,
r_longlong(  234 << 32 |   768):  7873,
r_longlong(  202 << 32 |   777):  7874,
r_longlong(  234 << 32 |   777):  7875,
r_longlong(  202 << 32 |   771):  7876,
r_longlong(  234 << 32 |   771):  7877,
r_longlong( 7864 << 32 |   770):  7878,
r_longlong( 7865 << 32 |   770):  7879,
r_longlong(   73 << 32 |   777):  7880,
r_longlong(  105 << 32 |   777):  7881,
r_longlong(   73 << 32 |   803):  7882,
r_longlong(  105 << 32 |   803):  7883,
r_longlong(   79 << 32 |   803):  7884,
r_longlong(  111 << 32 |   803):  7885,
r_longlong(   79 << 32 |   777):  7886,
r_longlong(  111 << 32 |   777):  7887,
r_longlong(  212 << 32 |   769):  7888,
r_longlong(  244 << 32 |   769):  7889,
r_longlong(  212 << 32 |   768):  7890,
r_longlong(  244 << 32 |   768):  7891,
r_longlong(  212 << 32 |   777):  7892,
r_longlong(  244 << 32 |   777):  7893,
r_longlong(  212 << 32 |   771):  7894,
r_longlong(  244 << 32 |   771):  7895,
r_longlong( 7884 << 32 |   770):  7896,
r_longlong( 7885 << 32 |   770):  7897,
r_longlong(  416 << 32 |   769):  7898,
r_longlong(  417 << 32 |   769):  7899,
r_longlong(  416 << 32 |   768):  7900,
r_longlong(  417 << 32 |   768):  7901,
r_longlong(  416 << 32 |   777):  7902,
r_longlong(  417 << 32 |   777):  7903,
r_longlong(  416 << 32 |   771):  7904,
r_longlong(  417 << 32 |   771):  7905,
r_longlong(  416 << 32 |   803):  7906,
r_longlong(  417 << 32 |   803):  7907,
r_longlong(   85 << 32 |   803):  7908,
r_longlong(  117 << 32 |   803):  7909,
r_longlong(   85 << 32 |   777):  7910,
r_longlong(  117 << 32 |   777):  7911,
r_longlong(  431 << 32 |   769):  7912,
r_longlong(  432 << 32 |   769):  7913,
r_longlong(  431 << 32 |   768):  7914,
r_longlong(  432 << 32 |   768):  7915,
r_longlong(  431 << 32 |   777):  7916,
r_longlong(  432 << 32 |   777):  7917,
r_longlong(  431 << 32 |   771):  7918,
r_longlong(  432 << 32 |   771):  7919,
r_longlong(  431 << 32 |   803):  7920,
r_longlong(  432 << 32 |   803):  7921,
r_longlong(   89 << 32 |   768):  7922,
r_longlong(  121 << 32 |   768):  7923,
r_longlong(   89 << 32 |   803):  7924,
r_longlong(  121 << 32 |   803):  7925,
r_longlong(   89 << 32 |   777):  7926,
r_longlong(  121 << 32 |   777):  7927,
r_longlong(   89 << 32 |   771):  7928,
r_longlong(  121 << 32 |   771):  7929,
r_longlong(  945 << 32 |   787):  7936,
r_longlong(  945 << 32 |   788):  7937,
r_longlong( 7936 << 32 |   768):  7938,
r_longlong( 7937 << 32 |   768):  7939,
r_longlong( 7936 << 32 |   769):  7940,
r_longlong( 7937 << 32 |   769):  7941,
r_longlong( 7936 << 32 |   834):  7942,
r_longlong( 7937 << 32 |   834):  7943,
r_longlong(  913 << 32 |   787):  7944,
r_longlong(  913 << 32 |   788):  7945,
r_longlong( 7944 << 32 |   768):  7946,
r_longlong( 7945 << 32 |   768):  7947,
r_longlong( 7944 << 32 |   769):  7948,
r_longlong( 7945 << 32 |   769):  7949,
r_longlong( 7944 << 32 |   834):  7950,
r_longlong( 7945 << 32 |   834):  7951,
r_longlong(  949 << 32 |   787):  7952,
r_longlong(  949 << 32 |   788):  7953,
r_longlong( 7952 << 32 |   768):  7954,
r_longlong( 7953 << 32 |   768):  7955,
r_longlong( 7952 << 32 |   769):  7956,
r_longlong( 7953 << 32 |   769):  7957,
r_longlong(  917 << 32 |   787):  7960,
r_longlong(  917 << 32 |   788):  7961,
r_longlong( 7960 << 32 |   768):  7962,
r_longlong( 7961 << 32 |   768):  7963,
r_longlong( 7960 << 32 |   769):  7964,
r_longlong( 7961 << 32 |   769):  7965,
r_longlong(  951 << 32 |   787):  7968,
r_longlong(  951 << 32 |   788):  7969,
r_longlong( 7968 << 32 |   768):  7970,
r_longlong( 7969 << 32 |   768):  7971,
r_longlong( 7968 << 32 |   769):  7972,
r_longlong( 7969 << 32 |   769):  7973,
r_longlong( 7968 << 32 |   834):  7974,
r_longlong( 7969 << 32 |   834):  7975,
r_longlong(  919 << 32 |   787):  7976,
r_longlong(  919 << 32 |   788):  7977,
r_longlong( 7976 << 32 |   768):  7978,
r_longlong( 7977 << 32 |   768):  7979,
r_longlong( 7976 << 32 |   769):  7980,
r_longlong( 7977 << 32 |   769):  7981,
r_longlong( 7976 << 32 |   834):  7982,
r_longlong( 7977 << 32 |   834):  7983,
r_longlong(  953 << 32 |   787):  7984,
r_longlong(  953 << 32 |   788):  7985,
r_longlong( 7984 << 32 |   768):  7986,
r_longlong( 7985 << 32 |   768):  7987,
r_longlong( 7984 << 32 |   769):  7988,
r_longlong( 7985 << 32 |   769):  7989,
r_longlong( 7984 << 32 |   834):  7990,
r_longlong( 7985 << 32 |   834):  7991,
r_longlong(  921 << 32 |   787):  7992,
r_longlong(  921 << 32 |   788):  7993,
r_longlong( 7992 << 32 |   768):  7994,
r_longlong( 7993 << 32 |   768):  7995,
r_longlong( 7992 << 32 |   769):  7996,
r_longlong( 7993 << 32 |   769):  7997,
r_longlong( 7992 << 32 |   834):  7998,
r_longlong( 7993 << 32 |   834):  7999,
r_longlong(  959 << 32 |   787):  8000,
r_longlong(  959 << 32 |   788):  8001,
r_longlong( 8000 << 32 |   768):  8002,
r_longlong( 8001 << 32 |   768):  8003,
r_longlong( 8000 << 32 |   769):  8004,
r_longlong( 8001 << 32 |   769):  8005,
r_longlong(  927 << 32 |   787):  8008,
r_longlong(  927 << 32 |   788):  8009,
r_longlong( 8008 << 32 |   768):  8010,
r_longlong( 8009 << 32 |   768):  8011,
r_longlong( 8008 << 32 |   769):  8012,
r_longlong( 8009 << 32 |   769):  8013,
r_longlong(  965 << 32 |   787):  8016,
r_longlong(  965 << 32 |   788):  8017,
r_longlong( 8016 << 32 |   768):  8018,
r_longlong( 8017 << 32 |   768):  8019,
r_longlong( 8016 << 32 |   769):  8020,
r_longlong( 8017 << 32 |   769):  8021,
r_longlong( 8016 << 32 |   834):  8022,
r_longlong( 8017 << 32 |   834):  8023,
r_longlong(  933 << 32 |   788):  8025,
r_longlong( 8025 << 32 |   768):  8027,
r_longlong( 8025 << 32 |   769):  8029,
r_longlong( 8025 << 32 |   834):  8031,
r_longlong(  969 << 32 |   787):  8032,
r_longlong(  969 << 32 |   788):  8033,
r_longlong( 8032 << 32 |   768):  8034,
r_longlong( 8033 << 32 |   768):  8035,
r_longlong( 8032 << 32 |   769):  8036,
r_longlong( 8033 << 32 |   769):  8037,
r_longlong( 8032 << 32 |   834):  8038,
r_longlong( 8033 << 32 |   834):  8039,
r_longlong(  937 << 32 |   787):  8040,
r_longlong(  937 << 32 |   788):  8041,
r_longlong( 8040 << 32 |   768):  8042,
r_longlong( 8041 << 32 |   768):  8043,
r_longlong( 8040 << 32 |   769):  8044,
r_longlong( 8041 << 32 |   769):  8045,
r_longlong( 8040 << 32 |   834):  8046,
r_longlong( 8041 << 32 |   834):  8047,
r_longlong(  945 << 32 |   768):  8048,
r_longlong(  949 << 32 |   768):  8050,
r_longlong(  951 << 32 |   768):  8052,
r_longlong(  953 << 32 |   768):  8054,
r_longlong(  959 << 32 |   768):  8056,
r_longlong(  965 << 32 |   768):  8058,
r_longlong(  969 << 32 |   768):  8060,
r_longlong( 7936 << 32 |   837):  8064,
r_longlong( 7937 << 32 |   837):  8065,
r_longlong( 7938 << 32 |   837):  8066,
r_longlong( 7939 << 32 |   837):  8067,
r_longlong( 7940 << 32 |   837):  8068,
r_longlong( 7941 << 32 |   837):  8069,
r_longlong( 7942 << 32 |   837):  8070,
r_longlong( 7943 << 32 |   837):  8071,
r_longlong( 7944 << 32 |   837):  8072,
r_longlong( 7945 << 32 |   837):  8073,
r_longlong( 7946 << 32 |   837):  8074,
r_longlong( 7947 << 32 |   837):  8075,
r_longlong( 7948 << 32 |   837):  8076,
r_longlong( 7949 << 32 |   837):  8077,
r_longlong( 7950 << 32 |   837):  8078,
r_longlong( 7951 << 32 |   837):  8079,
r_longlong( 7968 << 32 |   837):  8080,
r_longlong( 7969 << 32 |   837):  8081,
r_longlong( 7970 << 32 |   837):  8082,
r_longlong( 7971 << 32 |   837):  8083,
r_longlong( 7972 << 32 |   837):  8084,
r_longlong( 7973 << 32 |   837):  8085,
r_longlong( 7974 << 32 |   837):  8086,
r_longlong( 7975 << 32 |   837):  8087,
r_longlong( 7976 << 32 |   837):  8088,
r_longlong( 7977 << 32 |   837):  8089,
r_longlong( 7978 << 32 |   837):  8090,
r_longlong( 7979 << 32 |   837):  8091,
r_longlong( 7980 << 32 |   837):  8092,
r_longlong( 7981 << 32 |   837):  8093,
r_longlong( 7982 << 32 |   837):  8094,
r_longlong( 7983 << 32 |   837):  8095,
r_longlong( 8032 << 32 |   837):  8096,
r_longlong( 8033 << 32 |   837):  8097,
r_longlong( 8034 << 32 |   837):  8098,
r_longlong( 8035 << 32 |   837):  8099,
r_longlong( 8036 << 32 |   837):  8100,
r_longlong( 8037 << 32 |   837):  8101,
r_longlong( 8038 << 32 |   837):  8102,
r_longlong( 8039 << 32 |   837):  8103,
r_longlong( 8040 << 32 |   837):  8104,
r_longlong( 8041 << 32 |   837):  8105,
r_longlong( 8042 << 32 |   837):  8106,
r_longlong( 8043 << 32 |   837):  8107,
r_longlong( 8044 << 32 |   837):  8108,
r_longlong( 8045 << 32 |   837):  8109,
r_longlong( 8046 << 32 |   837):  8110,
r_longlong( 8047 << 32 |   837):  8111,
r_longlong(  945 << 32 |   774):  8112,
r_longlong(  945 << 32 |   772):  8113,
r_longlong( 8048 << 32 |   837):  8114,
r_longlong(  945 << 32 |   837):  8115,
r_longlong(  940 << 32 |   837):  8116,
r_longlong(  945 << 32 |   834):  8118,
r_longlong( 8118 << 32 |   837):  8119,
r_longlong(  913 << 32 |   774):  8120,
r_longlong(  913 << 32 |   772):  8121,
r_longlong(  913 << 32 |   768):  8122,
r_longlong(  913 << 32 |   837):  8124,
r_longlong(  168 << 32 |   834):  8129,
r_longlong( 8052 << 32 |   837):  8130,
r_longlong(  951 << 32 |   837):  8131,
r_longlong(  942 << 32 |   837):  8132,
r_longlong(  951 << 32 |   834):  8134,
r_longlong( 8134 << 32 |   837):  8135,
r_longlong(  917 << 32 |   768):  8136,
r_longlong(  919 << 32 |   768):  8138,
r_longlong(  919 << 32 |   837):  8140,
r_longlong( 8127 << 32 |   768):  8141,
r_longlong( 8127 << 32 |   769):  8142,
r_longlong( 8127 << 32 |   834):  8143,
r_longlong(  953 << 32 |   774):  8144,
r_longlong(  953 << 32 |   772):  8145,
r_longlong(  970 << 32 |   768):  8146,
r_longlong(  953 << 32 |   834):  8150,
r_longlong(  970 << 32 |   834):  8151,
r_longlong(  921 << 32 |   774):  8152,
r_longlong(  921 << 32 |   772):  8153,
r_longlong(  921 << 32 |   768):  8154,
r_longlong( 8190 << 32 |   768):  8157,
r_longlong( 8190 << 32 |   769):  8158,
r_longlong( 8190 << 32 |   834):  8159,
r_longlong(  965 << 32 |   774):  8160,
r_longlong(  965 << 32 |   772):  8161,
r_longlong(  971 << 32 |   768):  8162,
r_longlong(  961 << 32 |   787):  8164,
r_longlong(  961 << 32 |   788):  8165,
r_longlong(  965 << 32 |   834):  8166,
r_longlong(  971 << 32 |   834):  8167,
r_longlong(  933 << 32 |   774):  8168,
r_longlong(  933 << 32 |   772):  8169,
r_longlong(  933 << 32 |   768):  8170,
r_longlong(  929 << 32 |   788):  8172,
r_longlong(  168 << 32 |   768):  8173,
r_longlong( 8060 << 32 |   837):  8178,
r_longlong(  969 << 32 |   837):  8179,
r_longlong(  974 << 32 |   837):  8180,
r_longlong(  969 << 32 |   834):  8182,
r_longlong( 8182 << 32 |   837):  8183,
r_longlong(  927 << 32 |   768):  8184,
r_longlong(  937 << 32 |   768):  8186,
r_longlong(  937 << 32 |   837):  8188,
r_longlong( 8592 << 32 |   824):  8602,
r_longlong( 8594 << 32 |   824):  8603,
r_longlong( 8596 << 32 |   824):  8622,
r_longlong( 8656 << 32 |   824):  8653,
r_longlong( 8660 << 32 |   824):  8654,
r_longlong( 8658 << 32 |   824):  8655,
r_longlong( 8707 << 32 |   824):  8708,
r_longlong( 8712 << 32 |   824):  8713,
r_longlong( 8715 << 32 |   824):  8716,
r_longlong( 8739 << 32 |   824):  8740,
r_longlong( 8741 << 32 |   824):  8742,
r_longlong( 8764 << 32 |   824):  8769,
r_longlong( 8771 << 32 |   824):  8772,
r_longlong( 8773 << 32 |   824):  8775,
r_longlong( 8776 << 32 |   824):  8777,
r_longlong(   61 << 32 |   824):  8800,
r_longlong( 8801 << 32 |   824):  8802,
r_longlong( 8781 << 32 |   824):  8813,
r_longlong(   60 << 32 |   824):  8814,
r_longlong(   62 << 32 |   824):  8815,
r_longlong( 8804 << 32 |   824):  8816,
r_longlong( 8805 << 32 |   824):  8817,
r_longlong( 8818 << 32 |   824):  8820,
r_longlong( 8819 << 32 |   824):  8821,
r_longlong( 8822 << 32 |   824):  8824,
r_longlong( 8823 << 32 |   824):  8825,
r_longlong( 8826 << 32 |   824):  8832,
r_longlong( 8827 << 32 |   824):  8833,
r_longlong( 8834 << 32 |   824):  8836,
r_longlong( 8835 << 32 |   824):  8837,
r_longlong( 8838 << 32 |   824):  8840,
r_longlong( 8839 << 32 |   824):  8841,
r_longlong( 8866 << 32 |   824):  8876,
r_longlong( 8872 << 32 |   824):  8877,
r_longlong( 8873 << 32 |   824):  8878,
r_longlong( 8875 << 32 |   824):  8879,
r_longlong( 8828 << 32 |   824):  8928,
r_longlong( 8829 << 32 |   824):  8929,
r_longlong( 8849 << 32 |   824):  8930,
r_longlong( 8850 << 32 |   824):  8931,
r_longlong( 8882 << 32 |   824):  8938,
r_longlong( 8883 << 32 |   824):  8939,
r_longlong( 8884 << 32 |   824):  8940,
r_longlong( 8885 << 32 |   824):  8941,
r_longlong(12363 << 32 | 12441): 12364,
r_longlong(12365 << 32 | 12441): 12366,
r_longlong(12367 << 32 | 12441): 12368,
r_longlong(12369 << 32 | 12441): 12370,
r_longlong(12371 << 32 | 12441): 12372,
r_longlong(12373 << 32 | 12441): 12374,
r_longlong(12375 << 32 | 12441): 12376,
r_longlong(12377 << 32 | 12441): 12378,
r_longlong(12379 << 32 | 12441): 12380,
r_longlong(12381 << 32 | 12441): 12382,
r_longlong(12383 << 32 | 12441): 12384,
r_longlong(12385 << 32 | 12441): 12386,
r_longlong(12388 << 32 | 12441): 12389,
r_longlong(12390 << 32 | 12441): 12391,
r_longlong(12392 << 32 | 12441): 12393,
r_longlong(12399 << 32 | 12441): 12400,
r_longlong(12399 << 32 | 12442): 12401,
r_longlong(12402 << 32 | 12441): 12403,
r_longlong(12402 << 32 | 12442): 12404,
r_longlong(12405 << 32 | 12441): 12406,
r_longlong(12405 << 32 | 12442): 12407,
r_longlong(12408 << 32 | 12441): 12409,
r_longlong(12408 << 32 | 12442): 12410,
r_longlong(12411 << 32 | 12441): 12412,
r_longlong(12411 << 32 | 12442): 12413,
r_longlong(12358 << 32 | 12441): 12436,
r_longlong(12445 << 32 | 12441): 12446,
r_longlong(12459 << 32 | 12441): 12460,
r_longlong(12461 << 32 | 12441): 12462,
r_longlong(12463 << 32 | 12441): 12464,
r_longlong(12465 << 32 | 12441): 12466,
r_longlong(12467 << 32 | 12441): 12468,
r_longlong(12469 << 32 | 12441): 12470,
r_longlong(12471 << 32 | 12441): 12472,
r_longlong(12473 << 32 | 12441): 12474,
r_longlong(12475 << 32 | 12441): 12476,
r_longlong(12477 << 32 | 12441): 12478,
r_longlong(12479 << 32 | 12441): 12480,
r_longlong(12481 << 32 | 12441): 12482,
r_longlong(12484 << 32 | 12441): 12485,
r_longlong(12486 << 32 | 12441): 12487,
r_longlong(12488 << 32 | 12441): 12489,
r_longlong(12495 << 32 | 12441): 12496,
r_longlong(12495 << 32 | 12442): 12497,
r_longlong(12498 << 32 | 12441): 12499,
r_longlong(12498 << 32 | 12442): 12500,
r_longlong(12501 << 32 | 12441): 12502,
r_longlong(12501 << 32 | 12442): 12503,
r_longlong(12504 << 32 | 12441): 12505,
r_longlong(12504 << 32 | 12442): 12506,
r_longlong(12507 << 32 | 12441): 12508,
r_longlong(12507 << 32 | 12442): 12509,
r_longlong(12454 << 32 | 12441): 12532,
r_longlong(12527 << 32 | 12441): 12535,
r_longlong(12528 << 32 | 12441): 12536,
r_longlong(12529 << 32 | 12441): 12537,
r_longlong(12530 << 32 | 12441): 12538,
r_longlong(12541 << 32 | 12441): 12542,
r_longlong(69785 << 32 | 69818): 69786,
r_longlong(69787 << 32 | 69818): 69788,
r_longlong(69797 << 32 | 69818): 69803,
r_longlong(69937 << 32 | 69927): 69934,
r_longlong(69938 << 32 | 69927): 69935,
}

_canon_decomposition = {
64046: [37086],
64047: [38583],
69934: [69937, 69927],
69935: [69938, 69927],
}

_canon_decomposition_corrected = {
}
_compat_decomposition = {
8341: [104],
8342: [107],
8343: [108],
8344: [109],
8345: [110],
8346: [112],
8347: [115],
8348: [116],
43000: [294],
43001: [339],
64046: [37086],
64047: [38583],
69934: [69937, 69927],
69935: [69938, 69927],
126464: [1575],
126465: [1576],
126466: [1580],
126467: [1583],
126469: [1608],
126470: [1586],
126471: [1581],
126472: [1591],
126473: [1610],
126474: [1603],
126475: [1604],
126476: [1605],
126477: [1606],
126478: [1587],
126479: [1593],
126480: [1601],
126481: [1589],
126482: [1602],
126483: [1585],
126484: [1588],
126485: [1578],
126486: [1579],
126487: [1582],
126488: [1584],
126489: [1590],
126490: [1592],
126491: [1594],
126492: [1646],
126493: [1722],
126494: [1697],
126495: [1647],
126497: [1576],
126498: [1580],
126500: [1607],
126503: [1581],
126505: [1610],
126506: [1603],
126507: [1604],
126508: [1605],
126509: [1606],
126510: [1587],
126511: [1593],
126512: [1601],
126513: [1589],
126514: [1602],
126516: [1588],
126517: [1578],
126518: [1579],
126519: [1582],
126521: [1590],
126523: [1594],
126530: [1580],
126535: [1581],
126537: [1610],
126539: [1604],
126541: [1606],
126542: [1587],
126543: [1593],
126545: [1589],
126546: [1602],
126548: [1588],
126551: [1582],
126553: [1590],
126555: [1594],
126557: [1722],
126559: [1647],
126561: [1576],
126562: [1580],
126564: [1607],
126567: [1581],
126568: [1591],
126569: [1610],
126570: [1603],
126572: [1605],
126573: [1606],
126574: [1587],
126575: [1593],
126576: [1601],
126577: [1589],
126578: [1602],
126580: [1588],
126581: [1578],
126582: [1579],
126583: [1582],
126585: [1590],
126586: [1592],
126587: [1594],
126588: [1646],
126590: [1697],
126592: [1575],
126593: [1576],
126594: [1580],
126595: [1583],
126596: [1607],
126597: [1608],
126598: [1586],
126599: [1581],
126600: [1591],
126601: [1610],
126603: [1604],
126604: [1605],
126605: [1606],
126606: [1587],
126607: [1593],
126608: [1601],
126609: [1589],
126610: [1602],
126611: [1585],
126612: [1588],
126613: [1578],
126614: [1579],
126615: [1582],
126616: [1584],
126617: [1590],
126618: [1592],
126619: [1594],
126625: [1576],
126626: [1580],
126627: [1583],
126629: [1608],
126630: [1586],
126631: [1581],
126632: [1591],
126633: [1610],
126635: [1604],
126636: [1605],
126637: [1606],
126638: [1587],
126639: [1593],
126640: [1601],
126641: [1589],
126642: [1602],
126643: [1585],
126644: [1588],
126645: [1578],
126646: [1579],
126647: [1582],
126648: [1584],
126649: [1590],
126650: [1592],
126651: [1594],
127280: [65],
127282: [67],
127283: [68],
127284: [69],
127285: [70],
127286: [71],
127287: [72],
127288: [73],
127289: [74],
127290: [75],
127291: [76],
127292: [77],
127294: [79],
127296: [81],
127297: [82],
127299: [84],
127300: [85],
127301: [86],
127303: [88],
127304: [89],
127305: [90],
127311: [87, 67],
127338: [77, 67],
127339: [77, 68],
127489: [12467, 12467],
127490: [12469],
127538: [31105],
127539: [31354],
127540: [21512],
127541: [28288],
127542: [26377],
127543: [26376],
127544: [30003],
127545: [21106],
127546: [21942],
127568: [24471],
127569: [21487],
}

_compat_decomposition_corrected = {
}

def canon_decomposition(code):
    try:
        return _canon_decomposition[code]
    except KeyError:
        if base_mod is not None and code not in _canon_decomposition_corrected:
            return base_mod._canon_decomposition.get(code, [])
        else:
            return []
def compat_decomposition(code):
    try:
        return _compat_decomposition[code]
    except KeyError:
        if base_mod is not None and code not in _compat_decomposition_corrected:
            return base_mod._compat_decomposition.get(code, [])
        else:
            return []


_named_sequences = [
u'\u0100\u0300',
u'\u0101\u0300',
u'E\u0329',
u'e\u0329',
u'\xc8\u0329',
u'\xe8\u0329',
u'\xc9\u0329',
u'\xe9\u0329',
u'\xca\u0304',
u'\xea\u0304',
u'\xca\u030c',
u'\xea\u030c',
u'\u012a\u0300',
u'\u012b\u0300',
u'i\u0307\u0301',
u'n\u0360g',
u'O\u0329',
u'o\u0329',
u'\xd2\u0329',
u'\xf2\u0329',
u'\xd3\u0329',
u'\xf3\u0329',
u'S\u0329',
u's\u0329',
u'\u016a\u0300',
u'\u016b\u0300',
u'\u0104\u0301',
u'\u0105\u0301',
u'\u0104\u0303',
u'\u0105\u0303',
u'\u0118\u0301',
u'\u0119\u0301',
u'\u0118\u0303',
u'\u0119\u0303',
u'\u0116\u0301',
u'\u0117\u0301',
u'\u0116\u0303',
u'\u0117\u0303',
u'i\u0307\u0300',
u'i\u0307\u0303',
u'\u012e\u0301',
u'\u012f\u0307\u0301',
u'\u012e\u0303',
u'\u012f\u0307\u0303',
u'J\u0303',
u'j\u0307\u0303',
u'L\u0303',
u'l\u0303',
u'M\u0303',
u'm\u0303',
u'R\u0303',
u'r\u0303',
u'\u0172\u0301',
u'\u0173\u0301',
u'\u0172\u0303',
u'\u0173\u0303',
u'\u016a\u0301',
u'\u016b\u0301',
u'\u016a\u0303',
u'\u016b\u0303',
u'\xe6\u0300',
u'\u0254\u0300',
u'\u0254\u0301',
u'\u028c\u0300',
u'\u028c\u0301',
u'\u0259\u0300',
u'\u0259\u0301',
u'\u025a\u0300',
u'\u025a\u0301',
u'\u0995\u09cd\u09b7',
u'\u0b95\u0bcd',
u'\u0b99\u0bcd',
u'\u0b9a\u0bcd',
u'\u0b9e\u0bcd',
u'\u0b9f\u0bcd',
u'\u0ba3\u0bcd',
u'\u0ba4\u0bcd',
u'\u0ba8\u0bcd',
u'\u0baa\u0bcd',
u'\u0bae\u0bcd',
u'\u0baf\u0bcd',
u'\u0bb0\u0bcd',
u'\u0bb2\u0bcd',
u'\u0bb5\u0bcd',
u'\u0bb4\u0bcd',
u'\u0bb3\u0bcd',
u'\u0bb1\u0bcd',
u'\u0ba9\u0bcd',
u'\u0b9c\u0bcd',
u'\u0bb6\u0bcd',
u'\u0bb7\u0bcd',
u'\u0bb8\u0bcd',
u'\u0bb9\u0bcd',
u'\u0b95\u0bcd\u0bb7\u0bcd',
u'\u0b95\u0bbe',
u'\u0b95\u0bbf',
u'\u0b95\u0bc0',
u'\u0b95\u0bc1',
u'\u0b95\u0bc2',
u'\u0b95\u0bc6',
u'\u0b95\u0bc7',
u'\u0b95\u0bc8',
u'\u0b95\u0bca',
u'\u0b95\u0bcb',
u'\u0b95\u0bcc',
u'\u0b99\u0bbe',
u'\u0b99\u0bbf',
u'\u0b99\u0bc0',
u'\u0b99\u0bc1',
u'\u0b99\u0bc2',
u'\u0b99\u0bc6',
u'\u0b99\u0bc7',
u'\u0b99\u0bc8',
u'\u0b99\u0bca',
u'\u0b99\u0bcb',
u'\u0b99\u0bcc',
u'\u0b9a\u0bbe',
u'\u0b9a\u0bbf',
u'\u0b9a\u0bc0',
u'\u0b9a\u0bc1',
u'\u0b9a\u0bc2',
u'\u0b9a\u0bc6',
u'\u0b9a\u0bc7',
u'\u0b9a\u0bc8',
u'\u0b9a\u0bca',
u'\u0b9a\u0bcb',
u'\u0b9a\u0bcc',
u'\u0b9e\u0bbe',
u'\u0b9e\u0bbf',
u'\u0b9e\u0bc0',
u'\u0b9e\u0bc1',
u'\u0b9e\u0bc2',
u'\u0b9e\u0bc6',
u'\u0b9e\u0bc7',
u'\u0b9e\u0bc8',
u'\u0b9e\u0bca',
u'\u0b9e\u0bcb',
u'\u0b9e\u0bcc',
u'\u0b9f\u0bbe',
u'\u0b9f\u0bbf',
u'\u0b9f\u0bc0',
u'\u0b9f\u0bc1',
u'\u0b9f\u0bc2',
u'\u0b9f\u0bc6',
u'\u0b9f\u0bc7',
u'\u0b9f\u0bc8',
u'\u0b9f\u0bca',
u'\u0b9f\u0bcb',
u'\u0b9f\u0bcc',
u'\u0ba3\u0bbe',
u'\u0ba3\u0bbf',
u'\u0ba3\u0bc0',
u'\u0ba3\u0bc1',
u'\u0ba3\u0bc2',
u'\u0ba3\u0bc6',
u'\u0ba3\u0bc7',
u'\u0ba3\u0bc8',
u'\u0ba3\u0bca',
u'\u0ba3\u0bcb',
u'\u0ba3\u0bcc',
u'\u0ba4\u0bbe',
u'\u0ba4\u0bbf',
u'\u0ba4\u0bc0',
u'\u0ba4\u0bc1',
u'\u0ba4\u0bc2',
u'\u0ba4\u0bc6',
u'\u0ba4\u0bc7',
u'\u0ba4\u0bc8',
u'\u0ba4\u0bca',
u'\u0ba4\u0bcb',
u'\u0ba4\u0bcc',
u'\u0ba8\u0bbe',
u'\u0ba8\u0bbf',
u'\u0ba8\u0bc0',
u'\u0ba8\u0bc1',
u'\u0ba8\u0bc2',
u'\u0ba8\u0bc6',
u'\u0ba8\u0bc7',
u'\u0ba8\u0bc8',
u'\u0ba8\u0bca',
u'\u0ba8\u0bcb',
u'\u0ba8\u0bcc',
u'\u0baa\u0bbe',
u'\u0baa\u0bbf',
u'\u0baa\u0bc0',
u'\u0baa\u0bc1',
u'\u0baa\u0bc2',
u'\u0baa\u0bc6',
u'\u0baa\u0bc7',
u'\u0baa\u0bc8',
u'\u0baa\u0bca',
u'\u0baa\u0bcb',
u'\u0baa\u0bcc',
u'\u0bae\u0bbe',
u'\u0bae\u0bbf',
u'\u0bae\u0bc0',
u'\u0bae\u0bc1',
u'\u0bae\u0bc2',
u'\u0bae\u0bc6',
u'\u0bae\u0bc7',
u'\u0bae\u0bc8',
u'\u0bae\u0bca',
u'\u0bae\u0bcb',
u'\u0bae\u0bcc',
u'\u0baf\u0bbe',
u'\u0baf\u0bbf',
u'\u0baf\u0bc0',
u'\u0baf\u0bc1',
u'\u0baf\u0bc2',
u'\u0baf\u0bc6',
u'\u0baf\u0bc7',
u'\u0baf\u0bc8',
u'\u0baf\u0bca',
u'\u0baf\u0bcb',
u'\u0baf\u0bcc',
u'\u0bb0\u0bbe',
u'\u0bb0\u0bbf',
u'\u0bb0\u0bc0',
u'\u0bb0\u0bc1',
u'\u0bb0\u0bc2',
u'\u0bb0\u0bc6',
u'\u0bb0\u0bc7',
u'\u0bb0\u0bc8',
u'\u0bb0\u0bca',
u'\u0bb0\u0bcb',
u'\u0bb0\u0bcc',
u'\u0bb2\u0bbe',
u'\u0bb2\u0bbf',
u'\u0bb2\u0bc0',
u'\u0bb2\u0bc1',
u'\u0bb2\u0bc2',
u'\u0bb2\u0bc6',
u'\u0bb2\u0bc7',
u'\u0bb2\u0bc8',
u'\u0bb2\u0bca',
u'\u0bb2\u0bcb',
u'\u0bb2\u0bcc',
u'\u0bb5\u0bbe',
u'\u0bb5\u0bbf',
u'\u0bb5\u0bc0',
u'\u0bb5\u0bc1',
u'\u0bb5\u0bc2',
u'\u0bb5\u0bc6',
u'\u0bb5\u0bc7',
u'\u0bb5\u0bc8',
u'\u0bb5\u0bca',
u'\u0bb5\u0bcb',
u'\u0bb5\u0bcc',
u'\u0bb4\u0bbe',
u'\u0bb4\u0bbf',
u'\u0bb4\u0bc0',
u'\u0bb4\u0bc1',
u'\u0bb4\u0bc2',
u'\u0bb4\u0bc6',
u'\u0bb4\u0bc7',
u'\u0bb4\u0bc8',
u'\u0bb4\u0bca',
u'\u0bb4\u0bcb',
u'\u0bb4\u0bcc',
u'\u0bb3\u0bbe',
u'\u0bb3\u0bbf',
u'\u0bb3\u0bc0',
u'\u0bb3\u0bc1',
u'\u0bb3\u0bc2',
u'\u0bb3\u0bc6',
u'\u0bb3\u0bc7',
u'\u0bb3\u0bc8',
u'\u0bb3\u0bca',
u'\u0bb3\u0bcb',
u'\u0bb3\u0bcc',
u'\u0bb1\u0bbe',
u'\u0bb1\u0bbf',
u'\u0bb1\u0bc0',
u'\u0bb1\u0bc1',
u'\u0bb1\u0bc2',
u'\u0bb1\u0bc6',
u'\u0bb1\u0bc7',
u'\u0bb1\u0bc8',
u'\u0bb1\u0bca',
u'\u0bb1\u0bcb',
u'\u0bb1\u0bcc',
u'\u0ba9\u0bbe',
u'\u0ba9\u0bbf',
u'\u0ba9\u0bc0',
u'\u0ba9\u0bc1',
u'\u0ba9\u0bc2',
u'\u0ba9\u0bc6',
u'\u0ba9\u0bc7',
u'\u0ba9\u0bc8',
u'\u0ba9\u0bca',
u'\u0ba9\u0bcb',
u'\u0ba9\u0bcc',
u'\u0b9c\u0bbe',
u'\u0b9c\u0bbf',
u'\u0b9c\u0bc0',
u'\u0b9c\u0bc1',
u'\u0b9c\u0bc2',
u'\u0b9c\u0bc6',
u'\u0b9c\u0bc7',
u'\u0b9c\u0bc8',
u'\u0b9c\u0bca',
u'\u0b9c\u0bcb',
u'\u0b9c\u0bcc',
u'\u0bb6\u0bbe',
u'\u0bb6\u0bbf',
u'\u0bb6\u0bc0',
u'\u0bb6\u0bc1',
u'\u0bb6\u0bc2',
u'\u0bb6\u0bc6',
u'\u0bb6\u0bc7',
u'\u0bb6\u0bc8',
u'\u0bb6\u0bca',
u'\u0bb6\u0bcb',
u'\u0bb6\u0bcc',
u'\u0bb7\u0bbe',
u'\u0bb7\u0bbf',
u'\u0bb7\u0bc0',
u'\u0bb7\u0bc1',
u'\u0bb7\u0bc2',
u'\u0bb7\u0bc6',
u'\u0bb7\u0bc7',
u'\u0bb7\u0bc8',
u'\u0bb7\u0bca',
u'\u0bb7\u0bcb',
u'\u0bb7\u0bcc',
u'\u0bb8\u0bbe',
u'\u0bb8\u0bbf',
u'\u0bb8\u0bc0',
u'\u0bb8\u0bc1',
u'\u0bb8\u0bc2',
u'\u0bb8\u0bc6',
u'\u0bb8\u0bc7',
u'\u0bb8\u0bc8',
u'\u0bb8\u0bca',
u'\u0bb8\u0bcb',
u'\u0bb8\u0bcc',
u'\u0bb9\u0bbe',
u'\u0bb9\u0bbf',
u'\u0bb9\u0bc0',
u'\u0bb9\u0bc1',
u'\u0bb9\u0bc2',
u'\u0bb9\u0bc6',
u'\u0bb9\u0bc7',
u'\u0bb9\u0bc8',
u'\u0bb9\u0bca',
u'\u0bb9\u0bcb',
u'\u0bb9\u0bcc',
u'\u0b95\u0bcd\u0bb7',
u'\u0b95\u0bcd\u0bb7\u0bbe',
u'\u0b95\u0bcd\u0bb7\u0bbf',
u'\u0b95\u0bcd\u0bb7\u0bc0',
u'\u0b95\u0bcd\u0bb7\u0bc1',
u'\u0b95\u0bcd\u0bb7\u0bc2',
u'\u0b95\u0bcd\u0bb7\u0bc6',
u'\u0b95\u0bcd\u0bb7\u0bc7',
u'\u0b95\u0bcd\u0bb7\u0bc8',
u'\u0b95\u0bcd\u0bb7\u0bca',
u'\u0b95\u0bcd\u0bb7\u0bcb',
u'\u0b95\u0bcd\u0bb7\u0bcc',
u'\u0bb6\u0bcd\u0bb0\u0bc0',
u'\u0dca\u200d\u0dba',
u'\u0dca\u200d\u0dbb',
u'\u0dbb\u0dca\u200d',
u'\u10e3\u0302',
u'\u17d2\u1780',
u'\u17d2\u1781',
u'\u17d2\u1782',
u'\u17d2\u1783',
u'\u17d2\u1784',
u'\u17d2\u1785',
u'\u17d2\u1786',
u'\u17d2\u1787',
u'\u17d2\u1788',
u'\u17d2\u1789',
u'\u17d2\u178a',
u'\u17d2\u178b',
u'\u17d2\u178c',
u'\u17d2\u178d',
u'\u17d2\u178e',
u'\u17d2\u178f',
u'\u17d2\u1790',
u'\u17d2\u1791',
u'\u17d2\u1792',
u'\u17d2\u1793',
u'\u17d2\u1794',
u'\u17d2\u1795',
u'\u17d2\u1796',
u'\u17d2\u1797',
u'\u17d2\u1798',
u'\u17d2\u1799',
u'\u17d2\u179a',
u'\u17d2\u179b',
u'\u17d2\u179c',
u'\u17d2\u179d',
u'\u17d2\u179e',
u'\u17d2\u179f',
u'\u17d2\u17a0',
u'\u17d2\u17a1',
u'\u17d2\u17a2',
u'\u17d2\u17a7',
u'\u17d2\u17ab',
u'\u17d2\u17ac',
u'\u17d2\u17af',
u'\u17bb\u17c6',
u'\u17b6\u17c6',
u'\u304b\u309a',
u'\u304d\u309a',
u'\u304f\u309a',
u'\u3051\u309a',
u'\u3053\u309a',
u'\u30ab\u309a',
u'\u30ad\u309a',
u'\u30af\u309a',
u'\u30b1\u309a',
u'\u30b3\u309a',
u'\u30bb\u309a',
u'\u30c4\u309a',
u'\u30c8\u309a',
u'\u31f7\u309a',
u'\u02e5\u02e9',
u'\u02e9\u02e5',
]


def lookup_named_sequence(code):
    if 0 <= code - 983552 < len(_named_sequences):
        return _named_sequences[code - 983552]
    else:
        return None

_name_aliases = [
0,
0,
1,
1,
2,
2,
3,
3,
4,
4,
5,
5,
6,
6,
7,
7,
8,
8,
9,
9,
9,
9,
10,
10,
10,
10,
10,
10,
11,
11,
11,
12,
12,
13,
13,
14,
14,
14,
15,
15,
15,
16,
16,
17,
17,
18,
18,
19,
19,
20,
20,
21,
21,
22,
22,
23,
23,
24,
24,
25,
25,
26,
26,
27,
27,
28,
28,
28,
29,
29,
29,
30,
30,
30,
31,
31,
31,
32,
127,
127,
128,
128,
129,
129,
130,
130,
131,
131,
132,
132,
133,
133,
134,
134,
135,
135,
136,
136,
136,
137,
137,
137,
138,
138,
138,
139,
139,
139,
140,
140,
140,
141,
141,
141,
142,
142,
142,
143,
143,
143,
144,
144,
145,
145,
145,
146,
146,
146,
147,
147,
148,
148,
149,
149,
150,
150,
150,
151,
151,
151,
152,
152,
153,
153,
154,
154,
155,
155,
156,
156,
157,
157,
158,
158,
159,
159,
160,
173,
418,
419,
847,
3294,
3741,
3743,
3747,
3749,
4048,
6155,
6156,
6157,
6158,
8203,
8204,
8205,
8206,
8207,
8234,
8235,
8236,
8237,
8238,
8239,
8287,
8288,
8472,
9288,
9289,
40981,
65048,
65024,
65025,
65026,
65027,
65028,
65029,
65030,
65031,
65032,
65033,
65034,
65035,
65036,
65037,
65038,
65039,
65279,
65279,
65279,
118981,
917760,
917761,
917762,
917763,
917764,
917765,
917766,
917767,
917768,
917769,
917770,
917771,
917772,
917773,
917774,
917775,
917776,
917777,
917778,
917779,
917780,
917781,
917782,
917783,
917784,
917785,
917786,
917787,
917788,
917789,
917790,
917791,
917792,
917793,
917794,
917795,
917796,
917797,
917798,
917799,
917800,
917801,
917802,
917803,
917804,
917805,
917806,
917807,
917808,
917809,
917810,
917811,
917812,
917813,
917814,
917815,
917816,
917817,
917818,
917819,
917820,
917821,
917822,
917823,
917824,
917825,
917826,
917827,
917828,
917829,
917830,
917831,
917832,
917833,
917834,
917835,
917836,
917837,
917838,
917839,
917840,
917841,
917842,
917843,
917844,
917845,
917846,
917847,
917848,
917849,
917850,
917851,
917852,
917853,
917854,
917855,
917856,
917857,
917858,
917859,
917860,
917861,
917862,
917863,
917864,
917865,
917866,
917867,
917868,
917869,
917870,
917871,
917872,
917873,
917874,
917875,
917876,
917877,
917878,
917879,
917880,
917881,
917882,
917883,
917884,
917885,
917886,
917887,
917888,
917889,
917890,
917891,
917892,
917893,
917894,
917895,
917896,
917897,
917898,
917899,
917900,
917901,
917902,
917903,
917904,
917905,
917906,
917907,
917908,
917909,
917910,
917911,
917912,
917913,
917914,
917915,
917916,
917917,
917918,
917919,
917920,
917921,
917922,
917923,
917924,
917925,
917926,
917927,
917928,
917929,
917930,
917931,
917932,
917933,
917934,
917935,
917936,
917937,
917938,
917939,
917940,
917941,
917942,
917943,
917944,
917945,
917946,
917947,
917948,
917949,
917950,
917951,
917952,
917953,
917954,
917955,
917956,
917957,
917958,
917959,
917960,
917961,
917962,
917963,
917964,
917965,
917966,
917967,
917968,
917969,
917970,
917971,
917972,
917973,
917974,
917975,
917976,
917977,
917978,
917979,
917980,
917981,
917982,
917983,
917984,
917985,
917986,
917987,
917988,
917989,
917990,
917991,
917992,
917993,
917994,
917995,
917996,
917997,
917998,
917999,
]


def lookup_with_alias(name, with_named_sequence=False):
    code = lookup(name, with_named_sequence=with_named_sequence)
    if 0 <= code - 983040 < len(_name_aliases):
        return _name_aliases[code - 983040]
    else:
        return code

_casefolds = {
}

_casefolds_corrected = {
}


def casefold_lookup(code):
    try:
        return _casefolds[code]
    except KeyError:
        if base_mod is not None and code not in _casefolds_corrected:
            return base_mod._casefolds.get(code, None)
        else:
            return None

_combining = {
1631: 220,
2137: 220,
2138: 220,
2139: 220,
2276: 230,
2277: 230,
2278: 220,
2279: 230,
2280: 230,
2281: 220,
2282: 230,
2283: 230,
2284: 230,
2285: 220,
2286: 220,
2287: 220,
2288: 27,
2289: 28,
2290: 29,
2291: 230,
2292: 230,
2293: 230,
2294: 220,
2295: 230,
2296: 230,
2297: 220,
2298: 220,
2299: 230,
2300: 230,
2301: 230,
2302: 230,
4957: 230,
4958: 230,
7083: 9,
7142: 7,
7154: 9,
7155: 9,
7412: 230,
7676: 233,
11647: 9,
42612: 230,
42613: 230,
42614: 230,
42615: 230,
42616: 230,
42617: 230,
42618: 230,
42619: 230,
42655: 230,
43766: 9,
69702: 9,
69888: 230,
69889: 230,
69890: 230,
69939: 9,
69940: 9,
70080: 9,
71350: 9,
71351: 7,
}

_combining_corrected = {
}


def combining(code):
    try:
        return _combining[code]
    except KeyError:
        if base_mod is not None and code not in _combining_corrected:
            return base_mod._combining.get(code, 0)
        else:
            return 0

