
	SUBROUTINE DO_VAR_DSG (	idim, dset, nfeatures, maxobs,
     .				com, com_mr, com_cx,
     .				res, res_mr, res_cx,
     .				box, stddev,
     .				wsum, s )

*
*  This software was developed by the Thermal Modeling and Analysis
*  Project(TMAP) of the National Oceanographic and Atmospheric
*  Administration''s (NOAA) Pacific Marine Environmental Lab(PMEL),
*  hereafter referred to as NOAA/PMEL/TMAP.
*
*  Access and use of this software shall impose the following
*  obligations and understandings on the user. The user is granted the
*  right, without any fee or cost, to use, copy, modify, alter, enhance
*  and distribute this software, and any derivative works thereof, and
*  its supporting documentation for any purpose whatsoever, provided
*  that this entire notice appears in all copies of the software,
*  derivative works and supporting documentation.  Further, the user
*  agrees to credit NOAA/PMEL/TMAP in any publications that result from
*  the use of this software or in any product that includes this
*  software. The names TMAP, NOAA and/or PMEL, however, may not be used
*  in any advertising or publicity to endorse or promote any products
*  or commercial entity unless specific written permission is obtained
*  from NOAA/PMEL/TMAP. The user also understands that NOAA/PMEL/TMAP
*  is not obligated to provide the user with any support, consulting,
*  training or assistance of any kind with regard to the use, operation
*  and performance of this software nor to provide the user with any
*  updates, revisions, new versions or "bug fixes".
*
*  THIS SOFTWARE IS PROVIDED BY NOAA/PMEL/TMAP "AS IS" AND ANY EXPRESS
*  OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
*  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
*  ARE DISCLAIMED. IN NO EVENT SHALL NOAA/PMEL/TMAP BE LIABLE FOR ANY SPECIAL,
*  INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER
*  RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF
*  CONTRACT, NEGLIGENCE OR OTHER TORTUOUS ACTION, ARISING OUT OF OR IN
*  CONNECTION WITH THE ACCESS, USE OR PERFORMANCE OF THIS SOFTWARE. 
*
*
* determine the variance along the indicated axis
* for data on Distributed Sampling Geometries grids

* programmer - Ansley Manke
* NOAA/PMEL, Seattle, WA - Science Data Integration Group
* 2/2019
* V76   1/20 *acm* Orientation of Point-type data set to e_dim

****
* The algorithm:
*
* These initializations already done from IS_TRANS
*    wSum = 0
*    mean = 0    ! "res" in this code
*    S =0
*
* This routine performs this loop (see Wikipedia reference)
* v,w  is the value,weight pair contributed by each grid cell
*        wSum = wSum + w
*        meanOld = mean
*        mean = meanOld + (w / wSum) * (v - meanOld)
*        S = S + w * (v - meanOld) * (v - mean)
*	

        IMPLICIT NONE
        include 'tmap_dims.parm'
	include	'ferret.parm'
	include	'interp_stack.parm'
	include	'xcontext.cmn'
	include	'xvariables.cmn'
	include	'xmem_subsc.cmn'
	include 'xunits.cmn_text'
	external xunits_data
	include 'xtm_grid.cmn_text'
	external xgt_grid_data
	include 'xdyn_linemem.cmn_text'
	include 'xdset_info.cmn_text'
	include 'xdsg_context.cmn'

* calling argument declarations:
	INTEGER	action, idim, dset, com_mr, com_cx, res_mr, res_cx, 
     .		nfeatures, maxobs
	REAL	com  (*),
     .          res  (*),  
     .          wsum (*),
     .          s    (*),
     .		box( * )
* internal variable declarations:
	LOGICAL	stddev, fmask(nfeatures), omask(maxobs)
	INTEGER i, grid, pt, lo, hi, ok, ifeature, iobs, 
     .          flen, base, orientation, row_size_lm, 
     .          dsg_fmt_grid, dsg_coord_lm, dsg_coord_lm_y
	REAL	unit, bad_com, bad_res, val, 
     .          dsum, bsum, dummy, boxdel, boxmean, boxstd, 
     .          w, v, wsum_chunk, mean_chunk, mean_old, s_chunk
	CHARACTER*80 errstr

* --- end of introductory code ---

* initialize
	grid = mr_grid( com_mr )
	pt   = cx_lo_ss( res_cx, idim )
	bad_com = mr_bad_data( com_mr )
	bad_res = mr_bad_data( res_mr )
	unit = 1.  ! just used in box-size routine, units not applied

* DSG-specific initialize

        CALL MAKE_DSG_FEATURE_MASK(dset, com_cx, fmask, nfeatures)
	row_size_lm  = dsg_loaded_lm(dsg_row_size_var(dset))
	dsg_fmt_grid = dsg_xlate_grid(dset)
	orientation  = dsg_orientation(dset)
	dsg_coord_lm = cxdsg_coord_lm(orientation)
	IF (orientation .EQ. x_dim) dsg_coord_lm_y = cxdsg_coord_lm(y_dim)
	

* ****** PERFORM THE COMPUTATION *****
	IF (idim.EQ.orientation .AND. orientation.LE.t_dim) THEN 

* *** true ragged array processing:
* compress each feature into a single value 

           base = 0    ! obs index at end of preceding feature

* ... loop over the features
	   ftrloop: DO ifeature = 1, nfeatures 

	      flen = dsg_linemem(row_size_lm)%ptr(ifeature)  ! feature length

* ... have the user's constraints removed this feature?
	      IF (.NOT.fmask(ifeature)) THEN
                 base = base + flen
                 CYCLE ftrloop
              ENDIF

* ... get observation-level mask for this feature
	      CALL MAKE_DSG_OBS_MASK(dset, com_cx, ifeature, base,
     .				     omask, flen)

* ... loop over the observations within each feature
              iobs = base

* Single item in the feature, std can't be computed

	      IF (flen .EQ. 1) THEN 
		  res(ifeature) = bad_res
		  base = base + flen
		  CYCLE ftrloop 
	      ENDIF

* Get and save box sizes for all feature coordinates. Feature-mask applied later.
*
* Weighted computation:
*   For trajectories the box size is the  great-circle-distance along the line between 
*   lon-lat points, For integrals, convert to meters; routine returns distance in Km.
*   In Z and T use distance between, construct boxes based on coordinate data.

              IF (orientation .EQ. x_dim) THEN
	         CALL BOXES_DSG (orientation, flen, unit, 
     .		   dsg_linemem(dsg_coord_lm)%ptr(base+1), 
     .		   dsg_linemem(cxdsg_coord_lm(y_dim))%ptr(base+1), box)

              ELSE
	         CALL BOXES_DSG (orientation, flen, unit, 
     .		   dsg_linemem(dsg_coord_lm)%ptr(base+1), 
     .		   dummy, box)

              ENDIF

* Large box sizes along trajectories - big gaps within the path -
* are replaced by the surrounding box size (???)

              IF (orientation .EQ. x_dim) 
     .		 CALL MEAN_STD (box, flen, bad_val4, .TRUE., boxmean, boxstd)

* ... loop over the observations within each feature, if obs is not masked 
*     sum its box size; get the observation and add to sum.

	      dsum = 0.0D0	! data
	      bsum = 0.0D0	! boxes

	      wsum_chunk = 0.
	      mean_chunk = 0.
	      s_chunk  = 0.

	      iobs = base
	      oloop: DO i = 1, flen
	         iobs = iobs + 1   ! index in the contig ragged array

	         IF (.NOT.omask(i)) CYCLE

	         v = com(iobs)
	         IF ( v .EQ. bad_com ) CYCLE

*    box size. For trajectory datasets, look for extra-large boxes
*    and instead use nearby delta --- box should be just the sample region

		 boxdel = box(i)

		 IF ( orientation.EQ.x_dim ) THEN
		    IF (boxstd .GT. 0.) THEN
		       IF ( boxdel .GT. 2.* boxstd) THEN
		          IF (i.GT.1) THEN
		             boxdel = MIN( boxstd, box(i-1) )
		          ELSEIF (i.LT.flen) THEN
		             boxdel = MIN( boxstd, box(i+1) )
		          ELSE
		             boxdel = boxmean
		          ENDIF
		       ENDIF
	            ELSE
		       res(iobs) = bad_res
		       CYCLE oloop
		    ENDIF
	         ENDIF

	         w = boxdel
	         IF ( w .EQ. 0. ) CYCLE
	         wsum_chunk = wsum_chunk + w
	         mean_old = mean_chunk
	         mean_chunk = mean_old + (w/wsum_chunk)*(v-mean_old)
	         s_chunk = s_chunk + w * (v-mean_old)*(v-mean_chunk)

	      ENDDO oloop
	      
	      wsum(ifeature) = wsum_chunk
	      res(ifeature)  = mean_chunk
	      s(ifeature)    = s_chunk

	      base = base + flen

	   ENDDO ftrloop

	ELSE  

* *** a simple list of instances:
* compress along the instance (feature) axis resulting in just a single value
* Each feature weightsed equally.

	   wsum_chunk = 0.
	   mean_chunk = 0.
	   s_chunk  = 0.

	   DO ifeature = 1, nfeatures 

* ... have the user's constraints removed this feature?
	      IF (.NOT.fmask(ifeature)) CYCLE

* ... the data value
	      v = com(ifeature)
	      IF ( v .EQ. bad_com ) CYCLE

	      w = 1.
	      wsum_chunk = wsum_chunk + w
	      mean_old = mean_chunk
	      mean_chunk = mean_old + (w/wsum_chunk)*(v-mean_old)
	      s_chunk = s_chunk + w * (v-mean_old)*(v-mean_chunk)
           ENDDO
	   
* This will go off to the finalize routine so just set the res and weights

           wsum(1) = wsum_chunk
           res(1)  = mean_chunk
           s(1)    = s_chunk


	ENDIF  ! obs vs feature average/integral

	
	RETURN
	END
