---
id: fast-foundation.dialog
title: Dialog class
hide_title: true
---
<!-- Do not edit this file. It is automatically generated by API Documenter. -->

[@microsoft/fast-foundation](./fast-foundation.md) &gt; [Dialog](./fast-foundation.dialog.md)

## Dialog class

A Switch Custom HTML Element. Implements the [ARIA dialog](https://www.w3.org/TR/wai-aria-1.1/#dialog)<!-- -->.


- The default slot for the dialog content


positioning-region - A wrapping element used to center the dialog and position the modal overlay


overlay - The modal dialog overlay


control - The dialog element


cancel - Fires a custom 'cancel' event when the modal overlay is clicked


close - Fires a custom 'close' event when the dialog is hidden

<b>Signature:</b>

```typescript
export declare class Dialog extends FoundationElement 
```

## Properties

|  Property | Modifiers | Type | Description |
|  --- | --- | --- | --- |
|  [ariaDescribedby](./fast-foundation.dialog.ariadescribedby.md) |  | string | The id of the element describing the dialog. |
|  [ariaLabel](./fast-foundation.dialog.arialabel.md) |  | string | The label surfaced to assistive technologies. |
|  [ariaLabelledby](./fast-foundation.dialog.arialabelledby.md) |  | string | The id of the element labeling the dialog. |
|  [hidden](./fast-foundation.dialog.hidden.md) |  | boolean | The hidden state of the element. |
|  [modal](./fast-foundation.dialog.modal.md) |  | boolean | Indicates the element is modal. When modal, user mouse interaction will be limited to the contents of the element by a modal overlay. Clicks on the overlay will cause the dialog to emit a "dismiss" event. |
|  [trapFocus](./fast-foundation.dialog.trapfocus.md) |  | boolean | Indicates that the dialog should trap focus. |

## Methods

|  Method | Modifiers | Description |
|  --- | --- | --- |
|  [hide()](./fast-foundation.dialog.hide.md) |  | The method to hide the dialog. |
|  [show()](./fast-foundation.dialog.show.md) |  | The method to show the dialog. |
