/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef MvQPlaceMarkModel_H
#define MvQPlaceMarkModel_H

#include <QAbstractItemModel>
#include <QList>
//#include <QStyledItemDelegate>
//#include <QStyleOptionViewItem>

//class QSlider;
//class QLabel;

class MvQPlaceMarkNode;
/*
class MvQSlider : public QWidget
{
	Q_OBJECT

public: 
	MvQSlider(QWidget *parent);
	~MvQSlider();
	
	int sliderPosition();
	void setSliderPosition(int);	

protected slots:
	void slotUpdateLabel(int);

signals:
	void editingFinished();

private:
	QSlider *slider_;
	QLabel *label_;
};


class MvQPlaceMarkDelegate : public QStyledItemDelegate
{
	Q_OBJECT

public:

	MvQPlaceMarkDelegate(QWidget* parent=0);
	void paint(QPainter *painter,const QStyleOptionViewItem &option,
		           const QModelIndex& index) const;
	QWidget* createEditor(QWidget *parent, const QStyleOptionViewItem &option,
		           const QModelIndex& index) const;
	void setEditorData(QWidget *editor,const QModelIndex& index) const;
	void updateEditorGeometry(QWidget* editor, const QStyleOptionViewItem &option, const QModelIndex &index );

	void setModelData(QWidget *editor,QAbstractItemModel *model,const QModelIndex& index) const;

private slots:
	void commmitAndCloseEditor();

};
*/

class MvQPlaceMarkModel : public QAbstractItemModel
{
    Q_OBJECT

public:
    MvQPlaceMarkModel();

    int columnCount(const QModelIndex& parent = QModelIndex()) const;
    int rowCount(const QModelIndex& parent = QModelIndex()) const;

    QVariant data(const QModelIndex&, int role = Qt::DisplayRole) const;
    bool setData(const QModelIndex&, const QVariant&, int role = Qt::EditRole);
    QVariant headerData(int, Qt::Orientation, int role = Qt::DisplayRole) const;

    QModelIndex index(int, int, const QModelIndex& parent = QModelIndex()) const;
    QModelIndex parent(const QModelIndex&) const;

    void dataIsAboutToChange();

    void setRootNode(MvQPlaceMarkNode*);
    QModelIndex indexFromNode(MvQPlaceMarkNode*) const;
    MvQPlaceMarkNode* nodeFromIndex(const QModelIndex& index) const;
    void updateItem(const QModelIndex& index);

    Qt::ItemFlags flags(const QModelIndex&) const;

    Qt::DropActions supportedDropActions() const;
    QStringList mimeTypes() const;
    QMimeData* mimeData(const QModelIndexList&) const;
    bool dropMimeData(const QMimeData* data,
                      Qt::DropAction action, int row, int column,
                      const QModelIndex& parent);

public slots:
    void slotItemUpdated();

signals:
    void visibilityChanged();

protected:
    QString label(MvQPlaceMarkNode*, const int, const int) const;


private:
    MvQPlaceMarkNode* root_;
    Qt::CheckState state_;
};


#endif
