/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

//=============================================================================

#ifndef CBUFR_H__
#define CBUFR_H__


#include "Cached.h"
#include "MvGeoPoints.h"


class CBufr : public InPool
{
    request* r;
    virtual void ToRequest(request*&);
    virtual int Write(FILE*);
    virtual void ToBufr(CBufr*& x) { x = this; }

public:
    CBufr(request* r);
    CBufr(const char* name, int temp = 0);
    ~CBufr();

    const char* GetFileName();
};


class CGeopts : public InPool
{
    MvGeoPoints gpts;

    request* r;
    virtual void ToRequest(request*&);
    virtual void ToGeopts(CGeopts*& x) { x = this; }
    virtual int Write(FILE*);
    void SetSubValue(Value& v, int arity, Value* arg);

public:
    void load(void);
    void unload(bool doFree=false);
    void sort() { gpts.sort(); }
    void removeDuplicates() { gpts.removeDuplicates(); }
    void offset(double dlat, double dlon) { gpts.offset(dlat, dlon); }

    void SetSize(int n) { gpts.count(n); }
    long Count(void) { return gpts.count(); }
    int nValCols() { return gpts.nValCols(); }
    size_t nValColsForCompute() { return gpts.nValColsForCompute(); }
    int indexOfNamedValue(std::string& name) { return gpts.indexOfNamedValue(name); }
    long indexOfFirstValidPoint(size_t c) { return gpts.indexOfFirstValidPoint(c); }
    void hasStnIds() {gpts.hasStnIds(true); }
    void addColName(std::string name, bool markStnIdAsUsed = false) { gpts.addColName(name, markStnIdAsUsed); }
    void clearValueColNames() { gpts.clearValueColNames(); }
    vector<string> columnNames() const { return gpts.colNames(); }
    vector<string> valueColumnNames() const { return gpts.valueColNames(); }
     vector<string> usedColumnNames() const { return gpts.usedColNames(); }
    string valueColumnName(size_t i) {return gpts.valueColName(i); }
    void addColType(std::string name) { gpts.addColName(name); }
    MvGeoPointColumnInfo &columnInfo() { return gpts.columnInfo(); }
    MvGeoP1& operator[](long n) { return gpts[n]; }
    void SetFormat(eGeoFormat f, size_t nv = 0) { gpts.format(f, nv); }
    eGeoFormat Format(void) { return gpts.format(); }
    const char* GetFileName();
    std::string SetColumnValues(eGeoColType col, Value& newVals, bool isList, bool isVector, bool valueIndexProvided, Value* valueIndex);
    void fillValueColumnNames()  {gpts.fillValueColumnNames();}

    MvGeoPoints::metadata_t& metadata() { return gpts.metadata(); }
    MvGeoPoints::metadata_t const& metadataConst() { return gpts.metadataConst(); }
    bool const doesMetadataMatch(const request* r);

    bool isCompatible(const CGeopts &in) {return gpts.isCompatible(in.gpts);}

    string dbSystem() { return gpts.dbSystem(); }
    string dbPath() { return gpts.dbPath(); }
    string dbColumn(string c) { return gpts.dbColumn(c); }
    string dbColumnAlias(string c) { return gpts.dbColumnAlias(c); }
    const vector<string>& dbQuery() { return gpts.dbQuery(); }

    CGeopts(request* r);
    CGeopts(long count, int nvals, eGeoFormat efmt, bool init);
    CGeopts(long count, const MvGeoPointColumnInfo &colInfo, eGeoFormat efmt, bool init);
    CGeopts(CGeopts*);
    CGeopts(fieldset*, int);
    CGeopts(CGeopts*, fieldset*, int, bool nearest, bool nearestValid, bool storeLocs);
    CGeopts(const char* name, int temp = 0);
    CGeopts(MvGeoPoints& gptsIn);
    ~CGeopts();
};

#endif  // CBUFR_H__
