/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 4.0.2
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.sbml.libsbml;

/** 
 *  Registry of all libSBML SBML DefinitionURLs.
 <p>
 * <p style='color: #777; font-style: italic'>
This class of objects is defined by libSBML only and has no direct
equivalent in terms of SBML components.  It is a class used in
the implementation of extra functionality provided by libSBML.
</p>

 <p>
 * LibSBML provides facilities for transforming and converting SBML
 * documents in various ways.  These transformations can involve
 * essentially anything that can be written algorithmically; examples
 * include converting the units of measurement in a model, or converting
 * from one Level+Version combination of SBML to another.  DefinitionURLs are
 * implemented as objects derived from the class DefinitionURL.
 <p>
 * The DefinitionURL registry, implemented as a singleton object of class
 * {@link DefinitionURLRegistry}, maintains a list of known DefinitionURLs and provides
 * methods for discovering them.  Callers can use the method
 * {@link DefinitionURLRegistry#getNumDefinitionURLs()} to find out how many
 * DefinitionURLs are registered, then use
 * {@link DefinitionURLRegistry#getDefinitionURLByIndex(int)} to
 * iterate over each one; alternatively, callers can use
 * {@link DefinitionURLRegistry#getDefinitionURLFor(ConversionProperties)}
 * to search for a DefinitionURL having specific properties.
 */

public class DefinitionURLRegistry {
   private long swigCPtr;
   protected boolean swigCMemOwn;

   protected DefinitionURLRegistry(long cPtr, boolean cMemoryOwn)
   {
     swigCMemOwn = cMemoryOwn;
     swigCPtr    = cPtr;
   }

   protected static long getCPtr(DefinitionURLRegistry obj)
   {
     return (obj == null) ? 0 : obj.swigCPtr;
   }

   protected static long getCPtrAndDisown (DefinitionURLRegistry obj)
   {
     long ptr = 0;

     if (obj != null)
     {
       ptr             = obj.swigCPtr;
       obj.swigCMemOwn = false;
     }

     return ptr;
   }

  @SuppressWarnings("deprecation")
  protected void finalize() {
    delete();
  }

  public synchronized void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        libsbmlJNI.delete_DefinitionURLRegistry(swigCPtr);
      }
      swigCPtr = 0;
    }
  }

  
/**
   * Returns the singleton instance for the DefinitionURL registry.
   <p>
   * Prior to using the registry, callers have to obtain a copy of the
   * registry.  This static method provides the means for doing that.
   <p>
   * @return the singleton for the DefinitionURL registry.
   */ public
 static DefinitionURLRegistry getInstance() {
    return new DefinitionURLRegistry(libsbmlJNI.DefinitionURLRegistry_getInstance(), false);
  }

  
/**
   * Adds the given DefinitionURL to the registry of SBML DefinitionURLs.
   <p>
   * @param url the DefinitionURL to add to the registry.
   * @param type the {@link ASTNodeType_t} of the URL to add to the registry.
   <p>
   * <p>
 * @return integer value indicating success/failure of the
 * function.   The possible values
 * returned by this function are:
   * <ul>
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
   * <li> {@link libsbmlConstants#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT}
   * </ul>
   */ public
 static int addDefinitionURL(String url, int type) {
    return libsbmlJNI.DefinitionURLRegistry_addDefinitionURL(url, type);
  }

  
/**
   * Returns the number of DefinitionURLs known by the registry.
   <p>
   * @return the number of registered DefinitionURLs.
   <p>
   * @see #getDefinitionURLByIndex(int)
   */ public
 static int getNumDefinitionURLs() {
    return libsbmlJNI.DefinitionURLRegistry_getNumDefinitionURLs();
  }

  
/** */ public
 static void addSBMLDefinitions() {
    libsbmlJNI.DefinitionURLRegistry_addSBMLDefinitions();
  }

  
/** */ public
 static boolean getCoreDefinitionsAdded() {
    return libsbmlJNI.DefinitionURLRegistry_getCoreDefinitionsAdded();
  }

  
/** */ public
 static int getType(String url) {
    return libsbmlJNI.DefinitionURLRegistry_getType(url);
  }

  
/** */ public
 static String getDefinitionUrlByIndex(int index) {
    return libsbmlJNI.DefinitionURLRegistry_getDefinitionUrlByIndex(index);
  }

  
/** */ public
 static void clearDefinitions() {
    libsbmlJNI.DefinitionURLRegistry_clearDefinitions();
  }

}
