/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 4.0.2
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.sbml.libsbml;

/** 
 *  A <em>compartment type</em> in SBML Level&nbsp;2.
 <p>
 * SBML Level&nbsp;2 Versions&nbsp;2&ndash;4 provide the <em>compartment
 * type</em> as a grouping construct that can be used to establish a
 * relationship between multiple {@link Compartment} objects.  A {@link CompartmentType}
 * object only has an identity, and this identity can only be used to
 * indicate that particular {@link Compartment} objects in the model belong to this
 * type.  This may be useful for conveying a modeling intention, such as
 * when a model contains many similar compartments, either by their
 * biological function or the reactions they carry.  Without a compartment
 * type construct, it would be impossible within SBML itself to indicate
 * that all of the compartments share an underlying conceptual relationship
 * because each SBML compartment must be given a unique and separate
 * identity.  A {@link CompartmentType} has no mathematical meaning in
 * SBML&mdash;it has no effect on a model's mathematical interpretation.
 * Simulators and other numerical analysis software may ignore
 * {@link CompartmentType} definitions and references to them in a model.
 <p>
 * There is no mechanism in SBML Level 2 for representing hierarchies of
 * compartment types.  One {@link CompartmentType} instance cannot be the subtype
 * of another {@link CompartmentType} instance; SBML provides no means of defining
 * such relationships.
 <p>
 * As with other major structures in SBML, {@link CompartmentType} has a mandatory
 * attribute, 'id', used to give the compartment type an identifier.  The
 * identifier must be a text string conforming to the identifer syntax
 * permitted in SBML.  {@link CompartmentType} also has an optional 'name'
 * attribute, of type <code>string.</code>  The 'id' and 'name' must be used
 * according to the guidelines described in the SBML specification (e.g.,
 * Section 3.3 in the Level 2 Version 4 specification).
 <p>
 * {@link CompartmentType} was introduced in SBML Level 2 Version 2.  It is not
 * available in SBML Level&nbsp;1 nor in Level&nbsp;3.
 <p>
 * @see Compartment
 * @see ListOfCompartmentTypes
 * @see SpeciesType
 * @see ListOfSpeciesTypes
 */

public class CompartmentType extends SBase {
   private long swigCPtr;

   protected CompartmentType(long cPtr, boolean cMemoryOwn)
   {
     super(libsbmlJNI.CompartmentType_SWIGUpcast(cPtr), cMemoryOwn);
     swigCPtr = cPtr;
   }

   protected static long getCPtr(CompartmentType obj)
   {
     return (obj == null) ? 0 : obj.swigCPtr;
   }

   protected static long getCPtrAndDisown (CompartmentType obj)
   {
     long ptr = 0;

     if (obj != null)
     {
       ptr             = obj.swigCPtr;
       obj.swigCMemOwn = false;
     }

     return ptr;
   }

  @SuppressWarnings("deprecation")
  protected void finalize() {
    delete();
  }

  public synchronized void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        libsbmlJNI.delete_CompartmentType(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  
/**
   * Creates a new {@link CompartmentType} object using the given SBML <code>level</code> and
   * <code>version</code> values.
   <p>
   * @param level a long integer, the SBML Level to assign to this
   * {@link CompartmentType}.
   <p>
   * @param version a long integer, the SBML Version to assign to this
   * {@link CompartmentType}.
   <p>
   * <p>
 * @throws SBMLConstructorException
 * Thrown if the given <code>level</code> and <code>version</code> combination are invalid
 * or if this object is incompatible with the given level and version.
   <p>
   * <p>
 * @note Attempting to add an object to an {@link SBMLDocument} having a different
 * combination of SBML Level, Version and XML namespaces than the object
 * itself will result in an error at the time a caller attempts to make the
 * addition.  A parent object must have compatible Level, Version and XML
 * namespaces.  (Strictly speaking, a parent may also have more XML
 * namespaces than a child, but the reverse is not permitted.)  The
 * restriction is necessary to ensure that an SBML model has a consistent
 * overall structure.  This requires callers to manage their objects
 * carefully, but the benefit is increased flexibility in how models can be
 * created by permitting callers to create objects bottom-up if desired.  In
 * situations where objects are not yet attached to parents (e.g.,
 * {@link SBMLDocument}), knowledge of the intented SBML Level and Version help
 * libSBML determine such things as whether it is valid to assign a
 * particular value to an attribute.
   */ public
 CompartmentType(long level, long version) throws org.sbml.libsbml.SBMLConstructorException {
    this(libsbmlJNI.new_CompartmentType__SWIG_0(level, version), true);
  }

  
/**
   * Creates a new {@link CompartmentType} object using the given {@link SBMLNamespaces}
   * object <code>sbmlns</code>.
   <p>
   * <p>
 * The {@link SBMLNamespaces} object encapsulates SBML Level/Version/namespaces
 * information.  It is used to communicate the SBML Level, Version, and (in
 * Level&nbsp;3) packages used in addition to SBML Level&nbsp;3 Core.  A
 * common approach to using libSBML's {@link SBMLNamespaces} facilities is to create an
 * {@link SBMLNamespaces} object somewhere in a program once, then hand that object
 * as needed to object constructors that accept {@link SBMLNamespaces} as arguments.
   <p>
   * It is worth emphasizing that although this constructor does not take an
   * identifier argument, in SBML Level&nbsp;2 and beyond, the 'id'
   * (identifier) attribute of a {@link CompartmentType} object is required to have a
   * value.  Thus, callers are cautioned to assign a value after calling this
   * constructor.  Setting the identifier can be accomplished using the
   * method setId(String).
   <p>
   * @param sbmlns an {@link SBMLNamespaces} object.
   <p>
   * <p>
 * @throws SBMLConstructorException
 * Thrown if the given <code>sbmlns</code> is inconsistent or incompatible
 * with this object.
   <p>
   * <p>
 * @note Attempting to add an object to an {@link SBMLDocument} having a different
 * combination of SBML Level, Version and XML namespaces than the object
 * itself will result in an error at the time a caller attempts to make the
 * addition.  A parent object must have compatible Level, Version and XML
 * namespaces.  (Strictly speaking, a parent may also have more XML
 * namespaces than a child, but the reverse is not permitted.)  The
 * restriction is necessary to ensure that an SBML model has a consistent
 * overall structure.  This requires callers to manage their objects
 * carefully, but the benefit is increased flexibility in how models can be
 * created by permitting callers to create objects bottom-up if desired.  In
 * situations where objects are not yet attached to parents (e.g.,
 * {@link SBMLDocument}), knowledge of the intented SBML Level and Version help
 * libSBML determine such things as whether it is valid to assign a
 * particular value to an attribute.
   */ public
 CompartmentType(SBMLNamespaces sbmlns) throws org.sbml.libsbml.SBMLConstructorException {
    this(libsbmlJNI.new_CompartmentType__SWIG_1(SBMLNamespaces.getCPtr(sbmlns), sbmlns), true);
  }

  
/**
   * Copy constructor; creates a copy of this {@link CompartmentType} object.
   <p>
   * @param orig the object to copy.
   */ public
 CompartmentType(CompartmentType orig) throws org.sbml.libsbml.SBMLConstructorException {
    this(libsbmlJNI.new_CompartmentType__SWIG_2(CompartmentType.getCPtr(orig), orig), true);
  }

  
/**
   * Creates and returns a deep copy of this {@link CompartmentType} object.
   <p>
   * @return the (deep) copy of this {@link CompartmentType} object.
   */ public
 CompartmentType cloneObject() {
    long cPtr = libsbmlJNI.CompartmentType_cloneObject(swigCPtr, this);
    return (cPtr == 0) ? null : new CompartmentType(cPtr, true);
  }

  
/**
   * Returns the value of the 'id' attribute of this {@link CompartmentType}.
   <p>
   * @note Because of the inconsistent behavior of this function with 
   * respect to assignments and rules, it is now recommended to
   * use the getIdAttribute() function instead.
   <p>
   * <p>
 * The identifier given by an object's 'id' attribute value
 * is used to identify the object within the SBML model definition.
 * Other objects can refer to the component using this identifier.  The
 * data type of 'id' is always <code>SId</code> or a type derived
 * from that, such as <code>UnitSId</code>, depending on the object in 
 * question.  All data types are defined as follows:
 * <pre style='margin-left: 2em; border: none; font-weight: bold; color: black'>
 *   letter .= 'a'..'z','A'..'Z'
 *   digit  .= '0'..'9'
 *   idChar .= letter | digit | '_'
 *   SId    .= ( letter | '_' ) idChar*
 * </pre>
 * The characters <code>(</code> and <code>)</code> are used for grouping,
 * the character <code>*</code> 'zero or more times', and the character
 * <code>|</code> indicates logical 'or'.  The equality of SBML identifiers
 * is determined by an exact character sequence match; i.e., comparisons must
 * be performed in a case-sensitive manner.  This applies to all uses of
 * <code>SId</code>, <code>SIdRef</code>, and derived types.
 <p>
 * Users need to be aware of some important API issues that are the result of
 * the history of SBML and libSBML.  Prior to SBML Level&nbsp;3
 * Version&nbsp;2, SBML defined 'id' and 'name' attributes on only a subset
 * of SBML objects.  To simplify the work of programmers, libSBML's API
 * provided get, set, check, and unset on the {@link SBase} object class itself
 * instead of on individual subobject classes. This made the
 * get/set/etc. methods uniformly available on all objects in the libSBML
 * API.  LibSBML simply returned empty strings or otherwise did not act when
 * the methods were applied to SBML objects that were not defined by the SBML
 * specification to have 'id' or 'name' attributes.  Additional complications
 * arose with the rule and assignment objects: {@link InitialAssignment},
 * {@link EventAssignment}, {@link AssignmentRule}, and {@link RateRule}.  In early versions of SBML,
 * the rule object hierarchy was different, and in addition, then as now,
 * they possess different attributes: 'variable' (for the rules and event
 * assignments), 'symbol' (for initial assignments), or neither (for
 * algebraic rules).  Prior to SBML Level&nbsp;3 Version&nbsp;2, getId()
 * would always return an empty string, and isSetId() would always return 
 * <code>false</code> for objects of these classes.
 <p>
 * With the addition of 'id' and 'name' attributes on {@link SBase} in Level&nbsp;3
 * Version&nbsp;2, it became necessary to introduce a new way to interact
 * with the attributes more consistently in libSBML to avoid breaking
 * backward compatibility in the behavior of the original 'id' methods.  For
 * this reason, libSBML provides four functions (getIdAttribute(),
 * setIdAttribute(String), isSetIdAttribute(), and
 * unsetIdAttribute()) that always act on the actual 'id' attribute inherited
 * from {@link SBase}, regardless of the object's type.  <strong>These new methods
 * should be used instead of the older getId()/setId()/etc. methods</strong>
 * unless the old behavior is somehow necessary.  Regardless of the Level and
 * Version of the SBML, these functions allow client applications to use more
 * generalized code in some situations (for instance, when manipulating
 * objects that are all known to have identifiers).  If the object in
 * question does not posess an 'id' attribute according to the SBML
 * specification for the Level and Version in use, libSBML will not allow the
 * identifier to be set, nor will it read or write 'id' attributes for those
 * objects.
   <p>
   * @return the id of this {@link CompartmentType}.
   <p>
   * @see #getIdAttribute()
   * @see #setIdAttribute(String sid)
   * @see #isSetIdAttribute()
   * @see #unsetIdAttribute()
   */ public
 String getId() {
    return libsbmlJNI.CompartmentType_getId(swigCPtr, this);
  }

  
/**
   * Returns the value of the 'name' attribute of this {@link CompartmentType} object.
   <p>
   * <p>
 * <p>
 * In SBML Level&nbsp;3 Version&nbsp;2, the 'id' and 'name' attributes were
 * moved to {@link SBase} directly, instead of being defined individually for many
 * (but not all) objects.  LibSBML has for a long time provided functions
 * defined on {@link SBase} itself to get, set, and unset those attributes, which 
 * would fail or otherwise return empty strings if executed on any object 
 * for which those attributes were not defined.  Now that all {@link SBase} objects 
 * define those attributes, those functions now succeed for any object with 
 * the appropriate level and version.
 <p>
 * The 'name' attribute is
 * optional and is not intended to be used for cross-referencing purposes
 * within a model.  Its purpose instead is to provide a human-readable
 * label for the component.  The data type of 'name' is the type
 * <code>string</code> defined in XML Schema.  SBML imposes no
 * restrictions as to the content of 'name' attributes beyond those
 * restrictions defined by the <code>string</code> type in XML Schema.
 <p>
 * The recommended practice for handling 'name' is as follows.  If a
 * software tool has the capability for displaying the content of 'name'
 * attributes, it should display this content to the user as a
 * component's label instead of the component's 'id'.  If the user
 * interface does not have this capability (e.g., because it cannot
 * display or use special characters in symbol names), or if the 'name'
 * attribute is missing on a given component, then the user interface
 * should display the value of the 'id' attribute instead.  (Script
 * language interpreters are especially likely to display 'id' instead of
 * 'name'.)
 <p>
 * As a consequence of the above, authors of systems that automatically
 * generate the values of 'id' attributes should be aware some systems
 * may display the 'id''s to the user.  Authors therefore may wish to
 * take some care to have their software create 'id' values that are: (a)
 * reasonably easy for humans to type and read; and (b) likely to be
 * meaningful, for example by making the 'id' attribute be an abbreviated
 * form of the name attribute value.
 <p>
 * An additional point worth mentioning is although there are
 * restrictions on the uniqueness of 'id' values, there are no
 * restrictions on the uniqueness of 'name' values in a model.  This
 * allows software applications leeway in assigning component identifiers.
 <p>
 * Regardless of the level and version of the SBML, these functions allow
 * client applications to use more generalized code in some situations 
 * (for instance, when manipulating objects that are all known to have 
 * names).  If the object in question does not posess a 'name' attribute 
 * according to the SBML specification for the Level and Version in use,
 * libSBML will not allow the name to be set, nor will it read or 
 * write 'name' attributes for those objects.
 <p>
 * @return the name of this SBML object, or the empty string if not set or unsettable.
 <p>
 * @see #getIdAttribute()
 * @see #isSetName()
 * @see #setName(String sid)
 * @see #unsetName()
   */ public
 String getName() {
    return libsbmlJNI.CompartmentType_getName(swigCPtr, this);
  }

  
/**
   * Predicate returning <code>true</code> if this {@link CompartmentType} object's 'id'
   * attribute is set.
   <p>
   * <p>
 * <p>
 * The identifier given by an object's 'id' attribute value
 * is used to identify the object within the SBML model definition.
 * Other objects can refer to the component using this identifier.  The
 * data type of 'id' is always <code>SId</code> or a type derived
 * from that, such as <code>UnitSId</code>, depending on the object in 
 * question.  All data types are defined as follows:
 * <pre style='margin-left: 2em; border: none; font-weight: bold; color: black'>
 *   letter .= 'a'..'z','A'..'Z'
 *   digit  .= '0'..'9'
 *   idChar .= letter | digit | '_'
 *   SId    .= ( letter | '_' ) idChar*
 * </pre>
 * The characters <code>(</code> and <code>)</code> are used for grouping,
 * the character <code>*</code> 'zero or more times', and the character
 * <code>|</code> indicates logical 'or'.  The equality of SBML identifiers
 * is determined by an exact character sequence match; i.e., comparisons must
 * be performed in a case-sensitive manner.  This applies to all uses of
 * <code>SId</code>, <code>SIdRef</code>, and derived types.
 <p>
 * Users need to be aware of some important API issues that are the result of
 * the history of SBML and libSBML.  Prior to SBML Level&nbsp;3
 * Version&nbsp;2, SBML defined 'id' and 'name' attributes on only a subset
 * of SBML objects.  To simplify the work of programmers, libSBML's API
 * provided get, set, check, and unset on the {@link SBase} object class itself
 * instead of on individual subobject classes. This made the
 * get/set/etc. methods uniformly available on all objects in the libSBML
 * API.  LibSBML simply returned empty strings or otherwise did not act when
 * the methods were applied to SBML objects that were not defined by the SBML
 * specification to have 'id' or 'name' attributes.  Additional complications
 * arose with the rule and assignment objects: {@link InitialAssignment},
 * {@link EventAssignment}, {@link AssignmentRule}, and {@link RateRule}.  In early versions of SBML,
 * the rule object hierarchy was different, and in addition, then as now,
 * they possess different attributes: 'variable' (for the rules and event
 * assignments), 'symbol' (for initial assignments), or neither (for
 * algebraic rules).  Prior to SBML Level&nbsp;3 Version&nbsp;2, getId()
 * would always return an empty string, and isSetId() would always return 
 * <code>false</code> for objects of these classes.
 <p>
 * With the addition of 'id' and 'name' attributes on {@link SBase} in Level&nbsp;3
 * Version&nbsp;2, it became necessary to introduce a new way to interact
 * with the attributes more consistently in libSBML to avoid breaking
 * backward compatibility in the behavior of the original 'id' methods.  For
 * this reason, libSBML provides four functions (getIdAttribute(),
 * setIdAttribute(String), isSetIdAttribute(), and
 * unsetIdAttribute()) that always act on the actual 'id' attribute inherited
 * from {@link SBase}, regardless of the object's type.  <strong>These new methods
 * should be used instead of the older getId()/setId()/etc. methods</strong>
 * unless the old behavior is somehow necessary.  Regardless of the Level and
 * Version of the SBML, these functions allow client applications to use more
 * generalized code in some situations (for instance, when manipulating
 * objects that are all known to have identifiers).  If the object in
 * question does not posess an 'id' attribute according to the SBML
 * specification for the Level and Version in use, libSBML will not allow the
 * identifier to be set, nor will it read or write 'id' attributes for those
 * objects.
 <p>
 * @return <code>true</code> if the 'id' attribute of this SBML object is
 * set, <code>false</code> otherwise.
 <p>
 * @note Because of the inconsistent behavior of this function with
 * respect to assignments and rules, it is recommended that callers
 * use isSetIdAttribute() instead.
 <p>
 * @see #getIdAttribute()
 * @see #setIdAttribute(String sid)
 * @see #unsetIdAttribute()
 * @see #isSetIdAttribute()
   */ public
 boolean isSetId() {
    return libsbmlJNI.CompartmentType_isSetId(swigCPtr, this);
  }

  
/**
   * Predicate returning <code>true</code> if this {@link CompartmentType} object's 'name'
   * attribute is set.
   <p>
   * <p>
 * <p>
 * In SBML Level&nbsp;3 Version&nbsp;2, the 'id' and 'name' attributes were
 * moved to {@link SBase} directly, instead of being defined individually for many
 * (but not all) objects.  LibSBML has for a long time provided functions
 * defined on {@link SBase} itself to get, set, and unset those attributes, which 
 * would fail or otherwise return empty strings if executed on any object 
 * for which those attributes were not defined.  Now that all {@link SBase} objects 
 * define those attributes, those functions now succeed for any object with 
 * the appropriate level and version.
 <p>
 * The 'name' attribute is
 * optional and is not intended to be used for cross-referencing purposes
 * within a model.  Its purpose instead is to provide a human-readable
 * label for the component.  The data type of 'name' is the type
 * <code>string</code> defined in XML Schema.  SBML imposes no
 * restrictions as to the content of 'name' attributes beyond those
 * restrictions defined by the <code>string</code> type in XML Schema.
 <p>
 * The recommended practice for handling 'name' is as follows.  If a
 * software tool has the capability for displaying the content of 'name'
 * attributes, it should display this content to the user as a
 * component's label instead of the component's 'id'.  If the user
 * interface does not have this capability (e.g., because it cannot
 * display or use special characters in symbol names), or if the 'name'
 * attribute is missing on a given component, then the user interface
 * should display the value of the 'id' attribute instead.  (Script
 * language interpreters are especially likely to display 'id' instead of
 * 'name'.)
 <p>
 * As a consequence of the above, authors of systems that automatically
 * generate the values of 'id' attributes should be aware some systems
 * may display the 'id''s to the user.  Authors therefore may wish to
 * take some care to have their software create 'id' values that are: (a)
 * reasonably easy for humans to type and read; and (b) likely to be
 * meaningful, for example by making the 'id' attribute be an abbreviated
 * form of the name attribute value.
 <p>
 * An additional point worth mentioning is although there are
 * restrictions on the uniqueness of 'id' values, there are no
 * restrictions on the uniqueness of 'name' values in a model.  This
 * allows software applications leeway in assigning component identifiers.
 <p>
 * Regardless of the level and version of the SBML, these functions allow
 * client applications to use more generalized code in some situations 
 * (for instance, when manipulating objects that are all known to have 
 * names).  If the object in question does not posess a 'name' attribute 
 * according to the SBML specification for the Level and Version in use,
 * libSBML will not allow the name to be set, nor will it read or 
 * write 'name' attributes for those objects.
 <p>
 * @return <code>true</code> if the 'name' attribute of this SBML object is
 * set, <code>false</code> otherwise.
 <p>
 * @see #getName()
 * @see #setName(String sid)
 * @see #unsetName()
   */ public
 boolean isSetName() {
    return libsbmlJNI.CompartmentType_isSetName(swigCPtr, this);
  }

  
/**
   * Sets the value of the 'id' attribute of this {@link CompartmentType}.
   <p>
   * <p>
 * The string <code>sid</code> is copied.
 <p>
 * <p>
 * The identifier given by an object's 'id' attribute value
 * is used to identify the object within the SBML model definition.
 * Other objects can refer to the component using this identifier.  The
 * data type of 'id' is always <code>SId</code> or a type derived
 * from that, such as <code>UnitSId</code>, depending on the object in 
 * question.  All data types are defined as follows:
 * <pre style='margin-left: 2em; border: none; font-weight: bold; color: black'>
 *   letter .= 'a'..'z','A'..'Z'
 *   digit  .= '0'..'9'
 *   idChar .= letter | digit | '_'
 *   SId    .= ( letter | '_' ) idChar*
 * </pre>
 * The characters <code>(</code> and <code>)</code> are used for grouping,
 * the character <code>*</code> 'zero or more times', and the character
 * <code>|</code> indicates logical 'or'.  The equality of SBML identifiers
 * is determined by an exact character sequence match; i.e., comparisons must
 * be performed in a case-sensitive manner.  This applies to all uses of
 * <code>SId</code>, <code>SIdRef</code>, and derived types.
 <p>
 * Users need to be aware of some important API issues that are the result of
 * the history of SBML and libSBML.  Prior to SBML Level&nbsp;3
 * Version&nbsp;2, SBML defined 'id' and 'name' attributes on only a subset
 * of SBML objects.  To simplify the work of programmers, libSBML's API
 * provided get, set, check, and unset on the {@link SBase} object class itself
 * instead of on individual subobject classes. This made the
 * get/set/etc. methods uniformly available on all objects in the libSBML
 * API.  LibSBML simply returned empty strings or otherwise did not act when
 * the methods were applied to SBML objects that were not defined by the SBML
 * specification to have 'id' or 'name' attributes.  Additional complications
 * arose with the rule and assignment objects: {@link InitialAssignment},
 * {@link EventAssignment}, {@link AssignmentRule}, and {@link RateRule}.  In early versions of SBML,
 * the rule object hierarchy was different, and in addition, then as now,
 * they possess different attributes: 'variable' (for the rules and event
 * assignments), 'symbol' (for initial assignments), or neither (for
 * algebraic rules).  Prior to SBML Level&nbsp;3 Version&nbsp;2, getId()
 * would always return an empty string, and isSetId() would always return 
 * <code>false</code> for objects of these classes.
 <p>
 * With the addition of 'id' and 'name' attributes on {@link SBase} in Level&nbsp;3
 * Version&nbsp;2, it became necessary to introduce a new way to interact
 * with the attributes more consistently in libSBML to avoid breaking
 * backward compatibility in the behavior of the original 'id' methods.  For
 * this reason, libSBML provides four functions (getIdAttribute(),
 * setIdAttribute(String), isSetIdAttribute(), and
 * unsetIdAttribute()) that always act on the actual 'id' attribute inherited
 * from {@link SBase}, regardless of the object's type.  <strong>These new methods
 * should be used instead of the older getId()/setId()/etc. methods</strong>
 * unless the old behavior is somehow necessary.  Regardless of the Level and
 * Version of the SBML, these functions allow client applications to use more
 * generalized code in some situations (for instance, when manipulating
 * objects that are all known to have identifiers).  If the object in
 * question does not posess an 'id' attribute according to the SBML
 * specification for the Level and Version in use, libSBML will not allow the
 * identifier to be set, nor will it read or write 'id' attributes for those
 * objects.
 <p>
 * @param sid the string to use as the identifier of this object.
 <p>
 * <p>
 * @return integer value indicating success/failure of the
 * function.   The possible values
 * returned by this function are:
 * <ul>
 * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
 * <li> {@link libsbmlConstants#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE}
 * <li> {@link libsbmlConstants#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE}
 *
 * </ul> <p>
 * @see #getIdAttribute()
 * @see #setIdAttribute(String sid)
 * @see #isSetIdAttribute()
 * @see #unsetIdAttribute()
   */ public
 int setId(String sid) {
    return libsbmlJNI.CompartmentType_setId(swigCPtr, this, sid);
  }

  
/**
   * Sets the value of the 'name' attribute of this {@link CompartmentType}.
   <p>
   * <p>
 * The string in <code>name</code> is copied.
 <p>
 * @param name the new name for the SBML object.
 <p>
 * <p>
 * @return integer value indicating success/failure of the
 * function.   The possible values
 * returned by this function are:
 * <ul>
 * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
 * <li> {@link libsbmlConstants#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE}
 *
 * </ul>
   */ public
 int setName(String name) {
    return libsbmlJNI.CompartmentType_setName(swigCPtr, this, name);
  }

  
/**
   * Unsets the value of the 'name' attribute of this {@link CompartmentType} object.
   <p>
   * <p>
 * <p>
 * In SBML Level&nbsp;3 Version&nbsp;2, the 'id' and 'name' attributes were
 * moved to {@link SBase} directly, instead of being defined individually for many
 * (but not all) objects.  LibSBML has for a long time provided functions
 * defined on {@link SBase} itself to get, set, and unset those attributes, which 
 * would fail or otherwise return empty strings if executed on any object 
 * for which those attributes were not defined.  Now that all {@link SBase} objects 
 * define those attributes, those functions now succeed for any object with 
 * the appropriate level and version.
 <p>
 * The 'name' attribute is
 * optional and is not intended to be used for cross-referencing purposes
 * within a model.  Its purpose instead is to provide a human-readable
 * label for the component.  The data type of 'name' is the type
 * <code>string</code> defined in XML Schema.  SBML imposes no
 * restrictions as to the content of 'name' attributes beyond those
 * restrictions defined by the <code>string</code> type in XML Schema.
 <p>
 * The recommended practice for handling 'name' is as follows.  If a
 * software tool has the capability for displaying the content of 'name'
 * attributes, it should display this content to the user as a
 * component's label instead of the component's 'id'.  If the user
 * interface does not have this capability (e.g., because it cannot
 * display or use special characters in symbol names), or if the 'name'
 * attribute is missing on a given component, then the user interface
 * should display the value of the 'id' attribute instead.  (Script
 * language interpreters are especially likely to display 'id' instead of
 * 'name'.)
 <p>
 * As a consequence of the above, authors of systems that automatically
 * generate the values of 'id' attributes should be aware some systems
 * may display the 'id''s to the user.  Authors therefore may wish to
 * take some care to have their software create 'id' values that are: (a)
 * reasonably easy for humans to type and read; and (b) likely to be
 * meaningful, for example by making the 'id' attribute be an abbreviated
 * form of the name attribute value.
 <p>
 * An additional point worth mentioning is although there are
 * restrictions on the uniqueness of 'id' values, there are no
 * restrictions on the uniqueness of 'name' values in a model.  This
 * allows software applications leeway in assigning component identifiers.
 <p>
 * Regardless of the level and version of the SBML, these functions allow
 * client applications to use more generalized code in some situations 
 * (for instance, when manipulating objects that are all known to have 
 * names).  If the object in question does not posess a 'name' attribute 
 * according to the SBML specification for the Level and Version in use,
 * libSBML will not allow the name to be set, nor will it read or 
 * write 'name' attributes for those objects.
 <p>
 * <p>
 * @return integer value indicating success/failure of the
 * function.   The possible values
 * returned by this function are:
 * <ul>
 * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
 * <li> {@link libsbmlConstants#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED}
 *
 * </ul> <p>
 * @see #getName()
 * @see #setName(String sid)
 * @see #isSetName()
   */ public
 int unsetName() {
    return libsbmlJNI.CompartmentType_unsetName(swigCPtr, this);
  }

  
/**
   * Returns the libSBML type code for this SBML object.
   <p>
   * <p>
 * LibSBML attaches an identifying code to every kind of SBML object.  These
 * are integer constants known as <em>SBML type codes</em>.  The names of all
 * the codes begin with the characters <code>SBML_</code>.
 * In the Java language interface for libSBML, the
 * type codes are defined as static integer constants in the interface class
 * {@link libsbmlConstants}.    Note that different Level&nbsp;3
 * package plug-ins may use overlapping type codes; to identify the package
 * to which a given object belongs, call the 
 * <code>{@link SBase#getPackageName()}
 * </code>
 * method on the object.
 <p>
 * The exception to this is lists:  all SBML-style list elements have the type 
 * {@link libsbmlConstants#SBML_LIST_OF SBML_LIST_OF}, regardless of what package they 
 * are from.
   <p>
   * @return the SBML type code for this object:
   * {@link libsbmlConstants#SBML_COMPARTMENT_TYPE SBML_COMPARTMENT_TYPE} (default).
   <p>
   * <p>
 * @warning <span class='warning'>The specific integer values of the possible
 * type codes may be reused by different libSBML plug-ins for SBML Level&nbsp;3.
 * packages,  To fully identify the correct code, <strong>it is necessary to
 * invoke both getPackageName() and getTypeCode()</strong> (or 
 * {@link ListOf#getItemTypeCode()}).</span>
   <p>
   * @see #getElementName()
   * @see #getPackageName()
   */ public
 int getTypeCode() {
    return libsbmlJNI.CompartmentType_getTypeCode(swigCPtr, this);
  }

  
/**
   * Returns the XML element name of this object
   <p>
   * For {@link CompartmentType}, the element name is always <code>'compartmentType'.</code>
   <p>
   * @return the name of this element.
   <p>
   * @see #getTypeCode()
   * @see #getPackageName()
   */ public
 String getElementName() {
    return libsbmlJNI.CompartmentType_getElementName(swigCPtr, this);
  }

  
/**
   * Predicate returning <code>true</code> if all the required attributes for this
   * {@link CompartmentType} object have been set.
   <p>
   * The required attributes for a {@link CompartmentType} object are:
   * <ul>
   * <li> 'id'
   *
   * </ul> <p>
   * @return <code>true</code> if the required attributes have been set, <code>false</code>
   * otherwise.
   */ public
 boolean hasRequiredAttributes() {
    return libsbmlJNI.CompartmentType_hasRequiredAttributes(swigCPtr, this);
  }

}
