FIND_PATH(LCMS2_INCLUDE_DIR lcms2.h
  /usr/local/include
  /usr/include
  /opt/local/include
)

SET(LCMS2_NAMES ${LCMS2_NAMES} lcms2)
FIND_LIBRARY(LCMS2_LIBRARY NAMES ${LCMS2_NAMES} )

# handle the QUIETLY and REQUIRED arguments and set LCMS2_FOUND to TRUE if
# all listed variables are TRUE
INCLUDE(FindPackageHandleStandardArgs)
FIND_PACKAGE_HANDLE_STANDARD_ARGS(LCMS2  DEFAULT_MSG  LCMS2_LIBRARY  LCMS2_INCLUDE_DIR)

IF(LCMS2_FOUND)
  SET( LCMS2_LIBRARIES ${LCMS2_LIBRARY} )
  IF(NOT LCMS2_FIND_QUIETLY)
    MESSAGE(STATUS "Found LCMS2 (LCMS2_LIBRARIES = ${LCMS2_LIBRARIES})")
    MESSAGE(STATUS "Found LCMS2 (LCMS2_INCLUDE_DIR = ${LCMS2_INCLUDE_DIR})")
  ENDIF(NOT LCMS2_FIND_QUIETLY)
ELSE(LCMS2_FOUND)
  IF(LCMS2_FIND_REQUIRED)
    MESSAGE(FATAL_ERROR "Could not find LCMS2")
  ENDIF(LCMS2_FIND_REQUIRED)
ENDIF(LCMS2_FOUND)

MARK_AS_ADVANCED(LCMS2_INCLUDE_DIR LCMS2_LIBRARY)
