// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/ads/googleads/v2/services/recommendation_service.proto

package services

import (
	context "context"
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	wrappers "github.com/golang/protobuf/ptypes/wrappers"
	common "google.golang.org/genproto/googleapis/ads/googleads/v2/common"
	enums "google.golang.org/genproto/googleapis/ads/googleads/v2/enums"
	resources "google.golang.org/genproto/googleapis/ads/googleads/v2/resources"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	status "google.golang.org/genproto/googleapis/rpc/status"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status1 "google.golang.org/grpc/status"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Request message for [RecommendationService.GetRecommendation][google.ads.googleads.v2.services.RecommendationService.GetRecommendation].
type GetRecommendationRequest struct {
	// Required. The resource name of the recommendation to fetch.
	ResourceName         string   `protobuf:"bytes,1,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetRecommendationRequest) Reset()         { *m = GetRecommendationRequest{} }
func (m *GetRecommendationRequest) String() string { return proto.CompactTextString(m) }
func (*GetRecommendationRequest) ProtoMessage()    {}
func (*GetRecommendationRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_f11a792b35286279, []int{0}
}

func (m *GetRecommendationRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetRecommendationRequest.Unmarshal(m, b)
}
func (m *GetRecommendationRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetRecommendationRequest.Marshal(b, m, deterministic)
}
func (m *GetRecommendationRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetRecommendationRequest.Merge(m, src)
}
func (m *GetRecommendationRequest) XXX_Size() int {
	return xxx_messageInfo_GetRecommendationRequest.Size(m)
}
func (m *GetRecommendationRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetRecommendationRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetRecommendationRequest proto.InternalMessageInfo

func (m *GetRecommendationRequest) GetResourceName() string {
	if m != nil {
		return m.ResourceName
	}
	return ""
}

// Request message for [RecommendationService.ApplyRecommendation][google.ads.googleads.v2.services.RecommendationService.ApplyRecommendation].
type ApplyRecommendationRequest struct {
	// Required. The ID of the customer with the recommendation.
	CustomerId string `protobuf:"bytes,1,opt,name=customer_id,json=customerId,proto3" json:"customer_id,omitempty"`
	// Required. The list of operations to apply recommendations.
	// If partial_failure=false all recommendations should be of the same type
	// There is a limit of 100 operations per request.
	Operations []*ApplyRecommendationOperation `protobuf:"bytes,2,rep,name=operations,proto3" json:"operations,omitempty"`
	// If true, successful operations will be carried out and invalid
	// operations will return errors. If false, operations will be carried
	// out as a transaction if and only if they are all valid.
	// Default is false.
	PartialFailure       bool     `protobuf:"varint,3,opt,name=partial_failure,json=partialFailure,proto3" json:"partial_failure,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ApplyRecommendationRequest) Reset()         { *m = ApplyRecommendationRequest{} }
func (m *ApplyRecommendationRequest) String() string { return proto.CompactTextString(m) }
func (*ApplyRecommendationRequest) ProtoMessage()    {}
func (*ApplyRecommendationRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_f11a792b35286279, []int{1}
}

func (m *ApplyRecommendationRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ApplyRecommendationRequest.Unmarshal(m, b)
}
func (m *ApplyRecommendationRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ApplyRecommendationRequest.Marshal(b, m, deterministic)
}
func (m *ApplyRecommendationRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ApplyRecommendationRequest.Merge(m, src)
}
func (m *ApplyRecommendationRequest) XXX_Size() int {
	return xxx_messageInfo_ApplyRecommendationRequest.Size(m)
}
func (m *ApplyRecommendationRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ApplyRecommendationRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ApplyRecommendationRequest proto.InternalMessageInfo

func (m *ApplyRecommendationRequest) GetCustomerId() string {
	if m != nil {
		return m.CustomerId
	}
	return ""
}

func (m *ApplyRecommendationRequest) GetOperations() []*ApplyRecommendationOperation {
	if m != nil {
		return m.Operations
	}
	return nil
}

func (m *ApplyRecommendationRequest) GetPartialFailure() bool {
	if m != nil {
		return m.PartialFailure
	}
	return false
}

// Information about the operation to apply a recommendation and any parameters
// to customize it.
type ApplyRecommendationOperation struct {
	// The resource name of the recommendation to apply.
	ResourceName string `protobuf:"bytes,1,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
	// Parameters to use when applying the recommendation.
	//
	// Types that are valid to be assigned to ApplyParameters:
	//	*ApplyRecommendationOperation_CampaignBudget
	//	*ApplyRecommendationOperation_TextAd
	//	*ApplyRecommendationOperation_Keyword
	//	*ApplyRecommendationOperation_TargetCpaOptIn
	//	*ApplyRecommendationOperation_CalloutExtension
	//	*ApplyRecommendationOperation_CallExtension
	//	*ApplyRecommendationOperation_SitelinkExtension
	//	*ApplyRecommendationOperation_MoveUnusedBudget
	ApplyParameters      isApplyRecommendationOperation_ApplyParameters `protobuf_oneof:"apply_parameters"`
	XXX_NoUnkeyedLiteral struct{}                                       `json:"-"`
	XXX_unrecognized     []byte                                         `json:"-"`
	XXX_sizecache        int32                                          `json:"-"`
}

func (m *ApplyRecommendationOperation) Reset()         { *m = ApplyRecommendationOperation{} }
func (m *ApplyRecommendationOperation) String() string { return proto.CompactTextString(m) }
func (*ApplyRecommendationOperation) ProtoMessage()    {}
func (*ApplyRecommendationOperation) Descriptor() ([]byte, []int) {
	return fileDescriptor_f11a792b35286279, []int{2}
}

func (m *ApplyRecommendationOperation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ApplyRecommendationOperation.Unmarshal(m, b)
}
func (m *ApplyRecommendationOperation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ApplyRecommendationOperation.Marshal(b, m, deterministic)
}
func (m *ApplyRecommendationOperation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ApplyRecommendationOperation.Merge(m, src)
}
func (m *ApplyRecommendationOperation) XXX_Size() int {
	return xxx_messageInfo_ApplyRecommendationOperation.Size(m)
}
func (m *ApplyRecommendationOperation) XXX_DiscardUnknown() {
	xxx_messageInfo_ApplyRecommendationOperation.DiscardUnknown(m)
}

var xxx_messageInfo_ApplyRecommendationOperation proto.InternalMessageInfo

func (m *ApplyRecommendationOperation) GetResourceName() string {
	if m != nil {
		return m.ResourceName
	}
	return ""
}

type isApplyRecommendationOperation_ApplyParameters interface {
	isApplyRecommendationOperation_ApplyParameters()
}

type ApplyRecommendationOperation_CampaignBudget struct {
	CampaignBudget *ApplyRecommendationOperation_CampaignBudgetParameters `protobuf:"bytes,2,opt,name=campaign_budget,json=campaignBudget,proto3,oneof"`
}

type ApplyRecommendationOperation_TextAd struct {
	TextAd *ApplyRecommendationOperation_TextAdParameters `protobuf:"bytes,3,opt,name=text_ad,json=textAd,proto3,oneof"`
}

type ApplyRecommendationOperation_Keyword struct {
	Keyword *ApplyRecommendationOperation_KeywordParameters `protobuf:"bytes,4,opt,name=keyword,proto3,oneof"`
}

type ApplyRecommendationOperation_TargetCpaOptIn struct {
	TargetCpaOptIn *ApplyRecommendationOperation_TargetCpaOptInParameters `protobuf:"bytes,5,opt,name=target_cpa_opt_in,json=targetCpaOptIn,proto3,oneof"`
}

type ApplyRecommendationOperation_CalloutExtension struct {
	CalloutExtension *ApplyRecommendationOperation_CalloutExtensionParameters `protobuf:"bytes,6,opt,name=callout_extension,json=calloutExtension,proto3,oneof"`
}

type ApplyRecommendationOperation_CallExtension struct {
	CallExtension *ApplyRecommendationOperation_CallExtensionParameters `protobuf:"bytes,7,opt,name=call_extension,json=callExtension,proto3,oneof"`
}

type ApplyRecommendationOperation_SitelinkExtension struct {
	SitelinkExtension *ApplyRecommendationOperation_SitelinkExtensionParameters `protobuf:"bytes,8,opt,name=sitelink_extension,json=sitelinkExtension,proto3,oneof"`
}

type ApplyRecommendationOperation_MoveUnusedBudget struct {
	MoveUnusedBudget *ApplyRecommendationOperation_MoveUnusedBudgetParameters `protobuf:"bytes,9,opt,name=move_unused_budget,json=moveUnusedBudget,proto3,oneof"`
}

func (*ApplyRecommendationOperation_CampaignBudget) isApplyRecommendationOperation_ApplyParameters() {}

func (*ApplyRecommendationOperation_TextAd) isApplyRecommendationOperation_ApplyParameters() {}

func (*ApplyRecommendationOperation_Keyword) isApplyRecommendationOperation_ApplyParameters() {}

func (*ApplyRecommendationOperation_TargetCpaOptIn) isApplyRecommendationOperation_ApplyParameters() {}

func (*ApplyRecommendationOperation_CalloutExtension) isApplyRecommendationOperation_ApplyParameters() {
}

func (*ApplyRecommendationOperation_CallExtension) isApplyRecommendationOperation_ApplyParameters() {}

func (*ApplyRecommendationOperation_SitelinkExtension) isApplyRecommendationOperation_ApplyParameters() {
}

func (*ApplyRecommendationOperation_MoveUnusedBudget) isApplyRecommendationOperation_ApplyParameters() {
}

func (m *ApplyRecommendationOperation) GetApplyParameters() isApplyRecommendationOperation_ApplyParameters {
	if m != nil {
		return m.ApplyParameters
	}
	return nil
}

func (m *ApplyRecommendationOperation) GetCampaignBudget() *ApplyRecommendationOperation_CampaignBudgetParameters {
	if x, ok := m.GetApplyParameters().(*ApplyRecommendationOperation_CampaignBudget); ok {
		return x.CampaignBudget
	}
	return nil
}

func (m *ApplyRecommendationOperation) GetTextAd() *ApplyRecommendationOperation_TextAdParameters {
	if x, ok := m.GetApplyParameters().(*ApplyRecommendationOperation_TextAd); ok {
		return x.TextAd
	}
	return nil
}

func (m *ApplyRecommendationOperation) GetKeyword() *ApplyRecommendationOperation_KeywordParameters {
	if x, ok := m.GetApplyParameters().(*ApplyRecommendationOperation_Keyword); ok {
		return x.Keyword
	}
	return nil
}

func (m *ApplyRecommendationOperation) GetTargetCpaOptIn() *ApplyRecommendationOperation_TargetCpaOptInParameters {
	if x, ok := m.GetApplyParameters().(*ApplyRecommendationOperation_TargetCpaOptIn); ok {
		return x.TargetCpaOptIn
	}
	return nil
}

func (m *ApplyRecommendationOperation) GetCalloutExtension() *ApplyRecommendationOperation_CalloutExtensionParameters {
	if x, ok := m.GetApplyParameters().(*ApplyRecommendationOperation_CalloutExtension); ok {
		return x.CalloutExtension
	}
	return nil
}

func (m *ApplyRecommendationOperation) GetCallExtension() *ApplyRecommendationOperation_CallExtensionParameters {
	if x, ok := m.GetApplyParameters().(*ApplyRecommendationOperation_CallExtension); ok {
		return x.CallExtension
	}
	return nil
}

func (m *ApplyRecommendationOperation) GetSitelinkExtension() *ApplyRecommendationOperation_SitelinkExtensionParameters {
	if x, ok := m.GetApplyParameters().(*ApplyRecommendationOperation_SitelinkExtension); ok {
		return x.SitelinkExtension
	}
	return nil
}

func (m *ApplyRecommendationOperation) GetMoveUnusedBudget() *ApplyRecommendationOperation_MoveUnusedBudgetParameters {
	if x, ok := m.GetApplyParameters().(*ApplyRecommendationOperation_MoveUnusedBudget); ok {
		return x.MoveUnusedBudget
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*ApplyRecommendationOperation) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*ApplyRecommendationOperation_CampaignBudget)(nil),
		(*ApplyRecommendationOperation_TextAd)(nil),
		(*ApplyRecommendationOperation_Keyword)(nil),
		(*ApplyRecommendationOperation_TargetCpaOptIn)(nil),
		(*ApplyRecommendationOperation_CalloutExtension)(nil),
		(*ApplyRecommendationOperation_CallExtension)(nil),
		(*ApplyRecommendationOperation_SitelinkExtension)(nil),
		(*ApplyRecommendationOperation_MoveUnusedBudget)(nil),
	}
}

// Parameters to use when applying a campaign budget recommendation.
type ApplyRecommendationOperation_CampaignBudgetParameters struct {
	// New budget amount to set for target budget resource. This is a required
	// field.
	NewBudgetAmountMicros *wrappers.Int64Value `protobuf:"bytes,1,opt,name=new_budget_amount_micros,json=newBudgetAmountMicros,proto3" json:"new_budget_amount_micros,omitempty"`
	XXX_NoUnkeyedLiteral  struct{}             `json:"-"`
	XXX_unrecognized      []byte               `json:"-"`
	XXX_sizecache         int32                `json:"-"`
}

func (m *ApplyRecommendationOperation_CampaignBudgetParameters) Reset() {
	*m = ApplyRecommendationOperation_CampaignBudgetParameters{}
}
func (m *ApplyRecommendationOperation_CampaignBudgetParameters) String() string {
	return proto.CompactTextString(m)
}
func (*ApplyRecommendationOperation_CampaignBudgetParameters) ProtoMessage() {}
func (*ApplyRecommendationOperation_CampaignBudgetParameters) Descriptor() ([]byte, []int) {
	return fileDescriptor_f11a792b35286279, []int{2, 0}
}

func (m *ApplyRecommendationOperation_CampaignBudgetParameters) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ApplyRecommendationOperation_CampaignBudgetParameters.Unmarshal(m, b)
}
func (m *ApplyRecommendationOperation_CampaignBudgetParameters) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ApplyRecommendationOperation_CampaignBudgetParameters.Marshal(b, m, deterministic)
}
func (m *ApplyRecommendationOperation_CampaignBudgetParameters) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ApplyRecommendationOperation_CampaignBudgetParameters.Merge(m, src)
}
func (m *ApplyRecommendationOperation_CampaignBudgetParameters) XXX_Size() int {
	return xxx_messageInfo_ApplyRecommendationOperation_CampaignBudgetParameters.Size(m)
}
func (m *ApplyRecommendationOperation_CampaignBudgetParameters) XXX_DiscardUnknown() {
	xxx_messageInfo_ApplyRecommendationOperation_CampaignBudgetParameters.DiscardUnknown(m)
}

var xxx_messageInfo_ApplyRecommendationOperation_CampaignBudgetParameters proto.InternalMessageInfo

func (m *ApplyRecommendationOperation_CampaignBudgetParameters) GetNewBudgetAmountMicros() *wrappers.Int64Value {
	if m != nil {
		return m.NewBudgetAmountMicros
	}
	return nil
}

// Parameters to use when applying a text ad recommendation.
type ApplyRecommendationOperation_TextAdParameters struct {
	// New ad to add to recommended ad group. All necessary fields need to be
	// set in this message. This is a required field.
	Ad                   *resources.Ad `protobuf:"bytes,1,opt,name=ad,proto3" json:"ad,omitempty"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *ApplyRecommendationOperation_TextAdParameters) Reset() {
	*m = ApplyRecommendationOperation_TextAdParameters{}
}
func (m *ApplyRecommendationOperation_TextAdParameters) String() string {
	return proto.CompactTextString(m)
}
func (*ApplyRecommendationOperation_TextAdParameters) ProtoMessage() {}
func (*ApplyRecommendationOperation_TextAdParameters) Descriptor() ([]byte, []int) {
	return fileDescriptor_f11a792b35286279, []int{2, 1}
}

func (m *ApplyRecommendationOperation_TextAdParameters) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ApplyRecommendationOperation_TextAdParameters.Unmarshal(m, b)
}
func (m *ApplyRecommendationOperation_TextAdParameters) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ApplyRecommendationOperation_TextAdParameters.Marshal(b, m, deterministic)
}
func (m *ApplyRecommendationOperation_TextAdParameters) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ApplyRecommendationOperation_TextAdParameters.Merge(m, src)
}
func (m *ApplyRecommendationOperation_TextAdParameters) XXX_Size() int {
	return xxx_messageInfo_ApplyRecommendationOperation_TextAdParameters.Size(m)
}
func (m *ApplyRecommendationOperation_TextAdParameters) XXX_DiscardUnknown() {
	xxx_messageInfo_ApplyRecommendationOperation_TextAdParameters.DiscardUnknown(m)
}

var xxx_messageInfo_ApplyRecommendationOperation_TextAdParameters proto.InternalMessageInfo

func (m *ApplyRecommendationOperation_TextAdParameters) GetAd() *resources.Ad {
	if m != nil {
		return m.Ad
	}
	return nil
}

// Parameters to use when applying keyword recommendation.
type ApplyRecommendationOperation_KeywordParameters struct {
	// The ad group resource to add keyword to. This is a required field.
	AdGroup *wrappers.StringValue `protobuf:"bytes,1,opt,name=ad_group,json=adGroup,proto3" json:"ad_group,omitempty"`
	// The match type of the keyword. This is a required field.
	MatchType enums.KeywordMatchTypeEnum_KeywordMatchType `protobuf:"varint,2,opt,name=match_type,json=matchType,proto3,enum=google.ads.googleads.v2.enums.KeywordMatchTypeEnum_KeywordMatchType" json:"match_type,omitempty"`
	// Optional, CPC bid to set for the keyword. If not set, keyword will use
	// bid based on bidding strategy used by target ad group.
	CpcBidMicros         *wrappers.Int64Value `protobuf:"bytes,3,opt,name=cpc_bid_micros,json=cpcBidMicros,proto3" json:"cpc_bid_micros,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *ApplyRecommendationOperation_KeywordParameters) Reset() {
	*m = ApplyRecommendationOperation_KeywordParameters{}
}
func (m *ApplyRecommendationOperation_KeywordParameters) String() string {
	return proto.CompactTextString(m)
}
func (*ApplyRecommendationOperation_KeywordParameters) ProtoMessage() {}
func (*ApplyRecommendationOperation_KeywordParameters) Descriptor() ([]byte, []int) {
	return fileDescriptor_f11a792b35286279, []int{2, 2}
}

func (m *ApplyRecommendationOperation_KeywordParameters) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ApplyRecommendationOperation_KeywordParameters.Unmarshal(m, b)
}
func (m *ApplyRecommendationOperation_KeywordParameters) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ApplyRecommendationOperation_KeywordParameters.Marshal(b, m, deterministic)
}
func (m *ApplyRecommendationOperation_KeywordParameters) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ApplyRecommendationOperation_KeywordParameters.Merge(m, src)
}
func (m *ApplyRecommendationOperation_KeywordParameters) XXX_Size() int {
	return xxx_messageInfo_ApplyRecommendationOperation_KeywordParameters.Size(m)
}
func (m *ApplyRecommendationOperation_KeywordParameters) XXX_DiscardUnknown() {
	xxx_messageInfo_ApplyRecommendationOperation_KeywordParameters.DiscardUnknown(m)
}

var xxx_messageInfo_ApplyRecommendationOperation_KeywordParameters proto.InternalMessageInfo

func (m *ApplyRecommendationOperation_KeywordParameters) GetAdGroup() *wrappers.StringValue {
	if m != nil {
		return m.AdGroup
	}
	return nil
}

func (m *ApplyRecommendationOperation_KeywordParameters) GetMatchType() enums.KeywordMatchTypeEnum_KeywordMatchType {
	if m != nil {
		return m.MatchType
	}
	return enums.KeywordMatchTypeEnum_UNSPECIFIED
}

func (m *ApplyRecommendationOperation_KeywordParameters) GetCpcBidMicros() *wrappers.Int64Value {
	if m != nil {
		return m.CpcBidMicros
	}
	return nil
}

// Parameters to use when applying Target CPA recommendation.
type ApplyRecommendationOperation_TargetCpaOptInParameters struct {
	// Average CPA to use for Target CPA bidding strategy. This is a required
	// field.
	TargetCpaMicros *wrappers.Int64Value `protobuf:"bytes,1,opt,name=target_cpa_micros,json=targetCpaMicros,proto3" json:"target_cpa_micros,omitempty"`
	// Optional, budget amount to set for the campaign.
	NewCampaignBudgetAmountMicros *wrappers.Int64Value `protobuf:"bytes,2,opt,name=new_campaign_budget_amount_micros,json=newCampaignBudgetAmountMicros,proto3" json:"new_campaign_budget_amount_micros,omitempty"`
	XXX_NoUnkeyedLiteral          struct{}             `json:"-"`
	XXX_unrecognized              []byte               `json:"-"`
	XXX_sizecache                 int32                `json:"-"`
}

func (m *ApplyRecommendationOperation_TargetCpaOptInParameters) Reset() {
	*m = ApplyRecommendationOperation_TargetCpaOptInParameters{}
}
func (m *ApplyRecommendationOperation_TargetCpaOptInParameters) String() string {
	return proto.CompactTextString(m)
}
func (*ApplyRecommendationOperation_TargetCpaOptInParameters) ProtoMessage() {}
func (*ApplyRecommendationOperation_TargetCpaOptInParameters) Descriptor() ([]byte, []int) {
	return fileDescriptor_f11a792b35286279, []int{2, 3}
}

func (m *ApplyRecommendationOperation_TargetCpaOptInParameters) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ApplyRecommendationOperation_TargetCpaOptInParameters.Unmarshal(m, b)
}
func (m *ApplyRecommendationOperation_TargetCpaOptInParameters) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ApplyRecommendationOperation_TargetCpaOptInParameters.Marshal(b, m, deterministic)
}
func (m *ApplyRecommendationOperation_TargetCpaOptInParameters) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ApplyRecommendationOperation_TargetCpaOptInParameters.Merge(m, src)
}
func (m *ApplyRecommendationOperation_TargetCpaOptInParameters) XXX_Size() int {
	return xxx_messageInfo_ApplyRecommendationOperation_TargetCpaOptInParameters.Size(m)
}
func (m *ApplyRecommendationOperation_TargetCpaOptInParameters) XXX_DiscardUnknown() {
	xxx_messageInfo_ApplyRecommendationOperation_TargetCpaOptInParameters.DiscardUnknown(m)
}

var xxx_messageInfo_ApplyRecommendationOperation_TargetCpaOptInParameters proto.InternalMessageInfo

func (m *ApplyRecommendationOperation_TargetCpaOptInParameters) GetTargetCpaMicros() *wrappers.Int64Value {
	if m != nil {
		return m.TargetCpaMicros
	}
	return nil
}

func (m *ApplyRecommendationOperation_TargetCpaOptInParameters) GetNewCampaignBudgetAmountMicros() *wrappers.Int64Value {
	if m != nil {
		return m.NewCampaignBudgetAmountMicros
	}
	return nil
}

// Parameters to use when applying callout extension recommendation.
type ApplyRecommendationOperation_CalloutExtensionParameters struct {
	// Callout extensions to be added. This is a required field.
	CalloutExtensions    []*common.CalloutFeedItem `protobuf:"bytes,1,rep,name=callout_extensions,json=calloutExtensions,proto3" json:"callout_extensions,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                  `json:"-"`
	XXX_unrecognized     []byte                    `json:"-"`
	XXX_sizecache        int32                     `json:"-"`
}

func (m *ApplyRecommendationOperation_CalloutExtensionParameters) Reset() {
	*m = ApplyRecommendationOperation_CalloutExtensionParameters{}
}
func (m *ApplyRecommendationOperation_CalloutExtensionParameters) String() string {
	return proto.CompactTextString(m)
}
func (*ApplyRecommendationOperation_CalloutExtensionParameters) ProtoMessage() {}
func (*ApplyRecommendationOperation_CalloutExtensionParameters) Descriptor() ([]byte, []int) {
	return fileDescriptor_f11a792b35286279, []int{2, 4}
}

func (m *ApplyRecommendationOperation_CalloutExtensionParameters) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ApplyRecommendationOperation_CalloutExtensionParameters.Unmarshal(m, b)
}
func (m *ApplyRecommendationOperation_CalloutExtensionParameters) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ApplyRecommendationOperation_CalloutExtensionParameters.Marshal(b, m, deterministic)
}
func (m *ApplyRecommendationOperation_CalloutExtensionParameters) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ApplyRecommendationOperation_CalloutExtensionParameters.Merge(m, src)
}
func (m *ApplyRecommendationOperation_CalloutExtensionParameters) XXX_Size() int {
	return xxx_messageInfo_ApplyRecommendationOperation_CalloutExtensionParameters.Size(m)
}
func (m *ApplyRecommendationOperation_CalloutExtensionParameters) XXX_DiscardUnknown() {
	xxx_messageInfo_ApplyRecommendationOperation_CalloutExtensionParameters.DiscardUnknown(m)
}

var xxx_messageInfo_ApplyRecommendationOperation_CalloutExtensionParameters proto.InternalMessageInfo

func (m *ApplyRecommendationOperation_CalloutExtensionParameters) GetCalloutExtensions() []*common.CalloutFeedItem {
	if m != nil {
		return m.CalloutExtensions
	}
	return nil
}

// Parameters to use when applying call extension recommendation.
type ApplyRecommendationOperation_CallExtensionParameters struct {
	// Call extensions to be added. This is a required field.
	CallExtensions       []*common.CallFeedItem `protobuf:"bytes,1,rep,name=call_extensions,json=callExtensions,proto3" json:"call_extensions,omitempty"`
	XXX_NoUnkeyedLiteral struct{}               `json:"-"`
	XXX_unrecognized     []byte                 `json:"-"`
	XXX_sizecache        int32                  `json:"-"`
}

func (m *ApplyRecommendationOperation_CallExtensionParameters) Reset() {
	*m = ApplyRecommendationOperation_CallExtensionParameters{}
}
func (m *ApplyRecommendationOperation_CallExtensionParameters) String() string {
	return proto.CompactTextString(m)
}
func (*ApplyRecommendationOperation_CallExtensionParameters) ProtoMessage() {}
func (*ApplyRecommendationOperation_CallExtensionParameters) Descriptor() ([]byte, []int) {
	return fileDescriptor_f11a792b35286279, []int{2, 5}
}

func (m *ApplyRecommendationOperation_CallExtensionParameters) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ApplyRecommendationOperation_CallExtensionParameters.Unmarshal(m, b)
}
func (m *ApplyRecommendationOperation_CallExtensionParameters) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ApplyRecommendationOperation_CallExtensionParameters.Marshal(b, m, deterministic)
}
func (m *ApplyRecommendationOperation_CallExtensionParameters) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ApplyRecommendationOperation_CallExtensionParameters.Merge(m, src)
}
func (m *ApplyRecommendationOperation_CallExtensionParameters) XXX_Size() int {
	return xxx_messageInfo_ApplyRecommendationOperation_CallExtensionParameters.Size(m)
}
func (m *ApplyRecommendationOperation_CallExtensionParameters) XXX_DiscardUnknown() {
	xxx_messageInfo_ApplyRecommendationOperation_CallExtensionParameters.DiscardUnknown(m)
}

var xxx_messageInfo_ApplyRecommendationOperation_CallExtensionParameters proto.InternalMessageInfo

func (m *ApplyRecommendationOperation_CallExtensionParameters) GetCallExtensions() []*common.CallFeedItem {
	if m != nil {
		return m.CallExtensions
	}
	return nil
}

// Parameters to use when applying sitelink extension recommendation.
type ApplyRecommendationOperation_SitelinkExtensionParameters struct {
	// Sitelink extensions to be added. This is a required field.
	SitelinkExtensions   []*common.SitelinkFeedItem `protobuf:"bytes,1,rep,name=sitelink_extensions,json=sitelinkExtensions,proto3" json:"sitelink_extensions,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                   `json:"-"`
	XXX_unrecognized     []byte                     `json:"-"`
	XXX_sizecache        int32                      `json:"-"`
}

func (m *ApplyRecommendationOperation_SitelinkExtensionParameters) Reset() {
	*m = ApplyRecommendationOperation_SitelinkExtensionParameters{}
}
func (m *ApplyRecommendationOperation_SitelinkExtensionParameters) String() string {
	return proto.CompactTextString(m)
}
func (*ApplyRecommendationOperation_SitelinkExtensionParameters) ProtoMessage() {}
func (*ApplyRecommendationOperation_SitelinkExtensionParameters) Descriptor() ([]byte, []int) {
	return fileDescriptor_f11a792b35286279, []int{2, 6}
}

func (m *ApplyRecommendationOperation_SitelinkExtensionParameters) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ApplyRecommendationOperation_SitelinkExtensionParameters.Unmarshal(m, b)
}
func (m *ApplyRecommendationOperation_SitelinkExtensionParameters) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ApplyRecommendationOperation_SitelinkExtensionParameters.Marshal(b, m, deterministic)
}
func (m *ApplyRecommendationOperation_SitelinkExtensionParameters) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ApplyRecommendationOperation_SitelinkExtensionParameters.Merge(m, src)
}
func (m *ApplyRecommendationOperation_SitelinkExtensionParameters) XXX_Size() int {
	return xxx_messageInfo_ApplyRecommendationOperation_SitelinkExtensionParameters.Size(m)
}
func (m *ApplyRecommendationOperation_SitelinkExtensionParameters) XXX_DiscardUnknown() {
	xxx_messageInfo_ApplyRecommendationOperation_SitelinkExtensionParameters.DiscardUnknown(m)
}

var xxx_messageInfo_ApplyRecommendationOperation_SitelinkExtensionParameters proto.InternalMessageInfo

func (m *ApplyRecommendationOperation_SitelinkExtensionParameters) GetSitelinkExtensions() []*common.SitelinkFeedItem {
	if m != nil {
		return m.SitelinkExtensions
	}
	return nil
}

// Parameters to use when applying move unused budget recommendation.
type ApplyRecommendationOperation_MoveUnusedBudgetParameters struct {
	// Budget amount to move from excess budget to constrained budget. This is
	// a required field.
	BudgetMicrosToMove   *wrappers.Int64Value `protobuf:"bytes,1,opt,name=budget_micros_to_move,json=budgetMicrosToMove,proto3" json:"budget_micros_to_move,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *ApplyRecommendationOperation_MoveUnusedBudgetParameters) Reset() {
	*m = ApplyRecommendationOperation_MoveUnusedBudgetParameters{}
}
func (m *ApplyRecommendationOperation_MoveUnusedBudgetParameters) String() string {
	return proto.CompactTextString(m)
}
func (*ApplyRecommendationOperation_MoveUnusedBudgetParameters) ProtoMessage() {}
func (*ApplyRecommendationOperation_MoveUnusedBudgetParameters) Descriptor() ([]byte, []int) {
	return fileDescriptor_f11a792b35286279, []int{2, 7}
}

func (m *ApplyRecommendationOperation_MoveUnusedBudgetParameters) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ApplyRecommendationOperation_MoveUnusedBudgetParameters.Unmarshal(m, b)
}
func (m *ApplyRecommendationOperation_MoveUnusedBudgetParameters) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ApplyRecommendationOperation_MoveUnusedBudgetParameters.Marshal(b, m, deterministic)
}
func (m *ApplyRecommendationOperation_MoveUnusedBudgetParameters) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ApplyRecommendationOperation_MoveUnusedBudgetParameters.Merge(m, src)
}
func (m *ApplyRecommendationOperation_MoveUnusedBudgetParameters) XXX_Size() int {
	return xxx_messageInfo_ApplyRecommendationOperation_MoveUnusedBudgetParameters.Size(m)
}
func (m *ApplyRecommendationOperation_MoveUnusedBudgetParameters) XXX_DiscardUnknown() {
	xxx_messageInfo_ApplyRecommendationOperation_MoveUnusedBudgetParameters.DiscardUnknown(m)
}

var xxx_messageInfo_ApplyRecommendationOperation_MoveUnusedBudgetParameters proto.InternalMessageInfo

func (m *ApplyRecommendationOperation_MoveUnusedBudgetParameters) GetBudgetMicrosToMove() *wrappers.Int64Value {
	if m != nil {
		return m.BudgetMicrosToMove
	}
	return nil
}

// Response message for [RecommendationService.ApplyRecommendation][google.ads.googleads.v2.services.RecommendationService.ApplyRecommendation].
type ApplyRecommendationResponse struct {
	// Results of operations to apply recommendations.
	Results []*ApplyRecommendationResult `protobuf:"bytes,1,rep,name=results,proto3" json:"results,omitempty"`
	// Errors that pertain to operation failures in the partial failure mode.
	// Returned only when partial_failure = true and all errors occur inside the
	// operations. If any errors occur outside the operations (e.g. auth errors)
	// we return the RPC level error.
	PartialFailureError  *status.Status `protobuf:"bytes,2,opt,name=partial_failure_error,json=partialFailureError,proto3" json:"partial_failure_error,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *ApplyRecommendationResponse) Reset()         { *m = ApplyRecommendationResponse{} }
func (m *ApplyRecommendationResponse) String() string { return proto.CompactTextString(m) }
func (*ApplyRecommendationResponse) ProtoMessage()    {}
func (*ApplyRecommendationResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_f11a792b35286279, []int{3}
}

func (m *ApplyRecommendationResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ApplyRecommendationResponse.Unmarshal(m, b)
}
func (m *ApplyRecommendationResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ApplyRecommendationResponse.Marshal(b, m, deterministic)
}
func (m *ApplyRecommendationResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ApplyRecommendationResponse.Merge(m, src)
}
func (m *ApplyRecommendationResponse) XXX_Size() int {
	return xxx_messageInfo_ApplyRecommendationResponse.Size(m)
}
func (m *ApplyRecommendationResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ApplyRecommendationResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ApplyRecommendationResponse proto.InternalMessageInfo

func (m *ApplyRecommendationResponse) GetResults() []*ApplyRecommendationResult {
	if m != nil {
		return m.Results
	}
	return nil
}

func (m *ApplyRecommendationResponse) GetPartialFailureError() *status.Status {
	if m != nil {
		return m.PartialFailureError
	}
	return nil
}

// The result of applying a recommendation.
type ApplyRecommendationResult struct {
	// Returned for successful applies.
	ResourceName         string   `protobuf:"bytes,1,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ApplyRecommendationResult) Reset()         { *m = ApplyRecommendationResult{} }
func (m *ApplyRecommendationResult) String() string { return proto.CompactTextString(m) }
func (*ApplyRecommendationResult) ProtoMessage()    {}
func (*ApplyRecommendationResult) Descriptor() ([]byte, []int) {
	return fileDescriptor_f11a792b35286279, []int{4}
}

func (m *ApplyRecommendationResult) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ApplyRecommendationResult.Unmarshal(m, b)
}
func (m *ApplyRecommendationResult) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ApplyRecommendationResult.Marshal(b, m, deterministic)
}
func (m *ApplyRecommendationResult) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ApplyRecommendationResult.Merge(m, src)
}
func (m *ApplyRecommendationResult) XXX_Size() int {
	return xxx_messageInfo_ApplyRecommendationResult.Size(m)
}
func (m *ApplyRecommendationResult) XXX_DiscardUnknown() {
	xxx_messageInfo_ApplyRecommendationResult.DiscardUnknown(m)
}

var xxx_messageInfo_ApplyRecommendationResult proto.InternalMessageInfo

func (m *ApplyRecommendationResult) GetResourceName() string {
	if m != nil {
		return m.ResourceName
	}
	return ""
}

// Request message for [RecommendationService.DismissRecommendation][google.ads.googleads.v2.services.RecommendationService.DismissRecommendation].
type DismissRecommendationRequest struct {
	// Required. The ID of the customer with the recommendation.
	CustomerId string `protobuf:"bytes,1,opt,name=customer_id,json=customerId,proto3" json:"customer_id,omitempty"`
	// Required. The list of operations to dismiss recommendations.
	// If partial_failure=false all recommendations should be of the same type
	// There is a limit of 100 operations per request.
	Operations []*DismissRecommendationRequest_DismissRecommendationOperation `protobuf:"bytes,3,rep,name=operations,proto3" json:"operations,omitempty"`
	// If true, successful operations will be carried out and invalid
	// operations will return errors. If false, operations will be carried in a
	// single transaction if and only if they are all valid.
	// Default is false.
	PartialFailure       bool     `protobuf:"varint,2,opt,name=partial_failure,json=partialFailure,proto3" json:"partial_failure,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DismissRecommendationRequest) Reset()         { *m = DismissRecommendationRequest{} }
func (m *DismissRecommendationRequest) String() string { return proto.CompactTextString(m) }
func (*DismissRecommendationRequest) ProtoMessage()    {}
func (*DismissRecommendationRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_f11a792b35286279, []int{5}
}

func (m *DismissRecommendationRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DismissRecommendationRequest.Unmarshal(m, b)
}
func (m *DismissRecommendationRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DismissRecommendationRequest.Marshal(b, m, deterministic)
}
func (m *DismissRecommendationRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DismissRecommendationRequest.Merge(m, src)
}
func (m *DismissRecommendationRequest) XXX_Size() int {
	return xxx_messageInfo_DismissRecommendationRequest.Size(m)
}
func (m *DismissRecommendationRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DismissRecommendationRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DismissRecommendationRequest proto.InternalMessageInfo

func (m *DismissRecommendationRequest) GetCustomerId() string {
	if m != nil {
		return m.CustomerId
	}
	return ""
}

func (m *DismissRecommendationRequest) GetOperations() []*DismissRecommendationRequest_DismissRecommendationOperation {
	if m != nil {
		return m.Operations
	}
	return nil
}

func (m *DismissRecommendationRequest) GetPartialFailure() bool {
	if m != nil {
		return m.PartialFailure
	}
	return false
}

// Operation to dismiss a single recommendation identified by resource_name.
type DismissRecommendationRequest_DismissRecommendationOperation struct {
	// The resource name of the recommendation to dismiss.
	ResourceName         string   `protobuf:"bytes,1,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DismissRecommendationRequest_DismissRecommendationOperation) Reset() {
	*m = DismissRecommendationRequest_DismissRecommendationOperation{}
}
func (m *DismissRecommendationRequest_DismissRecommendationOperation) String() string {
	return proto.CompactTextString(m)
}
func (*DismissRecommendationRequest_DismissRecommendationOperation) ProtoMessage() {}
func (*DismissRecommendationRequest_DismissRecommendationOperation) Descriptor() ([]byte, []int) {
	return fileDescriptor_f11a792b35286279, []int{5, 0}
}

func (m *DismissRecommendationRequest_DismissRecommendationOperation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DismissRecommendationRequest_DismissRecommendationOperation.Unmarshal(m, b)
}
func (m *DismissRecommendationRequest_DismissRecommendationOperation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DismissRecommendationRequest_DismissRecommendationOperation.Marshal(b, m, deterministic)
}
func (m *DismissRecommendationRequest_DismissRecommendationOperation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DismissRecommendationRequest_DismissRecommendationOperation.Merge(m, src)
}
func (m *DismissRecommendationRequest_DismissRecommendationOperation) XXX_Size() int {
	return xxx_messageInfo_DismissRecommendationRequest_DismissRecommendationOperation.Size(m)
}
func (m *DismissRecommendationRequest_DismissRecommendationOperation) XXX_DiscardUnknown() {
	xxx_messageInfo_DismissRecommendationRequest_DismissRecommendationOperation.DiscardUnknown(m)
}

var xxx_messageInfo_DismissRecommendationRequest_DismissRecommendationOperation proto.InternalMessageInfo

func (m *DismissRecommendationRequest_DismissRecommendationOperation) GetResourceName() string {
	if m != nil {
		return m.ResourceName
	}
	return ""
}

// Response message for [RecommendationService.DismissRecommendation][google.ads.googleads.v2.services.RecommendationService.DismissRecommendation].
type DismissRecommendationResponse struct {
	// Results of operations to dismiss recommendations.
	Results []*DismissRecommendationResponse_DismissRecommendationResult `protobuf:"bytes,1,rep,name=results,proto3" json:"results,omitempty"`
	// Errors that pertain to operation failures in the partial failure mode.
	// Returned only when partial_failure = true and all errors occur inside the
	// operations. If any errors occur outside the operations (e.g. auth errors)
	// we return the RPC level error.
	PartialFailureError  *status.Status `protobuf:"bytes,2,opt,name=partial_failure_error,json=partialFailureError,proto3" json:"partial_failure_error,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *DismissRecommendationResponse) Reset()         { *m = DismissRecommendationResponse{} }
func (m *DismissRecommendationResponse) String() string { return proto.CompactTextString(m) }
func (*DismissRecommendationResponse) ProtoMessage()    {}
func (*DismissRecommendationResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_f11a792b35286279, []int{6}
}

func (m *DismissRecommendationResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DismissRecommendationResponse.Unmarshal(m, b)
}
func (m *DismissRecommendationResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DismissRecommendationResponse.Marshal(b, m, deterministic)
}
func (m *DismissRecommendationResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DismissRecommendationResponse.Merge(m, src)
}
func (m *DismissRecommendationResponse) XXX_Size() int {
	return xxx_messageInfo_DismissRecommendationResponse.Size(m)
}
func (m *DismissRecommendationResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_DismissRecommendationResponse.DiscardUnknown(m)
}

var xxx_messageInfo_DismissRecommendationResponse proto.InternalMessageInfo

func (m *DismissRecommendationResponse) GetResults() []*DismissRecommendationResponse_DismissRecommendationResult {
	if m != nil {
		return m.Results
	}
	return nil
}

func (m *DismissRecommendationResponse) GetPartialFailureError() *status.Status {
	if m != nil {
		return m.PartialFailureError
	}
	return nil
}

// The result of dismissing a recommendation.
type DismissRecommendationResponse_DismissRecommendationResult struct {
	// Returned for successful dismissals.
	ResourceName         string   `protobuf:"bytes,1,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DismissRecommendationResponse_DismissRecommendationResult) Reset() {
	*m = DismissRecommendationResponse_DismissRecommendationResult{}
}
func (m *DismissRecommendationResponse_DismissRecommendationResult) String() string {
	return proto.CompactTextString(m)
}
func (*DismissRecommendationResponse_DismissRecommendationResult) ProtoMessage() {}
func (*DismissRecommendationResponse_DismissRecommendationResult) Descriptor() ([]byte, []int) {
	return fileDescriptor_f11a792b35286279, []int{6, 0}
}

func (m *DismissRecommendationResponse_DismissRecommendationResult) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DismissRecommendationResponse_DismissRecommendationResult.Unmarshal(m, b)
}
func (m *DismissRecommendationResponse_DismissRecommendationResult) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DismissRecommendationResponse_DismissRecommendationResult.Marshal(b, m, deterministic)
}
func (m *DismissRecommendationResponse_DismissRecommendationResult) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DismissRecommendationResponse_DismissRecommendationResult.Merge(m, src)
}
func (m *DismissRecommendationResponse_DismissRecommendationResult) XXX_Size() int {
	return xxx_messageInfo_DismissRecommendationResponse_DismissRecommendationResult.Size(m)
}
func (m *DismissRecommendationResponse_DismissRecommendationResult) XXX_DiscardUnknown() {
	xxx_messageInfo_DismissRecommendationResponse_DismissRecommendationResult.DiscardUnknown(m)
}

var xxx_messageInfo_DismissRecommendationResponse_DismissRecommendationResult proto.InternalMessageInfo

func (m *DismissRecommendationResponse_DismissRecommendationResult) GetResourceName() string {
	if m != nil {
		return m.ResourceName
	}
	return ""
}

func init() {
	proto.RegisterType((*GetRecommendationRequest)(nil), "google.ads.googleads.v2.services.GetRecommendationRequest")
	proto.RegisterType((*ApplyRecommendationRequest)(nil), "google.ads.googleads.v2.services.ApplyRecommendationRequest")
	proto.RegisterType((*ApplyRecommendationOperation)(nil), "google.ads.googleads.v2.services.ApplyRecommendationOperation")
	proto.RegisterType((*ApplyRecommendationOperation_CampaignBudgetParameters)(nil), "google.ads.googleads.v2.services.ApplyRecommendationOperation.CampaignBudgetParameters")
	proto.RegisterType((*ApplyRecommendationOperation_TextAdParameters)(nil), "google.ads.googleads.v2.services.ApplyRecommendationOperation.TextAdParameters")
	proto.RegisterType((*ApplyRecommendationOperation_KeywordParameters)(nil), "google.ads.googleads.v2.services.ApplyRecommendationOperation.KeywordParameters")
	proto.RegisterType((*ApplyRecommendationOperation_TargetCpaOptInParameters)(nil), "google.ads.googleads.v2.services.ApplyRecommendationOperation.TargetCpaOptInParameters")
	proto.RegisterType((*ApplyRecommendationOperation_CalloutExtensionParameters)(nil), "google.ads.googleads.v2.services.ApplyRecommendationOperation.CalloutExtensionParameters")
	proto.RegisterType((*ApplyRecommendationOperation_CallExtensionParameters)(nil), "google.ads.googleads.v2.services.ApplyRecommendationOperation.CallExtensionParameters")
	proto.RegisterType((*ApplyRecommendationOperation_SitelinkExtensionParameters)(nil), "google.ads.googleads.v2.services.ApplyRecommendationOperation.SitelinkExtensionParameters")
	proto.RegisterType((*ApplyRecommendationOperation_MoveUnusedBudgetParameters)(nil), "google.ads.googleads.v2.services.ApplyRecommendationOperation.MoveUnusedBudgetParameters")
	proto.RegisterType((*ApplyRecommendationResponse)(nil), "google.ads.googleads.v2.services.ApplyRecommendationResponse")
	proto.RegisterType((*ApplyRecommendationResult)(nil), "google.ads.googleads.v2.services.ApplyRecommendationResult")
	proto.RegisterType((*DismissRecommendationRequest)(nil), "google.ads.googleads.v2.services.DismissRecommendationRequest")
	proto.RegisterType((*DismissRecommendationRequest_DismissRecommendationOperation)(nil), "google.ads.googleads.v2.services.DismissRecommendationRequest.DismissRecommendationOperation")
	proto.RegisterType((*DismissRecommendationResponse)(nil), "google.ads.googleads.v2.services.DismissRecommendationResponse")
	proto.RegisterType((*DismissRecommendationResponse_DismissRecommendationResult)(nil), "google.ads.googleads.v2.services.DismissRecommendationResponse.DismissRecommendationResult")
}

func init() {
	proto.RegisterFile("google/ads/googleads/v2/services/recommendation_service.proto", fileDescriptor_f11a792b35286279)
}

var fileDescriptor_f11a792b35286279 = []byte{
	// 1416 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xb4, 0x58, 0xd1, 0x6f, 0x14, 0x45,
	0x18, 0x77, 0xb7, 0x42, 0x61, 0x0a, 0xa5, 0x1d, 0x52, 0x39, 0xb6, 0x05, 0xeb, 0x89, 0xa1, 0x36,
	0x64, 0x57, 0x0e, 0x41, 0x73, 0x58, 0x74, 0x0f, 0x4a, 0x69, 0x0c, 0xd0, 0x5c, 0x4b, 0x09, 0x58,
	0xdd, 0x4c, 0x77, 0x87, 0x63, 0x65, 0x77, 0x67, 0x9c, 0x99, 0x6d, 0x69, 0x90, 0xa8, 0xc4, 0x07,
	0x8d, 0x8f, 0xfe, 0x07, 0x3c, 0xfa, 0x1f, 0x98, 0xf8, 0xea, 0x0b, 0x89, 0x89, 0x89, 0x6f, 0x3c,
	0xf1, 0xe0, 0x83, 0xd1, 0x47, 0x7d, 0xf2, 0xc9, 0xec, 0xec, 0xce, 0xf5, 0xf6, 0xee, 0xb6, 0x77,
	0xf4, 0xf0, 0x6d, 0x6e, 0xbe, 0xf9, 0x7e, 0xbf, 0xef, 0xfb, 0x66, 0xbe, 0xdf, 0xcc, 0x1e, 0x98,
	0x6b, 0x10, 0xd2, 0x08, 0xb0, 0x85, 0x3c, 0x6e, 0xa5, 0xc3, 0x64, 0xb4, 0x51, 0xb1, 0x38, 0x66,
	0x1b, 0xbe, 0x8b, 0xb9, 0xc5, 0xb0, 0x4b, 0xc2, 0x10, 0x47, 0x1e, 0x12, 0x3e, 0x89, 0x9c, 0x6c,
	0xde, 0xa4, 0x8c, 0x08, 0x02, 0xa7, 0x53, 0x1f, 0x13, 0x79, 0xdc, 0x6c, 0xba, 0x9b, 0x1b, 0x15,
	0x53, 0xb9, 0x1b, 0x56, 0x11, 0x41, 0x82, 0x4a, 0x22, 0x0b, 0xdf, 0x17, 0x38, 0xe2, 0x3e, 0x89,
	0x78, 0x0a, 0x69, 0x9c, 0x2b, 0x72, 0xc0, 0x51, 0x1c, 0x72, 0xeb, 0x1e, 0xde, 0xda, 0x24, 0xcc,
	0x73, 0x42, 0x24, 0xdc, 0xbb, 0x8e, 0xd8, 0xa2, 0x59, 0x28, 0xc6, 0x6c, 0x91, 0x1f, 0xc3, 0x9c,
	0xc4, 0x2c, 0x49, 0x05, 0x79, 0xbd, 0x38, 0xb6, 0xd7, 0xe6, 0xd3, 0xce, 0xfc, 0xa6, 0x94, 0x1f,
	0xf5, 0x2d, 0x14, 0x45, 0x44, 0x48, 0xa3, 0x8a, 0xfc, 0x48, 0x8b, 0xd5, 0x0d, 0x7c, 0x1c, 0x89,
	0xcc, 0xf0, 0x6a, 0x8b, 0xe1, 0x8e, 0x8f, 0x03, 0xcf, 0x59, 0xc7, 0x77, 0xd1, 0x86, 0x4f, 0x58,
	0xb6, 0xe0, 0x68, 0xcb, 0x02, 0x15, 0x42, 0x66, 0x3a, 0x9e, 0x99, 0xe4, 0xaf, 0xf5, 0xf8, 0x8e,
	0xb5, 0xc9, 0x10, 0xa5, 0x98, 0xb5, 0x93, 0x32, 0xea, 0x5a, 0x5c, 0x20, 0x11, 0x67, 0x86, 0x32,
	0x05, 0xa5, 0x05, 0x2c, 0xea, 0xb9, 0x34, 0xea, 0xf8, 0xb3, 0x18, 0x73, 0x01, 0x57, 0xc0, 0x41,
	0x45, 0xe3, 0x44, 0x28, 0xc4, 0x25, 0x6d, 0x5a, 0x9b, 0xd9, 0x5f, 0xb3, 0x9e, 0xd9, 0xfa, 0xbf,
	0xf6, 0x9b, 0xe0, 0xe4, 0xf6, 0x56, 0x66, 0x23, 0xea, 0x73, 0xd3, 0x25, 0xa1, 0xd5, 0x06, 0x77,
	0x40, 0xa1, 0x5c, 0x43, 0x21, 0x2e, 0xff, 0xaa, 0x01, 0xc3, 0xa6, 0x34, 0xd8, 0xea, 0x4e, 0x7a,
	0x02, 0x8c, 0xb8, 0x31, 0x17, 0x24, 0xc4, 0xcc, 0xf1, 0xbd, 0x8c, 0x72, 0xe8, 0x99, 0xad, 0xd7,
	0x81, 0x9a, 0x5f, 0xf4, 0xa0, 0x0b, 0x00, 0xa1, 0x98, 0xa5, 0x85, 0x2d, 0xe9, 0xd3, 0x43, 0x33,
	0x23, 0x95, 0x0b, 0x66, 0xaf, 0x63, 0x66, 0x76, 0xe1, 0xbd, 0xae, 0x60, 0x32, 0x92, 0x6d, 0x58,
	0x78, 0x12, 0x1c, 0xa2, 0x88, 0x09, 0x1f, 0x05, 0xce, 0x1d, 0xe4, 0x07, 0x31, 0xc3, 0xa5, 0xa1,
	0x69, 0x6d, 0x66, 0x5f, 0x7d, 0x34, 0x9b, 0xbe, 0x9c, 0xce, 0x96, 0x7f, 0x1e, 0x07, 0x53, 0x3b,
	0x41, 0xc3, 0xd7, 0xbb, 0x56, 0x32, 0x5f, 0x18, 0xf8, 0x48, 0x03, 0x87, 0x5c, 0x14, 0x52, 0xe4,
	0x37, 0x22, 0x67, 0x3d, 0xf6, 0x1a, 0x58, 0x94, 0xf4, 0x69, 0x6d, 0x66, 0xa4, 0x72, 0x73, 0xb0,
	0xcc, 0xcc, 0x8b, 0x19, 0x6a, 0x4d, 0x82, 0x2e, 0x21, 0x86, 0x42, 0x2c, 0x30, 0xe3, 0x57, 0x5e,
	0xaa, 0x8f, 0xba, 0x39, 0x1b, 0xfc, 0x14, 0x0c, 0x0b, 0x7c, 0x5f, 0x38, 0xc8, 0x93, 0xb9, 0x8e,
	0x54, 0xae, 0x0f, 0xc8, 0xbd, 0x82, 0xef, 0x0b, 0xdb, 0xcb, 0x71, 0xee, 0x15, 0x72, 0x0e, 0x06,
	0x60, 0x38, 0xeb, 0xd3, 0xd2, 0xcb, 0x92, 0x6b, 0x69, 0x40, 0xae, 0x0f, 0x53, 0xb4, 0x1c, 0x99,
	0xa2, 0x80, 0x5f, 0x6b, 0x60, 0x5c, 0x20, 0xd6, 0xc0, 0xc2, 0x71, 0x29, 0x72, 0x08, 0x15, 0x8e,
	0x1f, 0x95, 0xf6, 0xbc, 0x90, 0x02, 0xaf, 0x48, 0xdc, 0x8b, 0x14, 0x5d, 0xa7, 0x62, 0x31, 0xca,
	0x17, 0x58, 0xe4, 0x6c, 0xf0, 0x1b, 0x0d, 0x8c, 0xbb, 0x28, 0x08, 0x48, 0x2c, 0x9c, 0xa6, 0xaa,
	0x95, 0xf6, 0xca, 0x30, 0x6e, 0x0d, 0xbc, 0xcf, 0x12, 0x77, 0x5e, 0xc1, 0xe6, 0x02, 0x19, 0x73,
	0xdb, 0xac, 0xf0, 0x0b, 0x30, 0x9a, 0xcc, 0xb5, 0x84, 0x31, 0x2c, 0xc3, 0x58, 0x7d, 0x01, 0x61,
	0x74, 0x8f, 0xe1, 0xa0, 0xdb, 0x6a, 0x82, 0xdf, 0x69, 0x00, 0x72, 0x5f, 0xe0, 0xc0, 0x8f, 0xee,
	0xb5, 0x44, 0xb1, 0x4f, 0x46, 0x71, 0x7b, 0xc0, 0x28, 0x96, 0x33, 0xe0, 0xee, 0x91, 0x8c, 0xf3,
	0x76, 0x33, 0xfc, 0x56, 0x03, 0x30, 0x24, 0x1b, 0xd8, 0x89, 0xa3, 0x98, 0x63, 0x4f, 0xb5, 0xe0,
	0xfe, 0x17, 0xb2, 0x35, 0x57, 0xc9, 0x06, 0xbe, 0x21, 0x71, 0xbb, 0x34, 0xe1, 0x58, 0xd8, 0x66,
	0x35, 0x28, 0x28, 0x15, 0x35, 0x2d, 0x5c, 0x01, 0xa5, 0x08, 0x6f, 0x66, 0xe1, 0x39, 0x28, 0x24,
	0x71, 0x24, 0x9c, 0xd0, 0x77, 0x19, 0xe1, 0x52, 0x57, 0x46, 0x2a, 0x93, 0x2a, 0x58, 0x75, 0x1d,
	0x98, 0x8b, 0x91, 0x38, 0xf7, 0xf6, 0x2a, 0x0a, 0x62, 0x5c, 0x9f, 0x88, 0xf0, 0x66, 0x8a, 0x69,
	0x4b, 0xd7, 0xab, 0xd2, 0xd3, 0x58, 0x04, 0x63, 0xed, 0xad, 0x0a, 0xcf, 0x02, 0x1d, 0x79, 0x19,
	0xe6, 0x1b, 0x85, 0x05, 0x68, 0xde, 0x86, 0xa6, 0xed, 0xd5, 0x75, 0xe4, 0x19, 0xff, 0x68, 0x60,
	0xbc, 0xa3, 0x15, 0xe1, 0x3b, 0x60, 0x1f, 0xf2, 0x9c, 0x06, 0x23, 0x31, 0xcd, 0x20, 0xa7, 0x3a,
	0xc2, 0x5c, 0x16, 0xcc, 0x8f, 0x1a, 0x69, 0x9c, 0xc3, 0xc8, 0x5b, 0x48, 0x16, 0x27, 0x5a, 0xbf,
	0x7d, 0x8d, 0x4b, 0x45, 0x1c, 0xad, 0x5c, 0x2a, 0x8c, 0x46, 0xde, 0xff, 0x4a, 0x09, 0xae, 0x26,
	0x7e, 0x2b, 0x5b, 0x14, 0xcf, 0x47, 0x71, 0xd8, 0x31, 0x59, 0xdf, 0x1f, 0xaa, 0x21, 0xb4, 0xc1,
	0xa8, 0x4b, 0x5d, 0x67, 0xdd, 0xf7, 0x54, 0x29, 0x87, 0x7a, 0x97, 0xf2, 0x80, 0x4b, 0xdd, 0x9a,
	0xef, 0x65, 0x15, 0x7c, 0xa2, 0x81, 0x52, 0x91, 0x10, 0xc0, 0x85, 0x9c, 0xf8, 0xf4, 0xbf, 0x5b,
	0x87, 0x9a, 0xf2, 0x91, 0xb2, 0x40, 0x0c, 0x5e, 0x4b, 0x76, 0xbf, 0xed, 0xa2, 0x68, 0x3b, 0x06,
	0x7a, 0x6f, 0xe0, 0x63, 0x11, 0xde, 0xcc, 0x1f, 0xb1, 0xdc, 0x71, 0xf8, 0x1c, 0x18, 0xc5, 0x6a,
	0x02, 0x3f, 0x01, 0xb0, 0x43, 0xc3, 0x92, 0x74, 0x92, 0x6b, 0xd8, 0x2a, 0xdc, 0x9a, 0xf4, 0x2d,
	0xa7, 0x54, 0xea, 0x32, 0xc6, 0xde, 0xa2, 0xc0, 0x61, 0x7d, 0xbc, 0x5d, 0x98, 0xb8, 0x41, 0xc1,
	0x91, 0x02, 0x11, 0x81, 0x37, 0x92, 0x4b, 0xb2, 0x55, 0xb4, 0x14, 0xef, 0xa9, 0x7e, 0x78, 0x9b,
	0xa4, 0xa3, 0x39, 0x25, 0xe2, 0xc6, 0x97, 0x1a, 0x98, 0xdc, 0x41, 0x31, 0x20, 0x02, 0x87, 0x3b,
	0x95, 0x4a, 0x51, 0xbf, 0xd5, 0x8b, 0x5a, 0x21, 0x37, 0xe9, 0x61, 0x87, 0xfc, 0x70, 0x23, 0x00,
	0x46, 0xb1, 0x4a, 0xc0, 0x6b, 0x60, 0x22, 0xdb, 0xea, 0x74, 0x8f, 0x1d, 0x41, 0x9c, 0x44, 0x36,
	0xfa, 0x39, 0x44, 0x30, 0xf5, 0x4c, 0xb7, 0x76, 0x85, 0x24, 0x2c, 0x35, 0x08, 0xc6, 0x50, 0x22,
	0x58, 0x0e, 0x6d, 0x72, 0x94, 0x7f, 0xd2, 0xc0, 0x64, 0xd7, 0xa7, 0x19, 0xa7, 0x24, 0xe2, 0x18,
	0xde, 0x00, 0xc3, 0x0c, 0xf3, 0x38, 0x10, 0x2a, 0xf1, 0xf3, 0xbb, 0x52, 0xc5, 0xba, 0xc4, 0xa8,
	0x2b, 0x2c, 0x78, 0x19, 0x4c, 0xb4, 0xbd, 0xb3, 0x1c, 0xcc, 0x18, 0x61, 0xd9, 0x31, 0x86, 0x8a,
	0x84, 0x51, 0xd7, 0x5c, 0x96, 0x8f, 0xd7, 0xfa, 0xe1, 0xfc, 0x0b, 0x6c, 0x3e, 0x59, 0x5e, 0xfe,
	0x00, 0x1c, 0x2d, 0x64, 0xeb, 0xeb, 0x09, 0x56, 0xfe, 0x51, 0x07, 0x53, 0x97, 0x7c, 0x1e, 0xfa,
	0x9c, 0x0f, 0xf2, 0x3a, 0x7d, 0xa4, 0xe5, 0x9e, 0xa7, 0x43, 0xb2, 0x56, 0x1f, 0xf7, 0xae, 0xd5,
	0x4e, 0xd4, 0xdd, 0x8d, 0xcf, 0xf7, 0x7a, 0xd5, 0xbb, 0xbd, 0x5e, 0x8d, 0x79, 0x70, 0x7c, 0x67,
	0xec, 0xfe, 0x6a, 0xf7, 0x58, 0x07, 0xc7, 0x0a, 0x12, 0xc8, 0x8e, 0x4f, 0xdc, 0x7e, 0x7c, 0x3e,
	0xda, 0x75, 0x49, 0x52, 0xc4, 0x42, 0xeb, 0xff, 0x71, 0xbc, 0x8c, 0x1a, 0x98, 0xdc, 0x81, 0xaf,
	0xaf, 0x22, 0x55, 0xfe, 0xd8, 0x03, 0x26, 0xf2, 0xde, 0xcb, 0x69, 0xa6, 0xf0, 0x17, 0x0d, 0x8c,
	0x77, 0x7c, 0x89, 0xc1, 0x6a, 0xef, 0x0a, 0x15, 0x7d, 0xbe, 0x19, 0xa7, 0xfb, 0xb8, 0xb1, 0xf3,
	0x9e, 0xe5, 0xc5, 0xa7, 0x76, 0x3e, 0x89, 0x47, 0xbf, 0xfd, 0xfe, 0xbd, 0x7e, 0x06, 0x9e, 0x4e,
	0xbe, 0x7a, 0x1f, 0xe4, 0x2c, 0x73, 0xea, 0xbc, 0x73, 0x6b, 0xb6, 0xed, 0x33, 0x98, 0x5b, 0xb3,
	0x0f, 0xe1, 0x5f, 0x1a, 0x38, 0xdc, 0xa5, 0x1b, 0xe1, 0x7b, 0xbb, 0x94, 0x8c, 0x34, 0xa7, 0xb9,
	0xdd, 0x0a, 0x8e, 0x3c, 0x2f, 0xe5, 0x9b, 0x4f, 0xed, 0x57, 0x5a, 0xfa, 0xf7, 0xd4, 0x76, 0xbb,
	0xc8, 0x44, 0xdf, 0x2d, 0x9f, 0x91, 0xff, 0x39, 0x34, 0x33, 0x7b, 0xd0, 0xb2, 0x78, 0x6e, 0xf6,
	0x61, 0x7b, 0x9e, 0x55, 0xa9, 0xa0, 0x55, 0x6d, 0x16, 0xfe, 0xad, 0x81, 0x89, 0xae, 0x87, 0x03,
	0x5e, 0x18, 0xac, 0xed, 0x8d, 0xf7, 0x07, 0xec, 0x91, 0xf2, 0xad, 0x9d, 0x73, 0xae, 0x96, 0xcf,
	0x3e, 0x5f, 0xce, 0x5e, 0xca, 0x56, 0xd5, 0x66, 0x8d, 0xc9, 0x27, 0x76, 0xa9, 0xe8, 0x4f, 0x80,
	0xda, 0x57, 0x3a, 0x38, 0xe1, 0x92, 0xb0, 0x67, 0xf8, 0x35, 0xa3, 0x6b, 0x43, 0x2c, 0x25, 0xf7,
	0xd8, 0x92, 0x76, 0xfb, 0x4a, 0xe6, 0xdf, 0x20, 0x01, 0x8a, 0x1a, 0x26, 0x61, 0x0d, 0xab, 0x81,
	0x23, 0x79, 0xcb, 0x59, 0xdb, 0x8c, 0xc5, 0xff, 0x4c, 0x9d, 0x57, 0x83, 0xc7, 0xfa, 0xd0, 0x82,
	0x6d, 0xff, 0xa0, 0x4f, 0x2f, 0xa4, 0x80, 0xb6, 0xc7, 0xcd, 0x74, 0x98, 0x8c, 0x56, 0x2b, 0x66,
	0x46, 0xcc, 0x9f, 0xa8, 0x25, 0x6b, 0xb6, 0xc7, 0xd7, 0x9a, 0x4b, 0xd6, 0x56, 0x2b, 0x6b, 0x6a,
	0xc9, 0x9f, 0xfa, 0x89, 0x74, 0xbe, 0x5a, 0xb5, 0x3d, 0x5e, 0xad, 0x36, 0x17, 0x55, 0xab, 0xab,
	0x95, 0x6a, 0x55, 0x2d, 0x5b, 0xdf, 0x2b, 0xe3, 0x3c, 0xf3, 0x5f, 0x00, 0x00, 0x00, 0xff, 0xff,
	0x91, 0xe7, 0xf3, 0xa0, 0x40, 0x13, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// RecommendationServiceClient is the client API for RecommendationService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type RecommendationServiceClient interface {
	// Returns the requested recommendation in full detail.
	GetRecommendation(ctx context.Context, in *GetRecommendationRequest, opts ...grpc.CallOption) (*resources.Recommendation, error)
	// Applies given recommendations with corresponding apply parameters.
	ApplyRecommendation(ctx context.Context, in *ApplyRecommendationRequest, opts ...grpc.CallOption) (*ApplyRecommendationResponse, error)
	// Dismisses given recommendations.
	DismissRecommendation(ctx context.Context, in *DismissRecommendationRequest, opts ...grpc.CallOption) (*DismissRecommendationResponse, error)
}

type recommendationServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewRecommendationServiceClient(cc grpc.ClientConnInterface) RecommendationServiceClient {
	return &recommendationServiceClient{cc}
}

func (c *recommendationServiceClient) GetRecommendation(ctx context.Context, in *GetRecommendationRequest, opts ...grpc.CallOption) (*resources.Recommendation, error) {
	out := new(resources.Recommendation)
	err := c.cc.Invoke(ctx, "/google.ads.googleads.v2.services.RecommendationService/GetRecommendation", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *recommendationServiceClient) ApplyRecommendation(ctx context.Context, in *ApplyRecommendationRequest, opts ...grpc.CallOption) (*ApplyRecommendationResponse, error) {
	out := new(ApplyRecommendationResponse)
	err := c.cc.Invoke(ctx, "/google.ads.googleads.v2.services.RecommendationService/ApplyRecommendation", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *recommendationServiceClient) DismissRecommendation(ctx context.Context, in *DismissRecommendationRequest, opts ...grpc.CallOption) (*DismissRecommendationResponse, error) {
	out := new(DismissRecommendationResponse)
	err := c.cc.Invoke(ctx, "/google.ads.googleads.v2.services.RecommendationService/DismissRecommendation", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// RecommendationServiceServer is the server API for RecommendationService service.
type RecommendationServiceServer interface {
	// Returns the requested recommendation in full detail.
	GetRecommendation(context.Context, *GetRecommendationRequest) (*resources.Recommendation, error)
	// Applies given recommendations with corresponding apply parameters.
	ApplyRecommendation(context.Context, *ApplyRecommendationRequest) (*ApplyRecommendationResponse, error)
	// Dismisses given recommendations.
	DismissRecommendation(context.Context, *DismissRecommendationRequest) (*DismissRecommendationResponse, error)
}

// UnimplementedRecommendationServiceServer can be embedded to have forward compatible implementations.
type UnimplementedRecommendationServiceServer struct {
}

func (*UnimplementedRecommendationServiceServer) GetRecommendation(ctx context.Context, req *GetRecommendationRequest) (*resources.Recommendation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method GetRecommendation not implemented")
}
func (*UnimplementedRecommendationServiceServer) ApplyRecommendation(ctx context.Context, req *ApplyRecommendationRequest) (*ApplyRecommendationResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method ApplyRecommendation not implemented")
}
func (*UnimplementedRecommendationServiceServer) DismissRecommendation(ctx context.Context, req *DismissRecommendationRequest) (*DismissRecommendationResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method DismissRecommendation not implemented")
}

func RegisterRecommendationServiceServer(s *grpc.Server, srv RecommendationServiceServer) {
	s.RegisterService(&_RecommendationService_serviceDesc, srv)
}

func _RecommendationService_GetRecommendation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetRecommendationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RecommendationServiceServer).GetRecommendation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.ads.googleads.v2.services.RecommendationService/GetRecommendation",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RecommendationServiceServer).GetRecommendation(ctx, req.(*GetRecommendationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RecommendationService_ApplyRecommendation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ApplyRecommendationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RecommendationServiceServer).ApplyRecommendation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.ads.googleads.v2.services.RecommendationService/ApplyRecommendation",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RecommendationServiceServer).ApplyRecommendation(ctx, req.(*ApplyRecommendationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RecommendationService_DismissRecommendation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DismissRecommendationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RecommendationServiceServer).DismissRecommendation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.ads.googleads.v2.services.RecommendationService/DismissRecommendation",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RecommendationServiceServer).DismissRecommendation(ctx, req.(*DismissRecommendationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _RecommendationService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.ads.googleads.v2.services.RecommendationService",
	HandlerType: (*RecommendationServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetRecommendation",
			Handler:    _RecommendationService_GetRecommendation_Handler,
		},
		{
			MethodName: "ApplyRecommendation",
			Handler:    _RecommendationService_ApplyRecommendation_Handler,
		},
		{
			MethodName: "DismissRecommendation",
			Handler:    _RecommendationService_DismissRecommendation_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/ads/googleads/v2/services/recommendation_service.proto",
}
