/* gmp-mparam.h -- Compiler/machine parameter header file.

Copyright 2019 Free Software Foundation, Inc.

This file is part of the GNU MP Library.

The GNU MP Library is free software; you can redistribute it and/or modify
it under the terms of either:

  * the GNU Lesser General Public License as published by the Free
    Software Foundation; either version 3 of the License, or (at your
    option) any later version.

or

  * the GNU General Public License as published by the Free Software
    Foundation; either version 2 of the License, or (at your option) any
    later version.

or both in parallel, as here.

The GNU MP Library is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received copies of the GNU General Public License and the
GNU Lesser General Public License along with the GNU MP Library.  If not,
see https://www.gnu.org/licenses/.  */

#define GMP_LIMB_BITS 64
#define GMP_LIMB_BYTES 8

/* 900MHz Itanium2 (olympic.gmplib.org) */
/* FFT tuning limit = 59,194,709 */
/* Generated by tuneup.c, 2019-10-13, gcc 4.2 */

#define MOD_1_1P_METHOD                      2  /* 17.40% faster than 1 */
#define MOD_1_NORM_THRESHOLD                 0  /* always */
#define MOD_1_UNNORM_THRESHOLD               0  /* always */
#define MOD_1N_TO_MOD_1_1_THRESHOLD          8
#define MOD_1U_TO_MOD_1_1_THRESHOLD          6
#define MOD_1_1_TO_MOD_1_2_THRESHOLD        18
#define MOD_1_2_TO_MOD_1_4_THRESHOLD         0  /* never mpn_mod_1s_2p */
#define PREINV_MOD_1_TO_MOD_1_THRESHOLD     13
#define USE_PREINV_DIVREM_1                  1  /* native */
#define DIV_QR_1N_PI1_METHOD                 1  /* 1.35% faster than 2 */
#define DIV_QR_1_NORM_THRESHOLD          MP_SIZE_T_MAX  /* never */
#define DIV_QR_1_UNNORM_THRESHOLD        MP_SIZE_T_MAX  /* never */
#define DIV_QR_2_PI2_THRESHOLD              10
#define DIVEXACT_1_THRESHOLD                 0  /* always (native) */
#define BMOD_1_TO_MOD_1_THRESHOLD        MP_SIZE_T_MAX  /* never */

#define DIV_1_VS_MUL_1_PERCENT             316

#define MUL_TOOM22_THRESHOLD                47
#define MUL_TOOM33_THRESHOLD                89
#define MUL_TOOM44_THRESHOLD               220
#define MUL_TOOM6H_THRESHOLD               327
#define MUL_TOOM8H_THRESHOLD               454

#define MUL_TOOM32_TO_TOOM43_THRESHOLD      97
#define MUL_TOOM32_TO_TOOM53_THRESHOLD     153
#define MUL_TOOM42_TO_TOOM53_THRESHOLD     143
#define MUL_TOOM42_TO_TOOM63_THRESHOLD     153
#define MUL_TOOM43_TO_TOOM54_THRESHOLD     226

#define SQR_BASECASE_THRESHOLD              11
#define SQR_TOOM2_THRESHOLD                 98
#define SQR_TOOM3_THRESHOLD                135
#define SQR_TOOM4_THRESHOLD                272
#define SQR_TOOM6_THRESHOLD                354
#define SQR_TOOM8_THRESHOLD                490

#define MULMID_TOOM42_THRESHOLD             99

#define MULMOD_BNM1_THRESHOLD               23
#define SQRMOD_BNM1_THRESHOLD               27

#define MUL_FFT_MODF_THRESHOLD             840  /* k = 5 */
#define MUL_FFT_TABLE3                                      \
  { {    840, 5}, {     30, 6}, {     16, 5}, {     33, 6}, \
    {     17, 5}, {     36, 6}, {     35, 7}, {     18, 6}, \
    {     37, 7}, {     19, 6}, {     42, 7}, {     37, 8}, \
    {     19, 7}, {     43, 8}, {     23, 7}, {     47, 8}, \
    {     43, 9}, {     23, 8}, {     51, 9}, {     27, 8}, \
    {     57, 9}, {     31, 8}, {     63, 9}, {     35, 8}, \
    {     71, 9}, {     43,10}, {     23, 9}, {     55,10}, \
    {     31, 9}, {     71,10}, {     39, 9}, {     83,10}, \
    {     47, 9}, {     99,10}, {     55,11}, {     31,10}, \
    {     87,11}, {     47,10}, {    111,12}, {     31,11}, \
    {     63,10}, {    135,11}, {     79,10}, {    167,11}, \
    {     95,10}, {    191,11}, {    111,12}, {     63,11}, \
    {    143,10}, {    287,11}, {    159,12}, {     95,11}, \
    {    207,13}, {     63,12}, {    127,11}, {    271,12}, \
    {    159,11}, {    335,10}, {    671,12}, {    191,10}, \
    {    799,12}, {    223,13}, {    127,12}, {    287,11}, \
    {    607,12}, {    319,11}, {    671,13}, {    191,12}, \
    {    383,11}, {    799,10}, {   1599,12}, {    415,11}, \
    {    863,14}, {    127,13}, {    255,12}, {    543,11}, \
    {   1119,12}, {    607,13}, {    319,12}, {    735,11}, \
    {   1471,12}, {    863,13}, {    447,12}, {    927,11}, \
    {   1855,12}, {    959,14}, {    255,13}, {    511,12}, \
    {   1055,11}, {   2111,12}, {   1119,13}, {    575,12}, \
    {   1247,13}, {    639,12}, {   1311,13}, {    703,12}, \
    {   1471,13}, {    831,12}, {   1727,13}, {    895,12}, \
    {   1791,13}, {    959,15}, {    255,14}, {    511,13}, \
    {   1087,12}, {   2239,13}, {   1215,14}, {    639,13}, \
    {   1471,14}, {    767,13}, {   1727,14}, {    895,13}, \
    {   1855,12}, {   3711,13}, {   1919,15}, {    511,14}, \
    {   1023,13}, {   2111,12}, {   4223,13}, {   2175,14}, \
    {   1151,13}, {   2495,14}, {   1279,13}, {   2623,14}, \
    {   1407,15}, {    767,14}, {   1663,13}, {   3455,14}, \
    {   1919,16}, {    511,15}, {   1023,14}, {   2175,13}, \
    {   4479,14}, {   2431,15}, {   1279,14}, {   2943,15}, \
    {   1535,14}, {   3455,15}, {   1791,14}, {  16384,15}, \
    {  32768,16}, {  65536,17}, { 131072,18}, { 262144,19}, \
    { 524288,20}, {1048576,21}, {2097152,22}, {4194304,23}, \
    {8388608,24} }
#define MUL_FFT_TABLE3_SIZE 149
#define MUL_FFT_THRESHOLD                 8576

#define SQR_FFT_MODF_THRESHOLD             765  /* k = 5 */
#define SQR_FFT_TABLE3                                      \
  { {    765, 5}, {     36, 6}, {     37, 7}, {     19, 6}, \
    {     42, 7}, {     43, 8}, {     37, 9}, {     19, 8}, \
    {     43, 9}, {     23, 8}, {     49, 9}, {     27, 8}, \
    {     57, 9}, {     43,10}, {     23, 9}, {     55,10}, \
    {     31, 9}, {     71,10}, {     39, 9}, {     83,10}, \
    {     47, 9}, {     99,10}, {     55,11}, {     31,10}, \
    {     87,11}, {     47,10}, {    111,12}, {     31,11}, \
    {     63,10}, {    135,11}, {     79,10}, {    175,11}, \
    {     95,10}, {    199,11}, {    111,12}, {     63,11}, \
    {    159,12}, {     95,11}, {    191,10}, {    399,11}, \
    {    207,13}, {     63,12}, {    127,10}, {    511, 9}, \
    {   1023,10}, {    527,11}, {    271,12}, {    159,10}, \
    {    703,12}, {    191,11}, {    399,10}, {    799,11}, \
    {    431,12}, {    223,13}, {    127,12}, {    255,11}, \
    {    527,10}, {   1055,11}, {    559,12}, {    287,11}, \
    {    607,10}, {   1215,11}, {    703,13}, {    191,12}, \
    {    383,11}, {    799,12}, {    415,11}, {    863,12}, \
    {    447,14}, {    127,13}, {    255,12}, {    511,11}, \
    {   1055,12}, {    543,11}, {   1119,12}, {    607,11}, \
    {   1215,12}, {    735,13}, {    383,12}, {    799,11}, \
    {   1599,12}, {    863,13}, {    447,12}, {    991,14}, \
    {    255,13}, {    511,12}, {   1055,11}, {   2111,12}, \
    {   1119,13}, {    575,12}, {   1215,13}, {    639,12}, \
    {   1311,13}, {    703,12}, {   1407,14}, {    383,13}, \
    {    767,12}, {   1599,13}, {    831,12}, {   1727,13}, \
    {    895,12}, {   1791,13}, {    959,12}, {   1919,15}, \
    {    255,14}, {    511,13}, {   1023,12}, {   2047,13}, \
    {   1087,12}, {   2239,13}, {   1151,12}, {   2303,13}, \
    {   1215,14}, {    639,13}, {   1279,12}, {   2559,13}, \
    {   1471,14}, {    767,13}, {   1727,14}, {    895,13}, \
    {   1919,15}, {    511,14}, {   1023,13}, {   2239,14}, \
    {   1151,13}, {   2495,14}, {   1279,13}, {   2623,14}, \
    {   1407,15}, {    767,14}, {   1663,13}, {   3455,14}, \
    {   1919,16}, {    511,15}, {   1023,14}, {   2175,13}, \
    {   4479,14}, {   2431,15}, {   1279,14}, {   2943,15}, \
    {   1535,14}, {   3455,15}, {   1791,14}, {  16384,15}, \
    {  32768,16}, {  65536,17}, { 131072,18}, { 262144,19}, \
    { 524288,20}, {1048576,21}, {2097152,22}, {4194304,23}, \
    {8388608,24} }
#define SQR_FFT_TABLE3_SIZE 153
#define SQR_FFT_THRESHOLD                 6272

#define MULLO_BASECASE_THRESHOLD            39
#define MULLO_DC_THRESHOLD                   0  /* never mpn_mullo_basecase */
#define MULLO_MUL_N_THRESHOLD            17050
#define SQRLO_BASECASE_THRESHOLD             0  /* always */
#define SQRLO_DC_THRESHOLD                 134
#define SQRLO_SQR_THRESHOLD              12322

#define DC_DIV_QR_THRESHOLD                 73
#define DC_DIVAPPR_Q_THRESHOLD             262
#define DC_BDIV_QR_THRESHOLD               111
#define DC_BDIV_Q_THRESHOLD                315

#define INV_MULMOD_BNM1_THRESHOLD           92
#define INV_NEWTON_THRESHOLD                15
#define INV_APPR_THRESHOLD                  17

#define BINV_NEWTON_THRESHOLD              280
#define REDC_1_TO_REDC_2_THRESHOLD           0  /* always */
#define REDC_2_TO_REDC_N_THRESHOLD         172

#define MU_DIV_QR_THRESHOLD               1470
#define MU_DIVAPPR_Q_THRESHOLD            1210
#define MUPI_DIV_QR_THRESHOLD                0  /* always */
#define MU_BDIV_QR_THRESHOLD              1566
#define MU_BDIV_Q_THRESHOLD               1787

#define POWM_SEC_TABLE  3,22,139,1867

#define GET_STR_DC_THRESHOLD                14
#define GET_STR_PRECOMPUTE_THRESHOLD        42
#define SET_STR_DC_THRESHOLD              1339
#define SET_STR_PRECOMPUTE_THRESHOLD      3934

#define FAC_DSC_THRESHOLD                  866
#define FAC_ODD_THRESHOLD                    0  /* always */

#define MATRIX22_STRASSEN_THRESHOLD         20
#define HGCD2_DIV1_METHOD                    3  /* 13.73% faster than 1 */
#define HGCD_THRESHOLD                     129
#define HGCD_APPR_THRESHOLD                202
#define HGCD_REDUCE_THRESHOLD             4455
#define GCD_DC_THRESHOLD                   658
#define GCDEXT_DC_THRESHOLD                469
#define JACOBI_BASE_METHOD                   2  /* 0.62% faster than 4 */

/* Tuneup completed successfully, took 199042 seconds */
