import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.queryparser.classic.MultiFieldQueryParser;
import org.apache.lucene.util.Version;

/**
 * Vacuous extension of the default Lucene MultiFieldQueryParser. Used
 * to test that QueryParsers can be loaded from jar files in the
 * database. Build this class with Java 6 and put the source and
 * class into java/testing/org/apache/derbyTesting/functionTests/tests/lang/myLuceneClasses.jar
 */
public  class   MyQueryParser   extends MultiFieldQueryParser
{
    public  MyQueryParser
        (
         Version version,
         String[] fieldNames,
         Analyzer analyzer
         )
    {
        super( version, fieldNames, analyzer );
    }

    public static MyQueryParser    makeMyQueryParser
        (
         Version version,
         String[] fieldNames,
         Analyzer analyzer
         )
    {
        return new MyQueryParser( version, fieldNames, analyzer );
    }

}
