# CiviCRM 5.63.0

Released July 5, 2023

- **[Synopsis](#synopsis)**
- **[Features](#features)**
- **[Bugs resolved](#bugs)**
- **[Miscellany](#misc)**
- **[Credits](#credits)**
- **[Feedback](#feedback)**

## <a name="synopsis"></a>Synopsis

| *Does this version...?*                                         |         |
|:--------------------------------------------------------------- |:-------:|
| Fix security vulnerabilities?                                   |   no    |
| **Change the database schema?**                                 | **yes** |
| **Alter the API?**                                              | **yes** |
| Require attention to configuration options?                     |   no    |
| Fix problems installing or upgrading to a previous version?     |   no    |
| **Introduce features?**                                         | **yes** |
| **Fix bugs?**                                                   | **yes** |

## <a name="features"></a>Features

### CiviCRM Core

- **Update backend footer
  ([dev/core#3920](https://lab.civicrm.org/dev/core/-/issues/3920):
  [26167](https://github.com/civicrm/civicrm-core/pull/26167) and
  [26194](https://github.com/civicrm/civicrm-core/pull/26194))**

  Updates backend civicrm footer.

- **APIv4 - Add Group.cache_expired calculated field and Group::refresh action
  ([26357](https://github.com/civicrm/civicrm-core/pull/26357))**

  Adds to APIv4 a way to check if a smart group needs refreshing, and a method
  to refresh it.

- **Authx - Add APIv4 support for creating and validating credentials
  ([26044](https://github.com/civicrm/civicrm-core/pull/26044))**

  Adds APIv4 support for creating and validating Authx credentials.

- **Api4: add calculated field `contact_count` to Group
  ([26313](https://github.com/civicrm/civicrm-core/pull/26313))**

  Adds a calculated field 'contact_countto theGroup.get()` APIv4 which provides
  the current count of 'added' group members and smart group members. Note this
  does not rebuild the group cache so smart group counts may be out of date or
  zero.

- **APIv4 - Simplify bridge joins
  ([26129](https://github.com/civicrm/civicrm-core/pull/26129))**

  Makes bridge joins more efficient in SearchKit, and the APIv4
  code easier to work with.

- **Apiv4 entity parity
  ([dev/core#2486](https://lab.civicrm.org/dev/core/-/issues/2486):
  [26300](https://github.com/civicrm/civicrm-core/pull/26300))**

  Adds `BounceType` and `BouncePattern` APIv4 entities.

- **Speed up Download Spreadsheet from SearchKit results
  ([26214](https://github.com/civicrm/civicrm-core/pull/26214))**

  Speeds up downloading of spreadsheets from searchkit.

- **SearchKit - Add display of type `entity`
  ([25871](https://github.com/civicrm/civicrm-core/pull/25871))**

  Adds a new display type "entity" which does not produce user-facing output,
  instead it writes to a SQL table which can then be queried from SearchKit,
  the API, or other SQL-based tools like Drupal Views.

- **SearchKit: Tweak order and text for select All, This Page, None
  ([26385](https://github.com/civicrm/civicrm-core/pull/26385))**

  Improves usability of SearchKit select: "all", "none" or "this page" options.

- **SearchKit - Add sticky table header style
  ([26330](https://github.com/civicrm/civicrm-core/pull/26330))**

  Adds a "sticky" header option to SearchKit.

- **Make sql function IFNULL available in APIv4 and SearchKit
  ([26304](https://github.com/civicrm/civicrm-core/pull/26304))**

  Makes the sql function IF NULL available in APIv4 and SearchKit.

- **Add NOT CONTAINS to API and SK
  ([26366](https://github.com/civicrm/civicrm-core/pull/26366))**

  Adds 'NOT CONTAINS' to APIv4 and SearchKit.

- **SearchKit - Add caret icon to dropdown menus, tweak defaults
  ([26331](https://github.com/civicrm/civicrm-core/pull/26331))**

  Adds a caret icon to dropdown menus to clarify their function, and tweaks the
  defaults to the standard used by the AdminUI extension (xs size, no text).
  Adds css rule to prevent line breaks inside the button.

- **SearchKit - Add task to refresh smart/parent group cache
  ([26393](https://github.com/civicrm/civicrm-core/pull/26393))**

  Adds a task to refresh smart/parent group cache (and fixes the success message
  to give the correct count).

- **Use select2 for template on New Email, Scheduled Reminders, SMS & PDF Letter
  ([26461](https://github.com/civicrm/civicrm-core/pull/26461))**

  Updates a few fields to use select2 instead of select.

- **Support for accessing Contribution Recur tokens when a membership or
  contribution is referenced
  ([dev/core#4123](https://lab.civicrm.org/dev/core/-/issues/4123):
  [25563](https://github.com/civicrm/civicrm-core/pull/25563))**

  Adds support for using {contribution.contribution_recur_id.x} or
  {membership.contribution_recur_id.x} tokens

- **Proposal: Create stub extensions for civicrm core + all components (Work
  Towards [dev/core#3961](https://lab.civicrm.org/dev/core/-/issues/3961):
  [26256](https://github.com/civicrm/civicrm-core/pull/26256) and
  [26036](https://github.com/civicrm/civicrm-core/pull/26036))**

  Creates stub extensions for all components and modifys psr-0 namespaces of
  component extensions to match core.

- **Add support for loading ECMAScript Modules (ESM)
  ([dev/core#4279](https://lab.civicrm.org/dev/core/-/issues/4279):
  [26309](https://github.com/civicrm/civicrm-core/pull/26309) and
  [26195](https://github.com/civicrm/civicrm-core/pull/26195))**

  Adds support for ECMAScript Modules.

- **Installer - Clarify the function and purpose of sample data
  ([26345](https://github.com/civicrm/civicrm-core/pull/26345))**

  Improves the help text for the "Load Sample Data" checkbox when Installing
  CiviCRM.

- **Add some weights to menu link items
  ([26241](https://github.com/civicrm/civicrm-core/pull/26241),
  [26280](https://github.com/civicrm/civicrm-core/pull/26280),
  [26250](https://github.com/civicrm/civicrm-core/pull/26250) and
  [26244](https://github.com/civicrm/civicrm-core/pull/26244))**

  Adds some weights to core menu items.

- **Add weight to links spec
  ([26233](https://github.com/civicrm/civicrm-core/pull/26233))**

  Makes it so extension developers can add weights to alter link order in an
  extension.

- **Add is_active to link spec
  ([26255](https://github.com/civicrm/civicrm-core/pull/26255))**

  Adds an is active setting to links.

- **Add deceased date token
  ([26234](https://github.com/civicrm/civicrm-core/pull/26234))**

  Adds a deceased date token.

- **AdminUI: updates to Custom Group & Field
  ([26329](https://github.com/civicrm/civicrm-core/pull/26329))**

  Enhances the Administer Custom Group and Field pages in the AdminUI extension.

- **AdminUI - add Scheduled Jobs page
  ([26060](https://github.com/civicrm/civicrm-core/pull/26060))**

  Adds the Scheduled Jobs settings page to AdminUI extension.

- **AdminUI: add Manage Contribution Pages
  ([24937](https://github.com/civicrm/civicrm-core/pull/24937))**

  Adds the Manage Contribution Pages to AdminUI extension

- **Alternate Manage groups in Admin UI extension
  ([26261](https://github.com/civicrm/civicrm-core/pull/26261))**

  Adds "Manage group" page to the Admin UI extension.

- **FormBuilder: add 'Copy' button
  ([26071](https://github.com/civicrm/civicrm-core/pull/26071))**

  Adds a Copy button to FormBuilder so users can create a new item with a copy
  of the previous item's values.

- **Clean up Scheduled Jobs admin page
  ([26317](https://github.com/civicrm/civicrm-core/pull/26317))**

  Improves user experience on Scheduled Jobs page.

- **Improve Past Groups table on Contact Groups tab
  ([24705](https://github.com/civicrm/civicrm-core/pull/24705))**

  Improves user experience on the Contact Groups tab.

- **😵 Disambiguate "Source" field by showing the context of the source, ie.
  Membership, Participant, Contribution, Contact etc.
  ([25987](https://github.com/civicrm/civicrm-core/pull/25987) and
  [26173](https://github.com/civicrm/civicrm-core/pull/26173))**

  Improves user experience for Source fields by clarifying which entity the
  source field is on.

- **Remove form rule for Contribution Page and Event titles preventing /
  ([26249](https://github.com/civicrm/civicrm-core/pull/26249))**

  Allows "/" in Contribution Page and Event Titles.

### CiviContribute

- **Change "Contribution Received Date" to be "Contribution date" where is
  exists and basically sort this Contribution dates mess out once and for all
  ([dev/core#1403](https://lab.civicrm.org/dev/core/-/issues/1403):
  [26145](https://github.com/civicrm/civicrm-core/pull/26145))**

  Updates the Contribution receive_date title/label from "Date Received" to
  "Contribution Date" so it's clear that the date is the contribution date. Also,
  the receive_date description /comment has been removed.

- **Show next scheduled contribution date for recurring contributions on contact
  ([dev/core#4258](https://lab.civicrm.org/dev/core/-/issues/4258):
  [26151](https://github.com/civicrm/civicrm-core/pull/26151))**

  Adds the next scheduled contribution date to the "Contributions" -> "Recurring
  Contributions" tab on the contact summary.

- **Make frontend_title consistently required and use it in all front end
  presentations
  ([dev/core#4213](https://lab.civicrm.org/dev/core/-/issues/4213):
  [26259](https://github.com/civicrm/civicrm-core/pull/26259))**

  Makes the contribution page `frontend_title` field required.

- **Add default payment method for additional payment or refund
  ([26116](https://github.com/civicrm/civicrm-core/pull/26116))**

  Sets default payment method for additional payment and refund forms based on
  original contribution payment method.

### CiviEvent

- **Move event payment to the confirmation page
  ([24781](https://github.com/civicrm/civicrm-core/pull/24781))**

  Provides the option to move the payment processor onto the "Confirm" page for
  events.

- **Make event registration cancellation email optional for back office
  cancellation ([25207](https://github.com/civicrm/civicrm-core/pull/25207))**

  Adds a "Send Confirmation Email?" checkbox on back office event registration
  cancellation form.

- **Simplify messaging for event confirm page
  ([26469](https://github.com/civicrm/civicrm-core/pull/26469))**

  Simplifies messaging on the event confirmation page.

- **Additional event tokens
  ([26216](https://github.com/civicrm/civicrm-core/pull/26216))**

  Adds tokens for location block contact information (phone, email, address).

- **Show Event Info at bottom of Registration Confirm & Fee Info above Payment
  ([26431](https://github.com/civicrm/civicrm-core/pull/26431))**

  Reorganizes the event confirmation page to show the most important information
  first.

### CiviMail

- **Allow double opt-in email (and other emails that you don't want a reply
  from) to use a user configured "mail from" address
  ([dev/core#4273](https://lab.civicrm.org/dev/core/-/issues/4273):
  [26180](https://github.com/civicrm/civicrm-core/pull/26180))**

  Allows configuration of a "mail from" email address for double opt in emails
  and other emails you do not want a reply from.

- **Order mailings for selects in search and reports by id DESC
  ([26436](https://github.com/civicrm/civicrm-core/pull/26436))**

  Orders mailing selects by id DESC so they are displayed in chronological
  order, so most recent mailings show up first, instead of by name.

- **Mailing Report: when scheduled, displays stats so that we can see recipient
  count and scheduled date
  ([26378](https://github.com/civicrm/civicrm-core/pull/26378))**

  Displays stats for scheduled mailings on the mailing report.

- **Add Mailing view and preview paths to schema
  ([26342](https://github.com/civicrm/civicrm-core/pull/26342))**

  Adds Mailing view and preview paths to schema so they can be easily accessed
  in the SearchKit UI.

### CiviMember

- **Membership Type: allow changing the relationships even if there is data
  ([26274](https://github.com/civicrm/civicrm-core/pull/26274))**

  Makes it so one can change the relationships that inherit a membership even if
  there are existing contacts inheriting the membership.

## <a name="bugs"></a>Bugs resolved

### Core CiviCRM

- **group.get API (v3- but lets fix for v4) fails to find groups of one
  group_type if group has multiple types
  ([dev/core#1321](https://lab.civicrm.org/dev/core/-/issues/1321):
  [26068](https://github.com/civicrm/civicrm-core/pull/26068))**

- **Drop-down (select-list) fields don't render if "Options per line" is set
  ([dev/core#3815](https://lab.civicrm.org/dev/core/-/issues/3815):
  [26415](https://github.com/civicrm/civicrm-core/pull/26415))**

- **Merging contacts should not overwrite empty source
  ([dev/core#3989](https://lab.civicrm.org/dev/core/-/issues/3989):
  [26376](https://github.com/civicrm/civicrm-core/pull/26376))**

- **Import "fill" doesn't respect location type for email/phone
  ([dev/core#4278](https://lab.civicrm.org/dev/core/-/issues/4278):
  [26158](https://github.com/civicrm/civicrm-core/pull/26158))**

- **`{help}` tags that don't specify the `file` parameter no longer work on
  windows ([dev/core#4281](https://lab.civicrm.org/dev/core/-/issues/4281):
  [26164](https://github.com/civicrm/civicrm-core/pull/26164) and
  [26285](https://github.com/civicrm/civicrm-core/pull/26285))**

- **Allow deletion of primary email
  ([dev/core#4284](https://lab.civicrm.org/dev/core/-/issues/4284):
  [26198](https://github.com/civicrm/civicrm-core/pull/26198))**

- **Fatal error with managed custom groups containing duplicate field names
  ([dev/core#4286](https://lab.civicrm.org/dev/core/-/issues/4286):
  [26237](https://github.com/civicrm/civicrm-core/pull/26237))**

- **PHP 8 - Undefined variable warnings from Smarty appear in email
  notifications
  ([dev/core#4287](https://lab.civicrm.org/dev/core/-/issues/4287):
  [26297](https://github.com/civicrm/civicrm-core/pull/26297) and
  [26360](https://github.com/civicrm/civicrm-core/pull/26360))**

- **Fatal errors in code that calls methods in `CRM_Dedupe_BAO_RuleGroup` in
  5.62+ ([dev/core#4302](https://lab.civicrm.org/dev/core/-/issues/4302):
  [26307](https://github.com/civicrm/civicrm-core/pull/26307))**

- **Implementing hook_civicrm_alterAngular breaks href attributes that include
  some angular expressions
  ([dev/core#4305](https://lab.civicrm.org/dev/core/-/issues/4305):
  [26286](https://github.com/civicrm/civicrm-core/pull/26286) and
  [26315](https://github.com/civicrm/civicrm-core/pull/26315))**

- **Extra `<br>` tags inserted into rich text fields
  ([dev/core#4325](https://lab.civicrm.org/dev/core/-/issues/4325):
  [26386](https://github.com/civicrm/civicrm-core/pull/26386))**

- **Searchkit: Download spreadsheet should use standard date format, not the
  format set in Date Formats
  ([dev/core#4031](https://lab.civicrm.org/dev/core/-/issues/4031):
  [26211](https://github.com/civicrm/civicrm-core/pull/26211))**

- **SearchKit - non-core legacy search tasks don't work with contributions  
  ([dev/core#4295](https://lab.civicrm.org/dev/core/-/issues/4295):
  [26235](https://github.com/civicrm/civicrm-core/pull/26235))**

- **SearchKit: Directive Filters can fail with non-privileged user
  ([dev/core#4343](https://lab.civicrm.org/dev/core/-/issues/4343):
  [26457](https://github.com/civicrm/civicrm-core/pull/26457))**

- **Center SearchKit pagination
  ([26389](https://github.com/civicrm/civicrm-core/pull/26389))**

- **In searchkit, deleting a group parents inline doesn't work.
  ([26200](https://github.com/civicrm/civicrm-core/pull/26200))**

- **SearchKit: Entities that are no longer results of the search remain selected
  ([dev/core#4274](https://lab.civicrm.org/dev/core/-/issues/4274):
  [26341](https://github.com/civicrm/civicrm-core/pull/26341))**

- **SearchKit - proper EntityRef joins
  ([26192](https://github.com/civicrm/civicrm-core/pull/26192))**

- **SearchKit: Don't show the pager unless it is needed
  ([26395](https://github.com/civicrm/civicrm-core/pull/26395))**

- **FormBuilder: don't make 'Primary' required
  ([26272](https://github.com/civicrm/civicrm-core/pull/26272))**

- **Can't edit Activity source, targets, assignees in FormBuilder
  ([dev/core#4110](https://lab.civicrm.org/dev/core/-/issues/4110):
  [25744](https://github.com/civicrm/civicrm-core/pull/25744))**

- **Afform - Ensure checkboxes and radios are validated client-side
  ([26123](https://github.com/civicrm/civicrm-core/pull/26123))**

- **APIv4 - Fix Activity contact virtual fields to work across joins
  ([26374](https://github.com/civicrm/civicrm-core/pull/26374))**

- **APIv4 - Add metadata to `Group.children` column and `GroupNesting` entity
  ([26352](https://github.com/civicrm/civicrm-core/pull/26352))**

- **APIv4 - Fix html encoding of rich-text fields
  ([26251](https://github.com/civicrm/civicrm-core/pull/26251))**

- **APIv4 Explorer - Fix trailing whitespace
  ([26340](https://github.com/civicrm/civicrm-core/pull/26340))**

- **APIv4 - Fix CONTAINS operator to work with more types of serialized fields
  ([26362](https://github.com/civicrm/civicrm-core/pull/26362))**

- **APIv4 - Clarify specProvider code
  ([26349](https://github.com/civicrm/civicrm-core/pull/26349))**

- **AdminUI - Standardize button styles/labels
  ([26394](https://github.com/civicrm/civicrm-core/pull/26394))**

- **Component-Extensions - Ensure the initial activation list matches
  ([26499](https://github.com/civicrm/civicrm-core/pull/26499))**

- **Fix receive_date error saving on Edit Participant with Record Contribution
  ([26388](https://github.com/civicrm/civicrm-core/pull/26388))**

- **Get help text title from field label if htxt title is not provided
  ([26265](https://github.com/civicrm/civicrm-core/pull/26265))**

- **Remove unneeded description text on Campaign, Pledge, Tell a Friend, etc
  ([26397](https://github.com/civicrm/civicrm-core/pull/26397))**

- **Use dot to delimit log filename for domain ID
  ([26443](https://github.com/civicrm/civicrm-core/pull/26443))**

- **Metadata - Add missing html types/labels to the schema
  ([26417](https://github.com/civicrm/civicrm-core/pull/26417))**

- **description is wrong for permission to view notes that are marked for
  author only ([26392](https://github.com/civicrm/civicrm-core/pull/26392))**

- **Use Permission=FALSE when retrieving price sets in examples
  ([26399](https://github.com/civicrm/civicrm-core/pull/26399))**

- **Fix locale leaking into tokens
  ([26179](https://github.com/civicrm/civicrm-core/pull/26179))**

- **Remove deprecation from a hook that's actually uniquely useful
  ([25628](https://github.com/civicrm/civicrm-core/pull/25628))**

- **Fix Advanced search reset button formatting
  ([26324](https://github.com/civicrm/civicrm-core/pull/26324))**

- **Pass field specs out to alter functions
  ([26387](https://github.com/civicrm/civicrm-core/pull/26387))**

- **Metadata - Tag Group.refresh_date column as deprecated
  ([26350](https://github.com/civicrm/civicrm-core/pull/26350))**

- **PCP signup form - respect profile 'Add to Group'
  ([25908](https://github.com/civicrm/civicrm-core/pull/25908))**

- **Standardise casing on ids in WorkflowMessages
  ([26281](https://github.com/civicrm/civicrm-core/pull/26281))**

- **Clean up redundant descriptions and broken help on import forms
  ([26290](https://github.com/civicrm/civicrm-core/pull/26290))**

- **Save fields button on export screen is not permissioned
  ([dev/core#2435](https://lab.civicrm.org/dev/core/-/issues/2435):
  [26262](https://github.com/civicrm/civicrm-core/pull/26262))**

- **Fix token boolean filter to work with money & use in templates
  ([26254](https://github.com/civicrm/civicrm-core/pull/26254))**

- **Remove unneeded descriptions or replace with help text from Edit
  Contribution Page & Event
  ([26257](https://github.com/civicrm/civicrm-core/pull/26257) and
  [26291](https://github.com/civicrm/civicrm-core/pull/26291))**

- **Stop escaping tableHeader in secure smarty mode
  ([26168](https://github.com/civicrm/civicrm-core/pull/26168))**

- **Use purify rather than escape to preserve currency
  ([26133](https://github.com/civicrm/civicrm-core/pull/26133))**

- **Fix problem with group.update api
  ([26260](https://github.com/civicrm/civicrm-core/pull/26260))**

- **Fix PHP warning on Export Contacts
  ([26467](https://github.com/civicrm/civicrm-core/pull/26467))**

- **fix fatal error on custom data import
  ([26379](https://github.com/civicrm/civicrm-core/pull/26379))**

- **Fix PHP8 warning on DedupeFind
  ([26377](https://github.com/civicrm/civicrm-core/pull/26377))**

- **Fix PHP8 warnings for AddToGroup
  ([26165](https://github.com/civicrm/civicrm-core/pull/26165))**

- **Notice fix on edit Household
  ([26238](https://github.com/civicrm/civicrm-core/pull/26238))**

- **SchemaHandler - Cleanup string handling and fix syntax error
  ([26275](https://github.com/civicrm/civicrm-core/pull/26275))**

- **Fix config is null on hooks
  ([26178](https://github.com/civicrm/civicrm-core/pull/26178))**

- **Removes obsolete "Serbia and Montenegro" on civicrm_country.tpl
  ([26328](https://github.com/civicrm/civicrm-core/pull/26328) and
  [26413](https://github.com/civicrm/civicrm-core/pull/26413))**

### CiviCase

- **Attachment uploader information is missing in case attachments
  ([dev/core#4333](https://lab.civicrm.org/dev/core/-/issues/4333):
  [26409](https://github.com/civicrm/civicrm-core/pull/26409))**

- **[php8] fix Find Cases notices
  ([26163](https://github.com/civicrm/civicrm-core/pull/26163))**

### CiviContribute

- **Only call transitionComponents when transitioning pending/pay later to
  completed ([26228](https://github.com/civicrm/civicrm-core/pull/26228))**

- **Don't show refund due when balance is owed on Additional Payments
  ([26358](https://github.com/civicrm/civicrm-core/pull/26358))**

- **Changing contribution financial type from non-deductible to deductible does
  not change non-deductible amount, resulting in inability to issue tax receipts
  ([dev/financial#210](https://lab.civicrm.org/dev/financial/-/issues/210):
  [26400](https://github.com/civicrm/civicrm-core/pull/26400))**

- **Link to record payment from within participant change selections links it to
  wrong contribution, or crashes if that doesn't exist
  ([dev/financial#214](https://lab.civicrm.org/dev/financial/-/issues/214):
  [25543](https://github.com/civicrm/civicrm-core/pull/25543))**

- **Fix invoice being sent instead of receipt if contribution 'is_pay_later'
  is true ([26247](https://github.com/civicrm/civicrm-core/pull/26247))**

- **Uncheck is_email_receipt when hidden on New Contribution
  ([26191](https://github.com/civicrm/civicrm-core/pull/26191))**

- **fix parameters in APIv3 Payment.get
  ([26356](https://github.com/civicrm/civicrm-core/pull/26356))**

- **Fix payment validation for Payment on Confirm
  ([26430](https://github.com/civicrm/civicrm-core/pull/26430))**

- **Notice fix on isHonor on contribution page
  ([26171](https://github.com/civicrm/civicrm-core/pull/26171))**

- **E-notice fix on pay-later payment processor
  ([26169](https://github.com/civicrm/civicrm-core/pull/26169))**

- **Remove unneeded text on Contribution
  ([26380](https://github.com/civicrm/civicrm-core/pull/26380))**

- **Use PriceSet permissions for related entities
  ([26440](https://github.com/civicrm/civicrm-core/pull/26440))**

### CiviEvent

- **Fix missing error on Transfer Participant and allow multiple
  ([26365](https://github.com/civicrm/civicrm-core/pull/26365))**

- **Fix display of Fee Level on Self-service Registration Update
  ([26364](https://github.com/civicrm/civicrm-core/pull/26364))**

- **Allow backend transfer or cancel for all participant statuses
  ([26186](https://github.com/civicrm/civicrm-core/pull/26186))**

- **Don't show events without end date forever on Manage Events
  ([26347](https://github.com/civicrm/civicrm-core/pull/26347))**

- **Event price sets: Admin-only text field amount is shown in event
  registration test drive
  ([dev/core#4103](https://lab.civicrm.org/dev/core/-/issues/4103):
  [26103](https://github.com/civicrm/civicrm-core/pull/26103))**

- **CiviEvent: Submit button has wrong label in online registrations with
  multiple participants (on free events without confirmation screen)
  ([dev/core#4260](https://lab.civicrm.org/dev/core/-/issues/4260):
  [26355](https://github.com/civicrm/civicrm-core/pull/26355))**

- **Prevent prohibited self service cancellation by using is_backoffice=1 in URL
  ([26189](https://github.com/civicrm/civicrm-core/pull/26189))**

- **Show/hide billing name/address on event confirm based on if they're set
  instead of a magical collection of booleans
  ([26181](https://github.com/civicrm/civicrm-core/pull/26181))**

- **Fix authorization failed on self-service participant transfer
  ([26188](https://github.com/civicrm/civicrm-core/pull/26188))**

- **Fix back office register form validation
  ([26488](https://github.com/civicrm/civicrm-core/pull/26488))**

- **Preserve participant status when transferring
  ([26187](https://github.com/civicrm/civicrm-core/pull/26187))**

- **Fix broken event message template preview
  ([26569](https://github.com/civicrm/civicrm-core/pull/26569))**

- **Fix enotices in Register task formRule by separating functions
  ([26346](https://github.com/civicrm/civicrm-core/pull/26346))**

- **Don't show send broken confirmation description if registering multiple
  contacts ([26209](https://github.com/civicrm/civicrm-core/pull/26209))**

- **Fix PHP8 warnings in Participant.tpl
  ([26166](https://github.com/civicrm/civicrm-core/pull/26166) and
  [26319](https://github.com/civicrm/civicrm-core/pull/26319))**

- **Remove unneeded description text on Participant
  ([26382](https://github.com/civicrm/civicrm-core/pull/26382))**

- **Don't show event URL on Manage Event Template
  ([26419](https://github.com/civicrm/civicrm-core/pull/26419))**

- **Clarify isPrimary, isPaidEvent variables
  ([26283](https://github.com/civicrm/civicrm-core/pull/26283))**

- **Fix participantListingURL on Manage Event
  ([26351](https://github.com/civicrm/civicrm-core/pull/26351))**

- **Serialize Participant fee_level when using Change Selections
  ([26363](https://github.com/civicrm/civicrm-core/pull/26363))**

- **Replace isset with token for pay_later_receipt
  ([26299](https://github.com/civicrm/civicrm-core/pull/26299))**

- **Use balanceAmount token to remove isset in offline_event_receipt
  ([26215](https://github.com/civicrm/civicrm-core/pull/26215))**

- **Remove BOM from Registration.hlp
  ([26266](https://github.com/civicrm/civicrm-core/pull/26266))**

### CiviGrant

- **CiviGrant - Fix error when creating grant without permissions
  ([26513](https://github.com/civicrm/civicrm-core/pull/26513))**

### CiviMail

- **When creating a CiviMail it is possible to select this mailing as a
  "previous mailing" in the recipients list
  ([dev/core#3570](https://lab.civicrm.org/dev/core/-/issues/3570):
  [26427](https://github.com/civicrm/civicrm-core/pull/26427))**

- **crmMailingAB/services: catch exception, report error and rethrow
  ([26184](https://github.com/civicrm/civicrm-core/pull/26184))**

- **Fix undefined included mailing names in A/B test report, improve readability
  ([24734](https://github.com/civicrm/civicrm-core/pull/24734))**

- **Resize mailing preview modal
  ([26273](https://github.com/civicrm/civicrm-core/pull/26273))**

- **Simplify opt-out/unsubscribe help texts
  ([26301](https://github.com/civicrm/civicrm-core/pull/26301))**

### CiviMember

- **Error on membership fee token when using Print/Merge Document
  ([dev/core#3805](https://lab.civicrm.org/dev/core/-/issues/3805):
  [26263](https://github.com/civicrm/civicrm-core/pull/26263))**
  
- **Fix for membership discounts not showing in 5.62
  ([26538](https://github.com/civicrm/civicrm-core/pull/26538))**

- **don't show membership block on confirmation page if no membership exists
  ([26541](https://github.com/civicrm/civicrm-core/pull/26541))**

- **Remove unneeded description text on Memberships
  ([26396](https://github.com/civicrm/civicrm-core/pull/26396))**

- **Add deprecation notes to `processMembership` function deprecated in 2021
  ([26402](https://github.com/civicrm/civicrm-core/pull/26402))**

### CiviPetition

- **present friendlier error message if petition cannot be displayed.
  ([26446](https://github.com/civicrm/civicrm-core/pull/26446) and
  [26451](https://github.com/civicrm/civicrm-core/pull/26451))**

### Drupal Integration

- **Old Files notification on D8
  ([dev/core#1777](https://lab.civicrm.org/dev/core/-/issues/1777):
  [26196](https://github.com/civicrm/civicrm-core/pull/26196))**

  Skip checking vendor provided orphaned files if the vendor directory is not
  within the CiviCRM root.

- **Drupal 7, refuse the possibility to execute the REST API with blocked users
  ([26185](https://github.com/civicrm/civicrm-core/pull/26185))**

### WordPress Integration

- **Use custom actions for admin screen meta boxes
  ([dev/wordpress#139](https://lab.civicrm.org/dev/wordpress/-/issues/139):
  [292](https://github.com/civicrm/civicrm-wordpress/pull/292))**

- **Update WP Version tested to and CV Stable version. Test failure not
  relevant. ([294](https://github.com/civicrm/civicrm-wordpress/pull/294))**

- **5.63 - Update call to renamed mailing BAO
  ([296](https://github.com/civicrm/civicrm-wordpress/pull/296))**

## <a name="misc"></a>Miscellany

- **Stop passing $ids to membership::create
  ([26373](https://github.com/civicrm/civicrm-core/pull/26373))**

- **Cleanup on PriceSetCustom search  
  ([26439](https://github.com/civicrm/civicrm-core/pull/26439))**

- **Add eventTrait warning [ merge before rc is cut]
  ([26466](https://github.com/civicrm/civicrm-core/pull/26466))**

- **Fix another class to use the eventCreatePaid helper
  ([26463](https://github.com/civicrm/civicrm-core/pull/26463))**

- **Upgrader - Use generic (non-api4) code in upgrader
  ([26230](https://github.com/civicrm/civicrm-core/pull/26230))**

- **Clarify sent & not sent variables
  ([26223](https://github.com/civicrm/civicrm-core/pull/26223))**

- **AbstractAction: Drop `@throws` from phpdoc of `__construct()` because it's
  not thrown ([26213](https://github.com/civicrm/civicrm-core/pull/26213))**

- **5.62.0 - Last-minute notes. Bump version.
  ([26475](https://github.com/civicrm/civicrm-core/pull/26475))**

- **Add missing deprecated tag
  ([26204](https://github.com/civicrm/civicrm-core/pull/26204))**

- **Cleanup unused variables etc on membership form
  ([26371](https://github.com/civicrm/civicrm-core/pull/26371))**

- **Make some internal functions protected
  ([26221](https://github.com/civicrm/civicrm-core/pull/26221))**

- **Further separate register task from participant form
  ([26205](https://github.com/civicrm/civicrm-core/pull/26205))**

- **GenCode on Contribution DAO
  ([26284](https://github.com/civicrm/civicrm-core/pull/26284))**

- **Stop assigning variables removed from core templates in 2019
  ([26258](https://github.com/civicrm/civicrm-core/pull/26258))**

- **regen after recent message template updates
  ([26336](https://github.com/civicrm/civicrm-core/pull/26336))**

- **flexmailer remove cruft code
  ([26202](https://github.com/civicrm/civicrm-core/pull/26202))**

- **Extract sendEmail function
  ([26206](https://github.com/civicrm/civicrm-core/pull/26206))**

- **Update contributor-key to correct name
  ([26359](https://github.com/civicrm/civicrm-core/pull/26359))**

- **Added tpokorra to contributor-key.yml
  ([26418](https://github.com/civicrm/civicrm-core/pull/26418))**

- **Added Olayiwola Odunsi to contributor-key.yml
  ([26225](https://github.com/civicrm/civicrm-core/pull/26225))**

- **Added composerjk to contributor-key.yml
  ([26177](https://github.com/civicrm/civicrm-core/pull/26177))**

- **mixin/scan-classes - Don't scan extension-tests automatically
  ([26157](https://github.com/civicrm/civicrm-core/pull/26157))**

- **Remove unused constants
  ([26203](https://github.com/civicrm/civicrm-core/pull/26203))**

- **Remove unreachable validation
  ([26222](https://github.com/civicrm/civicrm-core/pull/26222))**

- **Minor cleanup on function
  ([26217](https://github.com/civicrm/civicrm-core/pull/26217))**

- **PriceSet forms - remove reference to undeclared _contributionAmount property
  ([26441](https://github.com/civicrm/civicrm-core/pull/26441))**

- **Remove unused variables from previously-shared function
  ([26264](https://github.com/civicrm/civicrm-core/pull/26264))**

- **Remove pass-by-ref
  ([26442](https://github.com/civicrm/civicrm-core/pull/26442))**

- **[REF][PHP8.2] Only clear cache values if property exists
  ([26289](https://github.com/civicrm/civicrm-core/pull/26289))**

- **[REF][PHP8.2] Declare campaigns property
  ([26293](https://github.com/civicrm/civicrm-core/pull/26293))**

- **[REF][PHP8.2] Remove unused entity dynamic property
  ([26287](https://github.com/civicrm/civicrm-core/pull/26287))**

- **[REF][PHP8.2] Remove seemingly unused write to dynamic property
  ([26288](https://github.com/civicrm/civicrm-core/pull/26288))**

- **[REF][PHP8.2] Sort out dynamic properties in api_v3_ReportTemplateTest
  ([26414](https://github.com/civicrm/civicrm-core/pull/26414))**

- **[REF][PHP8.2] Avoid dynamic properties in report summary
  ([26412](https://github.com/civicrm/civicrm-core/pull/26412))**

- **[REF][PHP8.2] Declare property in CRM_Report_Form_Contribute_Sybunt
  ([26411](https://github.com/civicrm/civicrm-core/pull/26411))**

- **[REF][PHP8.2] Declare property in CRM_Report_Form_Contact_Log
  ([26423](https://github.com/civicrm/civicrm-core/pull/26423))**

- **[REF][PHP8.2] Declare properties on OrganizationSummary report
  ([26424](https://github.com/civicrm/civicrm-core/pull/26424))**

- **[REF][PHP8.2] Remove unused dynamic property showMembershipSummary
  ([26433](https://github.com/civicrm/civicrm-core/pull/26433))**

- **[REF][PHP8.2] Fix dynamic property in FileReader class of PHPGetText
  ([362](https://github.com/civicrm/civicrm-packages/pull/362))**

- **[REF][PHP8.2] Declare getSiteDefaultCountry property
  ([26370](https://github.com/civicrm/civicrm-core/pull/26370))**

- **[REF][PHP8.2] Avoid unnecessary property in WebsiteTest
  ([26369](https://github.com/civicrm/civicrm-core/pull/26369))**

- **[REF][PHP8.2] Replace property with variable in OrderTest
  ([26368](https://github.com/civicrm/civicrm-core/pull/26368))**

- **[REF] CRM_Core_StateMachine::addSequentialPages(): don't pass extra
  parameter ([26367](https://github.com/civicrm/civicrm-core/pull/26367))**

- **(REF) civicrm_data - Move more baseline data to PHP files
  ([26270](https://github.com/civicrm/civicrm-core/pull/26270))**

- **(REF) civicrm_data.tpl - Split option-groups into many PHP files
  ([26245](https://github.com/civicrm/civicrm-core/pull/26245))**

- **REF: Small cleanup on contribution receipt code
  ([26078](https://github.com/civicrm/civicrm-core/pull/26078))**

- **(REF) CRM_Core_Config  - Simplify dependencies between MagicMerge and
  Runtime ([26143](https://github.com/civicrm/civicrm-core/pull/26143))**

- **REF - Cleanup unused variable and comment in SearchKit
  ([26306](https://github.com/civicrm/civicrm-core/pull/26306))**

- **REF - Fix Campaign index names, add default value for created_date
  ([26231](https://github.com/civicrm/civicrm-core/pull/26231))**

- **[REF] Move repeated code for Price Field labels into separate function
  ([26375](https://github.com/civicrm/civicrm-core/pull/26375))**

- **[NFC] SearchKit sql function "if": fix description
  ([dev/core#4307](https://lab.civicrm.org/dev/core/-/issues/4307):
  [26333](https://github.com/civicrm/civicrm-core/pull/26333))**

- **[NFC] Remove extra whitespace around date through in EventInfoBlock
  ([26429](https://github.com/civicrm/civicrm-core/pull/26429))**

- **[NFC] typo fixes
  ([26310](https://github.com/civicrm/civicrm-core/pull/26310))**

- **(NFC) CiviEventDispatcher - Update type declaration. Add test demonstion
  ([26276](https://github.com/civicrm/civicrm-core/pull/26276))**

- **[NFC] Fix capitalization of class names
  ([26428](https://github.com/civicrm/civicrm-core/pull/26428))**

- **More tests fixed to use fullFormFlow
  ([26269](https://github.com/civicrm/civicrm-core/pull/26269))**

- **[Test]  Fix UFGroup cleanup in ReportTemplateTest
  ([26421](https://github.com/civicrm/civicrm-core/pull/26421))**

- **[Test] More test UFGroup cleanup  
  ([26422](https://github.com/civicrm/civicrm-core/pull/26422))**

- **[Test] Switch some unpaid event test setup to use createUnPaidEvent
  ([26420](https://github.com/civicrm/civicrm-core/pull/26420))**

- **[TEST ONLY] APIv4 - Update tests to use new Invasive helper
  ([26361](https://github.com/civicrm/civicrm-core/pull/26361))**

- **[TEST] Further minor fixes on UFGroup Cleanup
  ([26434](https://github.com/civicrm/civicrm-core/pull/26434))**

- **[Test] Rename version of eventCreatePaid that is being replaced
  ([26450](https://github.com/civicrm/civicrm-core/pull/26450))**

- **Fix Participant tests to use full form flow
  ([26220](https://github.com/civicrm/civicrm-core/pull/26220))**

- **Fix UFGroupTest to cleanup it's UFGroups
  ([26406](https://github.com/civicrm/civicrm-core/pull/26406))**

- **Fix a couple of tests to use Event helpers
  ([26462](https://github.com/civicrm/civicrm-core/pull/26462))**

- **fix Mailsettings.testconnection picking wrong settings to test
  ([26398](https://github.com/civicrm/civicrm-core/pull/26398))**

- **Add Event test trait
  ([26405](https://github.com/civicrm/civicrm-core/pull/26405))**

- **Fix tests calling getParticipantOrderParams to use the trait
  ([26455](https://github.com/civicrm/civicrm-core/pull/26455))**

- **Stop truncating UFGroup on tearDown
  ([26449](https://github.com/civicrm/civicrm-core/pull/26449))**

- **Improve `UFGroup` cleanup in the `ProcessorFormTest`
  ([26408](https://github.com/civicrm/civicrm-core/pull/26408))**

- **Create UFGroup in tear-down-able manner
  ([26458](https://github.com/civicrm/civicrm-core/pull/26458))**

- **Test cleanup - improve cleanup of `UFGroup`
  ([26403](https://github.com/civicrm/civicrm-core/pull/26403))**

- **Superficial Cleanup in test class
  ([26454](https://github.com/civicrm/civicrm-core/pull/26454))**

- **Cleanup on ContributionTest
  ([26472](https://github.com/civicrm/civicrm-core/pull/26472))**

- **More test fixes on cleanup, helper use
  ([26464](https://github.com/civicrm/civicrm-core/pull/26464))**

- **Use APIv4 when creating test entities
  ([26471](https://github.com/civicrm/civicrm-core/pull/26471))**

- **APIv4 - Add test to ensure custom fields work with underscores
  ([26468](https://github.com/civicrm/civicrm-core/pull/26468))**

- **Declare paid event as example data, call from test
  ([26294](https://github.com/civicrm/civicrm-core/pull/26294))**

## <a name="credits"></a>Credits

This release was developed by the following code authors:

AGH Strategies - Andie Hunt; Agileware - Francis Whittle, Justin Freeman;
ASMAC (American Society of Music Arrangers and Composers) - Jeff Kellem;
Benjamin W; BrightMinded Ltd - Bradley Taylor; Christian Wach; Circle
Interactive - Pradeep Nayak; CiviCRM - Coleman Watts, Tim Otten; CiviDesk -
Yashodha Chaku; CompuCorp - Ahed Eid, Olayiwola Odunsi; Coop SymbioTIC - Mathieu
Lutfy, Samuel Vanhove; Dave D; Fuzion - Luke Stewart; iXiam - Rubén Pineda; Jens
Schuppe; JMA Consulting - Monish Deb, Seamus Lee; Lemniscus - Noah Miller;
Megaphone Technology Consulting - Jon Goldberg; MJW Consulting - Matthew Wire;
Progressive Technology Project - Jamie McClelland; Quim Gil; Reflexive
Communications - Sandor Semsey; Squiffle Consulting - Aidan Saunders; Tadpole
Collective - Kevin Cristiano; Hostsharing eG - Timotheus Pokorra; Wikimedia
Foundation - Eileen McNaughton; Wildsight - Lars Sanders-Green

Most authors also reviewed code for this release; in addition, the following
reviewers contributed their comments:

AGH Strategies - Eli Lisseck; Andreas Howiller; Calibrate - Wouter Hechtermans;
CompuCorp - Jamie Novick; Coop SymbioTIC - Shane Bill; destrieux; gibsonoliver;
Greenleaf Advancement - Guy Iaccarino; Greyson Stalcup; Guydn; Humanists UK -
Andrew West; John Kingsnorth; Korlon - Stuart Gaston; Mark Rodgers; MC3 - Graham
Mitchell; Megaphone Technology Consulting - Brienne Kordis; Nicol Wistreich;
Pooka & Co - Marcus J Wilson; Richard van Oosterhout; Skvare - Sunil Pawar;
