/* -*- mode: c; c-basic-offset: 4; indent-tabs-mode: nil -*- */
/*
 * tkIntDecls.h --
 *
 * This file contains the declarations for all unsupported functions
 * that are exported by the Tk library.  These interfaces are not
 * guaranteed to remain the same between versions.  Use at your own
 * risk.
 *
 * This file was adapted from tkIntDecls.h of the Tk library distribution.
 *
 * Copyright (c) 1998-1999 by Scriptics Corporation.
 *
 *   This software is copyrighted by the Regents of the University of
 *   California, Sun Microsystems, Inc., and other parties.  The following
 *   terms apply to all files associated with the software unless
 *   explicitly disclaimed in individual files.
 * 
 *   The authors hereby grant permission to use, copy, modify, distribute,
 *   and license this software and its documentation for any purpose,
 *   provided that existing copyright notices are retained in all copies
 *   and that this notice is included verbatim in any distributions. No
 *   written agreement, license, or royalty fee is required for any of the
 *   authorized uses.  Modifications to this software may be copyrighted by
 *   their authors and need not follow the licensing terms described here,
 *   provided that the new terms are clearly indicated on the first page of
 *   each file where they apply.
 * 
 *   IN NO EVENT SHALL THE AUTHORS OR DISTRIBUTORS BE LIABLE TO ANY PARTY
 *   FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
 *   ARISING OUT OF THE USE OF THIS SOFTWARE, ITS DOCUMENTATION, OR ANY
 *   DERIVATIVES THEREOF, EVEN IF THE AUTHORS HAVE BEEN ADVISED OF THE
 *   POSSIBILITY OF SUCH DAMAGE.
 * 
 *   THE AUTHORS AND DISTRIBUTORS SPECIFICALLY DISCLAIM ANY WARRANTIES,
 *   INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 *   MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, AND
 *   NON-INFRINGEMENT.  THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, AND
 *   THE AUTHORS AND DISTRIBUTORS HAVE NO OBLIGATION TO PROVIDE
 *   MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 *
 *   GOVERNMENT USE: If you are acquiring this software on behalf of the
 *   U.S. government, the Government shall have only "Restricted Rights" in
 *   the software and related documentation as defined in the Federal
 *   Acquisition Regulations (FARs) in Clause 52.227.19 (c) (2).  If you
 *   are acquiring the software on behalf of the Department of Defense, the
 *   software shall be classified as "Commercial Computer Software" and the
 *   Government shall have only "Restricted Rights" as defined in Clause
 *   252.227-7013 (b) (3) of DFARs.  Notwithstanding the foregoing, the
 *   authors grant the U.S. Government and others acting in its behalf
 *   permission to use and distribute the software in accordance with the
 *   terms specified in this license.
 *
 * Copyright 2015 George A. Howlett. All rights reserved.  
 *
 *   Redistribution and use in source and binary forms, with or without
 *   modification, are permitted provided that the following conditions are
 *   met:
 *
 *   1) Redistributions of source code must retain the above copyright
 *      notice, this list of conditions and the following disclaimer.
 *   2) Redistributions in binary form must reproduce the above copyright
 *      notice, this list of conditions and the following disclaimer in the
 *      documentation and/or other materials provided with the
 *      distribution.
 *   3) Neither the name of the authors nor the names of its contributors
 *      may be used to endorse or promote products derived from this
 *      software without specific prior written permission.
 *   4) Products derived from this software may not be called "BLT" nor may
 *      "BLT" appear in their names without specific prior written
 *      permission from the author.
 *
 *   THIS SOFTWARE IS PROVIDED ''AS IS'' AND ANY EXPRESS OR IMPLIED
 *   WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 *   MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 *   DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
 *   LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 *   CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 *   SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
 *   BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *   WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
 *   OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN
 *   IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

#include "tkDisplay.h"

#ifndef _TKINTDECLS
#define _TKINTDECLS

#ifdef BUILD_tk
#undef TCL_STORAGE_CLASS
#define TCL_STORAGE_CLASS DLLEXPORT
#endif

typedef struct _TkStateMap TkStateMap;

/*
 * WARNING: This file is automatically generated by the tools/genStubs.tcl
 * script.  Any modifications to the function declarations below should be made
 * in the generic/tkInt.decls script.
 */

/* !BEGIN!: Do not edit below this line. */

/*
 * Exported function declarations:
 */

/* 9 */
extern void TkComputeAnchor(Tk_Anchor anchor, Tk_Window tkwin, int xPad, 
        int yPad, int innerWidth, int innerHeight, int *xPtr, int *yPtr);
/* 10 */
extern int TkCopyAndGlobalEval(Tcl_Interp *interp, char * script);
/* 14 */
extern Tk_Window TkCreateMainWindow(Tcl_Interp *interp, char * screenName, 
        char *baseName);
/* 21 */
extern int TkFindStateNum(Tcl_Interp *interp, const char *option, 
        const TkStateMap *mapPtr, const char *strKey);
/* 64 */
extern void TkpMakeContainer(Tk_Window tkwin);
/* 74 */
extern void TkpSetMainMenubar(Tcl_Interp *interp, Tk_Window tkwin, 
        char *menuName);
/* 75 */
extern int TkpUseWindow(Tcl_Interp *interp, Tk_Window tkwin, char *string);
#if (_TK_VERSION < _VERSION(8,5,0)) 
/* 84 */
extern void TkSetClassProcs(Tk_Window tkwin, void *procs, 
        ClientData instanceData);
#endif
/* 85 */
extern void TkSetWindowMenuBar(Tcl_Interp *interp, Tk_Window tkwin, 
        char *oldMenuName, char *menuName);
/* 86 */
extern KeySym TkStringToKeysym(char *name);
/* 95 */
extern void TkWmRestackToplevel(Tk_Window tkwin, int aboveBelow, 
        Tk_Window otherPtr);
/* 104 */
extern int TkFindStateNumObj(Tcl_Interp *interp, Tcl_Obj *optionPtr, 
        const TkStateMap *mapPtr, Tcl_Obj *keyPtr);
/* 106 */
extern TkDisplay *TkGetDisplayList(void);

#if defined (WIN32) || defined(MAC_TCL) || defined(MAC_OSX_TCL)
/* 114 */
extern TkRegion TkCreateRegion(void);
/* 115 */
extern void TkDestroyRegion (TkRegion rgn);
/* 116 */
extern void TkIntersectRegion (TkRegion sra, TkRegion srcb, TkRegion dr_return);
/* 117 */
extern int TkRectInRegion(TkRegion rgn, int x, int y, unsigned int width, 
                          unsigned int height);
/* 118 */
extern void TkSetRegion(Display* display, GC gc, TkRegion rgn);
/* 119 */
extern void TkUnionRectWithRegion(XRectangle* rect, TkRegion src, 
        TkRegion dr_return);
#endif

/* 137 */
extern void TkpSetKeycodeAndState(Tk_Window tkwin, KeySym keySym, 
        XEvent *eventPtr);
/* 138 */
extern KeySym TkpGetKeySym(TkDisplay *dispPtr, XEvent *eventPtr);

typedef struct TkIntStubs {
    int magic;
    struct TkIntStubHooks *hooks;

    void *tkAllocWindow;                /* 0 */
    void *tkBezierPoints;               /* 1 */
    void *tkBezierScreenPoints;         /* 2 */
    void *tkBindDeadWindow;             /* 3 */
    void *tkBindEventProc;              /* 4 */
    void *tkBindFree;                   /* 5 */
    void *tkBindInit;                   /* 6 */
    void *tkChangeEventWindow;          /* 7 */
    void *tkClipInit;                   /* 8 */

    void (*tkComputeAnchor)(Tk_Anchor anchor, Tk_Window tkwin, 
        int xPad, int yPad, int innerWidth, int innerHeight, 
        int *xPtr, int *yPtr);          /* 9 */

    int (*tkCopyAndGlobalEval)(Tcl_Interp *interp, char *script); /* 10 */

    void *tkCreateBindingProcedure;     /* 11 */
    void *tkCreateCursorFromData;       /* 12 */
    void *tkCreateFrame;                /* 13 */

    Tk_Window (*tkCreateMainWindow)(Tcl_Interp *interp, char *screenName, 
        char * baseName);               /* 14 */

    void *tkCurrentTime;                /* 15 */
    void *tkDeleteAllImages;            /* 16 */
    void *tkDoConfigureNotify;          /* 17 */
    void *tkDrawInsetFocusHighlight;    /* 18 */
    void *tkEventDeadWindow;            /* 19 */
    void *tkFillPolygon;                /* 20 */
    int (*tkFindStateNum) (Tcl_Interp *interp, CONST char *option, CONST TkStateMap *mapPtr, CONST char *strKey); /* 21 */
    void *tkFindStateString;            /* 22 */
    void *tkFocusDeadWindow;            /* 23 */
    void *tkFocusFilterEvent;           /* 24 */
    void *tkFocusKeyEvent;              /* 25 */
    void *tkFontPkgInit;                /* 26 */
    void *tkFontPkgFree;                /* 27 */
    void *tkFreeBindingTags;            /* 28 */
    void *tkpFreeCursor;                /* 29 */
    void *tkGetBitmapData;              /* 30 */
    void *tkGetButtPoints;              /* 31 */
    void *tkGetCursorByName;            /* 32 */
    void *tkGetDefaultScreenName;       /* 33 */
    void *tkGetDisplay;                 /* 34 */
    void *tkGetDisplayOf;               /* 35 */
    void *tkGetFocusWin;                /* 36 */
    void *tkGetInterpNames;             /* 37 */
    void *tkGetMiterPoints;             /* 38 */
    void *tkGetPointerCoords;           /* 39 */
    void *tkGetServerInfo;              /* 40 */
    void *tkGrabDeadWindow;             /* 41 */
    void *tkGrabState;                  /* 42 */
    void *tkIncludePoint;               /* 43 */
    void *tkInOutEvents;                /* 44 */
    void *tkInstallFrameMenu;           /* 45 */
    void *tkKeysymToString;             /* 46 */
    void *tkLineToArea;                 /* 47 */
    void *tkLineToPoint;                /* 48 */
    void *tkMakeBezierCurve;            /* 49 */
    void *tkMakeBezierPostscript;       /* 50 */
    void *tkOptionClassChanged;         /* 51 */
    void *tkOptionDeadWindow;           /* 52 */
    void *tkOvalToArea;                 /* 53 */
    void *tkOvalToPoint;                /* 54 */
    void *tkpChangeFocus;               /* 55 */
    void *tkpCloseDisplay;              /* 56 */
    void *tkpClaimFocus;                /* 57 */
    void *tkpDisplayWarning;            /* 58 */
    void *tkpGetAppName;                /* 59 */
    void *tkpGetOtherWindow;            /* 60 */
    void *tkpGetWrapperWindow;          /* 61 */
    void *tkpInit;                      /* 62 */
    void *tkpInitializeMenuBindings;    /* 63 */

    void (*tkpMakeContainer)(Tk_Window tkwin); /* 64 */

    void *tkpMakeMenuWindow;            /* 65 */
    void *tkpMakeWindow;                /* 66 */
    void *tkpMenuNotifyToplevelCreate;  /* 67 */
    void *tkpOpenDisplay;               /* 68 */
    void *tkPointerEvent;               /* 69 */
    void *tkPolygonToArea;              /* 70 */
    void *tkPolygonToPoint;             /* 71 */
    void *tkPositionInTree;             /* 72 */
    void *tkpRedirectKeyEvent;          /* 73 */

    void (*tkpSetMainMenubar)(Tcl_Interp *interp, Tk_Window tkwin, 
        char *menuName);                /* 74 */

    int (*tkpUseWindow)(Tcl_Interp *interp, Tk_Window tkwin, 
        char *string);                  /* 75 */

    void *tkpWindowWasRecentlyDeleted;  /* 76 */
    void *tkQueueEventForAllChildren;   /* 77 */
    void *tkReadBitmapFile;             /* 78 */
    void *tkScrollWindow;               /* 79 */
    void *tkSelDeadWindow;              /* 80 */
    void *tkSelEventProc;               /* 81 */
    void *tkSelInit;                    /* 82 */
    void *tkSelPropProc;                /* 83 */

    void (*tkSetClassProcs)(Tk_Window tkwin, void *procs, 
        ClientData instanceData);       /* 84 */

    void (*tkSetWindowMenuBar)(Tcl_Interp *interp, Tk_Window tkwin, 
        char *oldMenuName, char *menuName); /* 85 */

    KeySym (*tkStringToKeysym) (char *name); /* 86 */
    void *tkThickPolyLineToArea;        /* 87 */
    void *tkWmAddToColormapWindows;     /* 88 */
    void *tkWmDeadWindow;               /* 89 */
    void *tkWmFocusToplevel;            /* 90 */
    void *tkWmMapWindow;                /* 91 */
    void *tkWmNewWindow;                /* 92 */
    void *tkWmProtocolEventProc;        /* 93 */
    void *tkWmRemoveFromColormapWindows; /* 94 */

    void (*tkWmRestackToplevel)(Tk_Window tkwin, int aboveBelow, 
        Tk_Window other);               /* 95 */

    void *tkWmSetClass;                 /* 96 */
    void *tkWmUnmapWindow;              /* 97 */
    void *tkDebugBitmap;                /* 98 */
    void *tkDebugBorder;                /* 99 */
    void *tkDebugCursor;                /* 100 */
    void *tkDebugColor;                 /* 101 */
    void *tkDebugConfig;                /* 102 */
    void *tkDebugFont;                  /* 103 */
    int (*tkFindStateNumObj) (Tcl_Interp *interp, Tcl_Obj *optionPtr, 
        const TkStateMap *mapPtr, Tcl_Obj *keyPtr); /* 104 */
    void *tkGetBitmapPredefTable;       /* 105 */
    TkDisplay *(*tkGetDisplayList)(void); /* 106 */
    void *tkGetMainInfoList;            /* 107 */
    void *tkGetWindowFromObj;           /* 108 */
    void *tkpGetString;         /* 109 */
    void *tkpGetSubFonts;       /* 110 */
    void *tkpGetSystemDefault;  /* 111 */
    void *tkpMenuThreadInit;    /* 112 */
    void *tkClipBox;            /* 113 */
#ifdef WIN32
    TkRegion (*tkCreateRegion) (void); /* 114 */
    void (*tkDestroyRegion) (TkRegion rgn); /* 115 */
    void (*tkIntersectRegion) (TkRegion sra, TkRegion srcb, TkRegion dr_return); /* 116 */
    int (*tkRectInRegion) (TkRegion rgn, int x, int y, unsigned int width, unsigned int height); /* 117 */
    void (*tkSetRegion) (Display *display, GC gc, TkRegion rgn); /* 118 */
    void (*tkUnionRectWithRegion) (XRectangle *rect, TkRegion src, TkRegion dr_return); /* 119 */
#else
    void *tkCreateRegion;       /* 114 */
    void *tkDestroyRegion;      /* 115 */
    void *tkIntersectRegion;    /* 116 */
    void *tkRectInRegion;       /* 117 */
    void *tkSetRegion;          /* 118 */
    void *tkUnionRectWithRegion; /* 119 */
#endif  /*WIN32*/
    void *reserved120;
    void *tkpCreateNativeBitmap; /* 121 */
    void *tkpDefineNativeBitmaps; /* 122 */
    void *reserved123;
    void *tkpGetNativeAppBitmap; /* 124 */
    void *reserved125;
    void *reserved126;
    void *reserved127;
    void *reserved128;
    void *reserved129;
    void *reserved130;
    void *reserved131;
    void *reserved132;
    void *reserved133;
    void *reserved134;
    void *tkpDrawHighlightBorder; /* 135 */
    void *tkSetFocusWin;        /* 136 */
    void (*tkpSetKeycodeAndState) (Tk_Window tkwin, KeySym keySym, XEvent *eventPtr); /* 137 */
    KeySym (*tkpGetKeySym) (TkDisplay *dispPtr, XEvent *eventPtr); /* 138 */
    void *tkpInitKeymapInfo;    /* 139 */
} TkIntStubs;

#if defined(USE_TK_STUBS) && !defined(USE_TK_STUB_PROCS)

#ifdef __cplusplus
extern "C" {
#endif /*__cplusplus*/

extern TkIntStubs *tkIntStubsPtr;

#ifdef __cplusplus
}
#endif /*__cplusplus*/


/*
 * Inline function declarations:
 */

#ifndef TkComputeAnchor
#define TkComputeAnchor \
        (tkIntStubsPtr->tkComputeAnchor) /* 9 */
#endif

#ifndef TkCopyAndGlobalEval
#define TkCopyAndGlobalEval \
        (tkIntStubsPtr->tkCopyAndGlobalEval) /* 10 */
#endif

#ifndef TkCreateMainWindow
#define TkCreateMainWindow \
        (tkIntStubsPtr->tkCreateMainWindow) /* 14 */
#endif

#ifndef TkFindStateNum
#define TkFindStateNum \
        (tkIntStubsPtr->tkFindStateNum) /* 21 */
#endif
#ifndef TkpMakeContainer
#define TkpMakeContainer \
        (tkIntStubsPtr->tkpMakeContainer) /* 64 */
#endif

#ifndef TkpSetMainMenubar
#define TkpSetMainMenubar \
        (tkIntStubsPtr->tkpSetMainMenubar) /* 74 */
#endif

#ifndef TkpUseWindow
#define TkpUseWindow \
        (tkIntStubsPtr->tkpUseWindow) /* 75 */
#endif

#ifndef TkSetClassProcs
#define TkSetClassProcs \
        (tkIntStubsPtr->tkSetClassProcs) /* 84 */
#endif

#ifndef TkSetWindowMenuBar
#define TkSetWindowMenuBar \
        (tkIntStubsPtr->tkSetWindowMenuBar) /* 85 */
#endif

#ifndef TkStringToKeysym
#define TkStringToKeysym \
        (tkIntStubsPtr->tkStringToKeysym) /* 86 */
#endif

#ifndef TkWmRestackToplevel
#define TkWmRestackToplevel \
        (tkIntStubsPtr->tkWmRestackToplevel) /* 95 */
#endif

#ifndef TkFindStateNumObj
#define TkFindStateNumObj \
        (tkIntStubsPtr->tkFindStateNumObj) /* 104 */
#endif

#ifndef TkGetDisplayList
#define TkGetDisplayList \
        (tkIntStubsPtr->tkGetDisplayList) /* 106 */
#endif


#if defined(WIN32) || defined(MAC_TCL) || defined(MAC_OSX_TCL)
#ifndef TkClipBox
#define TkClipBox \
        (tkIntStubsPtr->tkClipBox)      /* 113 */
#endif
#ifndef TkCreateRegion
#define TkCreateRegion \
        (tkIntStubsPtr->tkCreateRegion) /* 114 */
#endif
#ifndef TkDestroyRegion
#define TkDestroyRegion \
        (tkIntStubsPtr->tkDestroyRegion) /* 115 */
#endif
#ifndef TkIntersectRegion
#define TkIntersectRegion \
        (tkIntStubsPtr->tkIntersectRegion) /* 116 */
#endif
#ifndef TkRectInRegion
#define TkRectInRegion \
        (tkIntStubsPtr->tkRectInRegion) /* 117 */
#endif
#ifndef TkSetRegion
#define TkSetRegion \
        (tkIntStubsPtr->tkSetRegion)    /* 118 */
#endif
#ifndef TkUnionRectWithRegion
#define TkUnionRectWithRegion \
        (tkIntStubsPtr->tkUnionRectWithRegion)  /* 119 */
#endif
#endif  /* WIN32 */

#ifndef TkpSetKeycodeAndState
#define TkpSetKeycodeAndState \
        (tkIntStubsPtr->tkpSetKeycodeAndState) /* 137 */
#endif
#ifndef TkpGetKeySym
#define TkpGetKeySym \
        (tkIntStubsPtr->tkpGetKeySym) /* 138 */
#endif

#endif /*USE_STUBS*/

#undef TCL_STORAGE_CLASS
#define TCL_STORAGE_CLASS DLLIMPORT


#endif /* _TKINTDECLS */

