/*
   Copyright (C) 2010 Benjamin Redelings

This file is part of BAli-Phy.

BAli-Phy is free software; you can redistribute it and/or modify it under
the terms of the GNU General Public License as published by the Free
Software Foundation; either version 2, or (at your option) any later
version.

BAli-Phy is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License
along with BAli-Phy; see the file COPYING.  If not see
<http://www.gnu.org/licenses/>.  */

/**
 * @file util/time.H
 */

/*
 * A timer stack contains a collection of tokens (strings) identifying
 * various code regions.  The contexts are nested, with the top of the
 * stack being most deeply nested. Elapsed CPU time is credited to each
 * token that is on the stack.
 *
 * Usage: When we enter a code region which we wish to profile, we call
 * push_timer( ) to start charging CPU time to that token.  When we leave
 * the region, we call pop_timer().
 *
 * A report can be generated by calling report().
 */

#ifndef TIME_STACK_H
#define TIME_STACK_H

#include <string>
#include <boost/chrono.hpp>

typedef boost::chrono::nanoseconds duration_t;

duration_t total_cpu_time();

std::string duration_string(boost::chrono::seconds);

#endif /* TIME_STACK_H */
