/*
 * This file was automatically generated by EvoSuite
 * Fri Jun 08 19:06:11 GMT 2018
 */

package uk.ac.sanger.artemis.components.genebuilder;

import org.junit.Test;
import static org.junit.Assert.*;
import static org.evosuite.runtime.EvoAssertions.*;
import java.awt.HeadlessException;
import java.awt.datatransfer.Clipboard;
import java.time.chrono.ThaiBuddhistEra;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.JFrame;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.junit.runner.RunWith;
import uk.ac.sanger.artemis.Entry;
import uk.ac.sanger.artemis.EntryGroup;
import uk.ac.sanger.artemis.Feature;
import uk.ac.sanger.artemis.FeatureKeyPredicate;
import uk.ac.sanger.artemis.FeatureVector;
import uk.ac.sanger.artemis.FilteredEntryGroup;
import uk.ac.sanger.artemis.Selection;
import uk.ac.sanger.artemis.SimpleEntryGroup;
import uk.ac.sanger.artemis.SimpleGotoEventSource;
import uk.ac.sanger.artemis.chado.FeatureForUpdatingResidues;
import uk.ac.sanger.artemis.components.genebuilder.GeneUtils;
import uk.ac.sanger.artemis.io.BlastStreamFeature;
import uk.ac.sanger.artemis.io.ChadoCanonicalGene;
import uk.ac.sanger.artemis.io.DatabaseInferredFeature;
import uk.ac.sanger.artemis.io.EmblStreamFeature;
import uk.ac.sanger.artemis.io.GFFStreamFeature;
import uk.ac.sanger.artemis.io.GenbankStreamFeature;
import uk.ac.sanger.artemis.io.Key;
import uk.ac.sanger.artemis.io.Location;
import uk.ac.sanger.artemis.io.QualifierVector;
import uk.ac.sanger.artemis.io.Range;
import uk.ac.sanger.artemis.io.RangeVector;
import uk.ac.sanger.artemis.io.ReadOnlyEmblStreamFeature;

@RunWith(EvoRunner.class) @EvoRunnerParameters(mockJVMNonDeterminism = true, useVFS = true, useVNET = true, resetStaticState = true, separateClassLoader = false, useJEE = true) 
public class GeneUtils_ESTest extends GeneUtils_ESTest_scaffolding {

  @Test(timeout = 4000)
  public void test00()  throws Throwable  {
      GenbankStreamFeature genbankStreamFeature0 = new GenbankStreamFeature();
      BlastStreamFeature blastStreamFeature0 = new BlastStreamFeature(genbankStreamFeature0);
      GFFStreamFeature gFFStreamFeature0 = new GFFStreamFeature(blastStreamFeature0, false);
      ChadoCanonicalGene chadoCanonicalGene0 = new ChadoCanonicalGene();
      chadoCanonicalGene0.addTranscript(gFFStreamFeature0);
      // Undeclared exception!
      try { 
        GeneUtils.checkGeneBoundary(chadoCanonicalGene0, false);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.components.genebuilder.GeneUtils", e);
      }
  }

  @Test(timeout = 4000)
  public void test01()  throws Throwable  {
      GenbankStreamFeature genbankStreamFeature0 = new GenbankStreamFeature();
      BlastStreamFeature blastStreamFeature0 = new BlastStreamFeature(genbankStreamFeature0);
      GFFStreamFeature gFFStreamFeature0 = new GFFStreamFeature(blastStreamFeature0, false);
      ChadoCanonicalGene chadoCanonicalGene0 = new ChadoCanonicalGene();
      Feature feature0 = new Feature(gFFStreamFeature0);
      gFFStreamFeature0.setChadoGene(chadoCanonicalGene0);
      String string0 = GeneUtils.deriveResidues(gFFStreamFeature0);
      assertNull(string0);
  }

  @Test(timeout = 4000)
  public void test02()  throws Throwable  {
      GenbankStreamFeature genbankStreamFeature0 = new GenbankStreamFeature();
      ChadoCanonicalGene chadoCanonicalGene0 = new ChadoCanonicalGene();
      chadoCanonicalGene0.setGene(genbankStreamFeature0);
      // Undeclared exception!
      try { 
        GeneUtils.complementGeneModel(chadoCanonicalGene0);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.ChadoCanonicalGene", e);
      }
  }

  @Test(timeout = 4000)
  public void test03()  throws Throwable  {
      boolean boolean0 = GeneUtils.isHiddenFeature("polypeptide");
      assertTrue(boolean0);
  }

  @Test(timeout = 4000)
  public void test04()  throws Throwable  {
      Key key0 = new Key("");
      Range range0 = new Range(5090);
      Location location0 = new Location(range0);
      QualifierVector qualifierVector0 = new QualifierVector();
      ChadoCanonicalGene chadoCanonicalGene0 = new ChadoCanonicalGene();
      DatabaseInferredFeature databaseInferredFeature0 = new DatabaseInferredFeature(key0, location0, qualifierVector0, chadoCanonicalGene0);
      String string0 = GeneUtils.getUniqueName(databaseInferredFeature0);
      assertNotNull(string0);
  }

  @Test(timeout = 4000)
  public void test05()  throws Throwable  {
      LinkedHashSet<ReadOnlyEmblStreamFeature> linkedHashSet0 = new LinkedHashSet<ReadOnlyEmblStreamFeature>();
      // Undeclared exception!
      try { 
        GeneUtils.propagateId((GFFStreamFeature) null, "{|T079C", linkedHashSet0);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.components.genebuilder.GeneUtils", e);
      }
  }

  @Test(timeout = 4000)
  public void test06()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      FeatureVector featureVector0 = new FeatureVector();
      FilteredEntryGroup filteredEntryGroup0 = new FilteredEntryGroup(simpleEntryGroup0, featureVector0, "");
      Range range0 = new Range(257);
      // Undeclared exception!
      try { 
        GeneUtils.promptForUniquename((EntryGroup) filteredEntryGroup0, false, range0);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.components.genebuilder.GeneUtils", e);
      }
  }

  @Test(timeout = 4000)
  public void test07()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      Key key0 = new Key("");
      FeatureKeyPredicate featureKeyPredicate0 = new FeatureKeyPredicate(key0);
      FilteredEntryGroup filteredEntryGroup0 = new FilteredEntryGroup(simpleEntryGroup0, featureKeyPredicate0, "");
      // Undeclared exception!
      try { 
        GeneUtils.promptForUniquename((EntryGroup) filteredEntryGroup0, true);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.components.genebuilder.GeneUtils", e);
      }
  }

  @Test(timeout = 4000)
  public void test08()  throws Throwable  {
      ChadoCanonicalGene chadoCanonicalGene0 = new ChadoCanonicalGene();
      // Undeclared exception!
      try { 
        GeneUtils.isStrandOK(chadoCanonicalGene0);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.components.genebuilder.GeneUtils", e);
      }
  }

  @Test(timeout = 4000)
  public void test09()  throws Throwable  {
      // Undeclared exception!
      try { 
        GeneUtils.isObsolete((GFFStreamFeature) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.components.genebuilder.GeneUtils", e);
      }
  }

  @Test(timeout = 4000)
  public void test10()  throws Throwable  {
      // Undeclared exception!
      try { 
        GeneUtils.isNonCodingTranscripts((Key) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.components.genebuilder.GeneUtils", e);
      }
  }

  @Test(timeout = 4000)
  public void test11()  throws Throwable  {
      // Undeclared exception!
      try { 
        GeneUtils.isGFFEntry((EntryGroup) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.components.genebuilder.GeneUtils", e);
      }
  }

  @Test(timeout = 4000)
  public void test12()  throws Throwable  {
      // Undeclared exception!
      try { 
        GeneUtils.isDatabaseEntry((uk.ac.sanger.artemis.io.Feature) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.components.genebuilder.GeneUtils", e);
      }
  }

  @Test(timeout = 4000)
  public void test13()  throws Throwable  {
      // Undeclared exception!
      try { 
        GeneUtils.isDatabaseEntry((EntryGroup) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.components.genebuilder.GeneUtils", e);
      }
  }

  @Test(timeout = 4000)
  public void test14()  throws Throwable  {
      ChadoCanonicalGene chadoCanonicalGene0 = new ChadoCanonicalGene();
      // Undeclared exception!
      try { 
        GeneUtils.isBoundaryOK(chadoCanonicalGene0);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.components.genebuilder.GeneUtils", e);
      }
  }

  @Test(timeout = 4000)
  public void test15()  throws Throwable  {
      // Undeclared exception!
      try { 
        GeneUtils.getFeatureForUpdatingResidues((GFFStreamFeature) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.components.genebuilder.GeneUtils", e);
      }
  }

  @Test(timeout = 4000)
  public void test16()  throws Throwable  {
      // Undeclared exception!
      try { 
        GeneUtils.fixParentQualifier("", "Cn", (Set) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.components.genebuilder.GeneUtils", e);
      }
  }

  @Test(timeout = 4000)
  public void test17()  throws Throwable  {
      ThaiBuddhistEra thaiBuddhistEra0 = ThaiBuddhistEra.BEFORE_BE;
      EnumSet<ThaiBuddhistEra> enumSet0 = EnumSet.of(thaiBuddhistEra0);
      // Undeclared exception!
      try { 
        GeneUtils.fixParentQualifier("Load and write to file all qualifers from the database?\nThis may take a few minutes.", "Load and write to file all qualifers from the database?\nThis may take a few minutes.", enumSet0);
        fail("Expecting exception: ClassCastException");
      
      } catch(ClassCastException e) {
         //
         // java.time.chrono.ThaiBuddhistEra cannot be cast to uk.ac.sanger.artemis.io.Feature
         //
         verifyException("uk.ac.sanger.artemis.components.genebuilder.GeneUtils", e);
      }
  }

  @Test(timeout = 4000)
  public void test18()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      Key key0 = Key.CDS;
      FeatureKeyPredicate featureKeyPredicate0 = new FeatureKeyPredicate(key0);
      FilteredEntryGroup filteredEntryGroup0 = new FilteredEntryGroup(simpleEntryGroup0, featureKeyPredicate0, "f'C3");
      // Undeclared exception!
      try { 
        GeneUtils.duplicateGeneModel((JFrame) null, (FeatureVector) null, filteredEntryGroup0);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.components.genebuilder.GeneUtils", e);
      }
  }

  @Test(timeout = 4000)
  public void test19()  throws Throwable  {
      // Undeclared exception!
      try { 
        GeneUtils.deriveResidues((GFFStreamFeature) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.components.genebuilder.GeneUtils", e);
      }
  }

  @Test(timeout = 4000)
  public void test20()  throws Throwable  {
      Key key0 = new Key("");
      Range range0 = new Range(5093);
      Location location0 = new Location(range0);
      QualifierVector qualifierVector0 = new QualifierVector();
      ChadoCanonicalGene chadoCanonicalGene0 = new ChadoCanonicalGene();
      DatabaseInferredFeature databaseInferredFeature0 = new DatabaseInferredFeature(key0, location0, qualifierVector0, chadoCanonicalGene0);
      databaseInferredFeature0.setUserData(chadoCanonicalGene0);
      // Undeclared exception!
      try { 
        GeneUtils.deriveResidues(databaseInferredFeature0);
        fail("Expecting exception: ClassCastException");
      
      } catch(ClassCastException e) {
         //
         // uk.ac.sanger.artemis.io.ChadoCanonicalGene cannot be cast to uk.ac.sanger.artemis.Feature
         //
         verifyException("uk.ac.sanger.artemis.components.genebuilder.GeneUtils", e);
      }
  }

  @Test(timeout = 4000)
  public void test21()  throws Throwable  {
      ChadoCanonicalGene chadoCanonicalGene0 = new ChadoCanonicalGene();
      // Undeclared exception!
      try { 
        GeneUtils.deleteAllFeature((Feature) null, chadoCanonicalGene0, false);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.components.genebuilder.GeneUtils", e);
      }
  }

  @Test(timeout = 4000)
  public void test22()  throws Throwable  {
      // Undeclared exception!
      try { 
        GeneUtils.defineShowHideGeneFeatures((FeatureVector) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.components.genebuilder.GeneUtils", e);
      }
  }

  @Test(timeout = 4000)
  public void test23()  throws Throwable  {
      FeatureVector featureVector0 = new FeatureVector();
      // Undeclared exception!
      try { 
        GeneUtils.defineShowHideGeneFeatures(featureVector0);
        fail("Expecting exception: IndexOutOfBoundsException");
      
      } catch(IndexOutOfBoundsException e) {
         //
         // Index: 0, Size: 0
         //
         verifyException("java.util.ArrayList", e);
      }
  }

  @Test(timeout = 4000)
  public void test24()  throws Throwable  {
      Clipboard clipboard0 = new Clipboard("9/Oa2'RA");
      Selection selection0 = new Selection(clipboard0);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      SimpleGotoEventSource simpleGotoEventSource0 = new SimpleGotoEventSource(simpleEntryGroup0);
      // Undeclared exception!
      try { 
        GeneUtils.createGeneModel((JFrame) null, selection0, simpleEntryGroup0, simpleGotoEventSource0);
        fail("Expecting exception: HeadlessException");
      
      } catch(HeadlessException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("java.awt.GraphicsEnvironment", e);
      }
  }

  @Test(timeout = 4000)
  public void test25()  throws Throwable  {
      ChadoCanonicalGene chadoCanonicalGene0 = new ChadoCanonicalGene();
      // Undeclared exception!
      try { 
        GeneUtils.convertPseudo(chadoCanonicalGene0);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.components.genebuilder.GeneUtils", e);
      }
  }

  @Test(timeout = 4000)
  public void test26()  throws Throwable  {
      GenbankStreamFeature genbankStreamFeature0 = new GenbankStreamFeature();
      ChadoCanonicalGene chadoCanonicalGene0 = new ChadoCanonicalGene();
      chadoCanonicalGene0.setGene(genbankStreamFeature0);
      genbankStreamFeature0.setUserData(chadoCanonicalGene0);
      // Undeclared exception!
      try { 
        GeneUtils.convertPseudo(chadoCanonicalGene0);
        fail("Expecting exception: ClassCastException");
      
      } catch(ClassCastException e) {
         //
         // uk.ac.sanger.artemis.io.ChadoCanonicalGene cannot be cast to uk.ac.sanger.artemis.Feature
         //
         verifyException("uk.ac.sanger.artemis.components.genebuilder.GeneUtils", e);
      }
  }

  @Test(timeout = 4000)
  public void test27()  throws Throwable  {
      EmblStreamFeature emblStreamFeature0 = new EmblStreamFeature();
      Feature feature0 = new Feature(emblStreamFeature0);
      // Undeclared exception!
      try { 
        GeneUtils.checkTranscriptBoundary(feature0, (ChadoCanonicalGene) null, false);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.components.genebuilder.GeneUtils", e);
      }
  }

  @Test(timeout = 4000)
  public void test28()  throws Throwable  {
      GenbankStreamFeature genbankStreamFeature0 = new GenbankStreamFeature();
      BlastStreamFeature blastStreamFeature0 = new BlastStreamFeature(genbankStreamFeature0);
      GFFStreamFeature gFFStreamFeature0 = new GFFStreamFeature(blastStreamFeature0, false);
      ChadoCanonicalGene chadoCanonicalGene0 = new ChadoCanonicalGene();
      Feature feature0 = new Feature(gFFStreamFeature0);
      // Undeclared exception!
      try { 
        GeneUtils.checkTranscriptBoundary(feature0, chadoCanonicalGene0, true);
        
      } catch(Exception e) {
    	  	fail("Caught: Exception: " + e.getMessage());
      }
  }

  @Test(timeout = 4000)
  public void test29()  throws Throwable  {
      ChadoCanonicalGene chadoCanonicalGene0 = new ChadoCanonicalGene();
      // Undeclared exception!
      try { 
        GeneUtils.checkTranscriptBoundary((Feature) null, chadoCanonicalGene0);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.components.genebuilder.GeneUtils", e);
      }
  }

  @Test(timeout = 4000)
  public void test30()  throws Throwable  {
      // Undeclared exception!
      try { 
        GeneUtils.checkGeneBoundary((ChadoCanonicalGene) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.components.genebuilder.GeneUtils", e);
      }
  }

  @Test(timeout = 4000)
  public void test31()  throws Throwable  {
      // Undeclared exception!
      try { 
        GeneUtils.addSegment((GFFStreamFeature) null, (RangeVector) null, "No CDS features selected");
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.components.genebuilder.GeneUtils", e);
      }
  }

  @Test(timeout = 4000)
  public void test32()  throws Throwable  {
      // Undeclared exception!
      try { 
        GeneUtils.addLazyQualifiers((GFFStreamFeature) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.components.genebuilder.GeneUtils", e);
      }
  }

  @Test(timeout = 4000)
  public void test33()  throws Throwable  {
      boolean boolean0 = GeneUtils.isFeatureToUpdateResidues("-W7LA0lY5pM_ojO>");
      assertFalse(boolean0);
  }

  @Test(timeout = 4000)
  public void test34()  throws Throwable  {
      ChadoCanonicalGene chadoCanonicalGene0 = new ChadoCanonicalGene();
      GeneUtils.checkGeneBoundary(chadoCanonicalGene0, true);
      assertEquals(0, chadoCanonicalGene0.getSeqlen());
  }

  @Test(timeout = 4000)
  public void test35()  throws Throwable  {
      EmblStreamFeature emblStreamFeature0 = new EmblStreamFeature();
      // Undeclared exception!
      try { 
        GeneUtils.getUniqueName(emblStreamFeature0);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.components.genebuilder.GeneUtils", e);
      }
  }

  @Test(timeout = 4000)
  public void test36()  throws Throwable  {
      GenbankStreamFeature genbankStreamFeature0 = new GenbankStreamFeature();
      BlastStreamFeature blastStreamFeature0 = new BlastStreamFeature(genbankStreamFeature0);
      GFFStreamFeature gFFStreamFeature0 = new GFFStreamFeature(blastStreamFeature0, false);
      FeatureForUpdatingResidues featureForUpdatingResidues0 = GeneUtils.getFeatureForUpdatingResidues(gFFStreamFeature0);
      assertNull(featureForUpdatingResidues0);
  }

  @Test(timeout = 4000)
  public void test37()  throws Throwable  {
      Key key0 = new Key("snoRNA");
      boolean boolean0 = GeneUtils.isNonCodingTranscripts(key0);
      assertTrue(boolean0);
  }

  @Test(timeout = 4000)
  public void test38()  throws Throwable  {
      Key key0 = Key.CDS;
      boolean boolean0 = GeneUtils.isNonCodingTranscripts(key0);
      assertFalse(boolean0);
  }

  @Test(timeout = 4000)
  public void test39()  throws Throwable  {
      GenbankStreamFeature genbankStreamFeature0 = new GenbankStreamFeature();
      ChadoCanonicalGene chadoCanonicalGene0 = new ChadoCanonicalGene();
      chadoCanonicalGene0.setGene(genbankStreamFeature0);
      GeneUtils.convertPseudo(chadoCanonicalGene0);
      assertEquals(0, chadoCanonicalGene0.getSeqlen());
  }

  @Test(timeout = 4000)
  public void test40()  throws Throwable  {
      HashSet<BlastStreamFeature> hashSet0 = new HashSet<BlastStreamFeature>();
      Key key0 = new Key("snoRNA");
      QualifierVector qualifierVector0 = new QualifierVector();
      BlastStreamFeature blastStreamFeature0 = new BlastStreamFeature(key0, (Location) null, qualifierVector0);
      hashSet0.add(blastStreamFeature0);
      GeneUtils.fixParentQualifier("pseudogenic_exon", "pseudogenic_exon", hashSet0);
      assertFalse(hashSet0.isEmpty());
  }

  @Test(timeout = 4000)
  public void test41()  throws Throwable  {
      Key key0 = new Key("");
      Range range0 = new Range(5090);
      Location location0 = new Location(range0);
      QualifierVector qualifierVector0 = new QualifierVector();
      ChadoCanonicalGene chadoCanonicalGene0 = new ChadoCanonicalGene();
      DatabaseInferredFeature databaseInferredFeature0 = new DatabaseInferredFeature(key0, location0, qualifierVector0, chadoCanonicalGene0);
      TreeSet<EmblStreamFeature> treeSet0 = new TreeSet<EmblStreamFeature>();
      GeneUtils.propagateId(databaseInferredFeature0, "com.sshtools.j2ssh.io.UnsignedInteger32", treeSet0);
      assertTrue(databaseInferredFeature0.isVisible());
  }

  @Test(timeout = 4000)
  public void test42()  throws Throwable  {
      GenbankStreamFeature genbankStreamFeature0 = new GenbankStreamFeature();
      ChadoCanonicalGene chadoCanonicalGene0 = new ChadoCanonicalGene();
      chadoCanonicalGene0.setGene(genbankStreamFeature0);
      int int0 = GeneUtils.isBoundaryOK(chadoCanonicalGene0);
      assertEquals(0, int0);
  }

  @Test(timeout = 4000)
  public void test43()  throws Throwable  {
      GenbankStreamFeature genbankStreamFeature0 = new GenbankStreamFeature();
      ChadoCanonicalGene chadoCanonicalGene0 = new ChadoCanonicalGene();
      chadoCanonicalGene0.setGene(genbankStreamFeature0);
      boolean boolean0 = GeneUtils.isStrandOK(chadoCanonicalGene0);
      assertTrue(boolean0);
  }

  @Test(timeout = 4000)
  public void test44()  throws Throwable  {
      GenbankStreamFeature genbankStreamFeature0 = new GenbankStreamFeature();
      BlastStreamFeature blastStreamFeature0 = new BlastStreamFeature(genbankStreamFeature0);
      GFFStreamFeature gFFStreamFeature0 = new GFFStreamFeature(blastStreamFeature0, false);
      ChadoCanonicalGene chadoCanonicalGene0 = new ChadoCanonicalGene();
      chadoCanonicalGene0.setGene(genbankStreamFeature0);
      Feature feature0 = new Feature(gFFStreamFeature0);
      GeneUtils.deleteAllFeature(feature0, chadoCanonicalGene0);
      assertEquals(0, chadoCanonicalGene0.getSrcfeature_id());
  }

  @Test(timeout = 4000)
  public void test45()  throws Throwable  {
      EmblStreamFeature emblStreamFeature0 = new EmblStreamFeature();
      boolean boolean0 = GeneUtils.isDatabaseEntry((uk.ac.sanger.artemis.io.Feature) emblStreamFeature0);
      assertFalse(boolean0);
  }

  @Test(timeout = 4000)
  public void test46()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      simpleEntryGroup0.createEntry((String) null);
      boolean boolean0 = GeneUtils.isGFFEntry(simpleEntryGroup0);
      assertFalse(boolean0);
  }

  @Test(timeout = 4000)
  public void test47()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      simpleEntryGroup0.createEntry((String) null);
      boolean boolean0 = GeneUtils.isDatabaseEntry((EntryGroup) simpleEntryGroup0);
      assertFalse(boolean0);
  }

  @Test(timeout = 4000)
  public void test48()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      FilteredEntryGroup filteredEntryGroup0 = new FilteredEntryGroup(simpleEntryGroup0, (FeatureVector) null, "pseudogenic_exon");
      filteredEntryGroup0.createEntry("flEZ{zH>bu?ix%^1");
      String string0 = GeneUtils.promptForUniquename((EntryGroup) simpleEntryGroup0, true, (Range) null);
      assertNull(string0);
  }

  @Test(timeout = 4000)
  public void test49()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      simpleEntryGroup0.createEntry((String) null);
      String string0 = GeneUtils.promptForUniquename((EntryGroup) simpleEntryGroup0, false);
      assertNull(string0);
  }

  @Test(timeout = 4000)
  public void test50()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      FeatureVector featureVector0 = simpleEntryGroup0.getAllFeatures();
      Vector<ChadoCanonicalGene> vector0 = GeneUtils.duplicateGeneModel((JFrame) null, featureVector0, simpleEntryGroup0);
      assertEquals("[]", vector0.toString());
  }

  @Test(timeout = 4000)
  public void test51()  throws Throwable  {
      GenbankStreamFeature genbankStreamFeature0 = new GenbankStreamFeature();
      GFFStreamFeature gFFStreamFeature0 = new GFFStreamFeature(genbankStreamFeature0, false);
      boolean boolean0 = GeneUtils.isObsolete(gFFStreamFeature0);
      assertFalse(boolean0);
  }

  @Test(timeout = 4000)
  public void test52()  throws Throwable  {
      Clipboard clipboard0 = new Clipboard("java.lang.Object");
      Selection selection0 = new Selection(clipboard0);
      FeatureVector featureVector0 = selection0.getAllFeatures();
      featureVector0.insertElementAfter((Feature) null, (Feature) null);
      // Undeclared exception!
      try { 
        GeneUtils.showHideGeneFeatures(featureVector0);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.components.genebuilder.GeneUtils", e);
      }
  }

  @Test(timeout = 4000)
  public void test53()  throws Throwable  {
      Clipboard clipboard0 = new Clipboard("java.lang.Object");
      Selection selection0 = new Selection(clipboard0);
      FeatureVector featureVector0 = selection0.getAllFeatures();
      GeneUtils.showHideGeneFeatures(featureVector0);
  }

  @Test(timeout = 4000)
  public void test54()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      FilteredEntryGroup filteredEntryGroup0 = new FilteredEntryGroup(simpleEntryGroup0, (FeatureVector) null, "pseudogenic_exon");
      Entry entry0 = filteredEntryGroup0.createEntry("flEZ{zH>bu?ix%^1");
      GeneUtils.lazyLoadAll(entry0, (JFrame) null);
      assertFalse(entry0.hasUnsavedChanges());
  }

  @Test(timeout = 4000)
  public void test55()  throws Throwable  {
      Key key0 = new Key("");
      Range range0 = new Range(5090);
      Location location0 = new Location(range0);
      QualifierVector qualifierVector0 = new QualifierVector();
      ChadoCanonicalGene chadoCanonicalGene0 = new ChadoCanonicalGene();
      DatabaseInferredFeature databaseInferredFeature0 = new DatabaseInferredFeature(key0, location0, qualifierVector0, chadoCanonicalGene0);
      RangeVector rangeVector0 = new RangeVector(range0);
      GeneUtils.addSegment(databaseInferredFeature0, rangeVector0, "SHOW");
      assertEquals("[5090]", rangeVector0.toString());
  }

  @Test(timeout = 4000)
  public void test56()  throws Throwable  {
      GeneUtils.complementGeneModel((ChadoCanonicalGene) null);
  }

  @Test(timeout = 4000)
  public void test57()  throws Throwable  {
      GenbankStreamFeature genbankStreamFeature0 = new GenbankStreamFeature();
      BlastStreamFeature blastStreamFeature0 = new BlastStreamFeature(genbankStreamFeature0);
      GFFStreamFeature gFFStreamFeature0 = new GFFStreamFeature(blastStreamFeature0, false);
      GeneUtils.addLazyQualifiers(gFFStreamFeature0);
      assertNull(gFFStreamFeature0.getGffSeqName());
  }

  @Test(timeout = 4000)
  public void test58()  throws Throwable  {
      // Undeclared exception!
      try { 
        GeneUtils.main((String[]) null);
        fail("Expecting exception: IndexOutOfBoundsException");
      
      } catch(IndexOutOfBoundsException e) {
         //
         // Index: 0, Size: 0
         //
         verifyException("java.util.ArrayList", e);
      }
  }

  @Test(timeout = 4000)
  public void test59()  throws Throwable  {
      boolean boolean0 = GeneUtils.isHiddenFeature("");
      assertFalse(boolean0);
  }

  @Test(timeout = 4000)
  public void test60()  throws Throwable  {
      GenbankStreamFeature genbankStreamFeature0 = new GenbankStreamFeature();
      BlastStreamFeature blastStreamFeature0 = new BlastStreamFeature(genbankStreamFeature0);
      GFFStreamFeature gFFStreamFeature0 = new GFFStreamFeature(blastStreamFeature0, false);
      ChadoCanonicalGene chadoCanonicalGene0 = new ChadoCanonicalGene();
      Feature feature0 = new Feature(gFFStreamFeature0);
      // Undeclared exception!
      try { 
        GeneUtils.deleteAllFeature(feature0, chadoCanonicalGene0);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.ChadoCanonicalGene", e);
      }
  }

  @Test(timeout = 4000)
  public void test61()  throws Throwable  {
      ChadoCanonicalGene chadoCanonicalGene0 = new ChadoCanonicalGene();
      GeneUtils.checkGeneBoundary(chadoCanonicalGene0);
      assertEquals(0, chadoCanonicalGene0.getSrcfeature_id());
  }

  @Test(timeout = 4000)
  public void test62()  throws Throwable  {
      String[] stringArray0 = GeneUtils.getNonCodingTranscripts();
      assertEquals(6, stringArray0.length);
  }

  @Test(timeout = 4000)
  public void test63()  throws Throwable  {
      GenbankStreamFeature genbankStreamFeature0 = new GenbankStreamFeature();
      BlastStreamFeature blastStreamFeature0 = new BlastStreamFeature(genbankStreamFeature0);
      GFFStreamFeature gFFStreamFeature0 = new GFFStreamFeature(blastStreamFeature0, false);
      ChadoCanonicalGene chadoCanonicalGene0 = new ChadoCanonicalGene();
      Feature feature0 = new Feature(gFFStreamFeature0);
      // Undeclared exception!
      try { 
        GeneUtils.checkTranscriptBoundary(feature0, chadoCanonicalGene0);
      
      } catch(Exception e) {
    	  	fail("Caught: Exception: " + e.getMessage());
      }
  }

  @Test(timeout = 4000)
  public void test64()  throws Throwable  {
      GeneUtils geneUtils0 = new GeneUtils();
  }
}
